/*
Copyright (c) 2006-2007, Tom Thielicke IT Solutions

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.
*/

/****************************************************************
**
** Implementation of the KeyboardSql class
** File name: keyboardsql.cpp
**
****************************************************************/

#include <QSqlQuery>
#include <QSqlDriver>
#include <QVariant>
#include <QFile>
#include <QTextStream>
#include <QString>

#include "keyboardsql.h"

KeyboardSql::KeyboardSql(QString op) {
	// Set the keyboard layout
	opSystem = op;
}

bool KeyboardSql::getKeyLayout(QChar givenchar, int *left, int *top,
	int *color, int *form, int *modifier, int *finger, QString *status) {
	// Convert given char into properties of a key
	QSqlQuery query;
	if (query.exec("SELECT key_layouts.left, key_layouts.top, "
		"key_layouts.color, key_layouts.form, character_list_" + opSystem +
		".modifier, key_layouts.finger, key_layouts.status_text "
		"FROM character_list_" + opSystem +
		", key_layouts WHERE key_layouts.key_id = character_list_" + opSystem +
		".layout AND character_list_" + opSystem + ".unicode = " +
		QString::number(givenchar.unicode()) + ";")) {
		if (query.first()) {
			*left = query.value(0).toInt();
			*top = query.value(1).toInt();
			*color = query.value(2).toInt();
			*form = query.value(3).toInt();
			*modifier = query.value(4).toInt();
			*finger = query.value(5).toInt();
			*status = query.value(6).toString();
			return true;
		}
	}
	return false;
}

bool KeyboardSql::getModifierLayout(int givenmodifier, int *left, int *top,
	int *color, int *form, int *finger, QString *status) {
	// Convert given id into properties of a key
	QSqlQuery query;
	if (query.exec("SELECT key_layouts.left, key_layouts.top, "
		"key_layouts.color, key_layouts.form, key_layouts.finger, key_layouts.status_text FROM "
		"key_layouts WHERE key_layouts.key_id = "
		+ QString::number(givenmodifier) + ";")) {
		if (query.first()) {
			*left = query.value(0).toInt();
			*top = query.value(1).toInt();
			*color = query.value(2).toInt();
			*form = query.value(3).toInt();
			*finger = query.value(4).toInt();
			&status->prepend(query.value(5).toString() + " + ");
			return true;
		}
	}
	return false;
}
