/*
Copyright (c) 2006-2007, Tom Thielicke IT Solutions

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.
*/

/****************************************************************
**
** File name: main.cpp
**
****************************************************************/

#include <QApplication>
#include <QPlastiqueStyle>
#include <QString>
#include <QSettings>

#include "sql/connection.h"
#include "widget/mainwindow.h"
#include "def/defines.h"

int main(int argc, char *argv[]) {
    QApplication app(argc, argv);
    // Set windows style
    app.setStyle("plastique");
    // Set application name and domain
    // (this saves having to repeat the information
    // each time a QSettings object is created)
    app.setOrganizationName(APP_ORGANIZATION);
 	app.setOrganizationDomain(APP_URL);
    app.setApplicationName(APP_NAME);

    QSettings settings;
    if (argc > 1) {
		settings.beginGroup("database");
		settings.setValue("path", QString::fromLatin1(argv[1]) + "/" + APP_USER_DB);
		settings.endGroup();
	}
	// Create database connection
    if (!createConnection()) {
		// Cannot find or open database
		// -> exit program
		return 1;
	}
	// Create main window object
    MainWindow window;
    window.show();
    // Start the event loop
    return app.exec();
}
