/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.util;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.util.SBReference;
import java.awt.Font;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.plaf.FontUIResource;

public class ColoredFont {
    private SBReference sbReference;
    private FontUIResource font;
    private boolean isPlainFont;
    private boolean isBoldFont;

    public ColoredFont(ColoredFont other) {
        this.font = new FontUIResource(other.font);
        if (other.sbReference != null) {
            this.sbReference = new SBReference(other.sbReference);
        }
        this.isPlainFont = other.isPlainFont;
        this.isBoldFont = other.isBoldFont;
    }

    public ColoredFont(String fontFamily, int style, int size) {
        this.font = new FontUIResource(Theme.getPlatformFont(fontFamily), style, size);
    }

    public ColoredFont() {
        this.font = new FontUIResource(Theme.getPlatformFont("Tahoma"), 0, 11);
        this.isPlainFont = true;
    }

    public ColoredFont(SBReference ref) {
        this("Tahoma", 0, 11, ref);
        this.isPlainFont = true;
    }

    private ColoredFont(String fontFamily, int style, int size, SBReference sbReference) {
        this.font = new FontUIResource(Theme.getPlatformFont(fontFamily), style, size);
        this.sbReference = sbReference;
    }

    public void update(String fontFamily, int style, int size) {
        this.font = new FontUIResource(Theme.getPlatformFont(fontFamily), style, size);
    }

    public void update(SBReference sbReference) {
        this.font = new FontUIResource(Theme.getPlatformFont("Tahoma"), 0, 11);
        this.sbReference = sbReference;
        this.isPlainFont = true;
    }

    public void update(ColoredFont other) {
        this.font = new FontUIResource(other.font);
        this.isPlainFont = other.isPlainFont;
        this.isBoldFont = other.isBoldFont;
        if (other.sbReference != null) {
            this.sbReference.setBrightness(other.sbReference.getBrightness());
            this.sbReference.setLocked(other.sbReference.isLocked());
            this.sbReference.setReference(other.sbReference.getReference());
            this.sbReference.setSaturation(other.sbReference.getSaturation());
            this.sbReference.setColor(other.sbReference.getColor());
        }
    }

    public void update(ColoredFont other, Vector referenceColors) {
        this.font = new FontUIResource(other.font);
        this.isPlainFont = other.isPlainFont;
        this.isBoldFont = other.isBoldFont;
        if (other.sbReference != null) {
            this.sbReference.update(other.sbReference, referenceColors);
        }
    }

    public void setPlainFont(boolean b) {
        this.isPlainFont = b;
        if (b) {
            this.isBoldFont = false;
        }
    }

    public void setBoldFont(boolean b) {
        this.isBoldFont = b;
        if (b) {
            this.isPlainFont = false;
        }
    }

    public boolean isPlainFont() {
        return this.isPlainFont;
    }

    public boolean isBoldFont() {
        return this.isBoldFont;
    }

    public void setFont(String fontFamily, int style, int size) {
        this.font = new FontUIResource(fontFamily, style, size);
    }

    public void setFont(Font font) {
        this.font = new FontUIResource(font);
    }

    public void setFont(FontUIResource font) {
        this.font = font;
    }

    public FontUIResource getFont() {
        if (this.isPlainFont) {
            return Theme.plainFont.font;
        }
        if (this.isBoldFont) {
            return Theme.boldFont.font;
        }
        return this.font;
    }

    public SBReference getSBReference() {
        return this.sbReference;
    }

    public void setSBReference(SBReference sbReference) {
        this.sbReference = sbReference;
    }

    public void save(DataOutputStream out) throws IOException {
        out.writeUTF(this.font.getFamily());
        out.writeBoolean(this.font.isBold());
        out.writeInt(this.font.getSize());
        out.writeBoolean(this.isPlainFont);
        out.writeBoolean(this.isBoldFont);
    }

    public void load(DataInputStream in) throws IOException {
        this.font = new FontUIResource(Theme.getPlatformFont(in.readUTF()), in.readBoolean() ? 1 : 0, in.readInt());
        this.isPlainFont = in.readBoolean();
        this.isBoldFont = in.readBoolean();
    }

    public static void loadDummyData(DataInputStream in) throws IOException {
        in.readUTF();
        in.readBoolean();
        in.readInt();
        in.readBoolean();
        in.readBoolean();
    }

    public String toString() {
        return "ColoredFont[ref=" + (this.sbReference == null ? "null" : this.sbReference.toString()) + ",font=" + this.font + "]";
    }
}

