/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JToolBar;
import javax.swing.plaf.metal.MetalBorders;

public class TinyToolBarBorder
extends MetalBorders.ToolBarBorder {
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets newInsets) {
        Insets margin;
        newInsets.right = 2;
        newInsets.bottom = 2;
        newInsets.left = 2;
        newInsets.top = 2;
        if (!(c instanceof JToolBar)) {
            return newInsets;
        }
        if (((JToolBar)c).isFloatable()) {
            if (((JToolBar)c).getOrientation() == 0) {
                if (c.getComponentOrientation().isLeftToRight()) {
                    newInsets.left = 10;
                } else {
                    newInsets.right = 10;
                }
            } else {
                newInsets.top = 10;
            }
        }
        if ((margin = ((JToolBar)c).getMargin()) != null) {
            newInsets.left += margin.left;
            newInsets.top += margin.top;
            newInsets.right += margin.right;
            newInsets.bottom += margin.bottom;
        }
        return newInsets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (!(c instanceof JToolBar)) {
            return;
        }
        this.drawXPBorder(c, g, x, y, w, h);
        if (((JToolBar)c).getOrientation() == 0) {
            g.setColor(Theme.toolBarLightColor.getColor());
            g.drawLine(x, y, w - 1, y);
            g.setColor(Theme.toolBarDarkColor.getColor());
            g.drawLine(x, h - 1, w - 1, h - 1);
        } else {
            g.setColor(Theme.toolBarLightColor.getColor());
            g.drawLine(x, y, x, h - 1);
            g.setColor(Theme.toolBarDarkColor.getColor());
            g.drawLine(w - 1, y, w - 1, h - 1);
        }
    }

    protected void drawXPBorder(Component c, Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        if (((JToolBar)c).isFloatable()) {
            if (((JToolBar)c).getOrientation() == 0) {
                int xoff = 3;
                if (!c.getComponentOrientation().isLeftToRight()) {
                    xoff = c.getBounds().width - 8 + 3;
                }
                g.setColor(Theme.toolGripLightColor.getColor());
                g.drawLine(xoff, 3, xoff + 1, 3);
                g.drawLine(xoff, 3, xoff, h - 5);
                g.setColor(Theme.toolGripDarkColor.getColor());
                g.drawLine(xoff, h - 4, xoff + 1, h - 4);
                g.drawLine(xoff + 2, 3, xoff + 2, h - 4);
            } else {
                g.setColor(Theme.toolGripLightColor.getColor());
                g.drawLine(3, 3, 3, 4);
                g.drawLine(3, 3, w - 4, 3);
                g.setColor(Theme.toolGripDarkColor.getColor());
                g.drawLine(w - 4, 4, w - 4, 5);
                g.drawLine(3, 5, w - 4, 5);
            }
        }
        g.translate(-x, -y);
    }
}

