/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.borders.TinyToolButtonBorder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalToolBarUI;

public class TinyToolBarUI
extends MetalToolBarUI {
    private static List components = new ArrayList();
    public static final String IS_TOOL_BAR_BUTTON_KEY = "isToolbarButton";
    public static final int FLOATABLE_GRIP_SIZE = 8;
    private static Border toolButtonBorder = new TinyToolButtonBorder();

    public static ComponentUI createUI(JComponent c) {
        return new TinyToolBarUI();
    }

    public static boolean doesMenuBarBorderToolBar(JMenuBar c) {
        JToolBar tb = (JToolBar)TinyToolBarUI.findRegisteredComponentOfType(c, JToolBar.class);
        if (tb != null && tb.getOrientation() == 0) {
            JRootPane rp = SwingUtilities.getRootPane(c);
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(c, point, rp);
            int menuX = point.x;
            int menuY = point.y;
            point.y = 0;
            point.x = 0;
            point = SwingUtilities.convertPoint(tb, point, rp);
            return point.x == menuX && menuY + c.getHeight() == point.y && c.getWidth() == tb.getWidth();
        }
        return false;
    }

    static synchronized Object findRegisteredComponentOfType(JComponent from, Class target) {
        JRootPane rp = SwingUtilities.getRootPane(from);
        if (rp != null) {
            for (int counter = components.size() - 1; counter >= 0; --counter) {
                Object component = ((WeakReference)components.get(counter)).get();
                if (component == null) {
                    components.remove(counter);
                    continue;
                }
                if (!target.isInstance(component) || SwingUtilities.getRootPane((Component)component) != rp) continue;
                return component;
            }
        }
        return null;
    }

    static synchronized void register(JComponent c) {
        if (c == null) {
            throw new NullPointerException("JComponent must be non-null");
        }
        components.add(new WeakReference<JComponent>(c));
    }

    static synchronized void unregister(JComponent c) {
        for (int counter = components.size() - 1; counter >= 0; --counter) {
            WeakReference ref = (WeakReference)components.get(counter);
            Object target = ((WeakReference)components.get(counter)).get();
            if (target != c && target != null) continue;
            components.remove(counter);
        }
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        TinyToolBarUI.register(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.putClientProperty("JToolBar.isRollover", null);
        TinyToolBarUI.unregister(c);
    }

    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        Window window = SwingUtilities.getWindowAncestor(toolbar);
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, toolbar.getName(), false) : (window instanceof Dialog ? new JDialog((Dialog)window, toolbar.getName(), false) : new JDialog((Frame)null, toolbar.getName(), false));
        dialog.setTitle(toolbar.getName());
        dialog.setResizable(false);
        WindowListener wl = this.createFrameListener();
        dialog.addWindowListener(wl);
        return dialog;
    }

    public void paint(Graphics g, JComponent c) {
        if (c.getBackground() instanceof ColorUIResource) {
            g.setColor(Theme.toolBarColor.getColor());
        } else {
            g.setColor(c.getBackground());
        }
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
    }

    protected void setBorderToRollover(Component c) {
        this.setBorderToNormal(c);
    }

    protected void setBorderToNormal(Component c) {
        if (!(c instanceof AbstractButton)) {
            return;
        }
        if (c instanceof JCheckBox) {
            return;
        }
        if (c instanceof JRadioButton) {
            return;
        }
        AbstractButton b = (AbstractButton)c;
        b.setRolloverEnabled(true);
        b.putClientProperty(IS_TOOL_BAR_BUTTON_KEY, Boolean.TRUE);
        if (!(b.getBorder() instanceof UIResource) && !(b.getBorder() instanceof TinyToolButtonBorder)) {
            return;
        }
        b.setBorder(toolButtonBorder);
    }
}

