/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;

public class TinyToolBarSeparatorUI
extends BasicToolBarSeparatorUI {
    private static final int YQ_SIZE = 7;

    public static ComponentUI createUI(JComponent c) {
        return new TinyToolBarSeparatorUI();
    }

    protected void installDefaults(JSeparator s) {
    }

    public Dimension getMinimumSize(JComponent c) {
        JToolBar.Separator sep = (JToolBar.Separator)c;
        if (sep.getOrientation() == 0) {
            return new Dimension(0, 1);
        }
        return new Dimension(1, 0);
    }

    public Dimension getMaximumSize(JComponent c) {
        JToolBar.Separator sep = (JToolBar.Separator)c;
        Dimension size = sep.getSeparatorSize();
        if (sep.getOrientation() == 0) {
            if (size != null) {
                return new Dimension(Short.MAX_VALUE, size.height);
            }
            return new Dimension(Short.MAX_VALUE, 7);
        }
        if (size != null) {
            return new Dimension(Short.MAX_VALUE, size.width);
        }
        return new Dimension(7, Short.MAX_VALUE);
    }

    public Dimension getPreferredSize(JComponent c) {
        JToolBar.Separator sep = (JToolBar.Separator)c;
        Dimension size = sep.getSeparatorSize();
        if (size != null) {
            return size.getSize();
        }
        if (sep.getOrientation() == 0) {
            return new Dimension(0, 7);
        }
        return new Dimension(7, 0);
    }

    public void paint(Graphics g, JComponent c) {
        this.drawXpToolBarSeparator(g, c);
    }

    protected void drawXpToolBarSeparator(Graphics g, JComponent c) {
        JToolBar.Separator sep = (JToolBar.Separator)c;
        if (sep.getOrientation() == 0) {
            int y = sep.getHeight() / 2;
            g.setColor(Theme.toolSeparatorColor.getColor());
            g.drawLine(0, y, sep.getWidth(), y);
        } else {
            int x = sep.getWidth() / 2;
            g.setColor(Theme.toolSeparatorColor.getColor());
            g.drawLine(x, 0, x, sep.getHeight());
        }
    }
}

