/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTextFieldUI;
import javax.swing.text.JTextComponent;

public class TinyTextFieldUI
extends MetalTextFieldUI {
    public static ComponentUI createUI(JComponent c) {
        return new TinyTextFieldUI();
    }

    protected void paintBackground(Graphics g) {
        JTextComponent editor = this.getComponent();
        if (editor.isEnabled()) {
            if (editor.isEditable()) {
                g.setColor(editor.getBackground());
            } else if (editor.getBackground() instanceof ColorUIResource) {
                g.setColor(Theme.textNonEditableBgColor.getColor());
            } else {
                g.setColor(editor.getBackground());
            }
            g.fillRect(0, 0, editor.getWidth(), editor.getHeight());
        } else {
            if (editor.getBackground() instanceof ColorUIResource) {
                g.setColor(Theme.textDisabledBgColor.getColor());
            } else {
                g.setColor(editor.getBackground());
            }
            g.fillRect(0, 0, editor.getWidth(), editor.getHeight());
            if (editor.getBorder() == null) {
                return;
            }
            g.setColor(Theme.backColor.getColor());
            g.drawRect(1, 1, editor.getWidth() - 3, editor.getHeight() - 3);
            g.drawRect(2, 2, editor.getWidth() - 5, editor.getHeight() - 5);
        }
    }
}

