/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.TinyMenuItemUI;
import de.muntjak.tinylookandfeel.TinyTitlePane;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class TinyRootPaneUI
extends BasicRootPaneUI
implements FocusListener {
    private static final String[] borderKeys = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window window;
    private JComponent titlePane;
    private MouseInputListener mouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private JRootPane root;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private AWTEventListener mouseHandler = new MouseHandler();
    private KeyEventPostProcessor keyPostProcessor = new KeyPostProcessor();
    private boolean topMenuToClose = false;
    private Vector registeredKeyCodes;
    private static final boolean PARENT = false;
    private static final boolean CHILD = true;
    private static final boolean FORWARD = true;
    private static final boolean BACKWARD = false;
    private static final String CANCEL = "cancel";
    private static final String RETURN = "return";
    private static final String SELECT_PARENT = "selectParent";
    private static final String SELECT_CHILD = "selectChild";
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};

    public static ComponentUI createUI(JComponent c) {
        return new TinyRootPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.root = (JRootPane)c;
        int style = this.root.getWindowDecorationStyle();
        if (style != 0) {
            this.installClientDecorations(this.root);
        }
    }

    private Vector getRegisteredKeyCodes(JRootPane root) {
        Vector<Integer> v = new Vector<Integer>();
        InputMap im = root.getInputMap(2);
        if (im == null) {
            return v;
        }
        KeyStroke[] keys = im.allKeys();
        if (keys == null) {
            return v;
        }
        for (int i = 0; i < keys.length; ++i) {
            v.add(new Integer(keys[i].getKeyCode()));
        }
        return v;
    }

    private ActionMap getMapForKey(ActionMap am, String key) {
        if (am == null) {
            return null;
        }
        if (am != null && am.keys() != null) {
            Object[] keys = am.keys();
            for (int i = 0; i < keys.length; ++i) {
                if (!key.equals(keys[i])) continue;
                return am;
            }
        }
        return this.getMapForKey(am.getParent(), key);
    }

    boolean isTopMenuToClose() {
        return this.topMenuToClose;
    }

    private void addEscapeMenuHandlers() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Toolkit.getDefaultToolkit().addAWTEventListener(TinyRootPaneUI.this.mouseHandler, 131120L);
                return null;
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.keyPostProcessor);
    }

    private void removeEscapeMenuHandlers() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Toolkit.getDefaultToolkit().removeAWTEventListener(TinyRootPaneUI.this.mouseHandler);
                return null;
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.keyPostProcessor);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    protected void installListeners(JRootPane root) {
        super.installListeners(root);
        root.addFocusListener(this);
    }

    protected void uninstallListeners(JRootPane root) {
        super.uninstallListeners(root);
        root.removeFocusListener(this);
    }

    void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(root);
        } else {
            LookAndFeel.installBorder(root, borderKeys[style]);
        }
    }

    private void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener(root);
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private void uninstallWindowListeners(JRootPane root) {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    private void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.savedOldLayout != null) {
            root.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane root) {
        this.installBorder(root);
        JComponent titlePane = this.createTitlePane(root);
        this.setTitlePane(root, titlePane);
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        if (this.window != null) {
            root.revalidate();
            root.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane root) {
        this.uninstallBorder(root);
        this.uninstallWindowListeners(root);
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        root.repaint();
        root.revalidate();
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    private JComponent createTitlePane(JRootPane root) {
        return new TinyTitlePane(root, this);
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane root) {
        return new MouseInputHandler();
    }

    private LayoutManager createLayoutManager() {
        return new MetalRootLayout();
    }

    private void setTitlePane(JRootPane root, JComponent titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
        root.validate();
        root.repaint();
    }

    private JComponent getTitlePane() {
        return this.titlePane;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane root = (JRootPane)e.getSource();
            int style = root.getWindowDecorationStyle();
            this.uninstallClientDecorations(root);
            if (style != 0) {
                this.installClientDecorations(root);
            }
        } else if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners(this.root);
            if (((JRootPane)e.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root, this.root.getParent());
            }
        }
    }

    public void focusGained(FocusEvent e) {
        if (this.topMenuToClose) {
            this.topMenuToClose = false;
            this.removeEscapeMenuHandlers();
        } else {
            JRootPane root = (JRootPane)e.getSource();
            this.registeredKeyCodes = this.getRegisteredKeyCodes(root);
            ActionMap am = this.getMapForKey(root.getActionMap(), CANCEL);
            if (am != null) {
                am.put(CANCEL, new MenuActions(CANCEL));
                am.put(RETURN, new MenuActions(RETURN));
                am.put(SELECT_PARENT, new MenuActions(SELECT_PARENT));
                am.put(SELECT_CHILD, new MenuActions(SELECT_CHILD));
            }
        }
    }

    public void focusLost(FocusEvent e) {
    }

    private class MenuActions
    extends AbstractAction {
        private String name;

        MenuActions(String name) {
            super(name);
            this.name = name;
        }

        public void actionPerformed(ActionEvent e) {
            if (TinyRootPaneUI.CANCEL.equals(this.name)) {
                this.cancel();
            } else if (TinyRootPaneUI.SELECT_PARENT.equals(this.name)) {
                this.selectParentChild(false);
            } else if (TinyRootPaneUI.SELECT_CHILD.equals(this.name)) {
                this.selectParentChild(true);
            } else if (TinyRootPaneUI.RETURN.equals(this.name)) {
                this.doReturn();
            }
        }

        private void cancel() {
            MenuElement[] path;
            JPopupMenu lastPopup = this.getLastPopup();
            if (lastPopup != null) {
                lastPopup.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
            }
            if ((path = MenuSelectionManager.defaultManager().getSelectedPath()).length > 2) {
                int newSize = Math.max(2, path.length - 2);
                MenuElement[] newPath = new MenuElement[newSize];
                System.arraycopy(path, 0, newPath, 0, newSize);
                MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                if (newSize == 2 && !TinyRootPaneUI.this.topMenuToClose) {
                    TinyRootPaneUI.this.topMenuToClose = true;
                    TinyRootPaneUI.this.addEscapeMenuHandlers();
                }
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                if (TinyRootPaneUI.this.topMenuToClose) {
                    TinyRootPaneUI.this.topMenuToClose = false;
                    TinyRootPaneUI.this.removeEscapeMenuHandlers();
                }
            }
        }

        private void doReturn() {
            KeyboardFocusManager fmgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component focusOwner = fmgr.getFocusOwner();
            if (focusOwner != null && !(focusOwner instanceof JRootPane)) {
                return;
            }
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] path = msm.getSelectedPath();
            if (path.length > 0) {
                MenuElement lastElement = path[path.length - 1];
                if (lastElement instanceof JMenu) {
                    JPopupMenu popup = ((JMenu)lastElement).getPopupMenu();
                    MenuElement nextItem = this.findEnabledChild(popup.getSubElements(), -1, true);
                    if (nextItem != null) {
                        MenuElement[] newPath = new MenuElement[path.length + 2];
                        System.arraycopy(path, 0, newPath, 0, path.length);
                        newPath[path.length] = popup;
                        newPath[path.length + 1] = nextItem;
                        msm.setSelectedPath(newPath);
                    } else {
                        MenuElement[] newPath = new MenuElement[path.length + 1];
                        System.arraycopy(path, 0, newPath, 0, path.length);
                        newPath[path.length] = popup;
                        msm.setSelectedPath(newPath);
                    }
                } else if (lastElement instanceof JMenuItem) {
                    JMenuItem mi = (JMenuItem)lastElement;
                    if (mi.getUI() instanceof TinyMenuItemUI) {
                        ((TinyMenuItemUI)mi.getUI()).doClick(msm);
                    } else {
                        msm.clearSelectedPath();
                        mi.doClick(0);
                    }
                }
            }
        }

        private void selectParentChild(boolean direction) {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] path = msm.getSelectedPath();
            int len = path.length;
            if (!direction) {
                int popupIndex = len - 1;
                if (len > 2 && (path[popupIndex] instanceof JPopupMenu || path[--popupIndex] instanceof JPopupMenu) && !((JMenu)path[popupIndex - 1]).isTopLevelMenu()) {
                    MenuElement[] newPath = new MenuElement[popupIndex];
                    System.arraycopy(path, 0, newPath, 0, popupIndex);
                    msm.setSelectedPath(newPath);
                    return;
                }
            } else if (len > 0 && path[len - 1] instanceof JMenu && !((JMenu)path[len - 1]).isTopLevelMenu()) {
                MenuElement[] newPath;
                JMenu menu = (JMenu)path[len - 1];
                JPopupMenu popup = menu.getPopupMenu();
                MenuElement[] subs = popup.getSubElements();
                MenuElement item = this.findEnabledChild(subs, -1, true);
                if (item == null) {
                    newPath = new MenuElement[len + 1];
                } else {
                    newPath = new MenuElement[len + 2];
                    newPath[len + 1] = item;
                }
                System.arraycopy(path, 0, newPath, 0, len);
                newPath[len] = popup;
                msm.setSelectedPath(newPath);
                return;
            }
            if (len > 1 && path[0] instanceof JMenuBar) {
                MenuElement currentMenu = path[1];
                MenuElement nextMenu = this.findEnabledChild(path[0].getSubElements(), currentMenu, direction);
                if (nextMenu != null && nextMenu != currentMenu) {
                    JPopupMenu popup;
                    MenuElement nextItem;
                    MenuElement[] newSelection = null;
                    newSelection = len == 2 ? new MenuElement[]{path[0], nextMenu} : ((nextItem = this.findEnabledChild((popup = ((JMenu)nextMenu).getPopupMenu()).getSubElements(), -1, true)) != null ? new MenuElement[]{path[0], nextMenu, popup, nextItem} : new MenuElement[]{path[0], nextMenu, popup});
                    msm.setSelectedPath(newSelection);
                }
            }
        }

        private void selectItem(boolean direction) {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] path = msm.getSelectedPath();
            if (path.length < 2) {
                return;
            }
            int len = path.length;
            if (path[0] instanceof JMenuBar && path[1] instanceof JMenu && len == 2) {
                MenuElement[] newPath;
                JPopupMenu popup = ((JMenu)path[1]).getPopupMenu();
                MenuElement next = this.findEnabledChild(popup.getSubElements(), -1, true);
                if (next != null) {
                    newPath = new MenuElement[4];
                    newPath[3] = next;
                } else {
                    newPath = new MenuElement[3];
                }
                System.arraycopy(path, 0, newPath, 0, 2);
                newPath[2] = popup;
                msm.setSelectedPath(newPath);
            } else if (path[len - 1] instanceof JPopupMenu && path[len - 2] instanceof JMenu) {
                JMenu menu = (JMenu)path[len - 2];
                JPopupMenu popup = menu.getPopupMenu();
                MenuElement next = this.findEnabledChild(popup.getSubElements(), -1, direction);
                if (next != null) {
                    MenuElement[] newPath = new MenuElement[len + 1];
                    System.arraycopy(path, 0, newPath, 0, len);
                    newPath[len] = next;
                    msm.setSelectedPath(newPath);
                } else if (len > 2 && path[len - 3] instanceof JPopupMenu && (next = this.findEnabledChild((popup = (JPopupMenu)path[len - 3]).getSubElements(), menu, direction)) != null && next != menu) {
                    MenuElement[] newPath = new MenuElement[len - 1];
                    System.arraycopy(path, 0, newPath, 0, len - 2);
                    newPath[len - 2] = next;
                    msm.setSelectedPath(newPath);
                }
            } else {
                MenuElement[] subs = path[len - 2].getSubElements();
                MenuElement nextChild = this.findEnabledChild(subs, path[len - 1], direction);
                if (nextChild == null) {
                    nextChild = this.findEnabledChild(subs, -1, direction);
                }
                if (nextChild != null) {
                    path[len - 1] = nextChild;
                    msm.setSelectedPath(path);
                }
            }
        }

        private JPopupMenu getLastPopup() {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] p = msm.getSelectedPath();
            JPopupMenu popup = null;
            for (int i = p.length - 1; popup == null && i >= 0; --i) {
                if (!(p[i] instanceof JPopupMenu)) continue;
                popup = (JPopupMenu)p[i];
            }
            return popup;
        }

        private MenuElement findEnabledChild(MenuElement[] e, int fromIndex, boolean forward) {
            MenuElement result = null;
            if (forward) {
                result = this.nextEnabledChild(e, fromIndex + 1, e.length - 1);
                if (result == null) {
                    result = this.nextEnabledChild(e, 0, fromIndex - 1);
                }
            } else {
                result = this.previousEnabledChild(e, fromIndex - 1, 0);
                if (result == null) {
                    result = this.previousEnabledChild(e, e.length - 1, fromIndex + 1);
                }
            }
            return result;
        }

        private MenuElement nextEnabledChild(MenuElement[] e, int fromIndex, int toIndex) {
            for (int i = fromIndex; i <= toIndex; ++i) {
                Component comp;
                if (e[i] == null || (comp = e[i].getComponent()) == null || !comp.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable") || !comp.isVisible()) continue;
                return e[i];
            }
            return null;
        }

        private MenuElement previousEnabledChild(MenuElement[] e, int fromIndex, int toIndex) {
            for (int i = fromIndex; i >= toIndex; --i) {
                Component comp;
                if (e[i] == null || (comp = e[i].getComponent()) == null || !comp.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable") || !comp.isVisible()) continue;
                return e[i];
            }
            return null;
        }

        private MenuElement findEnabledChild(MenuElement[] e, MenuElement elem, boolean forward) {
            for (int i = 0; i < e.length; ++i) {
                if (e[i] != elem) continue;
                return this.findEnabledChild(e, i, forward);
            }
            return null;
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;

        private MouseInputHandler() {
        }

        public void mousePressed(MouseEvent ev) {
            int frameState;
            JRootPane rootPane = TinyRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Window w = (Window)ev.getSource();
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(w, dragWindowOffset, TinyRootPaneUI.this.getTitlePane());
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int n = frameState = f != null ? f.getExtendedState() : 0;
            if (TinyRootPaneUI.this.getTitlePane() != null && TinyRootPaneUI.this.getTitlePane().contains(convertedDragWindowOffset)) {
                if (ev.getClickCount() == 2 && f != null && f.isResizable()) {
                    if ((frameState & 2) == 2 || (frameState & 4) == 4) {
                        f.setExtendedState(frameState & 0xFFFFFFF9);
                    } else {
                        f.setExtendedState(frameState | 6);
                    }
                    return;
                }
                if ((f != null && (frameState & 2) != 2 && (frameState & 4) != 4 || d != null) && dragWindowOffset.y >= 5 && dragWindowOffset.x >= 5 && dragWindowOffset.x < w.getWidth() - 5) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = dragWindowOffset.x;
                    this.dragOffsetY = dragWindowOffset.y;
                    return;
                }
            }
            if (f != null && f.isResizable() && (frameState & 2) != 2 && (frameState & 4) != 4 || d != null && d.isResizable()) {
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
                this.dragWidth = w.getWidth();
                this.dragHeight = w.getHeight();
                int corner = this.calculateCorner(w, dragWindowOffset.x, dragWindowOffset.y);
                this.dragCursor = this.getCursor(corner);
            }
        }

        public void mouseReleased(MouseEvent ev) {
            if (this.dragCursor != 0 && TinyRootPaneUI.this.window != null && !TinyRootPaneUI.this.window.isValid()) {
                TinyRootPaneUI.this.window.validate();
                TinyRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
            Window w = (Window)ev.getSource();
            if (w.getCursor() != TinyRootPaneUI.this.lastCursor) {
                w.setCursor(TinyRootPaneUI.this.lastCursor);
            }
        }

        public void mouseMoved(MouseEvent ev) {
            JRootPane root = TinyRootPaneUI.this.getRootPane();
            if (root.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w = (Window)ev.getSource();
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int cursor = this.getCursor(this.calculateCorner(w, ev.getX(), ev.getY()));
            if (cursor != 0 && (f != null && f.isResizable() && (f.getExtendedState() & 4) != 4 && (f.getExtendedState() & 2) != 2 || d != null && d.isResizable())) {
                w.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                w.setCursor(TinyRootPaneUI.this.lastCursor);
            }
        }

        private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            bounds.x += deltaX;
            bounds.y += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (min != null) {
                int correction;
                if (bounds.width < min.width) {
                    correction = min.width - bounds.width;
                    if (deltaX != 0) {
                        bounds.x -= correction;
                    }
                    bounds.width = min.width;
                }
                if (bounds.height < min.height) {
                    correction = min.height - bounds.height;
                    if (deltaY != 0) {
                        bounds.y -= correction;
                    }
                    bounds.height = min.height;
                }
            }
        }

        public void mouseDragged(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Point pt = ev.getPoint();
            if (this.isMovingWindow) {
                Point windowPt = w.getLocationOnScreen();
                windowPt.x += pt.x - this.dragOffsetX;
                windowPt.y += pt.y - this.dragOffsetY;
                w.setLocation(windowPt);
            } else if (this.dragCursor != 0) {
                Rectangle r = w.getBounds();
                Rectangle startBounds = new Rectangle(r);
                Dimension min = w.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(r, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 8: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 6: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                }
                if (!r.equals(startBounds)) {
                    w.setBounds(r);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        w.validate();
                        TinyRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            TinyRootPaneUI.this.lastCursor = w.getCursor();
            this.mouseMoved(ev);
        }

        public void mouseExited(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            w.setCursor(TinyRootPaneUI.this.lastCursor);
        }

        public void mouseClicked(MouseEvent ev) {
        }

        private int calculateCorner(Component c, int x, int y) {
            int xPosition = this.calculatePosition(x, c.getWidth());
            int yPosition = this.calculatePosition(y, c.getHeight());
            if (xPosition == -1 || yPosition == -1) {
                return -1;
            }
            return yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return cursorMapping[corner];
        }

        private int calculatePosition(int spot, int width) {
            if (spot < 5) {
                return 0;
            }
            if (spot < 16) {
                return 1;
            }
            if (spot >= width - 5) {
                return 4;
            }
            if (spot >= width - 16) {
                return 3;
            }
            return 2;
        }
    }

    private class KeyPostProcessor
    implements KeyEventPostProcessor {
        private KeyPostProcessor() {
        }

        public boolean postProcessKeyEvent(KeyEvent e) {
            if (!TinyRootPaneUI.this.topMenuToClose) {
                return false;
            }
            if (e.getID() != 401) {
                return false;
            }
            if (e.getKeyCode() == 27) {
                return false;
            }
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            boolean isRegisteredKeyStroke = false;
            Iterator ii = TinyRootPaneUI.this.registeredKeyCodes.iterator();
            while (ii.hasNext()) {
                int keyCode = (Integer)ii.next();
                if (keyCode != e.getKeyCode()) continue;
                if (path.length > 2) {
                    TinyRootPaneUI.this.topMenuToClose = false;
                    TinyRootPaneUI.this.removeEscapeMenuHandlers();
                }
                return false;
            }
            if (path.length == 2) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
            TinyRootPaneUI.this.topMenuToClose = false;
            TinyRootPaneUI.this.removeEscapeMenuHandlers();
            return false;
        }
    }

    private class MouseHandler
    implements AWTEventListener {
        private MouseHandler() {
        }

        public void eventDispatched(AWTEvent e) {
            if (!TinyRootPaneUI.this.topMenuToClose) {
                return;
            }
            MenuSelectionManager.defaultManager().clearSelectedPath();
            TinyRootPaneUI.this.topMenuToClose = false;
            TinyRootPaneUI.this.removeEscapeMenuHandlers();
        }
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private MetalRootLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof TinyRootPaneUI && (titlePane = ((TinyRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof TinyRootPaneUI && (titlePane = ((TinyRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMinimumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
        }

        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets i = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof TinyRootPaneUI && (titlePane = ((TinyRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i.top + i.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += i.left + i.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        public void layoutContainer(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i = root.getInsets();
            int nextY = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof TinyRootPaneUI && (titlePane = ((TinyRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, w, tpHeight);
                nextY += tpHeight;
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, w, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                Dimension cpd = root.getContentPane().getPreferredSize();
                root.getContentPane().setBounds(0, nextY, w, h < nextY ? 0 : h - nextY);
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }
    }
}

