/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.metal.MetalComboBoxEditor;

public class TinyComboBoxEditor
extends MetalComboBoxEditor {
    public TinyComboBoxEditor() {
        this.editor = new JTextField("", 9){

            public void setText(String s) {
                if (this.getText().equals(s)) {
                    return;
                }
                super.setText(s);
            }
        };
        this.editor.setBorder(new EditorBorder());
    }

    private void drawXpBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (c != null && c.getParent() != null && c.getParent().getParent() != null) {
            g.setColor(c.getParent().getParent().getBackground());
        }
        g.drawLine(x, y, x + w - 1, y);
        g.drawLine(x, y, x, y + h - 1);
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        if (!c.isEnabled()) {
            DrawRoutines.drawEditableComboBorder(g, Theme.comboBorderDisabledColor.getColor(), 0, 0, w, h);
        } else {
            DrawRoutines.drawEditableComboBorder(g, Theme.comboBorderColor.getColor(), 0, 0, w, h);
        }
    }

    public static class UIResource
    extends TinyComboBoxEditor
    implements javax.swing.plaf.UIResource {
    }

    class EditorBorder
    extends AbstractBorder {
        EditorBorder() {
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, Theme.comboInsets.left + 1, 1, 0);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JComponent combo = (JComponent)TinyComboBoxEditor.this.editor.getParent();
            if (combo != null && combo.getBorder() == null) {
                return;
            }
            TinyComboBoxEditor.this.drawXpBorder(c, g, x, y, w, h);
        }
    }
}

