/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tintfu;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.List;
import java.util.Stack;
import net.sourceforge.tintfu.DefaultStateTransition;
import net.sourceforge.tintfu.DefaultToken;
import net.sourceforge.tintfu.DotAttribute;
import net.sourceforge.tintfu.DotEdge;
import net.sourceforge.tintfu.DotGraph;
import net.sourceforge.tintfu.DotNode;
import net.sourceforge.tintfu.DotTreeNode;
import net.sourceforge.tintfu.LineTokenizer;
import net.sourceforge.tintfu.Token;
import net.sourceforge.tintfu.Tokenizer;
import net.sourceforge.tintfu.TwoWayStateTransition;
import net.sourceforge.tintfu.YStateMachine;
import net.sourceforge.tintfu.YStringTokenizer;

public abstract class DotElement {
    private static Stack stateStack = new Stack();
    List fields;

    private static void pushState(YStateMachine ysm, String newState) throws Exception {
        stateStack.push(ysm.getState());
        ysm.setState(newState);
    }

    private static void popState(YStateMachine ysm) throws Exception {
        if (stateStack.isEmpty()) {
            ysm.setState("stateStackUnderFlow");
        }
        ysm.setState((String)stateStack.pop());
    }

    protected DotElement(List fields) {
        this.fields = fields;
    }

    public String getFromNode() {
        return null;
    }

    public String getGraphType() {
        return null;
    }

    public String getName() {
        return null;
    }

    public String getToNode() {
        return null;
    }

    public abstract int indexOf(String var1);

    public abstract String toString();

    public abstract void writeAttributes(PrintWriter var1);

    static Token getToken(Tokenizer tkn, YStateMachine ysm) throws Exception {
        Token tok = tkn.getToken();
        block0: while (tok.getType() == -5) {
            if (tok.getChar() == ' ' || tok.getChar() == '\t' || tok.getChar() == ';') {
                tok = tkn.getToken();
                continue;
            }
            if (tok.getChar() != '\"') break;
            String s = "";
            while (true) {
                if ((tok = tkn.getToken()).equals(DefaultToken.EOF)) {
                    ysm.setState("EOF_InString");
                    continue;
                }
                if (tok.getChar() == '\"') {
                    tok = new DefaultToken(s, -1);
                    continue block0;
                }
                if (tok.getChar() == '\\') {
                    s = s + tok.getChar();
                    s = s + tkn.getToken().getString();
                    continue;
                }
                s = s + tok.getString();
            }
        }
        System.out.println("Token: " + tok.dumpAsString());
        return tok;
    }

    static DotElement create(List fields) {
        String et = ((DotAttribute)fields.get(0)).getAttr();
        if (et.equals("graph")) {
            return new DotGraph(fields);
        }
        if (et.equals("node")) {
            return new DotNode(fields);
        }
        if (et.equals("edge")) {
            return new DotEdge(fields);
        }
        return null;
    }

    static YStateMachine createMachine() {
        YStateMachine ysm = null;
        try {
            ysm = new YStateMachine();
            ysm.setName("DotFileParser");
            new DefaultStateTransition(ysm, "BOF", "EOF", "Empty file");
            new DefaultStateTransition(ysm, "BOF", "graphName");
            new DefaultStateTransition(ysm, "graphName", "{");
            new DefaultStateTransition(ysm, "{", "stmtList");
            new TwoWayStateTransition(ysm, "stmtList", "graphAttrib");
            new DefaultStateTransition(ysm, "stmtList", "node");
            new DefaultStateTransition(ysm, "stmtList", "edge");
            new DefaultStateTransition(ysm, "stmtList", "{", "subGraph");
            new TwoWayStateTransition(ysm, "stmtList", "}");
            new DefaultStateTransition(ysm, "}", "EOF");
            new DefaultStateTransition(ysm, "node", "nodeName");
            new DefaultStateTransition(ysm, "edge", "edgePair");
            new DefaultStateTransition(ysm, "nodeName", "nodeList", "[");
            new DefaultStateTransition(ysm, "nodeName", "stmtList");
            new DefaultStateTransition(ysm, "edgePair", "edgeList", "[");
            new DefaultStateTransition(ysm, "edgePair", "stmtList");
            new DefaultStateTransition(ysm, "nodeList", "stmtList", "]");
            new DefaultStateTransition(ysm, "edgeList", "stmtList", "]");
            new TwoWayStateTransition(ysm, "nodeList", "nodeAttrib");
            new TwoWayStateTransition(ysm, "edgeList", "edgeAttrib");
            ysm.setInitialState("BOF");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        return ysm;
    }

    static Tokenizer createTokenizer(File f) throws Exception {
        return new YStringTokenizer(new LineTokenizer(new BufferedReader(new FileReader(f))), "\"=:@;{}[] \t->,()\\", true);
    }

    static DotTreeNode readDotFile(Tokenizer tkn, YStateMachine ysm, DotTreeNode current) {
        while (true) {
            try {
                Token tok = DotElement.getToken(tkn, ysm);
                switch (tok.getType()) {
                    case -7: {
                        ysm.setState("BOF");
                        break;
                    }
                    case -6: {
                        ysm.setState("EOF");
                    }
                }
                if (ysm.stateIs("BOF")) {
                    if (current.elm != null) {
                        ysm.setState("rootNotNull");
                    }
                    current.elm = new DotGraph(DotGraph.createGraphList(true));
                    tkn.unGet(tok);
                    ysm.setState("graphName");
                    continue;
                }
                if (ysm.stateIs("graphName")) {
                    DotGraph elm = (DotGraph)current.elm;
                    DotAttribute gt = (DotAttribute)elm.fields.get(0);
                    DotAttribute nm = (DotAttribute)elm.fields.get(1);
                    if (tok.getString().compareToIgnoreCase("strict") == 0) {
                        tok = DotElement.getToken(tkn, ysm);
                        if (tok.getString().compareToIgnoreCase("graph") == 0) {
                            gt.setValue("strict graph");
                        } else if (tok.getString().compareToIgnoreCase("digraph") == 0) {
                            gt.setValue("strict digraph");
                        } else {
                            ysm.setState("expectedKeywordGraph");
                        }
                    } else if (tok.getString().compareToIgnoreCase("graph") == 0) {
                        gt.setValue("graph");
                    } else if (tok.getString().compareToIgnoreCase("digraph") == 0) {
                        gt.setValue("digraph");
                    } else {
                        ysm.setState("expectedKeywordGraph");
                    }
                    tok = DotElement.getToken(tkn, ysm);
                    if (tok.getChar() == '{') {
                        ysm.setState("expectedGraphName");
                    }
                    nm.setValue(tok.getString());
                    ysm.setState("{");
                    continue;
                }
                if (ysm.stateIs("{")) {
                    if (tok.getType() == -5 && tok.getChar() == '{') {
                        ysm.setState("stmtList");
                        continue;
                    }
                    ysm.setState("expected{");
                    continue;
                }
                if (ysm.stateIs("stmtList")) {
                    if (tok.getString().compareToIgnoreCase("node") == 0) {
                        DotElement.pushState(ysm, "node");
                        continue;
                    }
                    if (tok.getString().compareToIgnoreCase("edge") == 0) {
                        DotElement.pushState(ysm, "edge");
                        continue;
                    }
                    if (tok.getChar() == '}') {
                        tkn.unGet(tok);
                        ysm.setState("}");
                        continue;
                    }
                    if (tok.getChar() == '{') {
                        DotElement.pushState(ysm, "{");
                        tkn.unGet(tok);
                        current.add(DotElement.readDotFile(tkn, ysm, new DotTreeNode(new DotGraph(DotGraph.createGraphList(false)))));
                        DotElement.popState(ysm);
                        continue;
                    }
                    Token peek = DotElement.getToken(tkn, ysm);
                    tkn.unGet(peek);
                    tkn.unGet(tok);
                    if (peek.getChar() == '=') {
                        DotElement.pushState(ysm, "graphAttrib");
                        continue;
                    }
                    if (peek.getChar() == '-') {
                        tkn.unGet(new DefaultToken("edge"));
                        continue;
                    }
                    tkn.unGet(new DefaultToken("node"));
                    continue;
                }
                if (ysm.stateIs("}")) {
                    if (tok.getType() == -5 && tok.getChar() == '}') {
                        return current;
                    }
                    ysm.setState("expected}");
                    continue;
                }
                if (ysm.stateIs("graphAttrib") || ysm.stateIs("nodeAttrib") || ysm.stateIs("edgeAttrib")) {
                    int idx;
                    if (DotElement.getToken(tkn, ysm).getChar() != '=') {
                        ysm.setState("expectedEquals");
                    }
                    if ((idx = current.elm.indexOf(tok.getString())) == -1) {
                        System.out.println("WARNING: Ignoring unknown attribute " + tok.getString() + " in " + current.elm);
                        DotElement.getToken(tkn, ysm);
                    } else {
                        DotAttribute dta = (DotAttribute)current.elm.fields.get(idx);
                        dta.setValue(DotElement.getToken(tkn, ysm).getString());
                    }
                    DotElement.popState(ysm);
                    continue;
                }
                if (ysm.stateIs("node")) {
                    ysm.setState("nodeName");
                    tkn.unGet(tok);
                    current.add(DotElement.readDotFile(tkn, ysm, new DotTreeNode(new DotNode(DotNode.createNodeList()))));
                    DotElement.popState(ysm);
                    continue;
                }
                if (ysm.stateIs("edge")) {
                    ysm.setState("edgePair");
                    tkn.unGet(tok);
                    current.add(DotElement.readDotFile(tkn, ysm, new DotTreeNode(new DotEdge(DotEdge.createEdgeList()))));
                    DotElement.popState(ysm);
                    continue;
                }
                if (ysm.stateIs("nodeName")) {
                    ((DotAttribute)current.elm.fields.get(0)).setValue(tok.getString());
                    tok = DotElement.getToken(tkn, ysm);
                    if (tok.getChar() == '[') {
                        ysm.setState("nodeList");
                        continue;
                    }
                    tkn.unGet(tok);
                    return current;
                }
                if (ysm.stateIs("edgePair")) {
                    ((DotAttribute)current.elm.fields.get(0)).setValue(tok.getString());
                    tok = DotElement.getToken(tkn, ysm);
                    tok = DotElement.getToken(tkn, ysm);
                    tok = DotElement.getToken(tkn, ysm);
                    ((DotAttribute)current.elm.fields.get(1)).setValue(tok.getString());
                    tok = DotElement.getToken(tkn, ysm);
                    if (tok.getChar() == '[') {
                        ysm.setState("edgeList");
                        continue;
                    }
                    tkn.unGet(tok);
                    return current;
                }
                if (ysm.stateIs("nodeList")) {
                    if (tok.getChar() == ']') {
                        return current;
                    }
                    tkn.unGet(tok);
                    DotElement.pushState(ysm, "nodeAttrib");
                    continue;
                }
                if (ysm.stateIs("edgeList")) {
                    if (tok.getChar() == ']') {
                        return current;
                    }
                    tkn.unGet(tok);
                    DotElement.pushState(ysm, "edgeAttrib");
                    continue;
                }
                ysm.setState("unknownState");
            }
            catch (Exception ex) {
                ysm.printLastTransitions(System.out);
                System.err.flush();
                System.out.flush();
                ex.printStackTrace();
                System.err.flush();
                System.exit(1);
                return null;
            }
        }
    }

    public DotAttribute getByName(String attr) {
        int i = this.indexOf(attr);
        if (i >= 0) {
            return (DotAttribute)this.fields.get(i);
        }
        return null;
    }
}

