/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tintfu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.tintfu.AboutBox;
import net.sourceforge.tintfu.DotAttribute;
import net.sourceforge.tintfu.DotEdge;
import net.sourceforge.tintfu.DotElement;
import net.sourceforge.tintfu.DotElementEditor;
import net.sourceforge.tintfu.DotGraph;
import net.sourceforge.tintfu.DotNode;
import net.sourceforge.tintfu.DotTreeNode;
import net.sourceforge.tintfu.EdgeListEditor;
import net.sourceforge.tintfu.Tokenizer;
import net.sourceforge.tintfu.YStateMachine;

public class DotEditor
extends JFrame {
    File lastPng = null;
    List clipBoard = null;
    File currentFile = null;
    DotTreeNode root = new DotTreeNode(new DotGraph(DotGraph.createGraphList(true)));
    EditTreeModel curTM = null;
    private JSeparator jSeparator2;
    private JButton buttCut;
    private JCheckBoxMenuItem usePNGMenuItem;
    private JScrollPane jScrollPane1;
    private JButton buttEdit;
    private JLabel jLabel1;
    private JMenu fileMenu;
    private JButton buttCopy;
    private JMenuItem exitMenuItem;
    private JSplitPane jSplitPane1;
    private JButton buttRename;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JScrollPane jScrollPane2;
    private JButton buttGraph;
    private JToolBar jToolBar1;
    private JMenuItem openMenuItem;
    private JMenuBar menuBar;
    private JButton buttNode;
    private JButton buttEdge;
    private JTextField txtRename;
    private JMenu editorMenu;
    private JButton buttPaste;
    private JSeparator jSeparator1;
    private JButton buttSwapRank;
    private JButton buttCycleDir;
    private JMenuItem jMenuItemEdgeEditor;
    private JMenuItem aboutMenuItem;
    private JMenu helpMenu;
    private JTree jTree1;

    public void writeDotFile(DotTreeNode node, PrintWriter out) {
        if (node.elm == null) {
            System.out.println("elm==null? " + node);
        }
        if (node.elm instanceof DotGraph) {
            if (node.getParent() == null && node.elm.getGraphType() != null) {
                out.println(node.elm.getGraphType() + " \"" + node.elm.getName() + "\" {");
            } else {
                out.println("{");
            }
            node.elm.writeAttributes(out);
        } else {
            node.elm.writeAttributes(out);
        }
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            this.writeDotFile((DotTreeNode)e.nextElement(), out);
        }
        if (node.elm instanceof DotGraph) {
            out.println("}");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void showDotImage() {
        try {
            int ch;
            File fDot = File.createTempFile("dot", ".dot");
            fDot.deleteOnExit();
            File fPng = File.createTempFile("dot", this.usePNGMenuItem.isSelected() ? ".png" : ".jpg");
            fPng.deleteOnExit();
            FileOutputStream fout = new FileOutputStream(fDot);
            PrintWriter pwrt = new PrintWriter(fout);
            this.writeDotFile(this.root, pwrt);
            pwrt.flush();
            pwrt.close();
            fout.flush();
            fout.close();
            Process prc = Runtime.getRuntime().exec("dot -T" + (this.usePNGMenuItem.isSelected() ? "png " : "jpg ") + fDot.getAbsolutePath());
            fout = new FileOutputStream(fPng);
            while ((ch = prc.getInputStream().read()) != -1) {
                void var6_7;
                fout.write((int)var6_7);
            }
            fout.flush();
            fout.close();
            try {
                prc.waitFor();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            prc = null;
            fDot.delete();
            this.jLabel1.setIcon(new ImageIcon(fPng.getAbsolutePath()));
            if (this.lastPng != null) {
                this.lastPng.delete();
            }
            this.lastPng = fPng;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DotEditor() {
        this.initComponents();
        this.buttRename.setEnabled(false);
        this.buttCycleDir.setEnabled(false);
        this.buttSwapRank.setEnabled(false);
        this.showDotImage();
    }

    TreeModel createTreeModel() {
        this.curTM = new EditTreeModel(this.root);
        return this.curTM;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jToolBar1 = new JToolBar();
        this.buttNode = new JButton();
        this.buttEdge = new JButton();
        this.buttGraph = new JButton();
        this.buttEdit = new JButton();
        this.jSeparator1 = new JSeparator();
        this.buttCut = new JButton();
        this.buttCopy = new JButton();
        this.buttPaste = new JButton();
        this.jSeparator2 = new JSeparator();
        this.txtRename = new JTextField();
        this.buttRename = new JButton();
        this.buttCycleDir = new JButton();
        this.buttSwapRank = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.usePNGMenuItem = new JCheckBoxMenuItem();
        this.editorMenu = new JMenu();
        this.jMenuItemEdgeEditor = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.setTitle("TINTFU");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DotEditor.this.exitForm(evt);
            }
        });
        this.jSplitPane1.setPreferredSize(new Dimension(800, 600));
        this.jScrollPane2.setViewportView(this.jLabel1);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.jTree1.setModel(this.createTreeModel());
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                DotEditor.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.buttNode.setText("Node");
        this.buttNode.setToolTipText("Insert a new node");
        this.buttNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.buttNodeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.buttNode);
        this.buttEdge.setText("Edge");
        this.buttEdge.setToolTipText("Insert a new edge");
        this.buttEdge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.buttEdgeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.buttEdge);
        this.buttGraph.setText("Graph");
        this.buttGraph.setToolTipText("Insert a new sub-graph");
        this.buttGraph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.buttGraphActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.buttGraph);
        this.buttEdit.setText("Edit");
        this.buttEdit.setToolTipText("Edit the current element");
        this.buttEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.buttEditActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.buttEdit);
        this.jSeparator1.setOrientation(1);
        this.jToolBar1.add(this.jSeparator1);
        this.buttCut.setText("Cut");
        this.buttCut.setToolTipText("Copy to clipboard and remove");
        this.buttCut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.buttCutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.buttCut);
        this.buttCopy.setText("Copy");
        this.buttCopy.setToolTipText("Copy to clipboard");
        this.buttCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.buttCopyActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.buttCopy);
        this.buttPaste.setText("Paste");
        this.buttPaste.setToolTipText("Paste from clipboard");
        this.buttPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.buttPasteActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.buttPaste);
        this.jToolBar1.add(this.jSeparator2);
        this.txtRename.setText("n/a");
        this.jToolBar1.add(this.txtRename);
        this.buttRename.setText("Rename");
        this.buttRename.setToolTipText("Rename the selected node");
        this.buttRename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.buttRenameActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.buttRename);
        this.buttCycleDir.setText("Cycle dir");
        this.buttCycleDir.setToolTipText("Cycle arrow direction");
        this.buttCycleDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.buttCycleDirActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.buttCycleDir);
        this.buttSwapRank.setText("Swap rank");
        this.buttSwapRank.setToolTipText("Swap edge from/to");
        this.buttSwapRank.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.buttSwapRankActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.buttSwapRank);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.fileMenu.setText("File");
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText("Save As ...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.usePNGMenuItem.setText("Use PNG preview");
        this.usePNGMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DotEditor.this.usePNGMenuItemItemStateChanged(evt);
            }
        });
        this.fileMenu.add(this.usePNGMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editorMenu.setText("Editors");
        this.jMenuItemEdgeEditor.setText("Edge list editor ...");
        this.jMenuItemEdgeEditor.setToolTipText("Open the edge list editor dialog");
        this.jMenuItemEdgeEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.jMenuItemEdgeEditorActionPerformed(evt);
            }
        });
        this.editorMenu.add(this.jMenuItemEdgeEditor);
        this.menuBar.add(this.editorMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setText("About ...");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DotEditor.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void usePNGMenuItemItemStateChanged(ItemEvent evt) {
        this.showDotImage();
    }

    private void jMenuItemEdgeEditorActionPerformed(ActionEvent evt) {
        new EdgeListEditor((Frame)this, true, this.root).show();
        this.jTree1.setModel(this.createTreeModel());
        this.showDotImage();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        new AboutBox((Frame)this, true, "Version 0.0.4 (beta)").show();
    }

    private void buttSwapRankActionPerformed(ActionEvent evt) {
        try {
            DotTreeNode n = (DotTreeNode)this.jTree1.getLastSelectedPathComponent();
            if (n.elm instanceof DotEdge) {
                DotAttribute fr = (DotAttribute)n.elm.fields.get(0);
                DotAttribute to = (DotAttribute)n.elm.fields.get(1);
                String tmp = fr.getValue();
                fr.setValue(to.getValue());
                to.setValue(tmp);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        TreePath tp = this.jTree1.getSelectionPath();
        this.jTree1.setModel(this.createTreeModel());
        this.jTree1.setSelectionPath(tp);
        this.showDotImage();
    }

    private void buttCycleDirActionPerformed(ActionEvent evt) {
        try {
            DotTreeNode n = (DotTreeNode)this.jTree1.getLastSelectedPathComponent();
            if (n.elm instanceof DotEdge) {
                DotAttribute dr = n.elm.getByName("dir");
                String s = dr.getValue();
                if (s == null) {
                    dr.setValue(DotAttribute.DIRECTIONS[1]);
                } else {
                    int i = 1;
                    while (i < DotAttribute.DIRECTIONS.length - 1) {
                        if (s.equals(DotAttribute.DIRECTIONS[i])) {
                            dr.setValue(DotAttribute.DIRECTIONS[i + 1]);
                            s = null;
                            break;
                        }
                        ++i;
                    }
                    if (s != null) {
                        dr.setValue(DotAttribute.DIRECTIONS[0]);
                    }
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        TreePath tp = this.jTree1.getSelectionPath();
        this.jTree1.setModel(this.createTreeModel());
        this.jTree1.setSelectionPath(tp);
        this.showDotImage();
    }

    private void buttRenameActionPerformed(ActionEvent evt) {
        try {
            DotTreeNode n = (DotTreeNode)this.jTree1.getLastSelectedPathComponent();
            if (n.elm instanceof DotNode) {
                this.root.renameNode(n.elm.getName(), this.txtRename.getText());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.jTree1.setModel(this.createTreeModel());
        this.showDotImage();
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        this.buttRename.setEnabled(false);
        this.txtRename.setText("n/a");
        this.buttCycleDir.setEnabled(false);
        this.buttSwapRank.setEnabled(false);
        try {
            DotTreeNode n = (DotTreeNode)this.jTree1.getLastSelectedPathComponent();
            if (n.elm instanceof DotNode) {
                this.txtRename.setText(n.elm.getName());
                this.buttRename.setEnabled(true);
            } else if (n.elm instanceof DotEdge) {
                this.buttCycleDir.setEnabled(true);
                this.buttSwapRank.setEnabled(true);
            }
        }
        catch (Exception ex) {}
    }

    private void buttPasteActionPerformed(ActionEvent evt) {
        if (this.clipBoard == null) {
            return;
        }
        try {
            DotTreeNode n = (DotTreeNode)this.jTree1.getLastSelectedPathComponent();
            while (!((DotAttribute)n.elm.fields.get(0)).getAttr().equals("graph")) {
                n = (DotTreeNode)n.getParent();
            }
            this.curTM.insertNodeInto(new DotTreeNode(DotElement.create(DotAttribute.copy(this.clipBoard))), n, n.getChildCount());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.showDotImage();
    }

    private void buttCopyActionPerformed(ActionEvent evt) {
        try {
            this.clipBoard = DotAttribute.copy(((DotTreeNode)this.jTree1.getLastSelectedPathComponent()).elm.fields);
        }
        catch (Exception ex) {}
    }

    private void buttCutActionPerformed(ActionEvent evt) {
        try {
            DotTreeNode n = (DotTreeNode)this.jTree1.getLastSelectedPathComponent();
            this.clipBoard = DotAttribute.copy(n.elm.fields);
            this.curTM.removeNodeFromParent(n);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.showDotImage();
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        if (this.currentFile != null) {
            chooser.setCurrentDirectory(this.currentFile);
        }
        chooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".dot");
            }

            public String getDescription() {
                return "DOT files";
            }
        });
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            this.currentFile = chooser.getSelectedFile();
            if (this.currentFile == null) {
                return;
            }
            try {
                this.setTitle("TINTFU - " + this.currentFile.getName());
                Tokenizer tkn = DotElement.createTokenizer(this.currentFile);
                YStateMachine ysm = DotElement.createMachine();
                this.root = DotElement.readDotFile(tkn, ysm, new DotTreeNode(null));
                this.jTree1.setModel(this.createTreeModel());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setTitle("TINTFU - FAILED TO READ FILE: " + this.currentFile.getName());
            }
        }
        this.showDotImage();
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        if (this.currentFile == null) {
            this.saveAsMenuItemActionPerformed(evt);
        } else {
            try {
                FileOutputStream fout = new FileOutputStream(this.currentFile);
                PrintWriter pwrt = new PrintWriter(fout);
                this.writeDotFile(this.root, pwrt);
                pwrt.flush();
                pwrt.close();
            }
            catch (Exception ex) {
                this.setTitle("TINTFU ! FAILED TO SAVE FILE !");
                ex.printStackTrace();
            }
        }
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        if (this.currentFile != null) {
            chooser.setCurrentDirectory(this.currentFile);
        }
        chooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".dot");
            }

            public String getDescription() {
                return "DOT files";
            }
        });
        int option = chooser.showSaveDialog(this);
        if (option == 0) {
            this.currentFile = chooser.getSelectedFile();
            if (this.currentFile == null) {
                return;
            }
            this.setTitle("TINTFU - " + this.currentFile.getName());
            this.saveMenuItemActionPerformed(evt);
        }
    }

    private void buttEditActionPerformed(ActionEvent evt) {
        try {
            DotTreeNode n = (DotTreeNode)this.jTree1.getLastSelectedPathComponent();
            DotElementEditor ea = new DotElementEditor((Frame)this, true, n.elm.fields);
            ea.show();
            if (ea.getReturnStatus() == 1) {
                this.jTree1.scrollPathToVisible(this.jTree1.getSelectionPath());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.showDotImage();
    }

    private void buttGraphActionPerformed(ActionEvent evt) {
        DotTreeNode n = this.getSelectedParentGraph();
        try {
            List fields = DotGraph.createGraphList(false);
            DotElementEditor ea = new DotElementEditor((Frame)this, true, fields);
            ea.show();
            if (ea.getReturnStatus() == 1) {
                this.curTM.insertNodeInto(new DotTreeNode(DotElement.create(fields)), n, n.getChildCount());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.showDotImage();
    }

    private void buttEdgeActionPerformed(ActionEvent evt) {
        DotTreeNode n = this.getSelectedParentGraph();
        try {
            List fields = DotEdge.createEdgeList();
            DotElementEditor ea = new DotElementEditor((Frame)this, true, fields);
            ea.show();
            if (ea.getReturnStatus() == 1) {
                this.curTM.insertNodeInto(new DotTreeNode(DotElement.create(fields)), n, n.getChildCount());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.showDotImage();
    }

    private DotTreeNode getSelectedParentGraph() {
        DotTreeNode n = null;
        try {
            n = (DotTreeNode)this.jTree1.getLastSelectedPathComponent();
            while (!((DotAttribute)n.elm.fields.get(0)).getAttr().equals("graph")) {
                n = (DotTreeNode)n.getParent();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (n == null) {
            return this.root;
        }
        return n;
    }

    private void buttNodeActionPerformed(ActionEvent evt) {
        DotTreeNode n = this.getSelectedParentGraph();
        try {
            List fields = DotNode.createNodeList();
            DotElementEditor ea = new DotElementEditor((Frame)this, true, fields);
            ea.show();
            if (ea.getReturnStatus() == 1) {
                this.curTM.insertNodeInto(new DotTreeNode(DotElement.create(fields)), n, n.getChildCount());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.showDotImage();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        new DotEditor().show();
    }

    class EditTreeModel
    extends DefaultTreeModel {
        EditTreeModel(DotTreeNode root) {
            super(root);
        }
    }
}

