/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tintfu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class DotAttribute {
    public static final String[] DIRECTIONS = new String[]{"forward", "back", "both", "none"};
    public static final String[] ARROWHEADS = new String[]{"normal", "inv", "none", "dot", "odot", "invdot", "invodot"};
    public static final String[] SHAPES = new String[]{"ellipse", "box", "diamond", "house", "invhouse", "egg", "circle", "doublecircle", "point", "triangle", "invtriangle", "plaintext", "trapezium", "invtrapezium", "parallelogram", "hexagon", "octagon", "doubleoctagon", "tripleoctagon", "record", "polygon"};
    protected final JComponent comp;
    protected JLabel attr = new JLabel();

    protected DotAttribute(String attr, JComponent comp) {
        this.attr.setText(attr);
        this.comp = comp;
        this.setSizes();
    }

    public void setAttr(String attr) {
        this.attr.setText(attr);
    }

    public String getAttr() {
        return this.attr.getText();
    }

    public abstract void setValue(String var1);

    public abstract String getValue();

    public void addComponents(JPanel parent) {
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new BorderLayout());
        fieldPanel.add((Component)this.attr, "West");
        fieldPanel.add((Component)this.comp, "Center");
        parent.add(fieldPanel);
    }

    public abstract DotAttribute dup();

    public static List copy(List src) {
        ArrayList<DotAttribute> dst = new ArrayList<DotAttribute>(src.size());
        int i = 0;
        while (i < src.size()) {
            dst.add(((DotAttribute)src.get(i)).dup());
            ++i;
        }
        return dst;
    }

    public String toString() {
        return this.getAttr() + "=\"" + this.getValue() + "\"";
    }

    private void setSizes() {
        this.attr.setPreferredSize(new Dimension(100, 20));
        this.comp.setPreferredSize(new Dimension(300, 20));
    }
}

