/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tintfu;

import net.sourceforge.tintfu.Token;

public abstract class AbstractToken
implements Token {
    private String token = null;

    public AbstractToken() {
    }

    public AbstractToken(String s) {
        this.token = s;
    }

    public boolean getBoolean() {
        switch (this.getType()) {
            case -7: 
            case -6: 
            case 0: {
                return false;
            }
            case -2: {
                return this.getInteger() != 0L;
            }
            case -3: {
                double d = this.getNumber();
                return d != Double.NaN && d != 0.0;
            }
        }
        String t = this.getString().trim();
        if (t.length() == 0) {
            return false;
        }
        return "nNfF".indexOf(t.charAt(0)) < 0;
    }

    public long getInteger() {
        try {
            return Long.valueOf(this.getString());
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public double getNumber() {
        try {
            return Double.valueOf(this.getString());
        }
        catch (Exception ex) {
            return Double.NaN;
        }
    }

    public void setToken(String token) {
        this.token = token;
    }

    public abstract int getType();

    public char getChar() {
        switch (this.getType()) {
            case -7: 
            case -6: {
                break;
            }
            case -2: {
                long l = this.getInteger();
                if (l < 0L || l >= 65535L) break;
                return (char)l;
            }
            case -3: {
                long l = Math.round(this.getNumber());
                if (l < 0L || l >= 65535L) break;
                return (char)l;
            }
            default: {
                if (this.token == null || this.token.length() <= 0) break;
                return this.token.charAt(0);
            }
        }
        return '\u0000';
    }

    public int getCharValue() {
        return this.getChar();
    }

    public String getString() {
        switch (this.getType()) {
            case -7: 
            case -6: {
                break;
            }
            case -5: {
                if (this.token != null) {
                    if (this.token.length() > 1) {
                        return this.token.substring(0, 1);
                    }
                    return this.token;
                }
                return new String();
            }
            default: {
                if (this.token == null) break;
                return this.token;
            }
        }
        return new String();
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Token) {
            Token t = (Token)obj;
            if (this.getType() == 0 || t.getType() == 0) {
                return true;
            }
            if (t.getType() != this.getType()) {
                return false;
            }
            switch (t.getType()) {
                case -7: 
                case -6: 
                case 0: {
                    return true;
                }
                case -2: {
                    return t.getInteger() == this.getInteger();
                }
                case -3: {
                    return t.getNumber() == this.getNumber();
                }
                case -4: {
                    return t.getBoolean() == this.getBoolean();
                }
            }
            return t.getString().equals(this.getString());
        }
        return this.getString().equals(obj.toString());
    }

    public String toString() {
        return this.getString();
    }

    public String dumpAsString() {
        return "token='" + this.token + "'";
    }
}

