
import java.util.Scanner;

import au.edu.mq.itec802.cardGame.blackjack.BlackjackGame;

/**
 * Class BlackjackClient
 * 
 * Sample client program for the Blackjack game developed as Assignment 1
 * for ITEC802@MQ
 * 
 * @author		Tomas Krajca <tomas.krajca@students.mq.edu.au>
 * @version 	$Id: BlackjackClient.java 22/03/2011 jumbo$
 */
public class BlackjackClient {
	/**
	 * Main 
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		Scanner in = new Scanner(System.in);
		int amount = 0;
		int bet = 0;

		do {
			System.out.print("Please enter amount to begin with: ");
			do {
				try {
					amount = Integer.parseInt(in.nextLine());
					if (amount > 0)
						break;
				} catch (NumberFormatException e) {
				}
				System.out.print("Please enter a positive integer: ");
			} while (amount <= 0);

			System.out.print("Please enter bet for each round: ");
			do {
				try {
					bet = Integer.parseInt(in.nextLine());
					if (bet > 0)
						break;
				} catch (NumberFormatException e) {
				}
				System.out.print("Please enter a positive integer: ");
			} while (bet <= 0);

			if (amount >= bet)
				break;
			System.out
					.println("Please enter a correct amount and bet (you \ncannot bet more than you have)");
		} while (bet > amount);

		BlackjackGame game = new BlackjackGame(2, new int[] { amount, amount },
				new int[] { bet, bet });

		game.play();

		System.out.println();
		System.out.println(game);
	}
}
