/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderLayout;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TypedListener;

public class CTabFolder
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int MIN_TAB_WIDTH = 4;
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    int xClient;
    int yClient;
    boolean onBottom = false;
    boolean single = false;
    boolean simple = true;
    int fixedTabHeight = -1;
    int tabHeight;
    int minChars = 20;
    CTabItem[] items = new CTabItem[0];
    int firstIndex = -1;
    int selectedIndex = -1;
    int[] priority = new int[0];
    boolean mru = false;
    Listener listener;
    boolean ignoreTraverse;
    CTabFolder2Listener[] folderListeners = new CTabFolder2Listener[0];
    CTabFolderListener[] tabListeners = new CTabFolderListener[0];
    Image selectionBgImage;
    Color[] selectionGradientColors;
    int[] selectionGradientPercents;
    boolean selectionGradientVertical;
    Color selectionForeground;
    Color selectionBackground;
    Color selectionFadeStart;
    Color selectionHighlightGradientBegin = null;
    Color[] selectionHighlightGradientColorsCache = null;
    Color selectedOuterColor = null;
    Color selectedInnerColor = null;
    Color tabAreaColor = null;
    Color[] gradientColors;
    int[] gradientPercents;
    boolean gradientVertical;
    boolean showUnselectedImage = true;
    Color fillColor;
    boolean showClose = false;
    boolean showUnselectedClose = true;
    Rectangle chevronRect = new Rectangle(0, 0, 0, 0);
    int chevronImageState = 1;
    boolean showChevron = false;
    Menu showMenu;
    boolean showMin = false;
    Rectangle minRect = new Rectangle(0, 0, 0, 0);
    boolean minimized = false;
    int minImageState = 1;
    boolean showMax = false;
    Rectangle maxRect = new Rectangle(0, 0, 0, 0);
    boolean maximized = false;
    int maxImageState = 1;
    Control topRight;
    Rectangle topRightRect = new Rectangle(0, 0, 0, 0);
    int topRightAlignment = 131072;
    int borderLeft = 0;
    int borderRight = 0;
    int borderTop = 0;
    int borderBottom = 0;
    int highlight_margin = 0;
    int highlight_header = 0;
    int[] curve;
    int[] topCurveHighlightStart;
    int[] topCurveHighlightEnd;
    int curveWidth = 0;
    int curveIndent = 0;
    boolean inDispose = false;
    Point oldSize;
    Font oldFont;
    Color lastBorderColor = null;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int BUTTON_SIZE = 18;
    static final int[] TOP_LEFT_CORNER;
    static final int[] TOP_LEFT_CORNER_HILITE;
    static final int[] TOP_RIGHT_CORNER;
    static final int[] BOTTOM_LEFT_CORNER;
    static final int[] BOTTOM_RIGHT_CORNER;
    static final int[] SIMPLE_TOP_LEFT_CORNER;
    static final int[] SIMPLE_TOP_RIGHT_CORNER;
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER;
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER;
    static final int[] SIMPLE_UNSELECTED_INNER_CORNER;
    static final int[] TOP_LEFT_CORNER_BORDERLESS;
    static final int[] TOP_RIGHT_CORNER_BORDERLESS;
    static final int[] BOTTOM_LEFT_CORNER_BORDERLESS;
    static final int[] BOTTOM_RIGHT_CORNER_BORDERLESS;
    static final int[] SIMPLE_TOP_LEFT_CORNER_BORDERLESS;
    static final int[] SIMPLE_TOP_RIGHT_CORNER_BORDERLESS;
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS;
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS;
    static final int SELECTION_FOREGROUND = 24;
    static final int SELECTION_BACKGROUND = 25;
    static final int BORDER1_COLOR = 18;
    static final int FOREGROUND = 21;
    static final int BACKGROUND = 22;
    static final int BUTTON_BORDER = 17;
    static final int BUTTON_FILL = 25;
    static final int NONE = 0;
    static final int NORMAL = 1;
    static final int HOT = 2;
    static final int SELECTED = 3;
    static final RGB CLOSE_FILL;
    static final int CHEVRON_CHILD_ID = 0;
    static final int MINIMIZE_CHILD_ID = 1;
    static final int MAXIMIZE_CHILD_ID = 2;
    static final int EXTRA_CHILD_ID_COUNT = 3;

    static {
        int[] nArray = new int[12];
        nArray[1] = 6;
        nArray[2] = 1;
        nArray[3] = 5;
        nArray[4] = 1;
        nArray[5] = 4;
        nArray[6] = 4;
        nArray[7] = 1;
        nArray[8] = 5;
        nArray[9] = 1;
        nArray[10] = 6;
        TOP_LEFT_CORNER = nArray;
        TOP_LEFT_CORNER_HILITE = new int[]{5, 2, 4, 2, 3, 3, 2, 4, 2, 5, 1, 6};
        int[] nArray2 = new int[12];
        nArray2[0] = -6;
        nArray2[2] = -5;
        nArray2[3] = 1;
        nArray2[4] = -4;
        nArray2[5] = 1;
        nArray2[6] = -1;
        nArray2[7] = 4;
        nArray2[8] = -1;
        nArray2[9] = 5;
        nArray2[11] = 6;
        TOP_RIGHT_CORNER = nArray2;
        int[] nArray3 = new int[12];
        nArray3[1] = -6;
        nArray3[2] = 1;
        nArray3[3] = -5;
        nArray3[4] = 1;
        nArray3[5] = -4;
        nArray3[6] = 4;
        nArray3[7] = -1;
        nArray3[8] = 5;
        nArray3[9] = -1;
        nArray3[10] = 6;
        BOTTOM_LEFT_CORNER = nArray3;
        int[] nArray4 = new int[12];
        nArray4[0] = -6;
        nArray4[2] = -5;
        nArray4[3] = -1;
        nArray4[4] = -4;
        nArray4[5] = -1;
        nArray4[6] = -1;
        nArray4[7] = -4;
        nArray4[8] = -1;
        nArray4[9] = -5;
        nArray4[11] = -6;
        BOTTOM_RIGHT_CORNER = nArray4;
        int[] nArray5 = new int[6];
        nArray5[1] = 2;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 2;
        SIMPLE_TOP_LEFT_CORNER = nArray5;
        int[] nArray6 = new int[6];
        nArray6[0] = -2;
        nArray6[2] = -1;
        nArray6[3] = 1;
        nArray6[5] = 2;
        SIMPLE_TOP_RIGHT_CORNER = nArray6;
        int[] nArray7 = new int[6];
        nArray7[1] = -2;
        nArray7[2] = 1;
        nArray7[3] = -1;
        nArray7[4] = 2;
        SIMPLE_BOTTOM_LEFT_CORNER = nArray7;
        int[] nArray8 = new int[6];
        nArray8[0] = -2;
        nArray8[2] = -1;
        nArray8[3] = -1;
        nArray8[5] = -2;
        SIMPLE_BOTTOM_RIGHT_CORNER = nArray8;
        SIMPLE_UNSELECTED_INNER_CORNER = new int[2];
        int[] nArray9 = new int[12];
        nArray9[1] = 6;
        nArray9[2] = 1;
        nArray9[3] = 5;
        nArray9[4] = 1;
        nArray9[5] = 4;
        nArray9[6] = 4;
        nArray9[7] = 1;
        nArray9[8] = 5;
        nArray9[9] = 1;
        nArray9[10] = 6;
        TOP_LEFT_CORNER_BORDERLESS = nArray9;
        int[] nArray10 = new int[12];
        nArray10[0] = -7;
        nArray10[2] = -6;
        nArray10[3] = 1;
        nArray10[4] = -5;
        nArray10[5] = 1;
        nArray10[6] = -2;
        nArray10[7] = 4;
        nArray10[8] = -2;
        nArray10[9] = 5;
        nArray10[10] = -1;
        nArray10[11] = 6;
        TOP_RIGHT_CORNER_BORDERLESS = nArray10;
        int[] nArray11 = new int[16];
        nArray11[1] = -6;
        nArray11[2] = 1;
        nArray11[3] = -6;
        nArray11[4] = 1;
        nArray11[5] = -5;
        nArray11[6] = 2;
        nArray11[7] = -4;
        nArray11[8] = 4;
        nArray11[9] = -2;
        nArray11[10] = 5;
        nArray11[11] = -1;
        nArray11[12] = 6;
        nArray11[13] = -1;
        nArray11[14] = 6;
        BOTTOM_LEFT_CORNER_BORDERLESS = nArray11;
        int[] nArray12 = new int[16];
        nArray12[0] = -7;
        nArray12[2] = -7;
        nArray12[3] = -1;
        nArray12[4] = -6;
        nArray12[5] = -1;
        nArray12[6] = -5;
        nArray12[7] = -2;
        nArray12[8] = -3;
        nArray12[9] = -4;
        nArray12[10] = -2;
        nArray12[11] = -5;
        nArray12[12] = -2;
        nArray12[13] = -6;
        nArray12[14] = -1;
        nArray12[15] = -6;
        BOTTOM_RIGHT_CORNER_BORDERLESS = nArray12;
        int[] nArray13 = new int[6];
        nArray13[1] = 2;
        nArray13[2] = 1;
        nArray13[3] = 1;
        nArray13[4] = 2;
        SIMPLE_TOP_LEFT_CORNER_BORDERLESS = nArray13;
        int[] nArray14 = new int[6];
        nArray14[0] = -3;
        nArray14[2] = -2;
        nArray14[3] = 1;
        nArray14[4] = -1;
        nArray14[5] = 2;
        SIMPLE_TOP_RIGHT_CORNER_BORDERLESS = nArray14;
        int[] nArray15 = new int[8];
        nArray15[1] = -3;
        nArray15[2] = 1;
        nArray15[3] = -2;
        nArray15[4] = 2;
        nArray15[5] = -1;
        nArray15[6] = 3;
        SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS = nArray15;
        int[] nArray16 = new int[8];
        nArray16[0] = -4;
        nArray16[2] = -3;
        nArray16[3] = -1;
        nArray16[4] = -2;
        nArray16[5] = -2;
        nArray16[6] = -1;
        nArray16[7] = -3;
        SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS = nArray16;
        CLOSE_FILL = new RGB(252, 160, 160);
    }

    public CTabFolder(Composite parent, int style) {
        super(parent, CTabFolder.checkStyle(parent, style));
        this.init(style);
    }

    void init(int style) {
        super.setLayout(new CTabFolderLayout());
        int style2 = super.getStyle();
        this.oldFont = this.getFont();
        this.onBottom = (style2 & 0x400) != 0;
        this.showClose = (style2 & 0x40) != 0;
        this.single = (style2 & 4) != 0;
        this.borderRight = (style & 0x800) != 0 ? 1 : 0;
        this.borderLeft = this.borderRight;
        this.borderTop = this.onBottom ? this.borderLeft : 0;
        this.borderBottom = this.onBottom ? 0 : this.borderLeft;
        this.highlight_header = (style & 0x800000) != 0 ? 1 : 3;
        this.highlight_margin = (style & 0x800000) != 0 ? 0 : 2;
        Display display = this.getDisplay();
        this.selectionForeground = display.getSystemColor(24);
        this.selectionBackground = display.getSystemColor(25);
        this.updateTabHeight(false);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CTabFolder.this.onDispose(event);
                        break;
                    }
                    case 29: {
                        CTabFolder.this.onDragDetect(event);
                        break;
                    }
                    case 15: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 16: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 1: {
                        CTabFolder.this.onKeyDown(event);
                        break;
                    }
                    case 8: {
                        CTabFolder.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 3: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 6: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 7: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 5: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 4: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 9: {
                        CTabFolder.this.onPaint(event);
                        break;
                    }
                    case 11: {
                        CTabFolder.this.onResize();
                        break;
                    }
                    case 31: {
                        CTabFolder.this.onTraverse(event);
                    }
                }
            }
        };
        int[] folderEvents = new int[]{12, 29, 15, 16, 1, 8, 3, 6, 7, 5, 4, 9, 11, 31};
        int i = 0;
        while (i < folderEvents.length) {
            this.addListener(folderEvents[i], this.listener);
            ++i;
        }
        this.initAccessible();
    }

    static int checkStyle(Composite parent, int style) {
        int mask = 109053126;
        if (((style &= mask) & 0x80) != 0) {
            style &= 0xFFFFFBFF;
        }
        if ((style & 2) != 0) {
            style &= 0xFFFFFFFB;
        }
        style |= 0x100000;
        String platform = SWT.getPlatform();
        if ("cocoa".equals(platform) || "carbon".equals(platform) || "gtk".equals(platform)) {
            return style;
        }
        if ((style & 0x4000000) != 0) {
            return style;
        }
        if ((parent.getStyle() & 0x8000000) != 0 && (style & 0x2000000) == 0) {
            return style;
        }
        return style | 0x40000;
    }

    static void fillRegion(GC gc, Region region) {
        Region clipping = new Region();
        gc.getClipping(clipping);
        region.intersect(clipping);
        gc.setClipping(region);
        gc.fillRectangle(region.getBounds());
        gc.setClipping(clipping);
        clipping.dispose();
    }

    public void addCTabFolder2Listener(CTabFolder2Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        CTabFolder2Listener[] newListeners = new CTabFolder2Listener[this.folderListeners.length + 1];
        System.arraycopy(this.folderListeners, 0, newListeners, 0, this.folderListeners.length);
        this.folderListeners = newListeners;
        this.folderListeners[this.folderListeners.length - 1] = listener;
    }

    public void addCTabFolderListener(CTabFolderListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        CTabFolderListener[] newTabListeners = new CTabFolderListener[this.tabListeners.length + 1];
        System.arraycopy(this.tabListeners, 0, newTabListeners, 0, this.tabListeners.length);
        this.tabListeners = newTabListeners;
        this.tabListeners[this.tabListeners.length - 1] = listener;
        if (!this.showClose) {
            this.showClose = true;
            this.updateItems();
            this.redraw();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void antialias(int[] shape, Color innerColor, Color outerColor, GC gc) {
        int i;
        if (this.simple) {
            return;
        }
        String platform = SWT.getPlatform();
        if ("cocoa".equals(platform)) {
            return;
        }
        if ("carbon".equals(platform)) {
            return;
        }
        if ("wpf".equals(platform)) {
            return;
        }
        if (this.getDisplay().getDepth() < 15) {
            return;
        }
        if (outerColor != null) {
            int index = 0;
            boolean left = true;
            int oldY = this.onBottom ? 0 : this.getSize().y;
            int[] outer = new int[shape.length];
            i = 0;
            while (i < shape.length / 2) {
                if (left && index + 3 < shape.length) {
                    left = this.onBottom ? oldY <= shape[index + 3] : oldY >= shape[index + 3];
                    oldY = shape[index + 1];
                }
                outer[index] = shape[index++] + (left ? -1 : 1);
                outer[index] = shape[index++];
                ++i;
            }
            gc.setForeground(outerColor);
            gc.drawPolyline(outer);
        }
        if (innerColor != null) {
            int[] inner = new int[shape.length];
            int index = 0;
            boolean left = true;
            int oldY = this.onBottom ? 0 : this.getSize().y;
            i = 0;
            while (i < shape.length / 2) {
                if (left && index + 3 < shape.length) {
                    left = this.onBottom ? oldY <= shape[index + 3] : oldY >= shape[index + 3];
                    oldY = shape[index + 1];
                }
                inner[index] = shape[index++] + (left ? 1 : -1);
                inner[index] = shape[index++];
                ++i;
            }
            gc.setForeground(innerColor);
            gc.drawPolyline(inner);
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int trimX = x - this.marginWidth - this.highlight_margin - this.borderLeft;
        int trimWidth = width + this.borderLeft + this.borderRight + 2 * this.marginWidth + 2 * this.highlight_margin;
        if (this.minimized) {
            int trimY = this.onBottom ? y - this.borderTop : y - this.highlight_header - this.tabHeight - this.borderTop;
            int trimHeight = this.borderTop + this.borderBottom + this.tabHeight + this.highlight_header;
            return new Rectangle(trimX, trimY, trimWidth, trimHeight);
        }
        int trimY = this.onBottom ? y - this.marginHeight - this.highlight_margin - this.borderTop : y - this.marginHeight - this.highlight_header - this.tabHeight - this.borderTop;
        int trimHeight = height + this.borderTop + this.borderBottom + 2 * this.marginHeight + this.tabHeight + this.highlight_header + this.highlight_margin;
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    void createItem(CTabItem item, int index) {
        if (index < 0 || index > this.getItemCount()) {
            SWT.error(6);
        }
        item.parent = this;
        CTabItem[] newItems = new CTabItem[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = item;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        if (this.selectedIndex >= index) {
            ++this.selectedIndex;
        }
        int[] newPriority = new int[this.priority.length + 1];
        int next = 0;
        int priorityIndex = this.priority.length;
        int i = 0;
        while (i < this.priority.length) {
            if (!this.mru && this.priority[i] == index) {
                priorityIndex = next++;
            }
            newPriority[next++] = this.priority[i] >= index ? this.priority[i] + 1 : this.priority[i];
            ++i;
        }
        newPriority[priorityIndex] = index;
        this.priority = newPriority;
        if (this.items.length == 1) {
            if (!this.updateTabHeight(false)) {
                this.updateItems();
            }
            this.redraw();
        } else {
            this.updateItems();
            this.redrawTabs();
        }
    }

    void destroyItem(CTabItem item) {
        if (this.inDispose) {
            return;
        }
        int index = this.indexOf(item);
        if (index == -1) {
            return;
        }
        if (this.items.length == 1) {
            this.items = new CTabItem[0];
            this.priority = new int[0];
            this.firstIndex = -1;
            this.selectedIndex = -1;
            Control control = item.getControl();
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            this.setToolTipText(null);
            this.setButtonBounds();
            this.redraw();
            return;
        }
        CTabItem[] newItems = new CTabItem[this.items.length - 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
        this.items = newItems;
        int[] newPriority = new int[this.priority.length - 1];
        int next = 0;
        int i = 0;
        while (i < this.priority.length) {
            if (this.priority[i] != index) {
                newPriority[next++] = this.priority[i] > index ? this.priority[i] - 1 : this.priority[i];
            }
            ++i;
        }
        this.priority = newPriority;
        if (this.selectedIndex == index) {
            Control control = item.getControl();
            this.selectedIndex = -1;
            int nextSelection = this.mru ? this.priority[0] : Math.max(0, index - 1);
            this.setSelection(nextSelection, true);
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        } else if (this.selectedIndex > index) {
            --this.selectedIndex;
        }
        this.updateItems();
        this.redrawTabs();
    }

    void drawBackground(GC gc, int[] shape, boolean selected) {
        Color defaultBackground = selected ? this.selectionBackground : this.getBackground();
        Image image = selected ? this.selectionBgImage : null;
        Color[] colors = selected ? this.selectionGradientColors : this.gradientColors;
        int[] percents = selected ? this.selectionGradientPercents : this.gradientPercents;
        boolean vertical = selected ? this.selectionGradientVertical : this.gradientVertical;
        Point size = this.getSize();
        int width = size.x;
        int height = this.tabHeight + this.highlight_header;
        int x = 0;
        if (this.borderLeft > 0) {
            ++x;
            width -= 2;
        }
        int y = this.onBottom ? size.y - this.borderBottom - height : this.borderTop;
        this.drawBackground(gc, shape, x, y, width, height, defaultBackground, image, colors, percents, vertical);
    }

    void drawBackground(GC gc, int[] shape, int x, int y, int width, int height, Color defaultBackground, Image image, Color[] colors, int[] percents, boolean vertical) {
        Region clipping = new Region();
        gc.getClipping(clipping);
        Region region = new Region();
        region.add(shape);
        region.intersect(clipping);
        gc.setClipping(region);
        if (image != null) {
            gc.setBackground(defaultBackground);
            gc.fillRectangle(x, y, width, height);
            Rectangle imageRect = image.getBounds();
            gc.drawImage(image, imageRect.x, imageRect.y, imageRect.width, imageRect.height, x, y, width, height);
        } else if (colors != null) {
            if (colors.length == 1) {
                Color background = colors[0] != null ? colors[0] : defaultBackground;
                gc.setBackground(background);
                gc.fillRectangle(x, y, width, height);
            } else if (vertical) {
                if (this.onBottom) {
                    Color lastColor;
                    int pos = 0;
                    if (percents[percents.length - 1] < 100) {
                        pos = (100 - percents[percents.length - 1]) * height / 100;
                        gc.setBackground(defaultBackground);
                        gc.fillRectangle(x, y, width, pos);
                    }
                    if ((lastColor = colors[colors.length - 1]) == null) {
                        lastColor = defaultBackground;
                    }
                    int i = percents.length - 1;
                    while (i >= 0) {
                        gc.setForeground(lastColor);
                        lastColor = colors[i];
                        if (lastColor == null) {
                            lastColor = defaultBackground;
                        }
                        gc.setBackground(lastColor);
                        int percentage = i > 0 ? percents[i] - percents[i - 1] : percents[i];
                        int gradientHeight = percentage * height / 100;
                        gc.fillGradientRectangle(x, y + pos, width, gradientHeight, true);
                        pos += gradientHeight;
                        --i;
                    }
                } else {
                    Color lastColor = colors[0];
                    if (lastColor == null) {
                        lastColor = defaultBackground;
                    }
                    int pos = 0;
                    int i = 0;
                    while (i < percents.length) {
                        gc.setForeground(lastColor);
                        lastColor = colors[i + 1];
                        if (lastColor == null) {
                            lastColor = defaultBackground;
                        }
                        gc.setBackground(lastColor);
                        int percentage = i > 0 ? percents[i] - percents[i - 1] : percents[i];
                        int gradientHeight = percentage * height / 100;
                        gc.fillGradientRectangle(x, y + pos, width, gradientHeight, true);
                        pos += gradientHeight;
                        ++i;
                    }
                    if (pos < height) {
                        gc.setBackground(defaultBackground);
                        gc.fillRectangle(x, pos, width, height - pos + 1);
                    }
                }
            } else {
                y = 0;
                height = this.getSize().y;
                Color lastColor = colors[0];
                if (lastColor == null) {
                    lastColor = defaultBackground;
                }
                int pos = 0;
                int i = 0;
                while (i < percents.length) {
                    gc.setForeground(lastColor);
                    lastColor = colors[i + 1];
                    if (lastColor == null) {
                        lastColor = defaultBackground;
                    }
                    gc.setBackground(lastColor);
                    int gradientWidth = percents[i] * width / 100 - pos;
                    gc.fillGradientRectangle(x + pos, y, gradientWidth, height, false);
                    pos += gradientWidth;
                    ++i;
                }
                if (pos < width) {
                    gc.setBackground(defaultBackground);
                    gc.fillRectangle(x + pos, y, width - pos, height);
                }
            }
        } else if ((this.getStyle() & 0x40000) != 0 || !defaultBackground.equals(this.getBackground())) {
            gc.setBackground(defaultBackground);
            gc.fillRectangle(x, y, width, height);
        }
        gc.setClipping(clipping);
        clipping.dispose();
        region.dispose();
    }

    void drawBody(Event event) {
        int height;
        GC gc = event.gc;
        Point size = this.getSize();
        if (!this.minimized) {
            int width = size.x - this.borderLeft - this.borderRight - 2 * this.highlight_margin;
            int height2 = size.y - this.borderTop - this.borderBottom - this.tabHeight - this.highlight_header - this.highlight_margin;
            if (this.highlight_margin > 0) {
                int x1;
                int[] shape = null;
                if (this.onBottom) {
                    x1 = this.borderLeft;
                    int y1 = this.borderTop;
                    int x2 = size.x - this.borderRight;
                    int y2 = size.y - this.borderBottom - this.tabHeight - this.highlight_header;
                    shape = new int[]{x1, y1, x2, y1, x2, y2, x2 - this.highlight_margin, y2, x2 - this.highlight_margin, y1 + this.highlight_margin, x1 + this.highlight_margin, y1 + this.highlight_margin, x1 + this.highlight_margin, y2, x1, y2};
                } else {
                    x1 = this.borderLeft;
                    int y1 = this.borderTop + this.tabHeight + this.highlight_header;
                    int x2 = size.x - this.borderRight;
                    int y2 = size.y - this.borderBottom;
                    shape = new int[]{x1, y1, x1 + this.highlight_margin, y1, x1 + this.highlight_margin, y2 - this.highlight_margin, x2 - this.highlight_margin, y2 - this.highlight_margin, x2 - this.highlight_margin, y1, x2, y1, x2, y2, x1, y2};
                }
                if (this.selectedIndex != -1 && this.selectionGradientColors != null && this.selectionGradientColors.length > 1 && !this.selectionGradientVertical) {
                    this.drawBackground(gc, shape, true);
                } else if (this.selectedIndex == -1 && this.gradientColors != null && this.gradientColors.length > 1 && !this.gradientVertical) {
                    this.drawBackground(gc, shape, false);
                } else {
                    gc.setBackground(this.selectedIndex == -1 ? this.getBackground() : this.selectionBackground);
                    gc.fillPolygon(shape);
                }
            }
            if ((this.getStyle() & 0x40000) != 0) {
                gc.setBackground(this.getBackground());
                gc.fillRectangle(this.xClient - this.marginWidth, this.yClient - this.marginHeight, width, height2);
            }
        } else if ((this.getStyle() & 0x40000) != 0 && size.y > (height = this.borderTop + this.tabHeight + this.highlight_header + this.borderBottom)) {
            gc.setBackground(this.getParent().getBackground());
            gc.fillRectangle(0, height, size.x, size.y - height);
        }
        if (this.borderLeft > 0) {
            gc.setForeground(this.getDisplay().getSystemColor(18));
            int x1 = this.borderLeft - 1;
            int x2 = size.x - this.borderRight;
            int y1 = this.onBottom ? this.borderTop - 1 : this.borderTop + this.tabHeight;
            int y2 = this.onBottom ? size.y - this.tabHeight - this.borderBottom - 1 : size.y - this.borderBottom;
            gc.drawLine(x1, y1, x1, y2);
            gc.drawLine(x2, y1, x2, y2);
            if (this.onBottom) {
                gc.drawLine(x1, y1, x2, y1);
            } else {
                gc.drawLine(x1, y2, x2, y2);
            }
        }
    }

    void drawChevron(GC gc) {
        int count;
        if (this.chevronRect.width == 0 || this.chevronRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        Point dpi = display.getDPI();
        int fontHeight = 720 / dpi.y;
        FontData fd = this.getFont().getFontData()[0];
        fd.setHeight(fontHeight);
        Font f = new Font((Device)display, fd);
        int fHeight = f.getFontData()[0].getHeight() * dpi.y / 72;
        int indent = Math.max(2, (this.chevronRect.height - fHeight - 4) / 2);
        int x = this.chevronRect.x + 2;
        int y = this.chevronRect.y + indent;
        if (this.single) {
            count = this.selectedIndex == -1 ? this.items.length : this.items.length - 1;
        } else {
            int showCount = 0;
            while (showCount < this.priority.length && this.items[this.priority[showCount]].showing) {
                ++showCount;
            }
            count = this.items.length - showCount;
        }
        String chevronString = count > 99 ? "99+" : String.valueOf(count);
        switch (this.chevronImageState) {
            case 1: {
                Color chevronBorder = this.single ? this.getSelectionForeground() : this.getForeground();
                gc.setForeground(chevronBorder);
                gc.setFont(f);
                gc.drawLine(x, y, x + 2, y + 2);
                gc.drawLine(x + 2, y + 2, x, y + 4);
                gc.drawLine(x + 1, y, x + 3, y + 2);
                gc.drawLine(x + 3, y + 2, x + 1, y + 4);
                gc.drawLine(x + 4, y, x + 6, y + 2);
                gc.drawLine(x + 6, y + 2, x + 5, y + 4);
                gc.drawLine(x + 5, y, x + 7, y + 2);
                gc.drawLine(x + 7, y + 2, x + 4, y + 4);
                gc.drawString(chevronString, x + 7, y + 3, true);
                break;
            }
            case 2: {
                gc.setForeground(display.getSystemColor(17));
                gc.setBackground(display.getSystemColor(25));
                gc.setFont(f);
                gc.fillRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, 6, 6);
                gc.drawRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width - 1, this.chevronRect.height - 1, 6, 6);
                gc.drawLine(x, y, x + 2, y + 2);
                gc.drawLine(x + 2, y + 2, x, y + 4);
                gc.drawLine(x + 1, y, x + 3, y + 2);
                gc.drawLine(x + 3, y + 2, x + 1, y + 4);
                gc.drawLine(x + 4, y, x + 6, y + 2);
                gc.drawLine(x + 6, y + 2, x + 5, y + 4);
                gc.drawLine(x + 5, y, x + 7, y + 2);
                gc.drawLine(x + 7, y + 2, x + 4, y + 4);
                gc.drawString(chevronString, x + 7, y + 3, true);
                break;
            }
            case 3: {
                gc.setForeground(display.getSystemColor(17));
                gc.setBackground(display.getSystemColor(25));
                gc.setFont(f);
                gc.fillRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, 6, 6);
                gc.drawRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width - 1, this.chevronRect.height - 1, 6, 6);
                gc.drawLine(x + 1, y + 1, x + 3, y + 3);
                gc.drawLine(x + 3, y + 3, x + 1, y + 5);
                gc.drawLine(x + 2, y + 1, x + 4, y + 3);
                gc.drawLine(x + 4, y + 3, x + 2, y + 5);
                gc.drawLine(x + 5, y + 1, x + 7, y + 3);
                gc.drawLine(x + 7, y + 3, x + 6, y + 5);
                gc.drawLine(x + 6, y + 1, x + 8, y + 3);
                gc.drawLine(x + 8, y + 3, x + 5, y + 5);
                gc.drawString(chevronString, x + 8, y + 4, true);
            }
        }
        f.dispose();
    }

    void drawMaximize(GC gc) {
        if (this.maxRect.width == 0 || this.maxRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int x = this.maxRect.x + 4;
        int y = this.maxRect.y + 3;
        gc.setForeground(display.getSystemColor(17));
        gc.setBackground(display.getSystemColor(25));
        switch (this.maxImageState) {
            case 1: {
                if (!this.maximized) {
                    gc.fillRectangle(x, y, 9, 9);
                    gc.drawRectangle(x, y, 9, 9);
                    gc.drawLine(x + 1, y + 2, x + 8, y + 2);
                    break;
                }
                gc.fillRectangle(x, y + 3, 5, 4);
                gc.fillRectangle(x + 2, y, 5, 4);
                gc.drawRectangle(x, y + 3, 5, 4);
                gc.drawRectangle(x + 2, y, 5, 4);
                gc.drawLine(x + 3, y + 1, x + 6, y + 1);
                gc.drawLine(x + 1, y + 4, x + 4, y + 4);
                break;
            }
            case 2: {
                gc.fillRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, 6, 6);
                gc.drawRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width - 1, this.maxRect.height - 1, 6, 6);
                if (!this.maximized) {
                    gc.fillRectangle(x, y, 9, 9);
                    gc.drawRectangle(x, y, 9, 9);
                    gc.drawLine(x + 1, y + 2, x + 8, y + 2);
                    break;
                }
                gc.fillRectangle(x, y + 3, 5, 4);
                gc.fillRectangle(x + 2, y, 5, 4);
                gc.drawRectangle(x, y + 3, 5, 4);
                gc.drawRectangle(x + 2, y, 5, 4);
                gc.drawLine(x + 3, y + 1, x + 6, y + 1);
                gc.drawLine(x + 1, y + 4, x + 4, y + 4);
                break;
            }
            case 3: {
                gc.fillRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, 6, 6);
                gc.drawRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width - 1, this.maxRect.height - 1, 6, 6);
                if (!this.maximized) {
                    gc.fillRectangle(x + 1, y + 1, 9, 9);
                    gc.drawRectangle(x + 1, y + 1, 9, 9);
                    gc.drawLine(x + 2, y + 3, x + 9, y + 3);
                    break;
                }
                gc.fillRectangle(x + 1, y + 4, 5, 4);
                gc.fillRectangle(x + 3, y + 1, 5, 4);
                gc.drawRectangle(x + 1, y + 4, 5, 4);
                gc.drawRectangle(x + 3, y + 1, 5, 4);
                gc.drawLine(x + 4, y + 2, x + 7, y + 2);
                gc.drawLine(x + 2, y + 5, x + 5, y + 5);
            }
        }
    }

    void drawMinimize(GC gc) {
        if (this.minRect.width == 0 || this.minRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int x = this.minRect.x + 4;
        int y = this.minRect.y + 3;
        gc.setForeground(display.getSystemColor(17));
        gc.setBackground(display.getSystemColor(25));
        switch (this.minImageState) {
            case 1: {
                if (!this.minimized) {
                    gc.fillRectangle(x, y, 9, 3);
                    gc.drawRectangle(x, y, 9, 3);
                    break;
                }
                gc.fillRectangle(x, y + 3, 5, 4);
                gc.fillRectangle(x + 2, y, 5, 4);
                gc.drawRectangle(x, y + 3, 5, 4);
                gc.drawRectangle(x + 2, y, 5, 4);
                gc.drawLine(x + 3, y + 1, x + 6, y + 1);
                gc.drawLine(x + 1, y + 4, x + 4, y + 4);
                break;
            }
            case 2: {
                gc.fillRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, 6, 6);
                gc.drawRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width - 1, this.minRect.height - 1, 6, 6);
                if (!this.minimized) {
                    gc.fillRectangle(x, y, 9, 3);
                    gc.drawRectangle(x, y, 9, 3);
                    break;
                }
                gc.fillRectangle(x, y + 3, 5, 4);
                gc.fillRectangle(x + 2, y, 5, 4);
                gc.drawRectangle(x, y + 3, 5, 4);
                gc.drawRectangle(x + 2, y, 5, 4);
                gc.drawLine(x + 3, y + 1, x + 6, y + 1);
                gc.drawLine(x + 1, y + 4, x + 4, y + 4);
                break;
            }
            case 3: {
                gc.fillRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, 6, 6);
                gc.drawRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width - 1, this.minRect.height - 1, 6, 6);
                if (!this.minimized) {
                    gc.fillRectangle(x + 1, y + 1, 9, 3);
                    gc.drawRectangle(x + 1, y + 1, 9, 3);
                    break;
                }
                gc.fillRectangle(x + 1, y + 4, 5, 4);
                gc.fillRectangle(x + 3, y + 1, 5, 4);
                gc.drawRectangle(x + 1, y + 4, 5, 4);
                gc.drawRectangle(x + 3, y + 1, 5, 4);
                gc.drawLine(x + 4, y + 2, x + 7, y + 2);
                gc.drawLine(x + 2, y + 5, x + 5, y + 5);
            }
        }
    }

    void drawTabArea(Event event) {
        int i;
        int index;
        int[] right;
        int[] left;
        GC gc = event.gc;
        Point size = this.getSize();
        int[] shape = null;
        Color borderColor = this.getDisplay().getSystemColor(18);
        if (this.tabHeight == 0) {
            int y2;
            int style = this.getStyle();
            if ((style & 0x800000) != 0 && (style & 0x800) == 0) {
                return;
            }
            int x1 = this.borderLeft - 1;
            int x2 = size.x - this.borderRight;
            int y1 = this.onBottom ? size.y - this.borderBottom - this.highlight_header - 1 : this.borderTop + this.highlight_header;
            int n = y2 = this.onBottom ? size.y - this.borderBottom : this.borderTop;
            if (this.borderLeft <= 0 || this.onBottom) {
                // empty if block
            }
            shape = new int[]{x1, y1, x1, --y2, x2, y2, x2, y1};
            if (this.selectedIndex != -1 && this.selectionGradientColors != null && this.selectionGradientColors.length > 1 && !this.selectionGradientVertical) {
                this.drawBackground(gc, shape, true);
            } else if (this.selectedIndex == -1 && this.gradientColors != null && this.gradientColors.length > 1 && !this.gradientVertical) {
                this.drawBackground(gc, shape, false);
            } else {
                gc.setBackground(this.selectedIndex == -1 ? this.getBackground() : this.selectionBackground);
                gc.fillPolygon(shape);
            }
            if (this.borderLeft > 0) {
                gc.setForeground(borderColor);
                gc.drawPolyline(shape);
            }
            return;
        }
        int x = Math.max(0, this.borderLeft - 1);
        int y = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop;
        int width = size.x - this.borderLeft - this.borderRight + 1;
        int height = this.tabHeight - 1;
        if (this.onBottom) {
            if ((this.getStyle() & 0x800) != 0) {
                left = this.simple ? SIMPLE_BOTTOM_LEFT_CORNER : BOTTOM_LEFT_CORNER;
                right = this.simple ? SIMPLE_BOTTOM_RIGHT_CORNER : BOTTOM_RIGHT_CORNER;
            } else {
                left = this.simple ? SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS : BOTTOM_LEFT_CORNER_BORDERLESS;
                right = this.simple ? SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS : BOTTOM_RIGHT_CORNER_BORDERLESS;
            }
            shape = new int[left.length + right.length + 4];
            index = 0;
            shape[index++] = x;
            shape[index++] = y - this.highlight_header;
            i = 0;
            while (i < left.length / 2) {
                shape[index++] = x + left[2 * i];
                shape[index++] = y + height + left[2 * i + 1];
                if (this.borderLeft == 0) {
                    int n = index - 1;
                    shape[n] = shape[n] + 1;
                }
                ++i;
            }
            i = 0;
            while (i < right.length / 2) {
                shape[index++] = x + width + right[2 * i];
                shape[index++] = y + height + right[2 * i + 1];
                if (this.borderLeft == 0) {
                    int n = index - 1;
                    shape[n] = shape[n] + 1;
                }
                ++i;
            }
            shape[index++] = x + width;
            shape[index++] = y - this.highlight_header;
        } else {
            if ((this.getStyle() & 0x800) != 0) {
                left = this.simple ? SIMPLE_TOP_LEFT_CORNER : TOP_LEFT_CORNER;
                right = this.simple ? SIMPLE_TOP_RIGHT_CORNER : TOP_RIGHT_CORNER;
            } else {
                left = this.simple ? SIMPLE_TOP_LEFT_CORNER_BORDERLESS : TOP_LEFT_CORNER_BORDERLESS;
                right = this.simple ? SIMPLE_TOP_RIGHT_CORNER_BORDERLESS : TOP_RIGHT_CORNER_BORDERLESS;
            }
            shape = new int[left.length + right.length + 4];
            index = 0;
            shape[index++] = x;
            shape[index++] = y + height + this.highlight_header + 1;
            i = 0;
            while (i < left.length / 2) {
                shape[index++] = x + left[2 * i];
                shape[index++] = y + left[2 * i + 1];
                ++i;
            }
            i = 0;
            while (i < right.length / 2) {
                shape[index++] = x + width + right[2 * i];
                shape[index++] = y + right[2 * i + 1];
                ++i;
            }
            shape[index++] = x + width;
            shape[index++] = y + height + this.highlight_header + 1;
        }
        boolean bkSelected = this.single && this.selectedIndex != -1;
        this.drawBackground(gc, shape, bkSelected);
        Region r = new Region();
        r.add(new Rectangle(x, y, width + 1, height + 1));
        r.subtract(shape);
        gc.setBackground(this.getParent().getBackground());
        CTabFolder.fillRegion(gc, r);
        r.dispose();
        if (!this.single) {
            int i2 = 0;
            while (i2 < this.items.length) {
                if (i2 != this.selectedIndex && event.getBounds().intersects(this.items[i2].getBounds())) {
                    this.items[i2].onPaint(gc, false);
                }
                ++i2;
            }
        }
        if (this.selectedIndex != -1) {
            CTabItem item = this.items[this.selectedIndex];
            item.onPaint(gc, true);
        } else {
            int x1 = this.borderLeft;
            int y1 = this.onBottom ? size.y - this.borderBottom - this.tabHeight - 1 : this.borderTop + this.tabHeight;
            int x2 = size.x - this.borderRight;
            gc.setForeground(borderColor);
            gc.drawLine(x1, y1, x2, y1);
        }
        this.drawChevron(gc);
        this.drawMinimize(gc);
        this.drawMaximize(gc);
        if (this.borderLeft > 0) {
            if (!borderColor.equals(this.lastBorderColor)) {
                this.createAntialiasColors();
            }
            this.antialias(shape, null, this.tabAreaColor, gc);
            gc.setForeground(borderColor);
            gc.drawPolyline(shape);
        }
    }

    public boolean getBorderVisible() {
        this.checkWidget();
        return this.borderLeft == 1;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (this.minimized) {
            return new Rectangle(this.xClient, this.yClient, 0, 0);
        }
        Point size = this.getSize();
        int width = size.x - this.borderLeft - this.borderRight - 2 * this.marginWidth - 2 * this.highlight_margin;
        int height = size.y - this.borderTop - this.borderBottom - 2 * this.marginHeight - this.highlight_margin - this.highlight_header;
        return new Rectangle(this.xClient, this.yClient, width, height -= this.tabHeight);
    }

    Color getFillColor() {
        if (this.fillColor == null) {
            this.fillColor = new Color(this.getDisplay(), CLOSE_FILL);
        }
        return this.fillColor;
    }

    public CTabItem getItem(int index) {
        if (index < 0 || index >= this.items.length) {
            SWT.error(6);
        }
        return this.items[index];
    }

    public CTabItem getItem(Point pt) {
        if (this.items.length == 0) {
            return null;
        }
        Point size = this.getSize();
        if (size.x <= this.borderLeft + this.borderRight) {
            return null;
        }
        if (this.showChevron && this.chevronRect.contains(pt)) {
            return null;
        }
        int i = 0;
        while (i < this.priority.length) {
            CTabItem item = this.items[this.priority[i]];
            Rectangle rect = item.getBounds();
            if (rect.contains(pt)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public CTabItem[] getItems() {
        CTabItem[] tabItems = new CTabItem[this.items.length];
        System.arraycopy(this.items, 0, tabItems, 0, this.items.length);
        return tabItems;
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return Character.toLowerCase(string.charAt(index));
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    String stripMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return string;
            }
            if (string.charAt(index) != '&') {
                return String.valueOf(string.substring(0, index - 1)) + string.substring(index, length);
            }
            if (++index >= length) break;
        }
        return string;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    public boolean getMinimizeVisible() {
        this.checkWidget();
        return this.showMin;
    }

    public int getMinimumCharacters() {
        this.checkWidget();
        return this.minChars;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public boolean getMaximizeVisible() {
        this.checkWidget();
        return this.showMax;
    }

    public boolean getMRUVisible() {
        this.checkWidget();
        return this.mru;
    }

    int getRightItemEdge() {
        int x = this.getSize().x - this.borderRight - 3;
        if (this.showMin) {
            x -= 18;
        }
        if (this.showMax) {
            x -= 18;
        }
        if (this.showChevron) {
            x -= 27;
        }
        if (this.topRight != null && this.topRightAlignment != 4) {
            Point rightSize = this.topRight.computeSize(-1, -1);
            x -= rightSize.x + 3;
        }
        return Math.max(0, x);
    }

    public CTabItem getSelection() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.items[this.selectedIndex];
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        return this.selectionForeground;
    }

    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    public boolean getSimple() {
        this.checkWidget();
        return this.simple;
    }

    public boolean getSingle() {
        this.checkWidget();
        return this.single;
    }

    public int getStyle() {
        int style = super.getStyle();
        style &= 0xFFFFFB7F;
        style |= this.onBottom ? 1024 : 128;
        style &= 0xFFFFFFF9;
        style |= this.single ? 4 : 2;
        if (this.borderLeft != 0) {
            style |= 0x800;
        }
        style &= 0xFFFFFFBF;
        if (this.showClose) {
            style |= 0x40;
        }
        return style;
    }

    public int getTabHeight() {
        this.checkWidget();
        if (this.fixedTabHeight != -1) {
            return this.fixedTabHeight;
        }
        return this.tabHeight - 1;
    }

    public int getTabPosition() {
        this.checkWidget();
        return this.onBottom ? 1024 : 128;
    }

    public Control getTopRight() {
        this.checkWidget();
        return this.topRight;
    }

    public boolean getUnselectedCloseVisible() {
        this.checkWidget();
        return this.showUnselectedClose;
    }

    public boolean getUnselectedImageVisible() {
        this.checkWidget();
        return this.showUnselectedImage;
    }

    public int indexOf(CTabItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String name = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    name = CTabFolder.this.stripMnemonic(CTabFolder.this.items[childID].getText());
                } else if (childID == CTabFolder.this.items.length + 0) {
                    name = SWT.getMessage("SWT_ShowList");
                } else if (childID == CTabFolder.this.items.length + 1) {
                    name = CTabFolder.this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize");
                } else if (childID == CTabFolder.this.items.length + 2) {
                    name = CTabFolder.this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize");
                }
                e.result = name;
            }

            public void getHelp(AccessibleEvent e) {
                String help = null;
                int childID = e.childID;
                if (childID == -1) {
                    help = CTabFolder.this.getToolTipText();
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    help = CTabFolder.this.items[childID].getToolTipText();
                }
                e.result = help;
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String text;
                String shortcut = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length && (text = CTabFolder.this.items[childID].getText()) != null && (mnemonic = CTabFolder.this._findMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e.result = shortcut;
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = CTabFolder.this.toControl(e.x, e.y);
                int childID = -2;
                int i = 0;
                while (i < CTabFolder.this.items.length) {
                    if (CTabFolder.this.items[i].getBounds().contains(testPoint)) {
                        childID = i;
                        break;
                    }
                    ++i;
                }
                if (childID == -2) {
                    if (CTabFolder.this.showChevron && CTabFolder.this.chevronRect.contains(testPoint)) {
                        childID = CTabFolder.this.items.length + 0;
                    } else if (CTabFolder.this.showMin && CTabFolder.this.minRect.contains(testPoint)) {
                        childID = CTabFolder.this.items.length + 1;
                    } else if (CTabFolder.this.showMax && CTabFolder.this.maxRect.contains(testPoint)) {
                        childID = CTabFolder.this.items.length + 2;
                    } else {
                        Rectangle location = CTabFolder.this.getBounds();
                        location.height -= CTabFolder.this.getClientArea().height;
                        if (location.contains(testPoint)) {
                            childID = -1;
                        }
                    }
                }
                e.childID = childID;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = null;
                Point pt = null;
                int childID = e.childID;
                if (childID == -1) {
                    location = CTabFolder.this.getBounds();
                    pt = CTabFolder.this.getParent().toDisplay(location.x, location.y);
                } else {
                    if (childID >= 0 && childID < CTabFolder.this.items.length && CTabFolder.this.items[childID].isShowing()) {
                        location = CTabFolder.this.items[childID].getBounds();
                    } else if (CTabFolder.this.showChevron && childID == CTabFolder.this.items.length + 0) {
                        location = CTabFolder.this.chevronRect;
                    } else if (CTabFolder.this.showMin && childID == CTabFolder.this.items.length + 1) {
                        location = CTabFolder.this.minRect;
                    } else if (CTabFolder.this.showMax && childID == CTabFolder.this.items.length + 2) {
                        location = CTabFolder.this.maxRect;
                    }
                    if (location != null) {
                        pt = CTabFolder.this.toDisplay(location.x, location.y);
                    }
                }
                if (location != null && pt != null) {
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                if (e.childID != -1) {
                    return;
                }
                e.detail = CTabFolder.this.items.length + 3;
            }

            public void getDefaultAction(AccessibleControlEvent e) {
                String action = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    action = SWT.getMessage("SWT_Switch");
                }
                if (childID >= CTabFolder.this.items.length && childID < CTabFolder.this.items.length + 3) {
                    action = SWT.getMessage("SWT_Press");
                }
                e.result = action;
            }

            public void getFocus(AccessibleControlEvent e) {
                int childID = -2;
                if (CTabFolder.this.isFocusControl()) {
                    childID = CTabFolder.this.selectedIndex == -1 ? -1 : CTabFolder.this.selectedIndex;
                }
                e.childID = childID;
            }

            public void getRole(AccessibleControlEvent e) {
                int role = 0;
                int childID = e.childID;
                if (childID == -1) {
                    role = 60;
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    role = 37;
                } else if (childID >= CTabFolder.this.items.length && childID < CTabFolder.this.items.length + 3) {
                    role = 43;
                }
                e.detail = role;
            }

            public void getSelection(AccessibleControlEvent e) {
                e.childID = CTabFolder.this.selectedIndex == -1 ? -2 : CTabFolder.this.selectedIndex;
            }

            public void getState(AccessibleControlEvent e) {
                int state = 0;
                int childID = e.childID;
                if (childID == -1) {
                    state = 0;
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    state = 0x200000;
                    if (CTabFolder.this.isFocusControl()) {
                        state |= 0x100000;
                    }
                    if (CTabFolder.this.selectedIndex == childID) {
                        state |= 2;
                        if (CTabFolder.this.isFocusControl()) {
                            state |= 4;
                        }
                    }
                } else if (childID == CTabFolder.this.items.length + 0) {
                    state = CTabFolder.this.showChevron ? 0 : 32768;
                } else if (childID == CTabFolder.this.items.length + 1) {
                    state = CTabFolder.this.showMin ? 0 : 32768;
                } else if (childID == CTabFolder.this.items.length + 2) {
                    state = CTabFolder.this.showMax ? 0 : 32768;
                }
                e.detail = state;
            }

            public void getChildren(AccessibleControlEvent e) {
                if (e.childID != -1) {
                    return;
                }
                int childIdCount = CTabFolder.this.items.length + 3;
                Object[] children = new Object[childIdCount];
                int i = 0;
                while (i < childIdCount) {
                    children[i] = new Integer(i);
                    ++i;
                }
                e.children = children;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.isFocusControl()) {
                    if (CTabFolder.this.selectedIndex == -1) {
                        accessible.setFocus(-1);
                    } else {
                        accessible.setFocus(CTabFolder.this.selectedIndex);
                    }
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.selectedIndex == -1) {
                    accessible.setFocus(-1);
                } else {
                    accessible.setFocus(CTabFolder.this.selectedIndex);
                }
            }
        });
    }

    void onKeyDown(Event event) {
        switch (event.keyCode) {
            case 0x1000003: 
            case 0x1000004: {
                int index;
                int offset;
                int count = this.items.length;
                if (count == 0) {
                    return;
                }
                if (this.selectedIndex == -1) {
                    return;
                }
                int leadKey = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                int n = offset = event.keyCode == leadKey ? -1 : 1;
                if (!this.mru) {
                    index = this.selectedIndex + offset;
                } else {
                    int[] visible = new int[this.items.length];
                    int idx = 0;
                    int current = -1;
                    int i = 0;
                    while (i < this.items.length) {
                        if (this.items[i].showing) {
                            if (i == this.selectedIndex) {
                                current = idx;
                            }
                            visible[idx++] = i;
                        }
                        ++i;
                    }
                    if (current + offset >= 0 && current + offset < idx) {
                        index = visible[current + offset];
                    } else {
                        if (this.showChevron) {
                            CTabFolderEvent e = new CTabFolderEvent(this);
                            e.widget = this;
                            e.time = event.time;
                            e.x = this.chevronRect.x;
                            e.y = this.chevronRect.y;
                            e.width = this.chevronRect.width;
                            e.height = this.chevronRect.height;
                            e.doit = true;
                            int i2 = 0;
                            while (i2 < this.folderListeners.length) {
                                this.folderListeners[i2].showList(e);
                                ++i2;
                            }
                            if (e.doit && !this.isDisposed()) {
                                this.showList(this.chevronRect);
                            }
                        }
                        return;
                    }
                }
                if (index < 0 || index >= count) {
                    return;
                }
                this.setSelection(index, true);
                this.forceFocus();
            }
        }
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        if (this.showMenu != null && !this.showMenu.isDisposed()) {
            this.showMenu.dispose();
            this.showMenu = null;
        }
        int length = this.items.length;
        int i = 0;
        while (i < length) {
            if (this.items[i] != null) {
                this.items[i].dispose();
            }
            ++i;
        }
        if (this.fillColor != null) {
            this.fillColor.dispose();
            this.fillColor = null;
        }
        this.selectionGradientColors = null;
        this.selectionGradientPercents = null;
        this.selectionBgImage = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.disposeSelectionHighlightGradientColors();
        this.disposeAntialiasColors();
    }

    void onDragDetect(Event event) {
        boolean consume = false;
        if (this.chevronRect.contains(event.x, event.y) || this.minRect.contains(event.x, event.y) || this.maxRect.contains(event.x, event.y)) {
            consume = true;
        } else {
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i].closeRect.contains(event.x, event.y)) {
                    consume = true;
                    break;
                }
                ++i;
            }
        }
        if (consume) {
            event.type = 0;
        }
    }

    void onFocus(Event event) {
        this.checkWidget();
        if (this.selectedIndex >= 0) {
            this.redraw();
        } else {
            this.setSelection(0, true);
        }
    }

    boolean onMnemonic(Event event, boolean doit) {
        char key = event.character;
        int i = 0;
        while (i < this.items.length) {
            char mnemonic;
            if (this.items[i] != null && (mnemonic = this._findMnemonic(this.items[i].getText())) != '\u0000' && Character.toLowerCase(key) == mnemonic) {
                if (doit) {
                    this.setSelection(i, true);
                    this.forceFocus();
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    void onMouseDoubleClick(Event event) {
        if (event.button != 1 || (event.stateMask & 0x100000) != 0 || (event.stateMask & 0x200000) != 0) {
            return;
        }
        Event e = new Event();
        e.item = this.getItem(new Point(event.x, event.y));
        if (e.item != null) {
            this.notifyListeners(14, e);
        }
    }

    void onMouse(Event event) {
        int x = event.x;
        int y = event.y;
        switch (event.type) {
            case 6: {
                this.setToolTipText(null);
                break;
            }
            case 7: {
                if (this.minImageState != 1) {
                    this.minImageState = 1;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                }
                if (this.maxImageState != 1) {
                    this.maxImageState = 1;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                }
                if (this.chevronImageState != 1) {
                    this.chevronImageState = 1;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                }
                int i = 0;
                while (i < this.items.length) {
                    CTabItem item = this.items[i];
                    if (i != this.selectedIndex && item.closeImageState != 0) {
                        item.closeImageState = 0;
                        this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                    }
                    if (i == this.selectedIndex && item.closeImageState != 1) {
                        item.closeImageState = 1;
                        this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                if (this.minRect.contains(x, y)) {
                    this.minImageState = 3;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    this.update();
                    return;
                }
                if (this.maxRect.contains(x, y)) {
                    this.maxImageState = 3;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    this.update();
                    return;
                }
                if (this.chevronRect.contains(x, y)) {
                    this.chevronImageState = this.chevronImageState != 2 ? 2 : 3;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    this.update();
                    return;
                }
                CTabItem item = null;
                if (this.single) {
                    Rectangle bounds;
                    if (this.selectedIndex != -1 && (bounds = this.items[this.selectedIndex].getBounds()).contains(x, y)) {
                        item = this.items[this.selectedIndex];
                    }
                } else {
                    int i = 0;
                    while (i < this.items.length) {
                        Rectangle bounds = this.items[i].getBounds();
                        if (bounds.contains(x, y)) {
                            item = this.items[i];
                        }
                        ++i;
                    }
                }
                if (item == null) break;
                if (item.closeRect.contains(x, y)) {
                    item.closeImageState = 3;
                    this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                    this.update();
                    return;
                }
                int index = this.indexOf(item);
                if (item.showing) {
                    int oldSelectedIndex = this.selectedIndex;
                    this.setSelection(index, true);
                    if (oldSelectedIndex == this.selectedIndex) {
                        this.forceFocus();
                    }
                }
                return;
            }
            case 5: {
                this._setToolTipText(event.x, event.y);
                boolean close = false;
                boolean minimize = false;
                boolean maximize = false;
                boolean chevron = false;
                if (this.minRect.contains(x, y)) {
                    minimize = true;
                    if (this.minImageState != 3 && this.minImageState != 2) {
                        this.minImageState = 2;
                        this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    }
                }
                if (this.maxRect.contains(x, y)) {
                    maximize = true;
                    if (this.maxImageState != 3 && this.maxImageState != 2) {
                        this.maxImageState = 2;
                        this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    }
                }
                if (this.chevronRect.contains(x, y)) {
                    chevron = true;
                    if (this.chevronImageState != 3 && this.chevronImageState != 2) {
                        this.chevronImageState = 2;
                        this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    }
                }
                if (this.minImageState != 1 && !minimize) {
                    this.minImageState = 1;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                }
                if (this.maxImageState != 1 && !maximize) {
                    this.maxImageState = 1;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                }
                if (this.chevronImageState != 1 && !chevron) {
                    this.chevronImageState = 1;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                }
                int i = 0;
                while (i < this.items.length) {
                    CTabItem item = this.items[i];
                    close = false;
                    if (item.getBounds().contains(x, y)) {
                        close = true;
                        if (item.closeRect.contains(x, y)) {
                            if (item.closeImageState != 3 && item.closeImageState != 2) {
                                item.closeImageState = 2;
                                this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                            }
                        } else if (item.closeImageState != 1) {
                            item.closeImageState = 1;
                            this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                        }
                    }
                    if (i != this.selectedIndex && item.closeImageState != 0 && !close) {
                        item.closeImageState = 0;
                        this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                    }
                    if (i == this.selectedIndex && item.closeImageState != 1 && !close) {
                        item.closeImageState = 1;
                        this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                SWTEventListener listener;
                if (event.button != 1) {
                    return;
                }
                if (this.chevronRect.contains(x, y)) {
                    boolean selected;
                    boolean bl = selected = this.chevronImageState == 3;
                    if (!selected) {
                        return;
                    }
                    CTabFolderEvent e = new CTabFolderEvent(this);
                    e.widget = this;
                    e.time = event.time;
                    e.x = this.chevronRect.x;
                    e.y = this.chevronRect.y;
                    e.width = this.chevronRect.width;
                    e.height = this.chevronRect.height;
                    e.doit = true;
                    int i = 0;
                    while (i < this.folderListeners.length) {
                        this.folderListeners[i].showList(e);
                        ++i;
                    }
                    if (e.doit && !this.isDisposed()) {
                        this.showList(this.chevronRect);
                    }
                    return;
                }
                if (this.minRect.contains(x, y)) {
                    boolean selected = this.minImageState == 3;
                    this.minImageState = 2;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    if (!selected) {
                        return;
                    }
                    CTabFolderEvent e = new CTabFolderEvent(this);
                    e.widget = this;
                    e.time = event.time;
                    int i = 0;
                    while (i < this.folderListeners.length) {
                        if (this.minimized) {
                            this.folderListeners[i].restore(e);
                        } else {
                            this.folderListeners[i].minimize(e);
                        }
                        ++i;
                    }
                    return;
                }
                if (this.maxRect.contains(x, y)) {
                    boolean selected = this.maxImageState == 3;
                    this.maxImageState = 2;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    if (!selected) {
                        return;
                    }
                    CTabFolderEvent e = new CTabFolderEvent(this);
                    e.widget = this;
                    e.time = event.time;
                    int i = 0;
                    while (i < this.folderListeners.length) {
                        if (this.maximized) {
                            this.folderListeners[i].restore(e);
                        } else {
                            this.folderListeners[i].maximize(e);
                        }
                        ++i;
                    }
                    return;
                }
                CTabItem item = null;
                if (this.single) {
                    Rectangle bounds;
                    if (this.selectedIndex != -1 && (bounds = this.items[this.selectedIndex].getBounds()).contains(x, y)) {
                        item = this.items[this.selectedIndex];
                    }
                } else {
                    int i = 0;
                    while (i < this.items.length) {
                        Rectangle bounds = this.items[i].getBounds();
                        if (bounds.contains(x, y)) {
                            item = this.items[i];
                        }
                        ++i;
                    }
                }
                if (item == null || !item.closeRect.contains(x, y)) break;
                boolean selected = item.closeImageState == 3;
                item.closeImageState = 2;
                this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                if (!selected) {
                    return;
                }
                CTabFolderEvent e = new CTabFolderEvent(this);
                e.widget = this;
                e.time = event.time;
                e.item = item;
                e.doit = true;
                int j = 0;
                while (j < this.folderListeners.length) {
                    listener = this.folderListeners[j];
                    listener.close(e);
                    ++j;
                }
                j = 0;
                while (j < this.tabListeners.length) {
                    listener = this.tabListeners[j];
                    listener.itemClosed(e);
                    ++j;
                }
                if (e.doit) {
                    item.dispose();
                }
                if (!this.isDisposed() && item.isDisposed()) {
                    Display display = this.getDisplay();
                    Point pt = display.getCursorLocation();
                    pt = display.map(null, this, pt.x, pt.y);
                    CTabItem nextItem = this.getItem(pt);
                    if (nextItem != null) {
                        if (nextItem.closeRect.contains(pt)) {
                            if (nextItem.closeImageState != 3 && nextItem.closeImageState != 2) {
                                nextItem.closeImageState = 2;
                                this.redraw(nextItem.closeRect.x, nextItem.closeRect.y, nextItem.closeRect.width, nextItem.closeRect.height, false);
                            }
                        } else if (nextItem.closeImageState != 1) {
                            nextItem.closeImageState = 1;
                            this.redraw(nextItem.closeRect.x, nextItem.closeRect.y, nextItem.closeRect.width, nextItem.closeRect.height, false);
                        }
                    }
                }
                return;
            }
        }
    }

    void onPageTraversal(Event event) {
        int count = this.items.length;
        if (count == 0) {
            return;
        }
        int index = this.selectedIndex;
        if (index == -1) {
            index = 0;
        } else {
            int offset;
            int n = offset = event.detail == 512 ? 1 : -1;
            if (!this.mru) {
                index = (this.selectedIndex + offset + count) % count;
            } else {
                int[] visible = new int[this.items.length];
                int idx = 0;
                int current = -1;
                int i = 0;
                while (i < this.items.length) {
                    if (this.items[i].showing) {
                        if (i == this.selectedIndex) {
                            current = idx;
                        }
                        visible[idx++] = i;
                    }
                    ++i;
                }
                if (current + offset >= 0 && current + offset < idx) {
                    index = visible[current + offset];
                } else if (this.showChevron) {
                    CTabFolderEvent e = new CTabFolderEvent(this);
                    e.widget = this;
                    e.time = event.time;
                    e.x = this.chevronRect.x;
                    e.y = this.chevronRect.y;
                    e.width = this.chevronRect.width;
                    e.height = this.chevronRect.height;
                    e.doit = true;
                    int i2 = 0;
                    while (i2 < this.folderListeners.length) {
                        this.folderListeners[i2].showList(e);
                        ++i2;
                    }
                    if (e.doit && !this.isDisposed()) {
                        this.showList(this.chevronRect);
                    }
                }
            }
        }
        this.setSelection(index, true);
    }

    void onPaint(Event event) {
        if (this.inDispose) {
            return;
        }
        Font font = this.getFont();
        if (this.oldFont == null || !this.oldFont.equals(font)) {
            this.oldFont = font;
            if (!this.updateTabHeight(false)) {
                this.updateItems();
                this.redraw();
                return;
            }
        }
        GC gc = event.gc;
        Font gcFont = gc.getFont();
        Color gcBackground = gc.getBackground();
        Color gcForeground = gc.getForeground();
        this.drawBody(event);
        gc.setFont(gcFont);
        gc.setForeground(gcForeground);
        gc.setBackground(gcBackground);
        this.drawTabArea(event);
        gc.setFont(gcFont);
        gc.setForeground(gcForeground);
        gc.setBackground(gcBackground);
    }

    void onResize() {
        if (this.updateItems()) {
            this.redrawTabs();
        }
        Point size = this.getSize();
        if (this.oldSize == null) {
            this.redraw();
        } else if (this.onBottom && size.y != this.oldSize.y) {
            this.redraw();
        } else {
            int x1 = Math.min(size.x, this.oldSize.x);
            if (size.x != this.oldSize.x) {
                x1 -= this.borderRight + this.highlight_margin + 2;
            }
            if (!this.simple) {
                x1 -= 5;
            }
            int y1 = Math.min(size.y, this.oldSize.y);
            if (size.y != this.oldSize.y) {
                y1 -= this.borderBottom + this.highlight_margin;
            }
            int x2 = Math.max(size.x, this.oldSize.x);
            int y2 = Math.max(size.y, this.oldSize.y);
            this.redraw(0, y1, x2, y2 - y1, false);
            this.redraw(x1, 0, x2 - x1, y2, false);
        }
        this.oldSize = size;
    }

    void onTraverse(Event event) {
        if (this.ignoreTraverse) {
            return;
        }
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl != this) break;
                event.doit = true;
                break;
            }
            case 128: {
                event.doit = this.onMnemonic(event, false);
                break;
            }
            case 256: 
            case 512: {
                event.doit = this.items.length > 0;
            }
        }
        this.ignoreTraverse = true;
        this.notifyListeners(31, event);
        this.ignoreTraverse = false;
        event.type = 0;
        if (this.isDisposed()) {
            return;
        }
        if (!event.doit) {
            return;
        }
        switch (event.detail) {
            case 128: {
                this.onMnemonic(event, true);
                event.detail = 0;
                break;
            }
            case 256: 
            case 512: {
                this.onPageTraversal(event);
                event.detail = 0;
            }
        }
    }

    void redrawTabs() {
        Point size = this.getSize();
        if (this.onBottom) {
            this.redraw(0, size.y - this.borderBottom - this.tabHeight - this.highlight_header - 1, size.x, this.borderBottom + this.tabHeight + this.highlight_header + 1, false);
        } else {
            this.redraw(0, 0, size.x, this.borderTop + this.tabHeight + this.highlight_header + 1, false);
        }
    }

    public void removeCTabFolder2Listener(CTabFolder2Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.folderListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.folderListeners.length) {
            if (listener == this.folderListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.folderListeners.length == 1) {
            this.folderListeners = new CTabFolder2Listener[0];
            return;
        }
        CTabFolder2Listener[] newTabListeners = new CTabFolder2Listener[this.folderListeners.length - 1];
        System.arraycopy(this.folderListeners, 0, newTabListeners, 0, index);
        System.arraycopy(this.folderListeners, index + 1, newTabListeners, index, this.folderListeners.length - index - 1);
        this.folderListeners = newTabListeners;
    }

    public void removeCTabFolderListener(CTabFolderListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.tabListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.tabListeners.length) {
            if (listener == this.tabListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.tabListeners.length == 1) {
            this.tabListeners = new CTabFolderListener[0];
            return;
        }
        CTabFolderListener[] newTabListeners = new CTabFolderListener[this.tabListeners.length - 1];
        System.arraycopy(this.tabListeners, 0, newTabListeners, 0, index);
        System.arraycopy(this.tabListeners, index + 1, newTabListeners, index, this.tabListeners.length - index - 1);
        this.tabListeners = newTabListeners;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void reskin(int flags) {
        super.reskin(flags);
        int i = 0;
        while (i < this.items.length) {
            this.items[i].reskin(flags);
            ++i;
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.createAntialiasColors();
        this.redraw();
    }

    void setBackground(Color[] colors, int[] percents) {
        this.setBackground(colors, percents, false);
    }

    void setBackground(Color[] colors, int[] percents, boolean vertical) {
        int i;
        this.checkWidget();
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                SWT.error(5);
            }
            i = 0;
            while (i < percents.length) {
                if (percents[i] < 0 || percents[i] > 100) {
                    SWT.error(5);
                }
                if (i > 0 && percents[i] < percents[i - 1]) {
                    SWT.error(5);
                }
                ++i;
            }
            if (this.getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[colors.length - 1]};
                percents = new int[]{};
            }
        }
        if (this.gradientColors != null && colors != null && this.gradientColors.length == colors.length) {
            boolean same = false;
            int i2 = 0;
            while (i2 < this.gradientColors.length) {
                same = this.gradientColors[i2] == null ? colors[i2] == null : this.gradientColors[i2].equals(colors[i2]);
                if (!same) break;
                ++i2;
            }
            if (same) {
                i2 = 0;
                while (i2 < this.gradientPercents.length) {
                    boolean bl = same = this.gradientPercents[i2] == percents[i2];
                    if (!same) break;
                    ++i2;
                }
            }
            if (same && this.gradientVertical == vertical) {
                return;
            }
        }
        if (colors == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
            this.setBackground(null);
        } else {
            this.gradientColors = new Color[colors.length];
            i = 0;
            while (i < colors.length) {
                this.gradientColors[i] = colors[i];
                ++i;
            }
            this.gradientPercents = new int[percents.length];
            i = 0;
            while (i < percents.length) {
                this.gradientPercents[i] = percents[i];
                ++i;
            }
            this.gradientVertical = vertical;
            this.setBackground(this.gradientColors[this.gradientColors.length - 1]);
        }
        this.redraw();
    }

    public void setBackgroundImage(Image image) {
        super.setBackgroundImage(image);
        this.createAntialiasColors();
        this.redraw();
    }

    public void setBorderVisible(boolean show) {
        this.checkWidget();
        if (this.borderLeft == 1 == show) {
            return;
        }
        this.borderRight = show ? 1 : 0;
        this.borderLeft = this.borderRight;
        this.borderTop = this.onBottom ? this.borderLeft : 0;
        this.borderBottom = this.onBottom ? 0 : this.borderLeft;
        Rectangle rectBefore = this.getClientArea();
        this.updateItems();
        Rectangle rectAfter = this.getClientArea();
        if (!rectBefore.equals(rectAfter)) {
            this.notifyListeners(11, new Event());
        }
        this.redraw();
    }

    void setButtonBounds() {
        int top;
        int right;
        int left;
        Point size = this.getSize();
        int oldX = this.maxRect.x;
        int oldY = this.maxRect.y;
        int oldWidth = this.maxRect.width;
        int oldHeight = this.maxRect.height;
        this.maxRect.height = 0;
        this.maxRect.width = 0;
        this.maxRect.y = 0;
        this.maxRect.x = 0;
        if (this.showMax) {
            this.maxRect.x = size.x - this.borderRight - 18 - 3;
            if (this.borderRight > 0) {
                ++this.maxRect.x;
            }
            this.maxRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
            this.maxRect.width = 18;
            this.maxRect.height = 18;
        }
        if (oldX != this.maxRect.x || oldWidth != this.maxRect.width || oldY != this.maxRect.y || oldHeight != this.maxRect.height) {
            left = Math.min(oldX, this.maxRect.x);
            right = Math.max(oldX + oldWidth, this.maxRect.x + this.maxRect.width);
            top = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(left, top, right - left, this.tabHeight, false);
        }
        oldX = this.minRect.x;
        oldY = this.minRect.y;
        oldWidth = this.minRect.width;
        oldHeight = this.minRect.height;
        this.minRect.height = 0;
        this.minRect.width = 0;
        this.minRect.y = 0;
        this.minRect.x = 0;
        if (this.showMin) {
            this.minRect.x = size.x - this.borderRight - this.maxRect.width - 18 - 3;
            if (this.borderRight > 0) {
                ++this.minRect.x;
            }
            this.minRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
            this.minRect.width = 18;
            this.minRect.height = 18;
        }
        if (oldX != this.minRect.x || oldWidth != this.minRect.width || oldY != this.minRect.y || oldHeight != this.minRect.height) {
            left = Math.min(oldX, this.minRect.x);
            right = Math.max(oldX + oldWidth, this.minRect.x + this.minRect.width);
            top = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(left, top, right - left, this.tabHeight, false);
        }
        oldX = this.topRightRect.x;
        oldY = this.topRightRect.y;
        oldWidth = this.topRightRect.width;
        oldHeight = this.topRightRect.height;
        this.topRightRect.height = 0;
        this.topRightRect.width = 0;
        this.topRightRect.y = 0;
        this.topRightRect.x = 0;
        if (this.topRight != null) {
            switch (this.topRightAlignment) {
                case 4: {
                    int rightEdge = size.x - this.borderRight - 3 - this.maxRect.width - this.minRect.width;
                    if (!(this.simple || this.borderRight <= 0 || this.showMax || this.showMin)) {
                        rightEdge -= 2;
                    }
                    if (this.single) {
                        if (this.items.length == 0 || this.selectedIndex == -1) {
                            this.topRightRect.x = this.borderLeft + 3;
                            this.topRightRect.width = rightEdge - this.topRightRect.x;
                        } else {
                            CTabItem item = this.items[this.selectedIndex];
                            if (item.x + item.width + 7 + 27 >= rightEdge) break;
                            this.topRightRect.x = item.x + item.width + 7 + 27;
                            this.topRightRect.width = rightEdge - this.topRightRect.x;
                        }
                    } else {
                        if (this.showChevron) break;
                        if (this.items.length == 0) {
                            this.topRightRect.x = this.borderLeft + 3;
                        } else {
                            CTabItem item = this.items[this.items.length - 1];
                            this.topRightRect.x = item.x + item.width;
                            if (!this.simple && this.items.length - 1 == this.selectedIndex) {
                                this.topRightRect.x += this.curveWidth - this.curveIndent;
                            }
                        }
                        this.topRightRect.width = Math.max(0, rightEdge - this.topRightRect.x);
                    }
                    this.topRightRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                    break;
                }
                case 131072: {
                    Point topRightSize = this.topRight.computeSize(-1, this.tabHeight, false);
                    int rightEdge = size.x - this.borderRight - 3 - this.maxRect.width - this.minRect.width;
                    if (!(this.simple || this.borderRight <= 0 || this.showMax || this.showMin)) {
                        rightEdge -= 2;
                    }
                    this.topRightRect.x = rightEdge - topRightSize.x;
                    this.topRightRect.width = topRightSize.x;
                    this.topRightRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                }
            }
            this.topRight.setBounds(this.topRightRect);
        }
        if (oldX != this.topRightRect.x || oldWidth != this.topRightRect.width || oldY != this.topRightRect.y || oldHeight != this.topRightRect.height) {
            int left2 = Math.min(oldX, this.topRightRect.x);
            int right2 = Math.max(oldX + oldWidth, this.topRightRect.x + this.topRightRect.width);
            top = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(left2, top, right2 - left2, this.tabHeight, false);
        }
        oldX = this.chevronRect.x;
        oldY = this.chevronRect.y;
        oldWidth = this.chevronRect.width;
        oldHeight = this.chevronRect.height;
        this.chevronRect.width = 0;
        this.chevronRect.height = 0;
        this.chevronRect.y = 0;
        this.chevronRect.x = 0;
        if (this.single) {
            if (this.selectedIndex == -1 || this.items.length > 1) {
                this.chevronRect.width = 27;
                this.chevronRect.height = 18;
                int n = this.chevronRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : this.borderTop + (this.tabHeight - this.chevronRect.height) / 2;
                if (this.selectedIndex == -1) {
                    this.chevronRect.x = size.x - this.borderRight - 3 - this.minRect.width - this.maxRect.width - this.topRightRect.width - this.chevronRect.width;
                } else {
                    CTabItem item = this.items[this.selectedIndex];
                    int w = size.x - this.borderRight - 3 - this.minRect.width - this.maxRect.width - this.chevronRect.width;
                    if (this.topRightRect.width > 0) {
                        w -= this.topRightRect.width + 3;
                    }
                    this.chevronRect.x = Math.min(item.x + item.width + 3, w);
                }
                if (this.borderRight > 0) {
                    ++this.chevronRect.x;
                }
            }
        } else if (this.showChevron) {
            this.chevronRect.width = 27;
            this.chevronRect.height = 18;
            int i = 0;
            int lastIndex = -1;
            while (i < this.priority.length && this.items[this.priority[i]].showing) {
                lastIndex = Math.max(lastIndex, this.priority[i++]);
            }
            if (lastIndex == -1) {
                lastIndex = this.firstIndex;
            }
            CTabItem lastItem = this.items[lastIndex];
            int w = lastItem.x + lastItem.width + 3;
            if (!this.simple && lastIndex == this.selectedIndex) {
                w += this.curveWidth - 2 * this.curveIndent;
            }
            this.chevronRect.x = Math.min(w, this.getRightItemEdge());
            int n = this.chevronRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : this.borderTop + (this.tabHeight - this.chevronRect.height) / 2;
        }
        if (oldX != this.chevronRect.x || oldWidth != this.chevronRect.width || oldY != this.chevronRect.y || oldHeight != this.chevronRect.height) {
            int left3 = Math.min(oldX, this.chevronRect.x);
            int right3 = Math.max(oldX + oldWidth, this.chevronRect.x + this.chevronRect.width);
            int top2 = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(left3, top2, right3 - left3, this.tabHeight, false);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        super.setFont(font);
        this.oldFont = this.getFont();
        if (!this.updateTabHeight(false)) {
            this.updateItems();
            this.redraw();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.redraw();
    }

    public void setInsertMark(CTabItem item, boolean after) {
        this.checkWidget();
    }

    public void setInsertMark(int index, boolean after) {
        this.checkWidget();
        if (index < -1 || index >= this.getItemCount()) {
            SWT.error(5);
        }
    }

    boolean setItemLocation() {
        int y;
        boolean changed = false;
        if (this.items.length == 0) {
            return false;
        }
        Point size = this.getSize();
        int n = y = this.onBottom ? Math.max(this.borderBottom, size.y - this.borderBottom - this.tabHeight) : this.borderTop;
        if (this.single) {
            int defaultX = this.getDisplay().getBounds().width + 10;
            int i = 0;
            while (i < this.items.length) {
                CTabItem item = this.items[i];
                if (i == this.selectedIndex) {
                    this.firstIndex = this.selectedIndex;
                    int oldX = item.x;
                    int oldY = item.y;
                    item.x = this.borderLeft;
                    item.y = y;
                    item.showing = true;
                    if (this.showClose || item.showClose) {
                        item.closeRect.x = this.borderLeft + 4;
                        int n2 = item.closeRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
                    }
                    if (item.x != oldX || item.y != oldY) {
                        changed = true;
                    }
                } else {
                    item.x = defaultX;
                    item.showing = false;
                }
                ++i;
            }
        } else {
            int rightItemEdge = this.getRightItemEdge();
            int maxWidth = rightItemEdge - this.borderLeft;
            int width = 0;
            int i = 0;
            while (i < this.priority.length) {
                CTabItem item = this.items[this.priority[i]];
                boolean bl = i == 0 ? true : (item.showing = item.width > 0 && (width += item.width) <= maxWidth);
                if (!this.simple && this.priority[i] == this.selectedIndex) {
                    width += this.curveWidth - 2 * this.curveIndent;
                }
                ++i;
            }
            int x = 0;
            int defaultX = this.getDisplay().getBounds().width + 10;
            this.firstIndex = this.items.length - 1;
            int i2 = 0;
            while (i2 < this.items.length) {
                CTabItem item = this.items[i2];
                if (!item.showing) {
                    if (item.x != defaultX) {
                        changed = true;
                    }
                    item.x = defaultX;
                } else {
                    this.firstIndex = Math.min(this.firstIndex, i2);
                    if (item.x != x || item.y != y) {
                        changed = true;
                    }
                    item.x = x;
                    item.y = y;
                    if (i2 == this.selectedIndex) {
                        int edge = Math.min(item.x + item.width, rightItemEdge);
                        item.closeRect.x = edge - 4 - 18;
                    } else {
                        item.closeRect.x = item.x + item.width - 4 - 18;
                    }
                    item.closeRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
                    x += item.width;
                    if (!this.simple && i2 == this.selectedIndex) {
                        x += this.curveWidth - 2 * this.curveIndent;
                    }
                }
                ++i2;
            }
        }
        return changed;
    }

    boolean setItemSize() {
        int[] widths;
        boolean changed = false;
        if (this.isDisposed()) {
            return changed;
        }
        Point size = this.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return changed;
        }
        this.xClient = this.borderLeft + this.marginWidth + this.highlight_margin;
        this.yClient = this.onBottom ? this.borderTop + this.highlight_margin + this.marginHeight : this.borderTop + this.tabHeight + this.highlight_header + this.marginHeight;
        this.showChevron = false;
        if (this.single) {
            this.showChevron = true;
            if (this.selectedIndex != -1) {
                CTabItem tab = this.items[this.selectedIndex];
                GC gc = new GC(this);
                int width = tab.preferredWidth(gc, true, false);
                gc.dispose();
                width = Math.min(width, this.getRightItemEdge() - this.borderLeft);
                if (tab.height != this.tabHeight || tab.width != width) {
                    changed = true;
                    tab.shortenedText = null;
                    tab.shortenedTextWidth = 0;
                    tab.height = this.tabHeight;
                    tab.width = width;
                    tab.closeRect.height = 0;
                    tab.closeRect.width = 0;
                    if (this.showClose || tab.showClose) {
                        tab.closeRect.width = 18;
                        tab.closeRect.height = 18;
                    }
                }
            }
            return changed;
        }
        if (this.items.length == 0) {
            return changed;
        }
        GC gc = new GC(this);
        int tabAreaWidth = size.x - this.borderLeft - this.borderRight - 3;
        if (this.showMin) {
            tabAreaWidth -= 18;
        }
        if (this.showMax) {
            tabAreaWidth -= 18;
        }
        if (this.topRightAlignment == 131072 && this.topRight != null) {
            Point rightSize = this.topRight.computeSize(-1, -1, false);
            tabAreaWidth -= rightSize.x + 3;
        }
        if (!this.simple) {
            tabAreaWidth -= this.curveWidth - 2 * this.curveIndent;
        }
        tabAreaWidth = Math.max(0, tabAreaWidth);
        int minWidth = 0;
        int[] minWidths = new int[this.items.length];
        int i = 0;
        while (i < this.priority.length) {
            int index = this.priority[i];
            minWidths[index] = this.items[index].preferredWidth(gc, index == this.selectedIndex, true);
            if ((minWidth += minWidths[index]) > tabAreaWidth) break;
            ++i;
        }
        if (minWidth > tabAreaWidth) {
            int index;
            boolean bl = this.showChevron = this.items.length > 1;
            if (this.showChevron) {
                tabAreaWidth -= 27;
            }
            widths = minWidths;
            int n = index = this.selectedIndex != -1 ? this.selectedIndex : 0;
            if (tabAreaWidth < widths[index]) {
                widths[index] = Math.max(0, tabAreaWidth);
            }
        } else {
            int maxWidth = 0;
            int[] maxWidths = new int[this.items.length];
            int i2 = 0;
            while (i2 < this.items.length) {
                maxWidths[i2] = this.items[i2].preferredWidth(gc, i2 == this.selectedIndex, false);
                maxWidth += maxWidths[i2];
                ++i2;
            }
            if (maxWidth <= tabAreaWidth) {
                widths = maxWidths;
            } else {
                int extra = (tabAreaWidth - minWidth) / this.items.length;
                while (true) {
                    int large = 0;
                    int totalWidth = 0;
                    int i3 = 0;
                    while (i3 < this.items.length) {
                        if (maxWidths[i3] > minWidths[i3] + extra) {
                            totalWidth += minWidths[i3] + extra;
                            ++large;
                        } else {
                            totalWidth += maxWidths[i3];
                        }
                        ++i3;
                    }
                    if (totalWidth >= tabAreaWidth) {
                        --extra;
                        break;
                    }
                    if (large == 0 || tabAreaWidth - totalWidth < large) break;
                    ++extra;
                }
                widths = new int[this.items.length];
                int i4 = 0;
                while (i4 < this.items.length) {
                    widths[i4] = Math.min(maxWidths[i4], minWidths[i4] + extra);
                    ++i4;
                }
            }
        }
        gc.dispose();
        i = 0;
        while (i < this.items.length) {
            CTabItem tab = this.items[i];
            int width = widths[i];
            if (tab.height != this.tabHeight || tab.width != width) {
                changed = true;
                tab.shortenedText = null;
                tab.shortenedTextWidth = 0;
                tab.height = this.tabHeight;
                tab.width = width;
                tab.closeRect.height = 0;
                tab.closeRect.width = 0;
                if ((this.showClose || tab.showClose) && (i == this.selectedIndex || this.showUnselectedClose)) {
                    tab.closeRect.width = 18;
                    tab.closeRect.height = 18;
                }
            }
            ++i;
        }
        return changed;
    }

    public void setMaximizeVisible(boolean visible) {
        this.checkWidget();
        if (this.showMax == visible) {
            return;
        }
        this.showMax = visible;
        this.updateItems();
        this.redraw();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximized(boolean maximize) {
        this.checkWidget();
        if (this.maximized == maximize) {
            return;
        }
        if (maximize && this.minimized) {
            this.setMinimized(false);
        }
        this.maximized = maximize;
        this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
    }

    public void setMinimizeVisible(boolean visible) {
        this.checkWidget();
        if (this.showMin == visible) {
            return;
        }
        this.showMin = visible;
        this.updateItems();
        this.redraw();
    }

    public void setMinimized(boolean minimize) {
        this.checkWidget();
        if (this.minimized == minimize) {
            return;
        }
        if (minimize && this.maximized) {
            this.setMaximized(false);
        }
        this.minimized = minimize;
        this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
    }

    public void setMinimumCharacters(int count) {
        this.checkWidget();
        if (count < 0) {
            SWT.error(6);
        }
        if (this.minChars == count) {
            return;
        }
        this.minChars = count;
        if (this.updateItems()) {
            this.redrawTabs();
        }
    }

    public void setMRUVisible(boolean show) {
        this.checkWidget();
        if (this.mru == show) {
            return;
        }
        this.mru = show;
        if (!this.mru) {
            int idx = this.firstIndex;
            int next = 0;
            int i = this.firstIndex;
            while (i < this.items.length) {
                this.priority[next++] = i++;
            }
            i = 0;
            while (i < idx) {
                this.priority[next++] = i++;
            }
            if (this.updateItems()) {
                this.redrawTabs();
            }
        }
    }

    public void setSelection(CTabItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        int index = this.indexOf(item);
        this.setSelection(index);
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        CTabItem selection = this.items[index];
        if (this.selectedIndex == index) {
            this.showItem(selection);
            return;
        }
        int oldIndex = this.selectedIndex;
        this.selectedIndex = index;
        if (oldIndex != -1) {
            this.items[oldIndex].closeImageState = 0;
        }
        selection.closeImageState = 1;
        selection.showing = false;
        Control newControl = selection.control;
        Control oldControl = null;
        if (oldIndex != -1) {
            oldControl = this.items[oldIndex].control;
        }
        if (newControl != oldControl) {
            if (newControl != null && !newControl.isDisposed()) {
                newControl.setBounds(this.getClientArea());
                newControl.setVisible(true);
            }
            if (oldControl != null && !oldControl.isDisposed()) {
                oldControl.setVisible(false);
            }
        }
        this.showItem(selection);
        this.redraw();
    }

    void setSelection(int index, boolean notify) {
        int oldSelectedIndex = this.selectedIndex;
        this.setSelection(index);
        if (notify && this.selectedIndex != oldSelectedIndex && this.selectedIndex != -1) {
            Event event = new Event();
            event.item = this.getItem(this.selectedIndex);
            this.notifyListeners(13, event);
        }
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        this.setSelectionHighlightGradientColor(null);
        if (this.selectionBackground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(25);
        }
        this.selectionBackground = color;
        this.createAntialiasColors();
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionBackground(Color[] colors, int[] percents) {
        this.setSelectionBackground(colors, percents, false);
    }

    public void setSelectionBackground(Color[] colors, int[] percents, boolean vertical) {
        int colorsLength;
        int i;
        this.checkWidget();
        Color highlightBeginColor = null;
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1 && percents.length != colors.length - 2) {
                SWT.error(5);
            }
            i = 0;
            while (i < percents.length) {
                if (percents[i] < 0 || percents[i] > 100) {
                    SWT.error(5);
                }
                if (i > 0 && percents[i] < percents[i - 1]) {
                    SWT.error(5);
                }
                ++i;
            }
            if (percents.length == colors.length - 2) {
                highlightBeginColor = colors[colors.length - 1];
                colorsLength = colors.length - 1;
            } else {
                colorsLength = colors.length;
            }
            if (this.getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[colorsLength - 1]};
                colorsLength = colors.length;
                percents = new int[]{};
            }
        } else {
            colorsLength = 0;
        }
        if (this.selectionBgImage == null) {
            if (this.selectionGradientColors != null && colors != null && this.selectionGradientColors.length == colorsLength) {
                boolean same = false;
                int i2 = 0;
                while (i2 < this.selectionGradientColors.length) {
                    same = this.selectionGradientColors[i2] == null ? colors[i2] == null : this.selectionGradientColors[i2].equals(colors[i2]);
                    if (!same) break;
                    ++i2;
                }
                if (same) {
                    i2 = 0;
                    while (i2 < this.selectionGradientPercents.length) {
                        boolean bl = same = this.selectionGradientPercents[i2] == percents[i2];
                        if (!same) break;
                        ++i2;
                    }
                }
                if (same && this.selectionGradientVertical == vertical) {
                    return;
                }
            }
        } else {
            this.selectionBgImage = null;
        }
        if (colors == null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.selectionGradientVertical = false;
            this.setSelectionBackground((Color)null);
            this.setSelectionHighlightGradientColor(null);
        } else {
            this.selectionGradientColors = new Color[colorsLength];
            i = 0;
            while (i < colorsLength) {
                this.selectionGradientColors[i] = colors[i];
                ++i;
            }
            this.selectionGradientPercents = new int[percents.length];
            i = 0;
            while (i < percents.length) {
                this.selectionGradientPercents[i] = percents[i];
                ++i;
            }
            this.selectionGradientVertical = vertical;
            this.setSelectionBackground(this.selectionGradientColors[this.selectionGradientColors.length - 1]);
            this.setSelectionHighlightGradientColor(highlightBeginColor);
        }
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    void setSelectionHighlightGradientColor(Color start) {
        this.selectionHighlightGradientBegin = null;
        if (start == null) {
            return;
        }
        if (this.getDisplay().getDepth() < 15) {
            return;
        }
        if (this.selectionGradientColors.length < 2) {
            return;
        }
        this.selectionHighlightGradientBegin = start;
        if (!this.isSelectionHighlightColorsCacheHit(start)) {
            this.createSelectionHighlightGradientColors(start);
        }
    }

    boolean isSelectionHighlightColorsCacheHit(Color start) {
        if (this.selectionHighlightGradientColorsCache == null) {
            return false;
        }
        if (this.selectionHighlightGradientColorsCache.length < 2) {
            return false;
        }
        Color highlightBegin = this.selectionHighlightGradientColorsCache[0];
        Color highlightEnd = this.selectionHighlightGradientColorsCache[this.selectionHighlightGradientColorsCache.length - 1];
        if (!highlightBegin.equals(start)) {
            return false;
        }
        if (this.selectionHighlightGradientColorsCache.length != this.tabHeight) {
            return false;
        }
        return highlightEnd.equals(this.selectionBackground);
    }

    public void setSelectionBackground(Image image) {
        this.checkWidget();
        this.setSelectionHighlightGradientColor(null);
        if (image == this.selectionBgImage) {
            return;
        }
        if (image != null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.disposeSelectionHighlightGradientColors();
        }
        this.selectionBgImage = image;
        this.createAntialiasColors();
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (this.selectionForeground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(24);
        }
        this.selectionForeground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    void createSelectionHighlightGradientColors(Color start) {
        this.disposeSelectionHighlightGradientColors();
        if (start == null) {
            return;
        }
        int fadeGradientSize = this.tabHeight;
        RGB from = start.getRGB();
        RGB to = this.selectionBackground.getRGB();
        this.selectionHighlightGradientColorsCache = new Color[fadeGradientSize];
        int denom = fadeGradientSize - 1;
        int i = 0;
        while (i < fadeGradientSize) {
            int propFrom = denom - i;
            int propTo = i;
            int red = (to.red * propTo + from.red * propFrom) / denom;
            int green = (to.green * propTo + from.green * propFrom) / denom;
            int blue = (to.blue * propTo + from.blue * propFrom) / denom;
            this.selectionHighlightGradientColorsCache[i] = new Color(this.getDisplay(), red, green, blue);
            ++i;
        }
    }

    void disposeSelectionHighlightGradientColors() {
        if (this.selectionHighlightGradientColorsCache == null) {
            return;
        }
        int i = 0;
        while (i < this.selectionHighlightGradientColorsCache.length) {
            this.selectionHighlightGradientColorsCache[i].dispose();
            ++i;
        }
        this.selectionHighlightGradientColorsCache = null;
    }

    Color getSelectionBackgroundGradientBegin() {
        if (this.selectionGradientColors == null) {
            return this.getSelectionBackground();
        }
        if (this.selectionGradientColors.length == 0) {
            return this.getSelectionBackground();
        }
        return this.selectionGradientColors[0];
    }

    public void setSimple(boolean simple) {
        this.checkWidget();
        if (this.simple != simple) {
            this.simple = simple;
            Rectangle rectBefore = this.getClientArea();
            this.updateItems();
            Rectangle rectAfter = this.getClientArea();
            if (!rectBefore.equals(rectAfter)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setSingle(boolean single) {
        this.checkWidget();
        if (this.single != single) {
            this.single = single;
            if (!single) {
                int i = 0;
                while (i < this.items.length) {
                    if (i != this.selectedIndex && this.items[i].closeImageState == 1) {
                        this.items[i].closeImageState = 0;
                    }
                    ++i;
                }
            }
            Rectangle rectBefore = this.getClientArea();
            this.updateItems();
            Rectangle rectAfter = this.getClientArea();
            if (!rectBefore.equals(rectAfter)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setTabHeight(int height) {
        this.checkWidget();
        if (height < -1) {
            SWT.error(5);
        }
        this.fixedTabHeight = height;
        this.updateTabHeight(false);
    }

    public void setTabPosition(int position) {
        this.checkWidget();
        if (position != 128 && position != 1024) {
            SWT.error(5);
        }
        if (this.onBottom != (position == 1024)) {
            this.onBottom = position == 1024;
            this.borderTop = this.onBottom ? this.borderLeft : 0;
            this.borderBottom = this.onBottom ? 0 : this.borderRight;
            this.updateTabHeight(true);
            Rectangle rectBefore = this.getClientArea();
            this.updateItems();
            Rectangle rectAfter = this.getClientArea();
            if (!rectBefore.equals(rectAfter)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setTopRight(Control control) {
        this.setTopRight(control, 131072);
    }

    public void setTopRight(Control control, int alignment) {
        this.checkWidget();
        if (alignment != 131072 && alignment != 4) {
            SWT.error(5);
        }
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        this.topRight = control;
        this.topRightAlignment = alignment;
        if (this.updateItems()) {
            this.redraw();
        }
    }

    public void setUnselectedCloseVisible(boolean visible) {
        this.checkWidget();
        if (this.showUnselectedClose == visible) {
            return;
        }
        this.showUnselectedClose = visible;
        this.updateItems();
        this.redraw();
    }

    public void setUnselectedImageVisible(boolean visible) {
        this.checkWidget();
        if (this.showUnselectedImage == visible) {
            return;
        }
        this.showUnselectedImage = visible;
        this.updateItems();
        this.redraw();
    }

    public void showItem(CTabItem item) {
        int index;
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        if ((index = this.indexOf(item)) == -1) {
            SWT.error(5);
        }
        int idx = -1;
        int i = 0;
        while (i < this.priority.length) {
            if (this.priority[i] == index) {
                idx = i;
                break;
            }
            ++i;
        }
        if (this.mru) {
            int[] newPriority = new int[this.priority.length];
            System.arraycopy(this.priority, 0, newPriority, 1, idx);
            System.arraycopy(this.priority, idx + 1, newPriority, idx + 1, this.priority.length - idx - 1);
            newPriority[0] = index;
            this.priority = newPriority;
        }
        if (item.isShowing()) {
            return;
        }
        this.updateItems(index);
        this.redrawTabs();
    }

    void showList(Rectangle rect) {
        if (this.items.length == 0 || !this.showChevron) {
            return;
        }
        if (this.showMenu == null || this.showMenu.isDisposed()) {
            this.showMenu = new Menu(this);
        } else {
            MenuItem[] items = this.showMenu.getItems();
            int i = 0;
            while (i < items.length) {
                items[i].dispose();
                ++i;
            }
        }
        int i = 0;
        while (i < this.items.length) {
            CTabItem tab = this.items[i];
            if (!tab.showing) {
                MenuItem item = new MenuItem(this.showMenu, 0);
                item.setText(tab.getText());
                item.setImage(tab.getImage());
                item.setData("CTabFolder_showList_Index", tab);
                item.addSelectionListener(new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MenuItem menuItem = (MenuItem)e.widget;
                        int index = CTabFolder.this.indexOf((CTabItem)menuItem.getData("CTabFolder_showList_Index"));
                        CTabFolder.this.setSelection(index, true);
                    }
                });
            }
            ++i;
        }
        int x = rect.x;
        int y = rect.y + rect.height;
        Point location = this.getDisplay().map(this, null, x, y);
        this.showMenu.setLocation(location.x, location.y);
        this.showMenu.setVisible(true);
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedIndex != -1) {
            this.showItem(this.getSelection());
        }
    }

    void _setToolTipText(int x, int y) {
        String oldTip = this.getToolTipText();
        String newTip = this._getToolTip(x, y);
        if (newTip == null || !newTip.equals(oldTip)) {
            this.setToolTipText(newTip);
        }
    }

    boolean updateItems() {
        return this.updateItems(this.selectedIndex);
    }

    boolean updateItems(int showIndex) {
        if (!this.single && !this.mru && showIndex != -1) {
            int firstIndex = showIndex;
            if (this.priority[0] < showIndex) {
                int maxWidth = this.getRightItemEdge() - this.borderLeft;
                if (!this.simple) {
                    maxWidth -= this.curveWidth - 2 * this.curveIndent;
                }
                int width = 0;
                int[] widths = new int[this.items.length];
                GC gc = new GC(this);
                int i = this.priority[0];
                while (i <= showIndex) {
                    widths[i] = this.items[i].preferredWidth(gc, i == this.selectedIndex, true);
                    if ((width += widths[i]) > maxWidth) break;
                    ++i;
                }
                if (width > maxWidth) {
                    width = 0;
                    i = showIndex;
                    while (i >= 0) {
                        if (widths[i] == 0) {
                            widths[i] = this.items[i].preferredWidth(gc, i == this.selectedIndex, true);
                        }
                        if ((width += widths[i]) <= maxWidth) {
                            firstIndex = i--;
                            continue;
                        }
                        break;
                    }
                } else {
                    firstIndex = this.priority[0];
                    i = showIndex + 1;
                    while (i < this.items.length) {
                        widths[i] = this.items[i].preferredWidth(gc, i == this.selectedIndex, true);
                        if ((width += widths[i]) >= maxWidth) break;
                        ++i;
                    }
                    if (width < maxWidth) {
                        i = this.priority[0] - 1;
                        while (i >= 0) {
                            if (widths[i] == 0) {
                                widths[i] = this.items[i].preferredWidth(gc, i == this.selectedIndex, true);
                            }
                            if ((width += widths[i]) <= maxWidth) {
                                firstIndex = i--;
                                continue;
                            }
                            break;
                        }
                    }
                }
                gc.dispose();
            }
            if (firstIndex != this.priority[0]) {
                int index = 0;
                int i = firstIndex;
                while (i < this.items.length) {
                    this.priority[index++] = i++;
                }
                i = 0;
                while (i < firstIndex) {
                    this.priority[index++] = i++;
                }
            }
        }
        boolean oldShowChevron = this.showChevron;
        boolean changed = this.setItemSize();
        changed |= this.setItemLocation();
        this.setButtonBounds();
        if ((changed |= this.showChevron ^ oldShowChevron) && this.getToolTipText() != null) {
            Point pt = this.getDisplay().getCursorLocation();
            pt = this.toControl(pt);
            this._setToolTipText(pt.x, pt.y);
        }
        return changed;
    }

    boolean updateTabHeight(boolean force) {
        int d;
        int style = this.getStyle();
        if (this.fixedTabHeight == 0 && (style & 0x800000) != 0 && (style & 0x800) == 0) {
            this.highlight_header = 0;
        }
        int oldHeight = this.tabHeight;
        if (this.fixedTabHeight != -1) {
            this.tabHeight = this.fixedTabHeight == 0 ? 0 : this.fixedTabHeight + 1;
        } else {
            int tempHeight = 0;
            GC gc = new GC(this);
            if (this.items.length == 0) {
                tempHeight = gc.textExtent((String)"Default", (int)9).y + 2 + 2;
            } else {
                int i = 0;
                while (i < this.items.length) {
                    tempHeight = Math.max(tempHeight, this.items[i].preferredHeight(gc));
                    ++i;
                }
            }
            gc.dispose();
            this.tabHeight = tempHeight;
        }
        if (!force && this.tabHeight == oldHeight) {
            return false;
        }
        this.oldSize = null;
        if (this.onBottom) {
            d = this.tabHeight - 12;
            int[] nArray = new int[40];
            nArray[1] = 13 + d;
            nArray[3] = 12 + d;
            nArray[4] = 2;
            nArray[5] = 12 + d;
            nArray[6] = 3;
            nArray[7] = 11 + d;
            nArray[8] = 5;
            nArray[9] = 11 + d;
            nArray[10] = 6;
            nArray[11] = 10 + d;
            nArray[12] = 7;
            nArray[13] = 10 + d;
            nArray[14] = 9;
            nArray[15] = 8 + d;
            nArray[16] = 10;
            nArray[17] = 8 + d;
            nArray[18] = 11;
            nArray[19] = 7 + d;
            nArray[20] = 11 + d;
            nArray[21] = 7;
            nArray[22] = 12 + d;
            nArray[23] = 6;
            nArray[24] = 13 + d;
            nArray[25] = 6;
            nArray[26] = 15 + d;
            nArray[27] = 4;
            nArray[28] = 16 + d;
            nArray[29] = 4;
            nArray[30] = 17 + d;
            nArray[31] = 3;
            nArray[32] = 19 + d;
            nArray[33] = 3;
            nArray[34] = 20 + d;
            nArray[35] = 2;
            nArray[36] = 22 + d;
            nArray[37] = 2;
            nArray[38] = 23 + d;
            nArray[39] = 1;
            this.curve = nArray;
            this.curveWidth = 26 + d;
            this.curveIndent = this.curveWidth / 3;
        } else {
            d = this.tabHeight - 12;
            int[] nArray = new int[40];
            nArray[3] = 1;
            nArray[4] = 2;
            nArray[5] = 1;
            nArray[6] = 3;
            nArray[7] = 2;
            nArray[8] = 5;
            nArray[9] = 2;
            nArray[10] = 6;
            nArray[11] = 3;
            nArray[12] = 7;
            nArray[13] = 3;
            nArray[14] = 9;
            nArray[15] = 5;
            nArray[16] = 10;
            nArray[17] = 5;
            nArray[18] = 11;
            nArray[19] = 6;
            nArray[20] = 11 + d;
            nArray[21] = 6 + d;
            nArray[22] = 12 + d;
            nArray[23] = 7 + d;
            nArray[24] = 13 + d;
            nArray[25] = 7 + d;
            nArray[26] = 15 + d;
            nArray[27] = 9 + d;
            nArray[28] = 16 + d;
            nArray[29] = 9 + d;
            nArray[30] = 17 + d;
            nArray[31] = 10 + d;
            nArray[32] = 19 + d;
            nArray[33] = 10 + d;
            nArray[34] = 20 + d;
            nArray[35] = 11 + d;
            nArray[36] = 22 + d;
            nArray[37] = 11 + d;
            nArray[38] = 23 + d;
            nArray[39] = 12 + d;
            this.curve = nArray;
            this.curveWidth = 26 + d;
            this.curveIndent = this.curveWidth / 3;
            int[] nArray2 = new int[22];
            nArray2[1] = 2;
            nArray2[2] = 1;
            nArray2[3] = 2;
            nArray2[4] = 2;
            nArray2[5] = 2;
            nArray2[6] = 3;
            nArray2[7] = 3;
            nArray2[8] = 4;
            nArray2[9] = 3;
            nArray2[10] = 5;
            nArray2[11] = 3;
            nArray2[12] = 6;
            nArray2[13] = 4;
            nArray2[14] = 7;
            nArray2[15] = 4;
            nArray2[16] = 8;
            nArray2[17] = 5;
            nArray2[18] = 9;
            nArray2[19] = 6;
            nArray2[20] = 10;
            nArray2[21] = 6;
            this.topCurveHighlightStart = nArray2;
            this.topCurveHighlightEnd = new int[]{10 + d, 6 + d, 11 + d, 7 + d, 12 + d, 8 + d, 13 + d, 8 + d, 14 + d, 9 + d, 15 + d, 10 + d, 16 + d, 10 + d, 17 + d, 11 + d, 18 + d, 11 + d, 19 + d, 11 + d, 20 + d, 12 + d, 21 + d, 12 + d, 22 + d, 12 + d};
        }
        this.notifyListeners(11, new Event());
        return true;
    }

    String _getToolTip(int x, int y) {
        if (this.showMin && this.minRect.contains(x, y)) {
            return this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize");
        }
        if (this.showMax && this.maxRect.contains(x, y)) {
            return this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize");
        }
        if (this.showChevron && this.chevronRect.contains(x, y)) {
            return SWT.getMessage("SWT_ShowList");
        }
        CTabItem item = this.getItem(new Point(x, y));
        if (item == null) {
            return null;
        }
        if (!item.showing) {
            return null;
        }
        if ((this.showClose || item.showClose) && item.closeRect.contains(x, y)) {
            return SWT.getMessage("SWT_Close");
        }
        return item.getToolTipText();
    }

    void createAntialiasColors() {
        int blue;
        int green;
        int red;
        RGB to;
        RGB from;
        this.disposeAntialiasColors();
        this.lastBorderColor = this.getDisplay().getSystemColor(18);
        RGB lineRGB = this.lastBorderColor.getRGB();
        RGB innerRGB = this.selectionBackground.getRGB();
        if (this.selectionBgImage != null || this.selectionGradientColors != null && this.selectionGradientColors.length > 1) {
            innerRGB = null;
        }
        RGB outerRGB = this.getBackground().getRGB();
        if (this.gradientColors != null && this.gradientColors.length > 1) {
            outerRGB = null;
        }
        if (outerRGB != null) {
            from = lineRGB;
            to = outerRGB;
            red = from.red + 2 * (to.red - from.red) / 3;
            green = from.green + 2 * (to.green - from.green) / 3;
            blue = from.blue + 2 * (to.blue - from.blue) / 3;
            this.selectedOuterColor = new Color(this.getDisplay(), red, green, blue);
        }
        if (innerRGB != null) {
            from = lineRGB;
            to = innerRGB;
            red = from.red + 2 * (to.red - from.red) / 3;
            green = from.green + 2 * (to.green - from.green) / 3;
            blue = from.blue + 2 * (to.blue - from.blue) / 3;
            this.selectedInnerColor = new Color(this.getDisplay(), red, green, blue);
        }
        if ((outerRGB = this.getParent().getBackground().getRGB()) != null) {
            from = lineRGB;
            to = outerRGB;
            red = from.red + 2 * (to.red - from.red) / 3;
            green = from.green + 2 * (to.green - from.green) / 3;
            blue = from.blue + 2 * (to.blue - from.blue) / 3;
            this.tabAreaColor = new Color(this.getDisplay(), red, green, blue);
        }
    }

    void disposeAntialiasColors() {
        if (this.tabAreaColor != null) {
            this.tabAreaColor.dispose();
        }
        if (this.selectedInnerColor != null) {
            this.selectedInnerColor.dispose();
        }
        if (this.selectedOuterColor != null) {
            this.selectedOuterColor.dispose();
        }
        this.selectedOuterColor = null;
        this.selectedInnerColor = null;
        this.tabAreaColor = null;
    }
}

