/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public class ImageTransfer
extends ByteArrayTransfer {
    private static ImageTransfer _instance = new ImageTransfer();
    private static final String JPEG = "image/jpeg";
    private static final int JPEG_ID = ImageTransfer.registerType("image/jpeg");
    private static final String PNG = "image/png";
    private static final int PNG_ID = ImageTransfer.registerType("image/png");
    private static final String BMP = "image/bmp";
    private static final int BMP_ID = ImageTransfer.registerType("image/bmp");
    private static final String EPS = "image/eps";
    private static final int EPS_ID = ImageTransfer.registerType("image/eps");
    private static final String PCX = "image/pcx";
    private static final int PCX_ID = ImageTransfer.registerType("image/pcx");
    private static final String PPM = "image/ppm";
    private static final int PPM_ID = ImageTransfer.registerType("image/ppm");
    private static final String RGB = "image/ppm";
    private static final int RGB_ID = ImageTransfer.registerType("image/ppm");
    private static final String TGA = "image/tga";
    private static final int TGA_ID = ImageTransfer.registerType("image/tga");
    private static final String XBM = "image/xbm";
    private static final int XBM_ID = ImageTransfer.registerType("image/xbm");
    private static final String XPM = "image/xpm";
    private static final int XPM_ID = ImageTransfer.registerType("image/xpm");
    private static final String XV = "image/xv";
    private static final int XV_ID = ImageTransfer.registerType("image/xv");

    private ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
            return;
        }
        ImageData imageData = (ImageData)object;
        if (imageData == null) {
            SWT.error(4);
        }
        Image image = new Image((Device)Display.getCurrent(), imageData);
        long l = image.pixmap;
        int n = imageData.width;
        int n2 = imageData.height;
        long l2 = OS.gdk_pixbuf_new(0, true, 8, n, n2);
        if (l2 == 0L) {
            SWT.error(2);
        }
        long l3 = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(l2, l, l3, 0, 0, 0, 0, n, n2);
        String string = "";
        if (transferData.type == (long)JPEG_ID) {
            string = "jpeg";
        }
        if (transferData.type == (long)PNG_ID) {
            string = "png";
        }
        if (transferData.type == (long)BMP_ID) {
            string = "bmp";
        }
        if (transferData.type == (long)EPS_ID) {
            string = "eps";
        }
        if (transferData.type == (long)PCX_ID) {
            string = "pcx";
        }
        if (transferData.type == (long)PPM_ID) {
            string = "ppm";
        }
        if (transferData.type == (long)RGB_ID) {
            string = "rgb";
        }
        if (transferData.type == (long)TGA_ID) {
            string = "tga";
        }
        if (transferData.type == (long)XBM_ID) {
            string = "xbm";
        }
        if (transferData.type == (long)XPM_ID) {
            string = "xpm";
        }
        if (transferData.type == (long)XV_ID) {
            string = "xv";
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        if (byArray == null) {
            return;
        }
        OS.gdk_pixbuf_save_to_bufferv(l2, lArray, lArray2, byArray, null, null, null);
        OS.g_object_unref(l2);
        image.dispose();
        transferData.pValue = lArray[0];
        transferData.length = (int)(lArray2[0] + 3L) / 4 * 4;
        transferData.result = 1;
        transferData.format = 32;
    }

    public Object nativeToJava(TransferData transferData) {
        ImageData imageData = null;
        if (transferData.length > 0) {
            long l = OS.gdk_pixbuf_loader_new();
            OS.gdk_pixbuf_loader_write(l, transferData.pValue, transferData.length, null);
            OS.gdk_pixbuf_loader_close(l, null);
            long l2 = OS.gdk_pixbuf_loader_get_pixbuf(l);
            if (l2 != 0L) {
                OS.g_object_ref(l2);
                long[] lArray = new long[1];
                OS.gdk_pixbuf_render_pixmap_and_mask(l2, lArray, null, 0);
                long l3 = lArray[0];
                if (l3 == 0L) {
                    SWT.error(2);
                }
                OS.g_object_unref(l);
                Image image = Image.gtk_new(Display.getCurrent(), 0, l3, 0L);
                imageData = image.getImageData();
                image.dispose();
            }
        }
        return imageData;
    }

    protected int[] getTypeIds() {
        return new int[]{PNG_ID, BMP_ID, EPS_ID, JPEG_ID, PCX_ID, PPM_ID, RGB_ID, TGA_ID, XBM_ID, XPM_ID, XV_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{PNG, BMP, EPS, JPEG, PCX, "image/ppm", "image/ppm", TGA, XBM, XPM, XV};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

