/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkCombo;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    int buttonHandle;
    int entryHandle;
    int listHandle;
    int textRenderer;
    int cellHandle;
    int popupHandle;
    int menuHandle;
    int lastEventTime;
    int visibleCount = 10;
    int gdkEventKey = 0;
    int fixStart = -1;
    int fixEnd = -1;
    String[] items = new String[0];
    boolean ignoreSelect;
    boolean lockText;
    boolean selectionAdded;
    int indexSelected;
    public static final int LIMIT = 65535;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.add(string, this.items.length);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index > this.items.length) {
            this.error(6);
        }
        String[] newItems = new String[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = string;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.gtk_combo_box_insert_text(this.handle, index, buffer);
            if ((this.style & 0x4000000) != 0 && this.popupHandle != 0) {
                OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2);
            }
        } else {
            this.lockText = true;
            this.ignoreSelect = true;
            int item = OS.gtk_list_item_new_with_label(buffer);
            int label = OS.gtk_bin_get_child(item);
            this.setForegroundColor(label, this.getForegroundColor());
            OS.gtk_widget_modify_font(label, this.getFontDescription());
            OS.gtk_widget_set_direction(label, OS.gtk_widget_get_direction(this.handle));
            OS.gtk_widget_show(item);
            int items = OS.g_list_append(0, item);
            OS.gtk_list_insert_items(this.listHandle, items, index);
            this.lockText = false;
            this.ignoreSelect = false;
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Combo.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            int position = OS.gtk_editable_get_position(this.entryHandle);
            OS.gtk_editable_select_region(this.entryHandle, position, position);
        }
    }

    void clearText() {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            if ((this.style & 8) != 0) {
                int index = OS.gtk_combo_box_get_active(this.handle);
                if (index != -1) {
                    int modelHandle = OS.gtk_combo_box_get_model(this.handle);
                    int[] ptr = new int[1];
                    int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
                    OS.gtk_tree_model_iter_nth_child(modelHandle, iter, 0, index);
                    OS.gtk_tree_model_get(modelHandle, iter, 0, ptr, -1);
                    OS.g_free(iter);
                    if (ptr[0] != 0 && OS.strlen(ptr[0]) > 0) {
                        this.postEvent(24);
                    }
                    OS.g_free(ptr[0]);
                }
            } else {
                OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            }
            OS.gtk_combo_box_set_active(this.handle, -1);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            return this.computeNativeSize(this.handle, wHint, hHint, changed);
        }
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gtk_widget_realize(this.entryHandle);
        int layout = OS.gtk_entry_get_layout(this.entryHandle);
        OS.pango_layout_get_size(layout, w, h);
        int xborder = 2;
        int yborder = 2;
        int style = OS.gtk_widget_get_style(this.entryHandle);
        xborder += OS.gtk_style_get_xthickness(style);
        yborder += OS.gtk_style_get_ythickness(style);
        int[] property = new int[1];
        OS.gtk_widget_style_get(this.entryHandle, OS.interior_focus, property, 0);
        if (property[0] == 0) {
            OS.gtk_widget_style_get(this.entryHandle, OS.focus_line_width, property, 0);
            xborder += property[0];
            yborder += property[0];
        }
        int width = OS.PANGO_PIXELS(w[0]) + xborder * 2;
        int height = OS.PANGO_PIXELS(h[0]) + yborder * 2;
        GtkRequisition arrowRequesition = new GtkRequisition();
        OS.gtk_widget_size_request(this.buttonHandle, arrowRequesition);
        GtkRequisition listRequesition = new GtkRequisition();
        int listParent = OS.gtk_widget_get_parent(this.listHandle);
        OS.gtk_widget_size_request(listParent != 0 ? listParent : this.listHandle, listRequesition);
        width = Math.max(listRequesition.width, width) + arrowRequesition.width + 4;
        width = wHint == -1 ? width : wHint;
        height = hHint == -1 ? height : hHint;
        return new Point(width, height);
    }

    public void copy() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            OS.gtk_editable_copy_clipboard(this.entryHandle);
        }
    }

    void createHandle(int index) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            int oldList = OS.gtk_window_list_toplevels();
            if ((this.style & 8) != 0) {
                this.handle = OS.gtk_combo_box_new_text();
                if (this.handle == 0) {
                    this.error(2);
                }
                this.cellHandle = OS.gtk_bin_get_child(this.handle);
                if (this.cellHandle == 0) {
                    this.error(2);
                }
            } else {
                this.handle = OS.gtk_combo_box_entry_new_text();
                if (this.handle == 0) {
                    this.error(2);
                }
                this.entryHandle = OS.gtk_bin_get_child(this.handle);
                if (this.entryHandle == 0) {
                    this.error(2);
                }
            }
            this.popupHandle = this.findPopupHandle(oldList);
            OS.gtk_container_add(this.fixedHandle, this.handle);
            this.textRenderer = OS.gtk_cell_renderer_text_new();
            if (this.textRenderer == 0) {
                this.error(2);
            }
            int pad = 0;
            if (OS.GTK_VERSION < OS.VERSION(2, 6, 0)) {
                pad = 1;
            }
            OS.g_object_set(this.textRenderer, OS.ypad, pad, 0);
            boolean warnings = this.display.getWarnings();
            this.display.setWarnings(false);
            OS.gtk_cell_layout_clear(this.handle);
            this.display.setWarnings(warnings);
            OS.gtk_cell_layout_pack_start(this.handle, this.textRenderer, true);
            OS.gtk_cell_layout_set_attributes(this.handle, this.textRenderer, OS.text, 0, 0);
            if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
                OS.gtk_widget_size_request(this.handle, new GtkRequisition());
            }
            if (this.popupHandle != 0) {
                this.findMenuHandle();
            }
            this.findButtonHandle();
            if ((this.style & 8) != 0 && this.buttonHandle != 0) {
                OS.GTK_WIDGET_UNSET_FLAGS(this.buttonHandle, 0x100000);
            }
        } else {
            int list;
            this.handle = OS.gtk_combo_new();
            if (this.handle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.handle);
            GtkCombo combo = new GtkCombo();
            OS.memmove(combo, this.handle);
            this.entryHandle = combo.entry;
            this.listHandle = combo.list;
            if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
                int modalGroup;
                int parentHandle = 0;
                int temp = this.listHandle;
                while ((temp = OS.gtk_widget_get_parent(temp)) != 0) {
                    parentHandle = temp;
                }
                this.popupHandle = parentHandle;
                if (this.popupHandle != 0 && (modalGroup = this.getShell().modalGroup) != 0) {
                    OS.gtk_window_group_add_window(modalGroup, this.popupHandle);
                }
            }
            if ((list = OS.gtk_container_get_children(this.handle)) != 0) {
                int i = 0;
                int count = OS.g_list_length(list);
                while (i < count) {
                    int childHandle = OS.g_list_nth_data(list, i);
                    if (childHandle != this.entryHandle && childHandle != this.listHandle) {
                        this.buttonHandle = childHandle;
                        break;
                    }
                    ++i;
                }
                OS.g_list_free(list);
            }
            boolean editable = (this.style & 8) == 0;
            OS.gtk_editable_set_editable(this.entryHandle, editable);
            OS.gtk_combo_disable_activate(this.handle);
            OS.gtk_combo_set_case_sensitive(this.handle, true);
        }
    }

    public void cut() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            OS.gtk_editable_cut_clipboard(this.entryHandle);
        }
    }

    void deregister() {
        int imContext;
        super.deregister();
        if (this.buttonHandle != 0) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.entryHandle != 0) {
            this.display.removeWidget(this.entryHandle);
        }
        if (this.listHandle != 0) {
            this.display.removeWidget(this.listHandle);
        }
        if (this.popupHandle != 0) {
            this.display.removeWidget(this.popupHandle);
        }
        if (this.menuHandle != 0) {
            this.display.removeWidget(this.menuHandle);
        }
        if ((imContext = this.imContext()) != 0) {
            this.display.removeWidget(imContext);
        }
    }

    boolean filterKey(int keyval, int event) {
        int time = OS.gdk_event_get_time(event);
        if (time != this.lastEventTime) {
            this.lastEventTime = time;
            int imContext = this.imContext();
            if (imContext != 0) {
                return OS.gtk_im_context_filter_keypress(imContext, event);
            }
        }
        this.gdkEventKey = event;
        return false;
    }

    int findPopupHandle(int oldList) {
        int hdl = 0;
        int currentList = OS.gtk_window_list_toplevels();
        int oldFromList = oldList;
        int newFromList = currentList;
        while (newFromList != 0) {
            int newToplevel = OS.g_list_data(newFromList);
            boolean isFound = false;
            oldFromList = oldList;
            while (oldFromList != 0) {
                int oldToplevel = OS.g_list_data(oldFromList);
                if (newToplevel == oldToplevel) {
                    isFound = true;
                    break;
                }
                oldFromList = OS.g_list_next(oldFromList);
            }
            if (!isFound) {
                hdl = newToplevel;
                break;
            }
            newFromList = OS.g_list_next(newFromList);
        }
        OS.g_list_free(oldList);
        OS.g_list_free(currentList);
        return hdl;
    }

    void findButtonHandle() {
        OS.gtk_container_forall(this.handle, this.display.allChildrenProc, 0);
        if (this.display.allChildren != 0) {
            int list = this.display.allChildren;
            while (list != 0) {
                int widget = OS.g_list_data(list);
                if (OS.GTK_IS_BUTTON(widget)) {
                    this.buttonHandle = widget;
                    break;
                }
                list = OS.g_list_next(list);
            }
            OS.g_list_free(this.display.allChildren);
            this.display.allChildren = 0;
        }
    }

    void findMenuHandle() {
        OS.gtk_container_forall(this.popupHandle, this.display.allChildrenProc, 0);
        if (this.display.allChildren != 0) {
            int list = this.display.allChildren;
            while (list != 0) {
                int widget = OS.g_list_data(list);
                if (OS.G_OBJECT_TYPE(widget) == OS.GTK_TYPE_MENU()) {
                    this.menuHandle = widget;
                    break;
                }
                list = OS.g_list_next(list);
            }
            OS.g_list_free(this.display.allChildren);
            this.display.allChildren = 0;
        }
    }

    void fixModal(int group, int modalGroup) {
        if (this.popupHandle != 0) {
            if (group != 0) {
                OS.gtk_window_group_add_window(group, this.popupHandle);
            } else if (modalGroup != 0) {
                OS.gtk_window_group_remove_window(modalGroup, this.popupHandle);
            }
        }
    }

    void fixIM() {
        int imContext;
        if (this.gdkEventKey != 0 && this.gdkEventKey != -1 && (imContext = this.imContext()) != 0) {
            OS.gtk_im_context_filter_keypress(imContext, this.gdkEventKey);
            this.gdkEventKey = -1;
            return;
        }
        this.gdkEventKey = 0;
    }

    int fontHandle() {
        if (this.entryHandle != 0) {
            return this.entryHandle;
        }
        return super.fontHandle();
    }

    int focusHandle() {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && (this.style & 8) != 0 && this.buttonHandle != 0) {
            return this.buttonHandle;
        }
        if (this.entryHandle != 0) {
            return this.entryHandle;
        }
        return super.focusHandle();
    }

    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        if (this.entryHandle != 0 && OS.GTK_WIDGET_HAS_FOCUS(this.entryHandle)) {
            return true;
        }
        return this.listHandle != 0 && OS.GTK_WIDGET_HAS_FOCUS(this.listHandle);
    }

    void hookEvents() {
        super.hookEvents();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_connect_closure(this.handle, OS.changed, this.display.closures[6], true);
        }
        if (this.entryHandle != 0) {
            OS.g_signal_connect_closure(this.entryHandle, OS.changed, this.display.closures[6], true);
            OS.g_signal_connect_closure(this.entryHandle, OS.insert_text, this.display.closures[26], false);
            OS.g_signal_connect_closure(this.entryHandle, OS.delete_text, this.display.closures[13], false);
            OS.g_signal_connect_closure(this.entryHandle, OS.activate, this.display.closures[1], false);
            OS.g_signal_connect_closure(this.entryHandle, OS.populate_popup, this.display.closures[37], false);
        }
        int eventMask = 772;
        int[] handles = new int[]{this.buttonHandle, this.entryHandle, this.listHandle, this.menuHandle};
        int i = 0;
        while (i < handles.length) {
            int eventHandle = handles[i];
            if (eventHandle != 0) {
                OS.gtk_widget_add_events(eventHandle, eventMask);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[2], 0, this.display.closures[2], false);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[4], 0, this.display.closures[4], false);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[33], 0, this.display.closures[33], false);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[2], 0, this.display.closures[3], true);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[4], 0, this.display.closures[5], true);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[33], 0, this.display.closures[34], true);
                if (eventHandle != this.focusHandle()) {
                    OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[16], 0, this.display.closures[16], false);
                }
            }
            ++i;
        }
        int imContext = this.imContext();
        if (imContext != 0) {
            OS.g_signal_connect_closure(imContext, OS.commit, this.display.closures[9], false);
            int id = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int blockMask = 17;
            OS.g_signal_handlers_block_matched(imContext, blockMask, id, 0, 0, 0, this.entryHandle);
        }
        if (this.menuHandle != 0) {
            OS.g_signal_connect_closure(this.menuHandle, OS.selection_done, this.display.closures[68], true);
        }
    }

    int imContext() {
        return this.entryHandle != 0 ? OS.GTK_ENTRY_IM_CONTEXT(this.entryHandle) : 0;
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (OS.gtk_combo_box_get_active(this.handle) == index) {
                this.clearText();
            }
        } else {
            boolean selected;
            this.ignoreSelect = true;
            int children = OS.gtk_container_get_children(this.listHandle);
            int item = OS.g_list_nth_data(children, index);
            boolean bl = selected = OS.GTK_WIDGET_STATE(item) == 3;
            if (selected) {
                OS.gtk_list_unselect_all(this.listHandle);
                OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            }
            OS.g_list_free(children);
            this.ignoreSelect = false;
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.clearText();
        } else {
            this.ignoreSelect = true;
            OS.gtk_list_unselect_all(this.listHandle);
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            this.ignoreSelect = false;
        }
    }

    boolean dragDetect(int x, int y, boolean filter, boolean[] consume) {
        if (filter && this.entryHandle != 0) {
            int[] index = new int[1];
            int[] trailing = new int[1];
            int layout = OS.gtk_entry_get_layout(this.entryHandle);
            OS.pango_layout_xy_to_index(layout, x * 1024, y * 1024, index, trailing);
            int ptr = OS.pango_layout_get_text(layout);
            int position = OS.g_utf8_pointer_to_offset(ptr, ptr + index[0]) + trailing[0];
            Point selection = this.getSelection();
            if (selection.x <= position && position < selection.y && super.dragDetect(x, y, filter, consume)) {
                if (consume != null) {
                    consume[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(x, y, filter, consume);
    }

    int enterExitHandle() {
        return this.fixedHandle;
    }

    int eventWindow() {
        return this.paintWindow();
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public String getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.listHandle != 0 ? this.listHandle : this.handle);
    }

    public String[] getItems() {
        this.checkWidget();
        String[] result = new String[this.items.length];
        System.arraycopy(this.items, 0, result, 0, this.items.length);
        return result;
    }

    public boolean getListVisible() {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            return this.popupHandle != 0 && OS.GTK_WIDGET_VISIBLE(this.popupHandle);
        }
        return false;
    }

    String getNameText() {
        return this.getText();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            int length = 0;
            if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
                int index = OS.gtk_combo_box_get_active(this.handle);
                if (index != -1) {
                    length = this.getItem(index).length();
                }
            } else {
                int str = OS.gtk_entry_get_text(this.entryHandle);
                if (str != 0) {
                    length = OS.g_utf8_strlen(str, -1);
                }
            }
            return new Point(0, length);
        }
        int[] start = new int[1];
        int[] end = new int[1];
        if (this.entryHandle != 0) {
            OS.gtk_editable_get_selection_bounds(this.entryHandle, start, end);
        }
        return new Point(start[0], end[0]);
    }

    public int getSelectionIndex() {
        int children;
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            return OS.gtk_combo_box_get_active(this.handle);
        }
        int index = 0;
        int result = -1;
        int temp = children = OS.gtk_container_get_children(this.listHandle);
        while (temp != 0) {
            int item = OS.g_list_data(temp);
            if (OS.GTK_WIDGET_STATE(item) == 3) {
                result = index;
                break;
            }
            ++index;
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(children);
        return result;
    }

    public String getText() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            int str = OS.gtk_entry_get_text(this.entryHandle);
            if (str == 0) {
                return "";
            }
            int length = OS.strlen(str);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, str, length);
            return new String(Converter.mbcsToWcs(null, buffer));
        }
        int index = OS.gtk_combo_box_get_active(this.handle);
        return index != -1 ? this.getItem(index) : "";
    }

    String getText(int start, int stop) {
        return this.getText().substring(start, stop - 1);
    }

    public int getTextHeight() {
        this.checkWidget();
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_size_request(this.handle, requisition);
        return OS.GTK_WIDGET_REQUISITION_HEIGHT(this.handle);
    }

    public int getTextLimit() {
        this.checkWidget();
        int limit = this.entryHandle != 0 ? OS.gtk_entry_get_max_length(this.entryHandle) : 0;
        return limit == 0 ? LIMIT : limit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    int gtk_activate(int widget) {
        this.sendSelectionEvent(14);
        return 0;
    }

    int gtk_button_press_event(int widget, int event) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            GdkEventButton gdkEvent = new GdkEventButton();
            OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
            if (gdkEvent.type == 4 && gdkEvent.button == 1) {
                return this.gtk_button_press_event(widget, event, false);
            }
        }
        return super.gtk_button_press_event(widget, event);
    }

    int gtk_changed(int widget) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (widget == this.handle) {
                int index;
                if (this.entryHandle == 0) {
                    this.sendEvent(24);
                    if (this.isDisposed()) {
                        return 0;
                    }
                }
                if ((index = OS.gtk_combo_box_get_active(this.handle)) != -1) {
                    this.sendSelectionEvent(13);
                }
                this.indexSelected = -1;
                return 0;
            }
        } else if (!this.ignoreSelect) {
            int ptr = OS.gtk_entry_get_text(this.entryHandle);
            int length = OS.strlen(ptr);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, ptr, length);
            String text = new String(Converter.mbcsToWcs(null, buffer));
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i].equals(text)) {
                    this.sendSelectionEvent(13);
                    break;
                }
                ++i;
            }
        }
        boolean keyPress = false;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    keyPress = true;
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        if (keyPress) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0;
    }

    int gtk_commit(int imContext, int text) {
        if (text == 0) {
            return 0;
        }
        if (!OS.gtk_editable_get_editable(this.entryHandle)) {
            return 0;
        }
        int length = OS.strlen(text);
        if (length == 0) {
            return 0;
        }
        byte[] buffer = new byte[length];
        OS.memmove(buffer, text, length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        char[] newChars = this.sendIMKeyEvent(1, null, chars);
        if (newChars == null) {
            return 0;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(imContext, 16, 0, 0, 0, 0, 9);
        int id = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched(imContext, mask, id, 0, 0, 0, this.entryHandle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name(imContext, OS.commit, text);
        } else {
            buffer = Converter.wcsToMbcs(null, newChars, true);
            OS.g_signal_emit_by_name(imContext, OS.commit, buffer);
        }
        OS.g_signal_handlers_unblock_matched(imContext, 16, 0, 0, 0, 0, 9);
        OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0, 0, this.entryHandle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            OS.gtk_editable_set_position(this.entryHandle, this.fixStart);
            OS.gtk_editable_select_region(this.entryHandle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0;
    }

    int gtk_delete_text(int widget, int start_pos, int end_pos) {
        String newText;
        if (this.lockText) {
            OS.gtk_list_unselect_item(this.listHandle, 0);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
            return 0;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        if (end_pos == -1) {
            end_pos = OS.g_utf8_strlen(OS.gtk_entry_get_text(this.entryHandle), -1);
        }
        if ((newText = this.verifyText("", start_pos, end_pos)) == null) {
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
        } else if (newText.length() > 0) {
            int[] pos = new int[]{end_pos};
            byte[] buffer = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
            OS.gtk_editable_insert_text(this.entryHandle, buffer, buffer.length, pos);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
            OS.gtk_editable_set_position(this.entryHandle, pos[0]);
        }
        return 0;
    }

    int gtk_event_after(int widget, int gdkEvent) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            GdkEvent event = new GdkEvent();
            OS.memmove(event, gdkEvent, GdkEvent.sizeof);
            switch (event.type) {
                case 4: {
                    int grabHandle;
                    if (OS.GTK_VERSION < OS.VERSION(2, 8, 0) && !this.selectionAdded && (grabHandle = OS.gtk_grab_get_current()) != 0 && OS.G_OBJECT_TYPE(grabHandle) == OS.GTK_TYPE_MENU()) {
                        this.menuHandle = grabHandle;
                        OS.g_signal_connect_closure_by_id(this.menuHandle, this.display.signalIds[4], 0, this.display.closures[4], false);
                        OS.g_signal_connect_closure_by_id(this.menuHandle, this.display.signalIds[4], 0, this.display.closures[5], true);
                        OS.g_signal_connect_closure(this.menuHandle, OS.selection_done, this.display.closures[68], false);
                        this.display.addWidget(this.menuHandle, this);
                        this.selectionAdded = true;
                    }
                    GdkEventButton gdkEventButton = new GdkEventButton();
                    OS.memmove(gdkEventButton, gdkEvent, GdkEventButton.sizeof);
                    if (gdkEventButton.button != 1) break;
                    if (!this.sendMouseEvent(3, gdkEventButton.button, this.display.clickCount, 0, false, gdkEventButton.time, gdkEventButton.x_root, gdkEventButton.y_root, false, gdkEventButton.state)) {
                        return 1;
                    }
                    if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) || (this.style & 8) != 0 || widget != this.buttonHandle) break;
                    OS.gtk_widget_grab_focus(this.entryHandle);
                    break;
                }
                case 12: {
                    if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) || (this.style & 8) != 0) break;
                    GdkEventFocus gdkEventFocus = new GdkEventFocus();
                    OS.memmove(gdkEventFocus, gdkEvent, GdkEventFocus.sizeof);
                    if (gdkEventFocus.in != 0) {
                        OS.gtk_combo_box_set_focus_on_click(this.handle, false);
                        break;
                    }
                    OS.gtk_combo_box_set_focus_on_click(this.handle, true);
                }
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    int gtk_focus_out_event(int widget, int event) {
        this.fixIM();
        return super.gtk_focus_out_event(widget, event);
    }

    int gtk_insert_text(int widget, int new_text, int new_text_length, int position) {
        String newText;
        if (this.lockText) {
            OS.gtk_list_unselect_item(this.listHandle, 0);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
            return 0;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        if (new_text == 0 || new_text_length == 0) {
            return 0;
        }
        byte[] buffer = new byte[new_text_length];
        OS.memmove(buffer, new_text, buffer.length);
        String oldText = new String(Converter.mbcsToWcs(null, buffer));
        int[] pos = new int[1];
        OS.memmove(pos, position, 4);
        if (pos[0] == -1) {
            int ptr = OS.gtk_entry_get_text(this.entryHandle);
            pos[0] = OS.g_utf8_strlen(ptr, -1);
        }
        if ((newText = this.verifyText(oldText, pos[0], pos[0])) != oldText) {
            int[] newStart = new int[1];
            int[] newEnd = new int[1];
            OS.gtk_editable_get_selection_bounds(this.entryHandle, newStart, newEnd);
            if (newText != null) {
                if (newStart[0] != newEnd[0]) {
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
                    OS.gtk_editable_delete_selection(this.entryHandle);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
                }
                byte[] buffer3 = Converter.wcsToMbcs(null, newText, false);
                OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
                OS.gtk_editable_insert_text(this.entryHandle, buffer3, buffer3.length, pos);
                OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
                newStart[0] = newEnd[0] = pos[0];
            }
            pos[0] = newEnd[0];
            if (newStart[0] != newEnd[0]) {
                this.fixStart = newStart[0];
                this.fixEnd = newEnd[0];
            }
            OS.memmove(position, pos, 4);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
        }
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        int result = super.gtk_key_press_event(widget, event);
        if (result != 0) {
            this.gdkEventKey = 0;
            this.fixIM();
            return result;
        }
        if (this.gdkEventKey == -1) {
            result = 1;
        }
        this.gdkEventKey = 0;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && (this.style & 8) == 0) {
            int oldIndex;
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, event, GdkEventKey.sizeof);
            int newIndex = oldIndex = OS.gtk_combo_box_get_active(this.handle);
            int key = keyEvent.keyval;
            switch (key) {
                case 65364: 
                case 65433: {
                    if (oldIndex == this.items.length - 1) break;
                    newIndex = oldIndex + 1;
                    break;
                }
                case 65362: 
                case 65431: {
                    if (oldIndex == -1 || oldIndex == 0) break;
                    newIndex = oldIndex - 1;
                    break;
                }
                case 65365: 
                case 65434: {
                    newIndex = 0;
                    break;
                }
                case 65366: 
                case 65435: {
                    newIndex = this.items.length - 1;
                }
            }
            if (newIndex != oldIndex) {
                OS.gtk_combo_box_set_active(this.handle, newIndex);
                return 1;
            }
        }
        return result;
    }

    int gtk_populate_popup(int widget, int menu) {
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(menu, 2);
            OS.gtk_container_forall(menu, this.display.setDirectionProc, 2);
        }
        return 0;
    }

    int gtk_selection_done(int menushell) {
        int index = OS.gtk_combo_box_get_active(this.handle);
        if (this.indexSelected == -1) {
            this.indexSelected = index;
        } else if (index != -1 && this.indexSelected == index) {
            this.sendSelectionEvent(13);
        }
        return 0;
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (start < 0 || start >= this.items.length) {
            return -1;
        }
        int i = start;
        while (i < this.items.length) {
            if (string.equals(this.items[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    boolean isFocusHandle(int widget) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.buttonHandle != 0 && widget == this.buttonHandle) {
                return true;
            }
            if (this.entryHandle != 0 && widget == this.entryHandle) {
                return true;
            }
        }
        return super.isFocusHandle(widget);
    }

    int paintWindow() {
        int childHandle = this.entryHandle != 0 ? this.entryHandle : this.handle;
        OS.gtk_widget_realize(childHandle);
        int window = OS.GTK_WIDGET_WINDOW(childHandle);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && (this.style & 8) != 0) {
            return window;
        }
        int children = OS.gdk_window_get_children(window);
        if (children != 0) {
            window = OS.g_list_data(children);
        }
        OS.g_list_free(children);
        return window;
    }

    public void paste() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            OS.gtk_editable_paste_clipboard(this.entryHandle);
        }
    }

    int parentingHandle() {
        return this.fixedHandle;
    }

    void register() {
        int imContext;
        super.register();
        if (this.buttonHandle != 0) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.entryHandle != 0) {
            this.display.addWidget(this.entryHandle, this);
        }
        if (this.listHandle != 0) {
            this.display.addWidget(this.listHandle, this);
        }
        if (this.popupHandle != 0) {
            this.display.addWidget(this.popupHandle, this);
        }
        if (this.menuHandle != 0) {
            this.display.addWidget(this.menuHandle, this);
        }
        if ((imContext = this.imContext()) != 0) {
            this.display.addWidget(imContext, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.listHandle = 0;
        this.entryHandle = 0;
        this.buttonHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.textRenderer = 0;
        this.fixIM();
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            this.error(6);
        }
        String[] oldItems = this.items;
        String[] newItems = new String[oldItems.length - 1];
        System.arraycopy(oldItems, 0, newItems, 0, index);
        System.arraycopy(oldItems, index + 1, newItems, index, oldItems.length - index - 1);
        this.items = newItems;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (OS.gtk_combo_box_get_active(this.handle) == index) {
                this.clearText();
            }
            OS.gtk_combo_box_remove_text(this.handle, index);
        } else {
            this.ignoreSelect = true;
            int children = OS.gtk_container_get_children(this.listHandle);
            int item = OS.g_list_nth_data(children, index);
            boolean selected = OS.GTK_WIDGET_STATE(item) == 3;
            int items = OS.g_list_append(0, item);
            OS.gtk_list_remove_items(this.listHandle, items);
            OS.g_list_free(items);
            OS.g_list_free(children);
            if (selected) {
                OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            }
            this.ignoreSelect = false;
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.items.length) {
            this.error(6);
        }
        String[] oldItems = this.items;
        String[] newItems = new String[oldItems.length - (end - start + 1)];
        System.arraycopy(oldItems, 0, newItems, 0, start);
        System.arraycopy(oldItems, end + 1, newItems, start, oldItems.length - end - 1);
        this.items = newItems;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            int index = OS.gtk_combo_box_get_active(this.handle);
            if (start <= index && index <= end) {
                this.clearText();
            }
            int i = end;
            while (i >= start) {
                OS.gtk_combo_box_remove_text(this.handle, i);
                --i;
            }
        } else {
            boolean selected = false;
            this.ignoreSelect = true;
            int items = 0;
            int children = OS.gtk_container_get_children(this.listHandle);
            int i = start;
            while (i <= end) {
                int item = OS.g_list_nth_data(children, i);
                selected |= OS.GTK_WIDGET_STATE(item) == 3;
                items = OS.g_list_append(items, item);
                ++i;
            }
            OS.gtk_list_remove_items(this.listHandle, items);
            OS.g_list_free(items);
            OS.g_list_free(children);
            if (selected) {
                OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            }
            this.ignoreSelect = false;
        }
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        int count = this.items.length;
        this.items = new String[0];
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.clearText();
            int i = count - 1;
            while (i >= 0) {
                OS.gtk_combo_box_remove_text(this.handle, i);
                --i;
            }
        } else {
            this.ignoreSelect = true;
            OS.gtk_list_clear_items(this.listHandle, 0, -1);
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            this.ignoreSelect = false;
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.gtk_combo_box_set_active(this.handle, index);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            if ((this.style & 8) != 0) {
                this.sendEvent(24);
            }
        } else {
            this.ignoreSelect = true;
            OS.gtk_list_select_item(this.listHandle, index);
            this.ignoreSelect = false;
        }
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.entryHandle != 0) {
                OS.gtk_widget_modify_base(this.entryHandle, 0, color);
            }
            if (this.cellHandle != 0) {
                OS.g_object_set(this.cellHandle, OS.background_gdk, color, 0);
            }
            OS.g_object_set(this.textRenderer, OS.background_gdk, color, 0);
        } else {
            OS.gtk_widget_modify_base(this.entryHandle, 0, color);
            if (this.listHandle != 0) {
                OS.gtk_widget_modify_base(this.listHandle, 0, color);
            }
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int newHeight = height;
        if (resize) {
            newHeight = Math.max(this.getTextHeight(), height);
        }
        return super.setBounds(x, y, width, newHeight, move, resize);
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.entryHandle != 0) {
                OS.gtk_widget_modify_font(this.entryHandle, font);
            }
            OS.g_object_set(this.textRenderer, OS.font_desc, font, 0);
            if ((this.style & 8) != 0) {
                int index = OS.gtk_combo_box_get_active(this.handle);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
                OS.gtk_combo_box_set_active(this.handle, -1);
                OS.gtk_combo_box_set_active(this.handle, index);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            }
        } else {
            OS.gtk_widget_modify_font(this.entryHandle, font);
            if (this.listHandle != 0) {
                OS.gtk_widget_modify_font(this.listHandle, font);
                int itemsList = OS.gtk_container_get_children(this.listHandle);
                if (itemsList != 0) {
                    int count = OS.g_list_length(itemsList);
                    int i = count - 1;
                    while (i >= 0) {
                        int widget = OS.gtk_bin_get_child(OS.g_list_nth_data(itemsList, i));
                        OS.gtk_widget_modify_font(widget, font);
                        --i;
                    }
                    OS.g_list_free(itemsList);
                }
            }
        }
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.entryHandle != 0) {
                this.setForegroundColor(this.entryHandle, color);
            }
            OS.g_object_set(this.textRenderer, OS.foreground_gdk, color, 0);
        } else {
            this.setForegroundColor(this.entryHandle, color);
            if (this.listHandle != 0) {
                this.setForegroundColor(this.listHandle, color);
                int itemsList = OS.gtk_container_get_children(this.listHandle);
                if (itemsList != 0) {
                    int count = OS.g_list_length(itemsList);
                    int i = count - 1;
                    while (i >= 0) {
                        int widget = OS.gtk_bin_get_child(OS.g_list_nth_data(itemsList, i));
                        this.setForegroundColor(widget, color);
                        --i;
                    }
                    OS.g_list_free(itemsList);
                }
            }
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index >= this.items.length) {
            this.error(5);
        }
        this.items[index] = string;
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.gtk_combo_box_remove_text(this.handle, index);
            OS.gtk_combo_box_insert_text(this.handle, index, buffer);
            if ((this.style & 0x4000000) != 0 && this.popupHandle != 0) {
                OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2);
            }
        } else {
            this.ignoreSelect = true;
            int children = OS.gtk_container_get_children(this.listHandle);
            int item = OS.g_list_nth_data(children, index);
            int label = OS.gtk_bin_get_child(item);
            OS.gtk_label_set_text(label, buffer);
            OS.g_list_free(children);
            this.ignoreSelect = false;
        }
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        int count = this.items.length;
        this.items = new String[items.length];
        System.arraycopy(items, 0, this.items, 0, items.length);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.clearText();
            int i2 = count - 1;
            while (i2 >= 0) {
                OS.gtk_combo_box_remove_text(this.handle, i2);
                --i2;
            }
            i2 = 0;
            while (i2 < items.length) {
                String string = items[i2];
                byte[] buffer = Converter.wcsToMbcs(null, string, true);
                OS.gtk_combo_box_insert_text(this.handle, i2, buffer);
                if ((this.style & 0x4000000) != 0 && this.popupHandle != 0) {
                    OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2);
                }
                ++i2;
            }
        } else {
            this.ignoreSelect = true;
            this.lockText = true;
            OS.gtk_list_clear_items(this.listHandle, 0, -1);
            int font = this.getFontDescription();
            GdkColor color = this.getForegroundColor();
            int direction = OS.gtk_widget_get_direction(this.handle);
            int i3 = 0;
            while (i3 < items.length) {
                String string = items[i3];
                byte[] buffer = Converter.wcsToMbcs(null, string, true);
                int item = OS.gtk_list_item_new_with_label(buffer);
                int label = OS.gtk_bin_get_child(item);
                this.setForegroundColor(label, color);
                OS.gtk_widget_modify_font(label, font);
                OS.gtk_widget_set_direction(label, direction);
                OS.gtk_container_add(this.listHandle, item);
                OS.gtk_widget_show(item);
                ++i3;
            }
            this.ignoreSelect = false;
            this.lockText = false;
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
        }
    }

    public void setListVisible(boolean visible) {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (visible) {
                OS.gtk_combo_box_popup(this.handle);
            } else {
                OS.gtk_combo_box_popdown(this.handle);
            }
        }
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.style & 0x4000000) != 0) {
            if (this.listHandle != 0) {
                OS.gtk_widget_set_direction(this.listHandle, 2);
            }
            if (this.entryHandle != 0) {
                OS.gtk_widget_set_direction(this.entryHandle, 2);
            }
            if (this.cellHandle != 0) {
                OS.gtk_widget_set_direction(this.cellHandle, 2);
            }
        }
    }

    public void setOrientation(int orientation) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.checkWidget();
            int flags = 0x6000000;
            if ((orientation & flags) == 0 || (orientation & flags) == flags) {
                return;
            }
            this.style &= ~flags;
            this.style |= orientation & flags;
            int dir = (orientation & 0x4000000) != 0 ? 2 : 1;
            OS.gtk_widget_set_direction(this.fixedHandle, dir);
            OS.gtk_widget_set_direction(this.handle, dir);
            if (this.entryHandle != 0) {
                OS.gtk_widget_set_direction(this.entryHandle, dir);
            }
            if (this.listHandle != 0) {
                OS.gtk_widget_set_direction(this.listHandle, dir);
                int itemsList = OS.gtk_container_get_children(this.listHandle);
                if (itemsList != 0) {
                    int count = OS.g_list_length(itemsList);
                    int i = count - 1;
                    while (i >= 0) {
                        int widget = OS.gtk_bin_get_child(OS.g_list_nth_data(itemsList, i));
                        OS.gtk_widget_set_direction(widget, dir);
                        --i;
                    }
                    OS.g_list_free(itemsList);
                }
            }
            if (this.cellHandle != 0) {
                OS.gtk_widget_set_direction(this.cellHandle, dir);
            }
            if (this.popupHandle != 0) {
                OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, dir);
            }
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            return;
        }
        if (this.entryHandle != 0) {
            OS.gtk_editable_set_position(this.entryHandle, selection.x);
            OS.gtk_editable_select_region(this.entryHandle, selection.x, selection.y);
        }
    }

    public void setText(String string) {
        int ptr;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index == -1) {
                return;
            }
            if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
                OS.gtk_combo_box_set_active(this.handle, index);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
                this.sendEvent(24);
                return;
            }
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, OS.g_utf8_strlen(ptr = OS.gtk_entry_get_text(this.entryHandle), -1))) == null) {
            return;
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
        }
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 13);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
        OS.gtk_entry_set_text(this.entryHandle, buffer);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
        }
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 13);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
        this.sendEvent(24);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if (this.entryHandle != 0) {
            OS.gtk_entry_set_max_length(this.entryHandle, limit);
        }
    }

    void setToolTipText(Shell shell, String newString) {
        if (this.entryHandle != 0) {
            shell.setToolTipText(this.entryHandle, newString);
        }
        if (this.buttonHandle != 0) {
            shell.setToolTipText(this.buttonHandle, newString);
        }
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.visibleCount = count;
    }

    boolean checkSubwindow() {
        return false;
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int key = keyEvent.keyval;
        switch (key) {
            case 65293: 
            case 65421: {
                int imContext = this.imContext();
                if (imContext == 0) break;
                int[] preeditString = new int[1];
                OS.gtk_im_context_get_preedit_string(imContext, preeditString, null, null);
                if (preeditString[0] == 0) break;
                int length = OS.strlen(preeditString[0]);
                OS.g_free(preeditString[0]);
                if (length == 0) break;
                return false;
            }
        }
        return super.translateTraversal(keyEvent);
    }

    String verifyText(String string, int start, int end) {
        if (string.length() == 0 && start == end) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    this.setKeyState(event, gdkEvent);
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

