/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation
 *******************************************************************************/

#ifdef NATIVE_STATS
extern int C_nativeFunctionCount;
extern int C_nativeFunctionCallCount[];
extern char* C_nativeFunctionNames[];
#define C_NATIVE_ENTER(env, that, func) C_nativeFunctionCallCount[func]++;
#define C_NATIVE_EXIT(env, that, func) 
#else
#ifndef C_NATIVE_ENTER
#define C_NATIVE_ENTER(env, that, func) 
#endif
#ifndef C_NATIVE_EXIT
#define C_NATIVE_EXIT(env, that, func) 
#endif
#endif

typedef enum {
	PTR_1sizeof_FUNC,
	free_FUNC,
	getenv_FUNC,
	malloc_FUNC,
	memmove__JJJ_FUNC,
	memmove__J_3BJ_FUNC,
	memmove__J_3CJ_FUNC,
	memmove__J_3DJ_FUNC,
	memmove__J_3FJ_FUNC,
	memmove__J_3IJ_FUNC,
	memmove__J_3JJ_FUNC,
	memmove__J_3SJ_FUNC,
	memmove___3BJJ_FUNC,
	memmove___3B_3CJ_FUNC,
	memmove___3CJJ_FUNC,
	memmove___3DJJ_FUNC,
	memmove___3FJJ_FUNC,
	memmove___3IJJ_FUNC,
	memmove___3I_3BJ_FUNC,
	memmove___3JJJ_FUNC,
	memmove___3SJJ_FUNC,
	memset_FUNC,
	strlen_FUNC,
} C_FUNCS;
