/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    public int handle;
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int HANDLE = 8;
    static final int DISABLED = 16;
    static final int MENU = 32;
    static final int OBSCURED = 64;
    static final int MOVED = 128;
    static final int RESIZED = 256;
    static final int ZERO_WIDTH = 512;
    static final int ZERO_HEIGHT = 1024;
    static final int HIDDEN = 2048;
    static final int FOREGROUND = 4096;
    static final int BACKGROUND = 8192;
    static final int FONT = 16384;
    static final int PARENT_BACKGROUND = 32768;
    static final int THEME_BACKGROUND = 65536;
    static final int LAYOUT_NEEDED = 131072;
    static final int LAYOUT_CHANGED = 262144;
    static final int LAYOUT_CHILD = 524288;
    static final int RELEASED = 0x100000;
    static final int DISPOSE_SENT = 0x200000;
    static final int FOREIGN_HANDLE = 0x400000;
    static final int DRAG_DETECT = 0x800000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int ACTIVATE = 1;
    static final int BUTTON_PRESS_EVENT = 2;
    static final int BUTTON_PRESS_EVENT_INVERSE = 3;
    static final int BUTTON_RELEASE_EVENT = 4;
    static final int BUTTON_RELEASE_EVENT_INVERSE = 5;
    static final int CHANGED = 6;
    static final int CHANGE_VALUE = 7;
    static final int CLICKED = 8;
    static final int COMMIT = 9;
    static final int CONFIGURE_EVENT = 10;
    static final int DELETE_EVENT = 11;
    static final int DELETE_RANGE = 12;
    static final int DELETE_TEXT = 13;
    static final int ENTER_NOTIFY_EVENT = 14;
    static final int EVENT = 15;
    static final int EVENT_AFTER = 16;
    static final int EXPAND_COLLAPSE_CURSOR_ROW = 17;
    static final int EXPOSE_EVENT = 18;
    static final int EXPOSE_EVENT_INVERSE = 19;
    static final int FOCUS = 20;
    static final int FOCUS_IN_EVENT = 21;
    static final int FOCUS_OUT_EVENT = 22;
    static final int GRAB_FOCUS = 23;
    static final int HIDE = 24;
    static final int INPUT = 25;
    static final int INSERT_TEXT = 26;
    static final int KEY_PRESS_EVENT = 27;
    static final int KEY_RELEASE_EVENT = 28;
    static final int LEAVE_NOTIFY_EVENT = 29;
    static final int MAP = 30;
    static final int MAP_EVENT = 31;
    static final int MNEMONIC_ACTIVATE = 32;
    static final int MOTION_NOTIFY_EVENT = 33;
    static final int MOTION_NOTIFY_EVENT_INVERSE = 34;
    static final int MOVE_FOCUS = 35;
    static final int OUTPUT = 36;
    static final int POPULATE_POPUP = 37;
    static final int POPUP_MENU = 38;
    static final int PREEDIT_CHANGED = 39;
    static final int REALIZE = 40;
    static final int ROW_ACTIVATED = 41;
    static final int SCROLL_CHILD = 42;
    static final int SCROLL_EVENT = 43;
    static final int SELECT = 44;
    static final int SHOW = 45;
    static final int SHOW_HELP = 46;
    static final int SIZE_ALLOCATE = 47;
    static final int STYLE_SET = 48;
    static final int SWITCH_PAGE = 49;
    static final int TEST_COLLAPSE_ROW = 50;
    static final int TEST_EXPAND_ROW = 51;
    static final int TEXT_BUFFER_INSERT_TEXT = 52;
    static final int TOGGLED = 53;
    static final int UNMAP = 54;
    static final int UNMAP_EVENT = 55;
    static final int UNREALIZE = 56;
    static final int VALUE_CHANGED = 57;
    static final int VISIBILITY_NOTIFY_EVENT = 58;
    static final int WINDOW_STATE_EVENT = 59;
    static final int ACTIVATE_INVERSE = 60;
    static final int DAY_SELECTED = 61;
    static final int MONTH_CHANGED = 62;
    static final int STATUS_ICON_POPUP_MENU = 63;
    static final int ROW_INSERTED = 64;
    static final int ROW_DELETED = 65;
    static final int DAY_SELECTED_DOUBLE_CLICK = 66;
    static final int LAST_SIGNAL = 67;

    Widget() {
    }

    public Widget(Widget widget, int n) {
        this.checkSubclass();
        this.checkParent(widget);
        this.style = n;
        this.display = widget.display;
    }

    void _addListener(int n, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    public void addListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(n, listener);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(disposeListener);
        this.addListener(12, typedListener);
    }

    int paintWindow() {
        return 0;
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    int cellDataProc(int n, int n2, int n3, int n4, int n5) {
        return 0;
    }

    void checkOpen() {
    }

    void checkOrientation(Widget widget) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && widget != null) {
            if ((widget.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((widget.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            this.style &= 0xFBFFFFFF;
            this.style |= 0x2000000;
        }
    }

    void checkParent(Widget widget) {
        if (widget == null) {
            this.error(4);
        }
        if (widget.isDisposed()) {
            this.error(5);
        }
        widget.checkWidget();
        widget.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void createHandle(int n) {
    }

    void createWidget(int n) {
        this.createHandle(n);
        this.setOrientation();
        this.hookEvents();
        this.register();
    }

    void deregister() {
        if (this.handle == 0) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.removeWidget(this.handle);
        }
    }

    void destroyWidget() {
        int n = this.topHandle();
        this.releaseHandle();
        if (n != 0 && (this.state & 8) != 0) {
            OS.gtk_widget_destroy(n);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void error(int n) {
        SWT.error(n);
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] objectArray = (Object[])this.data;
            int n = 1;
            while (n < objectArray.length) {
                if (string.equals(objectArray[n])) {
                    return objectArray[n + 1];
                }
                n += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    public Listener[] getListeners(int n) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(n);
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.length();
        while (--n > 0 && string.charAt(n) != '.') {
        }
        return string.substring(n + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    int gtk_activate(int n) {
        return 0;
    }

    int gtk_button_press_event(int n, int n2) {
        return 0;
    }

    int gtk_button_release_event(int n, int n2) {
        return 0;
    }

    int gtk_changed(int n) {
        return 0;
    }

    int gtk_change_value(int n, int n2, int n3, int n4) {
        return 0;
    }

    int gtk_clicked(int n) {
        return 0;
    }

    int gtk_commit(int n, int n2) {
        return 0;
    }

    int gtk_configure_event(int n, int n2) {
        return 0;
    }

    int gtk_day_selected(int n) {
        return 0;
    }

    int gtk_day_selected_double_click(int n) {
        return 0;
    }

    int gtk_delete_event(int n, int n2) {
        return 0;
    }

    int gtk_delete_range(int n, int n2, int n3) {
        return 0;
    }

    int gtk_delete_text(int n, int n2, int n3) {
        return 0;
    }

    int gtk_enter_notify_event(int n, int n2) {
        return 0;
    }

    int gtk_event(int n, int n2) {
        return 0;
    }

    int gtk_event_after(int n, int n2) {
        return 0;
    }

    int gtk_expand_collapse_cursor_row(int n, int n2, int n3, int n4) {
        return 0;
    }

    int gtk_expose_event(int n, int n2) {
        return 0;
    }

    int gtk_focus(int n, int n2) {
        return 0;
    }

    int gtk_focus_in_event(int n, int n2) {
        return 0;
    }

    int gtk_focus_out_event(int n, int n2) {
        return 0;
    }

    int gtk_grab_focus(int n) {
        return 0;
    }

    int gtk_hide(int n) {
        return 0;
    }

    int gtk_input(int n, int n2) {
        return 0;
    }

    int gtk_insert_text(int n, int n2, int n3, int n4) {
        return 0;
    }

    int gtk_key_press_event(int n, int n2) {
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
        return this.sendKeyEvent(1, gdkEventKey) ? 0 : 1;
    }

    int gtk_key_release_event(int n, int n2) {
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
        return this.sendKeyEvent(2, gdkEventKey) ? 0 : 1;
    }

    int gtk_leave_notify_event(int n, int n2) {
        return 0;
    }

    int gtk_map(int n) {
        return 0;
    }

    int gtk_map_event(int n, int n2) {
        return 0;
    }

    int gtk_mnemonic_activate(int n, int n2) {
        return 0;
    }

    int gtk_month_changed(int n) {
        return 0;
    }

    int gtk_motion_notify_event(int n, int n2) {
        return 0;
    }

    int gtk_move_focus(int n, int n2) {
        return 0;
    }

    int gtk_output(int n) {
        return 0;
    }

    int gtk_populate_popup(int n, int n2) {
        return 0;
    }

    int gtk_popup_menu(int n) {
        return 0;
    }

    int gtk_preedit_changed(int n) {
        return 0;
    }

    int gtk_realize(int n) {
        return 0;
    }

    int gtk_row_activated(int n, int n2, int n3) {
        return 0;
    }

    int gtk_row_deleted(int n, int n2) {
        return 0;
    }

    int gtk_row_inserted(int n, int n2, int n3) {
        return 0;
    }

    int gtk_scroll_child(int n, int n2, int n3) {
        return 0;
    }

    int gtk_scroll_event(int n, int n2) {
        return 0;
    }

    int gtk_select(int n) {
        return 0;
    }

    int gtk_show(int n) {
        return 0;
    }

    int gtk_show_help(int n, int n2) {
        return 0;
    }

    int gtk_size_allocate(int n, int n2) {
        return 0;
    }

    int gtk_status_icon_popup_menu(int n, int n2, int n3) {
        return 0;
    }

    int gtk_style_set(int n, int n2) {
        return 0;
    }

    int gtk_switch_page(int n, int n2, int n3) {
        return 0;
    }

    int gtk_test_collapse_row(int n, int n2, int n3) {
        return 0;
    }

    int gtk_test_expand_row(int n, int n2, int n3) {
        return 0;
    }

    int gtk_text_buffer_insert_text(int n, int n2, int n3, int n4) {
        return 0;
    }

    int gtk_timer() {
        return 0;
    }

    int gtk_toggled(int n, int n2) {
        return 0;
    }

    int gtk_unmap(int n) {
        return 0;
    }

    int gtk_unmap_event(int n, int n2) {
        return 0;
    }

    int gtk_unrealize(int n) {
        return 0;
    }

    int gtk_value_changed(int n) {
        return 0;
    }

    int gtk_visibility_notify_event(int n, int n2) {
        return 0;
    }

    int gtk_window_state_event(int n, int n2) {
        return 0;
    }

    int fontHeight(int n, int n2) {
        int n3 = OS.gtk_widget_get_pango_context(n2);
        int n4 = OS.pango_context_get_language(n3);
        int n5 = OS.pango_context_get_metrics(n3, n, n4);
        int n6 = OS.pango_font_metrics_get_ascent(n5);
        int n7 = OS.pango_font_metrics_get_descent(n5);
        OS.pango_font_metrics_unref(n5);
        return OS.PANGO_PIXELS(n6 + n7);
    }

    int filterProc(int n, int n2, int n3) {
        return 0;
    }

    boolean filters(int n) {
        return this.display.filters(n);
    }

    int fixedMapProc(int n) {
        return 0;
    }

    int fixedSizeAllocateProc(int n, int n2) {
        return OS.Call(Display.oldFixedSizeAllocateProc, n, n2);
    }

    char[] fixMnemonic(String string) {
        return this.fixMnemonic(string, true);
    }

    char[] fixMnemonic(String string, boolean bl) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        int n3 = 0;
        char[] cArray2 = new char[n * 2];
        while (n2 < n) {
            switch (cArray[n2]) {
                case '&': {
                    if (n2 + 1 < n && cArray[n2 + 1] == '&') {
                        cArray2[n3++] = cArray[n2++];
                    } else if (bl) {
                        cArray2[n3++] = 95;
                    }
                    ++n2;
                    break;
                }
                case '_': {
                    if (bl) {
                        cArray2[n3++] = 95;
                    }
                }
                default: {
                    cArray2[n3++] = cArray[n2++];
                }
            }
        }
        return cArray2;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int n) {
        this.checkWidget();
        return this.hooks(n);
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    void hookEvents() {
    }

    boolean hooks(int n) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(n);
    }

    int hoverProc(int n) {
        return 0;
    }

    int menuPositionProc(int n, int n2, int n3, int n4, int n5) {
        return 0;
    }

    boolean mnemonicHit(int n, char c) {
        if (!this.mnemonicMatch(n, c)) {
            return false;
        }
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 32);
        boolean bl = OS.gtk_widget_mnemonic_activate(n, false);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 32);
        return bl;
    }

    boolean mnemonicMatch(int n, char c) {
        int n2;
        int n3 = OS.gdk_keyval_to_lower(OS.gdk_unicode_to_keyval(c));
        return n3 == (n2 = OS.gdk_keyval_to_lower(OS.gtk_label_get_mnemonic_keyval(n)));
    }

    void modifyStyle(int n, int n2) {
        OS.gtk_widget_modify_style(n, n2);
    }

    public void notifyListeners(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(n, event);
    }

    void postEvent(int n) {
        this.sendEvent(n, null, false);
    }

    void postEvent(int n, Event event) {
        this.sendEvent(n, event, false);
    }

    void register() {
        if (this.handle == 0) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.addWidget(this.handle, this);
        }
    }

    void release(boolean bl) {
        if ((this.state & 0x200000) == 0) {
            this.state |= 0x200000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(bl);
        }
        if ((this.state & 0x100000) == 0) {
            this.state |= 0x100000;
            if (bl) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean bl) {
    }

    void releaseHandle() {
        this.handle = 0;
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    protected void removeListener(int n, SWTEventListener sWTEventListener) {
        this.checkWidget();
        if (sWTEventListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, sWTEventListener);
    }

    int rendererGetSizeProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return 0;
    }

    int rendererRenderProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return 0;
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, disposeListener);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int n) {
        this.sendEvent(n, null, true);
    }

    void sendEvent(int n, Event event) {
        this.sendEvent(n, event, true);
    }

    void sendEvent(int n, Event event, boolean bl) {
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = n;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (bl) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(int n, GdkEventKey gdkEventKey) {
        int n2 = gdkEventKey.length;
        if (gdkEventKey.string == 0 || OS.g_utf8_strlen(gdkEventKey.string, n2) <= 1) {
            Event event = new Event();
            event.time = gdkEventKey.time;
            if (!this.setKeyState(event, gdkEventKey)) {
                return true;
            }
            this.sendEvent(n, event);
            if (this.isDisposed()) {
                return false;
            }
            return event.doit;
        }
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, gdkEventKey.string, n2);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        return this.sendIMKeyEvent(n, gdkEventKey, cArray) != null;
    }

    char[] sendIMKeyEvent(int n, GdkEventKey gdkEventKey, char[] cArray) {
        Object object;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (gdkEventKey == null && (n5 = OS.gtk_get_current_event()) != 0) {
            gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n5, GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: 
                case 9: {
                    n4 = gdkEventKey.state;
                    break;
                }
                default: {
                    gdkEventKey = null;
                }
            }
        }
        if (gdkEventKey == null) {
            object = new int[1];
            OS.gtk_get_current_event_state(object);
            n4 = object[0];
        }
        while (n2 < cArray.length) {
            object = new Event();
            if (gdkEventKey != null && cArray.length <= 1) {
                this.setKeyState((Event)object, gdkEventKey);
            } else {
                this.setInputState((Event)object, n4);
            }
            object.character = cArray[n2];
            this.sendEvent(n, (Event)object);
            if (this.isDisposed()) {
                if (n5 != 0) {
                    OS.gdk_event_free(n5);
                }
                return null;
            }
            if (object.doit) {
                cArray[n3++] = cArray[n2];
            }
            ++n2;
        }
        if (n5 != 0) {
            OS.gdk_event_free(n5);
        }
        if (n3 == 0) {
            return null;
        }
        if (n2 != n3) {
            object = new char[n3];
            System.arraycopy(cArray, 0, object, 0, n3);
            return object;
        }
        return cArray;
    }

    public void setData(Object object) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = object;
        } else {
            this.data = object;
        }
    }

    public void setData(String string, Object object) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n = 1;
        Object[] objectArray = null;
        if ((this.state & 4) != 0) {
            objectArray = (Object[])this.data;
            while (n < objectArray.length) {
                if (string.equals(objectArray[n])) break;
                n += 2;
            }
        }
        if (object != null) {
            if ((this.state & 4) != 0) {
                if (n == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    this.data = objectArray2;
                }
            } else {
                objectArray = new Object[3];
                objectArray[0] = this.data;
                this.data = objectArray;
                this.state |= 4;
            }
            objectArray[n] = string;
            objectArray[n + 1] = object;
        } else if ((this.state & 4) != 0 && n != objectArray.length) {
            int n2 = objectArray.length - 2;
            if (n2 == 1) {
                this.data = objectArray[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] objectArray3 = new Object[n2];
                System.arraycopy(objectArray, 0, objectArray3, 0, n);
                System.arraycopy(objectArray, n + 2, objectArray3, n, n2 - n);
                this.data = objectArray3;
            }
        }
    }

    void setForegroundColor(int n, GdkColor gdkColor) {
        int n2 = OS.gtk_widget_get_modifier_style(n);
        OS.gtk_rc_style_set_fg(n2, 0, gdkColor);
        OS.gtk_rc_style_set_fg(n2, 1, gdkColor);
        OS.gtk_rc_style_set_fg(n2, 2, gdkColor);
        int n3 = OS.gtk_rc_style_get_color_flags(n2, 0);
        n3 = gdkColor == null ? n3 & 0xFFFFFFFE : n3 | 1;
        OS.gtk_rc_style_set_color_flags(n2, 0, n3);
        n3 = OS.gtk_rc_style_get_color_flags(n2, 1);
        n3 = gdkColor == null ? n3 & 0xFFFFFFFE : n3 | 1;
        OS.gtk_rc_style_set_color_flags(n2, 1, n3);
        n3 = OS.gtk_rc_style_get_color_flags(n2, 2);
        n3 = gdkColor == null ? n3 & 0xFFFFFFFE : n3 | 1;
        OS.gtk_rc_style_set_color_flags(n2, 2, n3);
        OS.gtk_rc_style_set_text(n2, 0, gdkColor);
        OS.gtk_rc_style_set_text(n2, 1, gdkColor);
        OS.gtk_rc_style_set_text(n2, 2, gdkColor);
        n3 = OS.gtk_rc_style_get_color_flags(n2, 0);
        n3 = gdkColor == null ? n3 & 0xFFFFFFFB : n3 | 4;
        OS.gtk_rc_style_set_color_flags(n2, 0, n3);
        n3 = OS.gtk_rc_style_get_color_flags(n2, 2);
        n3 = gdkColor == null ? n3 & 0xFFFFFFFB : n3 | 4;
        OS.gtk_rc_style_set_color_flags(n2, 2, n3);
        n3 = OS.gtk_rc_style_get_color_flags(n2, 1);
        n3 = gdkColor == null ? n3 & 0xFFFFFFFB : n3 | 4;
        OS.gtk_rc_style_set_color_flags(n2, 1, n3);
        this.modifyStyle(n, n2);
    }

    boolean setInputState(Event event, int n) {
        if ((n & 8) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((n & 1) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((n & 4) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((n & 0x100) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((n & 0x200) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((n & 0x400) != 0) {
            event.stateMask |= 0x200000;
        }
        return true;
    }

    boolean setKeyState(Event event, GdkEventKey gdkEventKey) {
        if (gdkEventKey.string != 0 && OS.g_utf8_strlen(gdkEventKey.string, gdkEventKey.length) > 1) {
            return false;
        }
        boolean bl = false;
        event.keyCode = Display.translateKey(gdkEventKey.keyval);
        switch (gdkEventKey.keyval) {
            case 65288: {
                event.character = (char)8;
                break;
            }
            case 65290: {
                event.character = (char)10;
                break;
            }
            case 65293: 
            case 65421: {
                event.character = (char)13;
                break;
            }
            case 65439: 
            case 65535: {
                event.character = (char)127;
                break;
            }
            case 65307: {
                event.character = (char)27;
                break;
            }
            case 65056: 
            case 65289: {
                event.character = (char)9;
                break;
            }
            default: {
                if (event.keyCode == 0) {
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    int[] nArray3 = new int[1];
                    int[] nArray4 = new int[1];
                    if (OS.gdk_keymap_translate_keyboard_state(OS.gdk_keymap_get_default(), gdkEventKey.hardware_keycode, 0, gdkEventKey.group, nArray, nArray2, nArray3, nArray4)) {
                        event.keyCode = OS.gdk_keyval_to_unicode(nArray[0]);
                    }
                }
                int n = gdkEventKey.keyval;
                if ((gdkEventKey.state & 4) != 0 && n >= 0 && n <= 127) {
                    if (97 <= n && n <= 122) {
                        n -= 32;
                    }
                    if (64 <= n && n <= 95) {
                        n -= 64;
                    }
                    event.character = (char)n;
                    bl = gdkEventKey.keyval == 64 && n == 0;
                    break;
                }
                event.character = (char)OS.gdk_keyval_to_unicode(n);
            }
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !bl) {
            return false;
        }
        return this.setInputState(event, gdkEventKey.state);
    }

    void setOrientation() {
    }

    boolean setTabGroupFocus(boolean bl) {
        return this.setTabItemFocus(bl);
    }

    boolean setTabItemFocus(boolean bl) {
        return false;
    }

    int shellMapProc(int n, int n2, int n3) {
        return 0;
    }

    int sizeAllocateProc(int n, int n2, int n3) {
        return 0;
    }

    int sizeRequestProc(int n, int n2, int n3) {
        return 0;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    int topHandle() {
        return this.handle;
    }

    int timerProc(int n) {
        return 0;
    }

    int treeSelectionProc(int n, int n2, int n3, int[] nArray, int n4) {
        return 0;
    }

    boolean translateTraversal(int n) {
        return false;
    }

    int windowProc(int n, int n2) {
        switch (n2) {
            case 1: {
                return this.gtk_activate(n);
            }
            case 6: {
                return this.gtk_changed(n);
            }
            case 8: {
                return this.gtk_clicked(n);
            }
            case 61: {
                return this.gtk_day_selected(n);
            }
            case 66: {
                return this.gtk_day_selected_double_click(n);
            }
            case 24: {
                return this.gtk_hide(n);
            }
            case 23: {
                return this.gtk_grab_focus(n);
            }
            case 30: {
                return this.gtk_map(n);
            }
            case 62: {
                return this.gtk_month_changed(n);
            }
            case 36: {
                return this.gtk_output(n);
            }
            case 38: {
                return this.gtk_popup_menu(n);
            }
            case 39: {
                return this.gtk_preedit_changed(n);
            }
            case 40: {
                return this.gtk_realize(n);
            }
            case 44: {
                return this.gtk_select(n);
            }
            case 45: {
                return this.gtk_show(n);
            }
            case 57: {
                return this.gtk_value_changed(n);
            }
            case 54: {
                return this.gtk_unmap(n);
            }
            case 56: {
                return this.gtk_unrealize(n);
            }
        }
        return 0;
    }

    int windowProc(int n, int n2, int n3) {
        switch (n3) {
            case 19: {
                GdkEventExpose gdkEventExpose = new GdkEventExpose();
                OS.memmove(gdkEventExpose, n2, GdkEventExpose.sizeof);
                int n4 = this.paintWindow();
                int n5 = gdkEventExpose.window;
                if (n5 != n4) {
                    return 0;
                }
                return (this.state & 0x40) != 0 ? 1 : 0;
            }
            case 3: 
            case 5: 
            case 34: {
                return 1;
            }
            case 2: {
                return this.gtk_button_press_event(n, n2);
            }
            case 4: {
                return this.gtk_button_release_event(n, n2);
            }
            case 9: {
                return this.gtk_commit(n, n2);
            }
            case 10: {
                return this.gtk_configure_event(n, n2);
            }
            case 11: {
                return this.gtk_delete_event(n, n2);
            }
            case 14: {
                return this.gtk_enter_notify_event(n, n2);
            }
            case 15: {
                return this.gtk_event(n, n2);
            }
            case 16: {
                return this.gtk_event_after(n, n2);
            }
            case 18: {
                return this.gtk_expose_event(n, n2);
            }
            case 20: {
                return this.gtk_focus(n, n2);
            }
            case 21: {
                return this.gtk_focus_in_event(n, n2);
            }
            case 22: {
                return this.gtk_focus_out_event(n, n2);
            }
            case 27: {
                return this.gtk_key_press_event(n, n2);
            }
            case 28: {
                return this.gtk_key_release_event(n, n2);
            }
            case 25: {
                return this.gtk_input(n, n2);
            }
            case 29: {
                return this.gtk_leave_notify_event(n, n2);
            }
            case 31: {
                return this.gtk_map_event(n, n2);
            }
            case 32: {
                return this.gtk_mnemonic_activate(n, n2);
            }
            case 33: {
                return this.gtk_motion_notify_event(n, n2);
            }
            case 35: {
                return this.gtk_move_focus(n, n2);
            }
            case 37: {
                return this.gtk_populate_popup(n, n2);
            }
            case 43: {
                return this.gtk_scroll_event(n, n2);
            }
            case 46: {
                return this.gtk_show_help(n, n2);
            }
            case 47: {
                return this.gtk_size_allocate(n, n2);
            }
            case 48: {
                return this.gtk_style_set(n, n2);
            }
            case 53: {
                return this.gtk_toggled(n, n2);
            }
            case 55: {
                return this.gtk_unmap_event(n, n2);
            }
            case 58: {
                return this.gtk_visibility_notify_event(n, n2);
            }
            case 59: {
                return this.gtk_window_state_event(n, n2);
            }
            case 65: {
                return this.gtk_row_deleted(n, n2);
            }
        }
        return 0;
    }

    int windowProc(int n, int n2, int n3, int n4) {
        switch (n4) {
            case 12: {
                return this.gtk_delete_range(n, n2, n3);
            }
            case 13: {
                return this.gtk_delete_text(n, n2, n3);
            }
            case 41: {
                return this.gtk_row_activated(n, n2, n3);
            }
            case 42: {
                return this.gtk_scroll_child(n, n2, n3);
            }
            case 63: {
                return this.gtk_status_icon_popup_menu(n, n2, n3);
            }
            case 49: {
                return this.gtk_switch_page(n, n2, n3);
            }
            case 50: {
                return this.gtk_test_collapse_row(n, n2, n3);
            }
            case 51: {
                return this.gtk_test_expand_row(n, n2, n3);
            }
            case 64: {
                return this.gtk_row_inserted(n, n2, n3);
            }
        }
        return 0;
    }

    int windowProc(int n, int n2, int n3, int n4, int n5) {
        switch (n5) {
            case 7: {
                return this.gtk_change_value(n, n2, n3, n4);
            }
            case 17: {
                return this.gtk_expand_collapse_cursor_row(n, n2, n3, n4);
            }
            case 26: {
                return this.gtk_insert_text(n, n2, n3, n4);
            }
            case 52: {
                return this.gtk_text_buffer_insert_text(n, n2, n3, n4);
            }
        }
        return 0;
    }
}

