/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventWindowState;
import org.eclipse.swt.internal.gtk.GdkGeometry;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XFocusChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    long shellHandle;
    long tooltipsHandle;
    long tooltipWindow;
    boolean mapped;
    boolean moved;
    boolean resized;
    boolean opened;
    int oldX;
    int oldY;
    int oldWidth;
    int oldHeight;
    int minWidth;
    int minHeight;
    Control lastActive;
    Region region;
    static final int MAXIMUM_TRIM = 128;

    public Shell() {
        this((Display)null);
    }

    public Shell(int n) {
        this((Display)null, n);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int n) {
        this(display, null, n, 0L, false);
    }

    Shell(Display display, Shell shell, int n, long l, boolean bl) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (shell != null && shell.isDisposed()) {
            this.error(5);
        }
        this.style = Shell.checkStyle(n);
        this.parent = shell;
        this.display = display;
        if (l != 0L) {
            if (bl) {
                this.handle = l;
            } else {
                this.shellHandle = l;
                this.state |= 0x400000;
            }
        }
        this.createWidget(0);
    }

    public Shell(Shell shell) {
        this(shell, 2144);
    }

    public Shell(Shell shell, int n) {
        this(shell != null ? shell.display : null, shell, n, 0L, false);
    }

    public static Shell gtk_new(Display display, long l) {
        return new Shell(display, null, 8, l, true);
    }

    public static Shell internal_new(Display display, long l) {
        return new Shell(display, null, 8, l, false);
    }

    static int checkStyle(int n) {
        if (((n = Decorations.checkStyle(n)) & 0x4000) != 0) {
            n &= 0xFFFFFB0F;
        }
        int n2 = 229376;
        int n3 = n & ~n2;
        if ((n & 0x20000) != 0) {
            return n3 | 0x20000;
        }
        if ((n & 0x10000) != 0) {
            return n3 | 0x10000;
        }
        if ((n & 0x8000) != 0) {
            return n3 | 0x8000;
        }
        return n3;
    }

    public void addShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(shellListener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    void adjustTrim() {
        if (this.display.ignoreTrim) {
            return;
        }
        int n = OS.GTK_WIDGET_WIDTH(this.shellHandle);
        int n2 = OS.GTK_WIDGET_HEIGHT(this.shellHandle);
        long l = OS.GTK_WIDGET_WINDOW(this.shellHandle);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gdk_window_get_frame_extents(l, gdkRectangle);
        int n3 = Math.max(0, gdkRectangle.width - n);
        int n4 = Math.max(0, gdkRectangle.height - n2);
        if (n3 > 128 || n4 > 128) {
            this.display.ignoreTrim = true;
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if ((this.style & 8) == 0) {
            bl = (this.style & 0x4E0) != 0;
            bl2 = (this.style & 0x10) != 0;
            boolean bl4 = bl3 = (this.style & 0x800) != 0;
        }
        if (bl) {
            if (bl2) {
                this.display.titleResizeTrimWidth = n3;
                this.display.titleResizeTrimHeight = n4;
                return;
            }
            if (bl3) {
                this.display.titleBorderTrimWidth = n3;
                this.display.titleBorderTrimHeight = n4;
                return;
            }
            this.display.titleTrimWidth = n3;
            this.display.titleTrimHeight = n4;
            return;
        }
        if (bl2) {
            this.display.resizeTrimWidth = n3;
            this.display.resizeTrimHeight = n4;
            return;
        }
        if (bl3) {
            this.display.borderTrimWidth = n3;
            this.display.borderTrimHeight = n4;
            return;
        }
    }

    void bringToTop(boolean bl) {
        if (!OS.GTK_WIDGET_VISIBLE(this.shellHandle)) {
            return;
        }
        Display display = this.display;
        Shell shell = display.activeShell;
        if (shell == this) {
            return;
        }
        if (!bl) {
            long l;
            if (shell == null) {
                return;
            }
            if (!display.activePending && (l = OS.gtk_window_get_focus(shell.shellHandle)) != 0L && !OS.GTK_WIDGET_HAS_FOCUS(l)) {
                return;
            }
        }
        boolean bl2 = false;
        if (shell != null) {
            if (OS.GTK_VERSION < OS.VERSION(2, 6, 8)) {
                bl2 = shell.isUndecorated();
            }
            display.activeShell = null;
            display.activePending = true;
        }
        long l = OS.GTK_WIDGET_WINDOW(this.shellHandle);
        if ((bl2 || (this.style & 0x4000) != 0) && OS.GDK_WINDOWING_X11()) {
            long l2 = OS.gdk_x11_drawable_get_xdisplay(l);
            long l3 = OS.gdk_x11_drawable_get_xid(l);
            OS.gdk_error_trap_push();
            OS.XSetInputFocus(l2, l3, 2, 0);
            OS.gdk_error_trap_pop();
        } else if (display.windowManager.toLowerCase().equals("metacity")) {
            OS.gdk_window_focus(l, display.lastUserEventTime);
        } else {
            OS.gdk_window_focus(l, 0);
        }
        display.activeShell = this;
        display.activePending = true;
    }

    void checkBorder() {
    }

    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    long childStyle() {
        return 0L;
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        int n5 = 0;
        if ((this.style & 0xCF8) == 0) {
            n5 = OS.gtk_container_get_border_width(this.shellHandle);
        }
        int n6 = this.trimWidth();
        int n7 = this.trimHeight();
        rectangle.x -= n6 / 2 + n5;
        rectangle.y -= n7 - n6 / 2 + n5;
        rectangle.width += n6 + n5 * 2;
        rectangle.height += n7 + n5 * 2;
        if (this.menuBar != null) {
            this.forceResize();
            int n8 = OS.GTK_WIDGET_HEIGHT(this.menuBar.handle);
            rectangle.y -= n8;
            rectangle.height += n8;
        }
        return rectangle;
    }

    void createHandle(int n) {
        this.state |= 0xA;
        if (this.shellHandle == 0L) {
            int n2;
            boolean bl;
            if (this.handle == 0L) {
                int n3 = 0;
                if ((this.style & 0x4000) != 0) {
                    n3 = 1;
                }
                this.shellHandle = OS.gtk_window_new(n3);
            } else {
                this.shellHandle = OS.gtk_plug_new(this.handle);
            }
            if (this.shellHandle == 0L) {
                this.error(2);
            }
            if (this.parent != null) {
                OS.gtk_window_set_transient_for(this.shellHandle, this.parent.topHandle());
                OS.gtk_window_set_destroy_with_parent(this.shellHandle, true);
                if (!this.isUndecorated()) {
                    OS.gtk_window_set_type_hint(this.shellHandle, 1);
                } else if (OS.GTK_VERSION >= OS.VERSION(2, 2, 0)) {
                    OS.gtk_window_set_skip_taskbar_hint(this.shellHandle, true);
                }
            }
            if ((this.style & 0x10) != 0) {
                OS.gtk_widget_set_size_request(this.shellHandle, 0, 0);
                OS.gtk_window_set_resizable(this.shellHandle, true);
            } else {
                OS.gtk_window_set_resizable(this.shellHandle, false);
            }
            this.vboxHandle = OS.gtk_vbox_new(false, 0);
            if (this.vboxHandle == 0L) {
                this.error(2);
            }
            this.createHandle(n, false, true);
            OS.gtk_container_add(this.vboxHandle, this.scrolledHandle);
            OS.gtk_box_set_child_packing(this.vboxHandle, this.scrolledHandle, true, true, 0, 1);
            OS.gtk_window_set_title(this.shellHandle, new byte[1]);
            if ((this.style & 0xCF8) == 0) {
                OS.gtk_container_set_border_width(this.shellHandle, 1);
                GdkColor gdkColor = new GdkColor();
                OS.gtk_style_get_black(OS.gtk_widget_get_style(this.shellHandle), gdkColor);
                OS.gtk_widget_modify_bg(this.shellHandle, 0, gdkColor);
            }
            boolean bl2 = bl = (this.style & (n2 = 229376)) != 0;
            if ((this.style & 0x4000) == 0) {
                bl |= this.parent != null && (this.parent.style & n2) != 0;
            }
            OS.gtk_window_set_modal(this.shellHandle, bl);
        } else {
            long l;
            this.vboxHandle = OS.gtk_bin_get_child(this.shellHandle);
            if (this.vboxHandle == 0L) {
                this.error(2);
            }
            if (OS.g_list_length(l = OS.gtk_container_get_children(this.vboxHandle)) > 0) {
                this.scrolledHandle = OS.g_list_data(l);
            }
            OS.g_list_free(l);
            if (this.scrolledHandle == 0L) {
                this.error(2);
            }
            this.handle = OS.gtk_bin_get_child(this.scrolledHandle);
            if (this.handle == 0L) {
                this.error(2);
            }
        }
        OS.gtk_widget_realize(this.shellHandle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long filterProc(long l, long l2, long l3) {
        int n = OS.X_EVENT_TYPE(l);
        if (n != 10 && n != 9) {
            return 0L;
        }
        XFocusChangeEvent xFocusChangeEvent = new XFocusChangeEvent();
        OS.memmove(xFocusChangeEvent, l, (long)XFocusChangeEvent.sizeof);
        switch (n) {
            case 9: {
                if (xFocusChangeEvent.mode != 0 && xFocusChangeEvent.mode != 3) return 0L;
                switch (xFocusChangeEvent.detail) {
                    case 0: 
                    case 3: 
                    case 4: {
                        if (this.tooltipsHandle != 0L) {
                            OS.gtk_tooltips_enable(this.tooltipsHandle);
                        }
                        this.display.activeShell = this;
                        this.display.activePending = false;
                        this.sendEvent(26);
                    }
                }
                return 0L;
            }
            case 10: {
                if (xFocusChangeEvent.mode != 0 && xFocusChangeEvent.mode != 3) return 0L;
                switch (xFocusChangeEvent.detail) {
                    case 1: 
                    case 3: 
                    case 4: {
                        if (this.tooltipsHandle != 0L) {
                            OS.gtk_tooltips_disable(this.tooltipsHandle);
                        }
                        Display display = this.display;
                        this.sendEvent(27);
                        this.setActiveControl(null);
                        if (display.activeShell != this) return 0L;
                        display.activeShell = null;
                        display.activePending = false;
                    }
                }
            }
        }
        return 0L;
    }

    Control findBackgroundControl() {
        return (this.state & 0x2000) != 0 || this.backgroundImage != null ? this : null;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    boolean hasBorder() {
        return false;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[27], 0, this.display.closures[27], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[31], 0, this.display.closures[31], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[54], 0, this.display.closures[54], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[58], 0, this.display.closures[58], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[46], 0, this.display.closures[46], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[10], 0, this.display.closures[10], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[11], 0, this.display.closures[11], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[31], 0, this.display.shellMapProcClosure, false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[14], 0, this.display.closures[14], false);
        OS.g_signal_connect_closure(this.shellHandle, OS.move_focus, this.display.closures[35], false);
        long l = OS.GTK_WIDGET_WINDOW(this.shellHandle);
        OS.gdk_window_add_filter(l, this.display.filterProc, this.shellHandle);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isUndecorated() {
        return (this.style & 0xCF0) == 0 || (this.style & 0x4008) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void register() {
        super.register();
        this.display.addWidget(this.shellHandle, this);
    }

    void releaseParent() {
    }

    long topHandle() {
        return this.shellHandle;
    }

    void fixActiveShell() {
        if (this.display.activeShell == this) {
            Shell shell = null;
            if (this.parent != null && this.parent.isVisible()) {
                shell = this.parent.getShell();
            }
            if (shell == null && this.isUndecorated()) {
                Shell[] shellArray = this.display.getShells();
                int n = 0;
                while (n < shellArray.length) {
                    if (shellArray[n] != null && shellArray[n].isVisible()) {
                        shell = shellArray[n];
                        break;
                    }
                    ++n;
                }
            }
            if (shell != null) {
                shell.bringToTop(false);
            }
        }
    }

    void fixShell(Shell shell, Control control) {
        String string;
        if (this == shell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
        if ((string = control.toolTipText) != null) {
            control.setToolTipText(this, null);
            control.setToolTipText(shell, string);
        }
    }

    void fixStyle(long l) {
    }

    void forceResize() {
        this.forceResize(OS.GTK_WIDGET_WIDTH(this.vboxHandle), OS.GTK_WIDGET_HEIGHT(this.vboxHandle));
    }

    void forceResize(int n, int n2) {
        int n3;
        GtkRequisition gtkRequisition = new GtkRequisition();
        OS.gtk_widget_size_request(this.vboxHandle, gtkRequisition);
        GtkAllocation gtkAllocation = new GtkAllocation();
        gtkAllocation.x = n3 = OS.gtk_container_get_border_width(this.shellHandle);
        gtkAllocation.y = n3;
        gtkAllocation.width = n;
        gtkAllocation.height = n2;
        OS.gtk_widget_size_allocate(this.vboxHandle, gtkAllocation);
    }

    public Point getLocation() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_window_get_position(this.shellHandle, nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public Point getMinimumSize() {
        this.checkWidget();
        int n = Math.max(1, this.minWidth + this.trimWidth());
        int n2 = Math.max(1, this.minHeight + this.trimHeight());
        return new Point(n, n2);
    }

    public Point getSize() {
        this.checkWidget();
        int n = OS.GTK_WIDGET_WIDTH(this.vboxHandle);
        int n2 = OS.GTK_WIDGET_HEIGHT(this.vboxHandle);
        int n3 = 0;
        if ((this.style & 0xCF8) == 0) {
            n3 = OS.gtk_container_get_border_width(this.shellHandle);
        }
        return new Point(n + this.trimWidth() + 2 * n3, n2 + this.trimHeight() + 2 * n3);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.GTK_WIDGET_VISIBLE(this.shellHandle);
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    Shell _getShell() {
        return this;
    }

    public Shell[] getShells() {
        Shell[] shellArray;
        this.checkWidget();
        int n = 0;
        Shell[] shellArray2 = this.display.getShells();
        int n2 = 0;
        while (n2 < shellArray2.length) {
            shellArray = shellArray2[n2];
            while ((shellArray = shellArray.getParent()) != null && shellArray != this) {
            }
            if (shellArray == this) {
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        shellArray = new Shell[n];
        int n3 = 0;
        while (n3 < shellArray2.length) {
            Composite composite = shellArray2[n3];
            while ((composite = composite.getParent()) != null && composite != this) {
            }
            if (composite == this) {
                shellArray[n2++] = shellArray2[n3];
            }
            ++n3;
        }
        return shellArray;
    }

    long gtk_configure_event(long l, long l2) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_window_get_position(this.shellHandle, nArray, nArray2);
        if (!this.moved || this.oldX != nArray[0] || this.oldY != nArray2[0]) {
            this.moved = true;
            this.oldX = nArray[0];
            this.oldY = nArray2[0];
            this.sendEvent(10);
        }
        return 0L;
    }

    long gtk_delete_event(long l, long l2) {
        if (this.isEnabled()) {
            this.closeWidget();
        }
        return 1L;
    }

    long gtk_enter_notify_event(long l, long l2) {
        if (l != this.shellHandle) {
            return super.gtk_enter_notify_event(l, l2);
        }
        return 0L;
    }

    long gtk_focus(long l, long l2) {
        switch ((int)l2) {
            case 0: 
            case 1: {
                Control control = this.display.getFocusControl();
                if (control == null || (control.state & 2) == 0 || (control.style & 0x1000000) == 0) break;
                int n = l2 == 0L ? 16 : 8;
                control.traverse(n);
                return 1L;
            }
        }
        return super.gtk_focus(l, l2);
    }

    long gtk_move_focus(long l, long l2) {
        Control control = this.display.getFocusControl();
        if (control != null) {
            long l3 = control.focusHandle();
            OS.gtk_widget_child_focus(l3, (int)l2);
        }
        OS.g_signal_stop_emission_by_name(this.shellHandle, OS.move_focus);
        return 1L;
    }

    long gtk_key_press_event(long l, long l2) {
        if (l == this.shellHandle) {
            return (this.state & 0x10) != 0 ? 1 : 0;
        }
        return super.gtk_key_press_event(l, l2);
    }

    long gtk_map_event(long l, long l2) {
        this.minimized = false;
        this.sendEvent(20);
        return 0L;
    }

    long gtk_size_allocate(long l, long l2) {
        int n = OS.GTK_WIDGET_WIDTH(this.shellHandle);
        int n2 = OS.GTK_WIDGET_HEIGHT(this.shellHandle);
        if (!this.resized || this.oldWidth != n || this.oldHeight != n2) {
            this.oldWidth = n;
            this.oldHeight = n2;
            this.resizeBounds(n, n2, true);
        }
        return 0L;
    }

    long gtk_realize(long l) {
        long l2 = super.gtk_realize(l);
        long l3 = OS.GTK_WIDGET_WINDOW(this.shellHandle);
        if ((this.style & 0x4F0) != 1264) {
            int n = 0;
            if ((this.style & 8) == 0) {
                if ((this.style & 0x80) != 0) {
                    n |= 0x20;
                }
                if ((this.style & 0x400) != 0) {
                    n |= 0x40;
                }
                if ((this.style & 0x10) != 0) {
                    n |= 4;
                }
                if ((this.style & 0x800) != 0) {
                    n |= 2;
                }
                if ((this.style & 0x40) != 0) {
                    n |= 0x10;
                }
                if ((this.style & 0x20) != 0) {
                    n |= 8;
                }
                if ((this.style & 0x10) != 0) {
                    n |= 2;
                }
            }
            OS.gdk_window_set_decorations(l3, n);
        }
        if ((this.style & 0x4000) != 0) {
            OS.gdk_window_set_override_redirect(l3, true);
        }
        return l2;
    }

    long gtk_unmap_event(long l, long l2) {
        this.minimized = true;
        this.sendEvent(19);
        return 0L;
    }

    long gtk_window_state_event(long l, long l2) {
        GdkEventWindowState gdkEventWindowState = new GdkEventWindowState();
        OS.memmove(gdkEventWindowState, l2, (long)GdkEventWindowState.sizeof);
        this.minimized = (gdkEventWindowState.new_window_state & 2) != 0;
        this.maximized = (gdkEventWindowState.new_window_state & 4) != 0;
        return 0L;
    }

    public void open() {
        this.checkWidget();
        this.bringToTop(false);
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    public void removeShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, shellListener);
        this.eventTable.unhook(19, shellListener);
        this.eventTable.unhook(20, shellListener);
        this.eventTable.unhook(26, shellListener);
        this.eventTable.unhook(27, shellListener);
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop(false);
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] controlArray = control == null ? new Control[]{} : control.getPath();
        Control[] controlArray2 = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int n = 0;
        int n2 = Math.min(controlArray.length, controlArray2.length);
        while (n < n2) {
            if (controlArray[n] != controlArray2[n]) break;
            ++n;
        }
        int n3 = controlArray2.length - 1;
        while (n3 >= n) {
            if (!controlArray2[n3].isDisposed()) {
                controlArray2[n3].sendEvent(27);
            }
            --n3;
        }
        n3 = controlArray.length - 1;
        while (n3 >= n) {
            if (!controlArray[n3].isDisposed()) {
                controlArray[n3].sendEvent(26);
            }
            --n3;
        }
    }

    void resizeBounds(int n, int n2, boolean bl) {
        if (this.redrawWindow != 0L) {
            OS.gdk_window_resize(this.redrawWindow, n, n2);
        }
        if (this.enableWindow != 0L) {
            OS.gdk_window_resize(this.enableWindow, n, n2);
        }
        int n3 = OS.gtk_container_get_border_width(this.shellHandle);
        int n4 = n - 2 * n3;
        int n5 = n2 - 2 * n3;
        OS.gtk_widget_set_size_request(this.vboxHandle, n4, n5);
        this.forceResize(n4, n5);
        if (bl) {
            this.resized = true;
            this.sendEvent(11);
            if (this.isDisposed()) {
                return;
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        if (this.getMaximized()) {
            boolean bl4;
            Rectangle rectangle = this.getBounds();
            bl3 = !bl || rectangle.x == n && rectangle.y == n2;
            boolean bl5 = bl4 = !bl2 || rectangle.width == n3 && rectangle.height == n4;
            if (bl3 && bl4) {
                return 0;
            }
            this.setMaximized(false);
        }
        int n5 = 0;
        if (bl) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_window_get_position(this.shellHandle, nArray, nArray2);
            OS.gtk_window_move(this.shellHandle, n, n2);
            if (nArray[0] != n || nArray2[0] != n2) {
                this.moved = true;
                this.oldX = n;
                this.oldY = n2;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return 0;
                }
                n5 |= 0x80;
            }
        }
        if (bl2) {
            n3 = Math.max(1, Math.max(this.minWidth, n3 - this.trimWidth()));
            n4 = Math.max(1, Math.max(this.minHeight, n4 - this.trimHeight()));
            if ((this.style & 0x10) != 0) {
                OS.gtk_window_resize(this.shellHandle, n3, n4);
            }
            boolean bl6 = bl3 = n3 != this.oldWidth || n4 != this.oldHeight;
            if (bl3) {
                this.oldWidth = n3;
                this.oldHeight = n4;
                n5 |= 0x100;
            }
            this.resizeBounds(n3, n4, bl3);
        }
        return n5;
    }

    void setCursor(long l) {
        if (this.enableWindow != 0L) {
            OS.gdk_window_set_cursor(this.enableWindow, l);
            if (!OS.GDK_WINDOWING_X11()) {
                OS.gdk_flush();
            } else {
                long l2 = OS.GDK_DISPLAY();
                OS.XFlush(l2);
            }
        }
        super.setCursor(l);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == bl) {
            return;
        }
        Display display = this.display;
        Control control = null;
        boolean bl2 = false;
        if (!bl && display.focusEvent != 16) {
            control = display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.state = bl ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(bl);
        if (this.isDisposed()) {
            return;
        }
        if (bl) {
            if (this.enableWindow != 0L) {
                OS.gdk_window_set_user_data(this.enableWindow, 0L);
                OS.gdk_window_destroy(this.enableWindow);
                this.enableWindow = 0L;
            }
        } else {
            long l = this.shellHandle;
            OS.gtk_widget_realize(l);
            long l2 = OS.GTK_WIDGET_WINDOW(l);
            Rectangle rectangle = this.getBounds();
            GdkWindowAttr gdkWindowAttr = new GdkWindowAttr();
            gdkWindowAttr.width = rectangle.width;
            gdkWindowAttr.height = rectangle.height;
            gdkWindowAttr.event_mask = -32769;
            gdkWindowAttr.wclass = 1;
            gdkWindowAttr.window_type = 2;
            this.enableWindow = OS.gdk_window_new(l2, gdkWindowAttr, 0);
            if (this.enableWindow != 0L) {
                if (this.cursor != null) {
                    OS.gdk_window_set_cursor(this.enableWindow, this.cursor.handle);
                    if (!OS.GDK_WINDOWING_X11()) {
                        OS.gdk_flush();
                    } else {
                        long l3 = OS.GDK_DISPLAY();
                        OS.XFlush(l3);
                    }
                }
                OS.gdk_window_set_user_data(this.enableWindow, l);
                OS.gdk_window_show(this.enableWindow);
            }
        }
        if (bl2) {
            this.fixFocus(control);
        }
        if (bl && display.activeShell == this && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setImeInputMode(int n) {
        this.checkWidget();
    }

    void setInitialBounds() {
        if ((this.state & 0x400000) != 0) {
            return;
        }
        Monitor monitor = this.getMonitor();
        Rectangle rectangle = monitor.getClientArea();
        int n = rectangle.width * 5 / 8;
        int n2 = rectangle.height * 5 / 8;
        if ((this.style & 0x10) != 0) {
            OS.gtk_window_resize(this.shellHandle, n, n2);
        }
        this.resizeBounds(n, n2, false);
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        super.setMaximized(bl);
        if (bl) {
            OS.gtk_window_maximize(this.shellHandle);
        } else {
            OS.gtk_window_unmaximize(this.shellHandle);
        }
    }

    public void setMenuBar(Menu menu) {
        long l;
        boolean bl;
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        boolean bl2 = bl = menu != null && this.menuBar != null;
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (this.menuBar != null) {
            l = this.menuBar.handle;
            OS.gtk_widget_hide(l);
            this.destroyAccelGroup();
        }
        this.menuBar = menu;
        if (this.menuBar != null) {
            l = menu.handle;
            OS.gtk_widget_show(l);
            this.createAccelGroup();
            this.menuBar.addAccelerators(this.accelGroup);
        }
        int n = OS.GTK_WIDGET_WIDTH(this.vboxHandle);
        int n2 = OS.GTK_WIDGET_HEIGHT(this.vboxHandle);
        this.resizeBounds(n, n2, !bl);
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        if (this.minimized == bl) {
            return;
        }
        super.setMinimized(bl);
        if (bl) {
            OS.gtk_window_iconify(this.shellHandle);
        } else {
            OS.gtk_window_deiconify(this.shellHandle);
            this.bringToTop(false);
        }
    }

    public void setMinimumSize(int n, int n2) {
        this.checkWidget();
        GdkGeometry gdkGeometry = new GdkGeometry();
        this.minWidth = gdkGeometry.min_width = Math.max(n, this.trimWidth()) - this.trimWidth();
        this.minHeight = gdkGeometry.min_height = Math.max(n2, this.trimHeight()) - this.trimHeight();
        OS.gtk_window_set_geometry_hints(this.shellHandle, 0L, gdkGeometry, 2);
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMinimumSize(point.x, point.y);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        long l = OS.GTK_WIDGET_WINDOW(this.shellHandle);
        long l2 = region == null ? 0L : region.handle;
        OS.gdk_window_shape_combine_region(l, l2, 0, 0);
        this.region = region;
    }

    void setRelations() {
    }

    public void setText(String string) {
        super.setText(string);
        int n = string.length();
        char[] cArray = new char[Math.max(6, n) + 1];
        string.getChars(0, n, cArray, 0);
        int n2 = n;
        while (n2 < cArray.length) {
            cArray[n2] = 32;
            ++n2;
        }
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        OS.gtk_window_set_title(this.shellHandle, byArray);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (OS.GTK_WIDGET_MAPPED(this.shellHandle) == bl) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            OS.gtk_widget_show(this.shellHandle);
            if (!OS.GTK_IS_PLUG(this.shellHandle)) {
                this.mapped = false;
                if (this.isDisposed()) {
                    return;
                }
                this.display.dispatchEvents = new int[]{2, 12, 13, 14, 15, 30};
                Display display = this.display;
                display.putGdkEvents();
                boolean bl2 = false;
                Shell shell = this.parent != null ? this.parent.getShell() : null;
                do {
                    OS.g_main_context_iteration(0L, false);
                    if (this.isDisposed()) break;
                    boolean bl3 = bl2 = this.minimized || shell != null && shell.minimized;
                } while (!this.mapped && !bl2);
                display.dispatchEvents = null;
                if (this.isDisposed()) {
                    return;
                }
                if (!bl2) {
                    this.update(true, true);
                    if (this.isDisposed()) {
                        return;
                    }
                    this.adjustTrim();
                }
            }
            this.mapped = true;
            int n = 229376;
            if ((this.style & n) != 0) {
                OS.gdk_pointer_ungrab(0);
            }
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                Point point = this.getLocation();
                this.oldX = point.x;
                this.oldY = point.y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                Point point = this.getSize();
                this.oldWidth = point.x - this.trimWidth();
                this.oldHeight = point.y - this.trimHeight();
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            this.fixActiveShell();
            OS.gtk_widget_hide(this.shellHandle);
            this.sendEvent(23);
        }
    }

    void setZOrder(Control control, boolean bl, boolean bl2) {
        if (this.mapped) {
            this.setZOrder(control, bl, false, false);
        }
    }

    long shellMapProc(long l, long l2, long l3) {
        this.mapped = true;
        this.display.dispatchEvents = null;
        return 0L;
    }

    void showWidget() {
        if ((this.state & 0x400000) != 0) {
            return;
        }
        OS.gtk_container_add(this.shellHandle, this.vboxHandle);
        if (this.scrolledHandle != 0L) {
            OS.gtk_widget_show(this.scrolledHandle);
        }
        if (this.handle != 0L) {
            OS.gtk_widget_show(this.handle);
        }
        if (this.vboxHandle != 0L) {
            OS.gtk_widget_show(this.vboxHandle);
        }
    }

    long sizeAllocateProc(long l, long l2, long l3) {
        int n = 16;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_pointer(0L, nArray, nArray2, null);
        nArray2[0] = nArray2[0] + n;
        long l4 = OS.gdk_screen_get_default();
        if (l4 != 0L) {
            int n2 = OS.gdk_screen_get_monitor_at_point(l4, nArray[0], nArray2[0]);
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gdk_screen_get_monitor_geometry(l4, n2, gdkRectangle);
            int n3 = OS.GTK_WIDGET_WIDTH(l);
            int n4 = OS.GTK_WIDGET_HEIGHT(l);
            if (nArray[0] + n3 > gdkRectangle.x + gdkRectangle.width) {
                nArray[0] = gdkRectangle.x + gdkRectangle.width - n3;
            }
            if (nArray2[0] + n4 > gdkRectangle.y + gdkRectangle.height) {
                nArray2[0] = gdkRectangle.y + gdkRectangle.height - n4;
            }
        }
        OS.gtk_window_move(l, nArray[0], nArray2[0]);
        return 0L;
    }

    long sizeRequestProc(long l, long l2, long l3) {
        OS.gtk_widget_hide(l);
        return 0L;
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    int trimHeight() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl = (this.style & 0x4E0) != 0;
        bl2 = (this.style & 0x10) != 0;
        boolean bl4 = bl3 = (this.style & 0x800) != 0;
        if (bl) {
            if (bl2) {
                return this.display.titleResizeTrimHeight;
            }
            if (bl3) {
                return this.display.titleBorderTrimHeight;
            }
            return this.display.titleTrimHeight;
        }
        if (bl2) {
            return this.display.resizeTrimHeight;
        }
        if (bl3) {
            return this.display.borderTrimHeight;
        }
        return 0;
    }

    int trimWidth() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl = (this.style & 0x4E0) != 0;
        bl2 = (this.style & 0x10) != 0;
        boolean bl4 = bl3 = (this.style & 0x800) != 0;
        if (bl) {
            if (bl2) {
                return this.display.titleResizeTrimWidth;
            }
            if (bl3) {
                return this.display.titleBorderTrimWidth;
            }
            return this.display.titleTrimWidth;
        }
        if (bl2) {
            return this.display.resizeTrimWidth;
        }
        if (bl3) {
            return this.display.borderTrimWidth;
        }
        return 0;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.shellHandle);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.fixActiveShell();
        OS.gtk_widget_hide(this.shellHandle);
        super.dispose();
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop(true);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_window_get_position(this.shellHandle, nArray, nArray2);
        int n = OS.GTK_WIDGET_WIDTH(this.vboxHandle);
        int n2 = OS.GTK_WIDGET_HEIGHT(this.vboxHandle);
        int n3 = 0;
        if ((this.style & 0xCF8) == 0) {
            n3 = OS.gtk_container_get_border_width(this.shellHandle);
        }
        return new Rectangle(nArray[0], nArray2[0], n + this.trimWidth() + 2 * n3, n2 + this.trimHeight() + 2 * n3);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0L;
    }

    void releaseChildren(boolean bl) {
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (shell != null && !shell.isDisposed()) {
                shell.release(false);
            }
            ++n;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.destroyAccelGroup();
        if (this.display.activeShell == this) {
            this.display.activeShell = null;
        }
        if (this.tooltipsHandle != 0L) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0L;
        long l = OS.GTK_WIDGET_WINDOW(this.shellHandle);
        OS.gdk_window_remove_filter(l, this.display.filterProc, this.shellHandle);
        this.region = null;
        this.lastActive = null;
    }

    void setToolTipText(long l, String string) {
        int[] nArray;
        int[] nArray2;
        long l2;
        long l3;
        byte[] byArray = null;
        if (string != null && string.length() > 0) {
            byArray = Converter.wcsToMbcs(null, string, true);
        }
        if (this.tooltipsHandle == 0L) {
            this.tooltipsHandle = OS.gtk_tooltips_new();
            if (this.tooltipsHandle == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.tooltipsHandle);
            OS.gtk_object_sink(this.tooltipsHandle);
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 2, 1)) {
            OS.gtk_tooltips_force_window(this.tooltipsHandle);
        }
        if ((l3 = OS.GTK_TOOLTIPS_TIP_WINDOW(this.tooltipsHandle)) != 0L && l3 != this.tooltipWindow) {
            OS.g_signal_connect(l3, OS.size_allocate, this.display.sizeAllocateProc, this.shellHandle);
            this.tooltipWindow = l3;
        }
        boolean bl = true;
        if (l3 != 0L && (OS.GTK_WIDGET_FLAGS(l) & 0x140) != 0 && (l2 = OS.gdk_window_at_pointer(nArray2 = new int[1], nArray = new int[1])) != 0L) {
            long[] lArray = new long[1];
            OS.gdk_window_get_user_data(l2, lArray);
            if (l == lArray[0]) {
                bl = false;
                int n = OS.g_signal_connect(l3, OS.size_request, this.display.sizeRequestProc, this.shellHandle);
                OS.gtk_tooltips_set_tip(this.tooltipsHandle, l, byArray, null);
                OS.gtk_widget_hide(l3);
                long l4 = OS.gtk_tooltips_data_get(l);
                OS.GTK_TOOLTIPS_SET_ACTIVE(this.tooltipsHandle, l4);
                OS.gtk_tooltips_set_tip(this.tooltipsHandle, l, byArray, null);
                if (n != 0) {
                    OS.g_signal_handler_disconnect(l3, n);
                }
            }
        }
        if (bl) {
            OS.gtk_tooltips_set_tip(this.tooltipsHandle, l, byArray, null);
        }
    }
}

