/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIInputStream;
import org.eclipse.swt.internal.mozilla.nsISupports;

class InputStream {
    XPCOMObject inputStream;
    int refCount = 0;
    byte[] buffer;
    int index = 0;

    public InputStream(byte[] byArray) {
        this.buffer = byArray;
        this.index = 0;
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[8];
        nArray[0] = 2;
        nArray[4] = 1;
        nArray[5] = 3;
        nArray[6] = 4;
        nArray[7] = 1;
        this.inputStream = new XPCOMObject(nArray){

            public long method0(long[] lArray) {
                return InputStream.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return InputStream.this.AddRef();
            }

            public long method2(long[] lArray) {
                return InputStream.this.Release();
            }

            public long method3(long[] lArray) {
                return InputStream.this.Close();
            }

            public long method4(long[] lArray) {
                return InputStream.this.Available(lArray[0]);
            }

            public long method5(long[] lArray) {
                return InputStream.this.Read(lArray[0], lArray[1], lArray[2]);
            }

            public long method6(long[] lArray) {
                return InputStream.this.ReadSegments(lArray[0], lArray[1], lArray[2], lArray[3]);
            }

            public long method7(long[] lArray) {
                return InputStream.this.IsNonBlocking(lArray[0]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.inputStream != null) {
            this.inputStream.dispose();
            this.inputStream = null;
        }
    }

    long getAddress() {
        return this.inputStream.getAddress();
    }

    long QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147467262L;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, l, 16);
        if (nsID2.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(l2, new long[]{this.inputStream.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (nsID2.Equals(nsIInputStream.NS_IINPUTSTREAM_IID)) {
            XPCOM.memmove(l2, new long[]{this.inputStream.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        XPCOM.memmove(l2, new long[1], (long)C.PTR_SIZEOF);
        return -2147467262L;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    long Close() {
        this.buffer = null;
        this.index = 0;
        return 0L;
    }

    long Available(long l) {
        int n = this.buffer == null ? 0 : this.buffer.length - this.index;
        XPCOM.memmove(l, new int[]{n}, 4L);
        return 0L;
    }

    long Read(long l, long l2, long l3) {
        int n = Math.min((int)l2, this.buffer == null ? 0 : this.buffer.length - this.index);
        if (n > 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, this.index, byArray, 0, n);
            XPCOM.memmove(l, byArray, (long)n);
            this.index += n;
        }
        XPCOM.memmove(l3, new int[]{n}, 4L);
        return 0L;
    }

    long ReadSegments(long l, long l2, long l3, long l4) {
        int n;
        int n2 = n = Math.min((int)l3, this.buffer == null ? 0 : this.buffer.length - this.index);
        while (n2 > 0) {
            int[] nArray = new int[1];
            long l5 = XPCOM.Call(l, this.getAddress(), l2, this.buffer, this.index, n2, nArray);
            if (l5 != 0L) break;
            this.index += nArray[0];
            n2 -= nArray[0];
        }
        XPCOM.memmove(l4, new int[]{n - n2}, 4L);
        return 0L;
    }

    long IsNonBlocking(long l) {
        XPCOM.memmove(l, new int[1], 4L);
        return 0L;
    }
}

