/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell parent) {
        this(parent, 32768);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] result = new FontData[]{this.fontData};
        return result;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        boolean success;
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        long handle = OS.gtk_font_selection_dialog_new(titleBytes);
        if (this.parent != null) {
            long shellHandle = this.parent.topHandle();
            OS.gtk_window_set_transient_for(handle, shellHandle);
            long pixbufs = OS.gtk_window_get_icon_list(shellHandle);
            if (pixbufs != 0L) {
                OS.gtk_window_set_icon_list(handle, pixbufs);
                OS.g_list_free(pixbufs);
            }
        }
        if (this.fontData != null) {
            Display display = this.parent != null ? this.parent.display : Display.getCurrent();
            Font font = new Font((Device)display, this.fontData);
            long fontName = OS.pango_font_description_to_string(font.handle);
            int length = OS.strlen(fontName);
            byte[] buffer = new byte[length + 1];
            OS.memmove(buffer, fontName, (long)length);
            font.dispose();
            OS.g_free(fontName);
            OS.gtk_font_selection_dialog_set_font_name(handle, buffer);
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        int response = OS.gtk_dialog_run(handle);
        boolean bl = success = response == -5;
        if (success) {
            long fontName = OS.gtk_font_selection_dialog_get_font_name(handle);
            int length = OS.strlen(fontName);
            byte[] buffer = new byte[length + 1];
            OS.memmove(buffer, fontName, (long)length);
            OS.g_free(fontName);
            long fontDesc = OS.pango_font_description_from_string(buffer);
            Font font = Font.gtk_new(display, fontDesc);
            this.fontData = font.getFontData()[0];
            OS.pango_font_description_free(fontDesc);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(handle);
        if (!success) {
            return null;
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

