/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    int x;
    int y;
    boolean hasLocation;
    MenuItem cascade;
    MenuItem selectedItem;
    Decorations parent;
    long imItem;
    long imSeparator;
    long imHandle;
    ImageList imageList;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).menuShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    public void _setVisible(boolean visible) {
        if (visible == OS.GTK_WIDGET_MAPPED(this.handle)) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.getItemCount() != 0) {
                long address = this.hasLocation ? this.display.menuPositionProc : 0L;
                OS.gtk_menu_popup(this.handle, 0L, 0L, address, 0L, 0, this.display.getLastEventTime());
            } else {
                this.sendEvent(23);
            }
        } else {
            OS.gtk_menu_popdown(this.handle);
        }
    }

    void addAccelerators(long accelGroup) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.addAccelerators(accelGroup);
            ++i;
        }
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    void createHandle(int index) {
        this.state |= 8;
        if ((this.style & 2) != 0) {
            this.handle = OS.gtk_menu_bar_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            long parentHandle = this.parent.fixedHandle;
            OS.gtk_container_add(parentHandle, this.handle);
        } else {
            this.handle = OS.gtk_menu_new();
            if (this.handle == 0L) {
                this.error(2);
            }
        }
    }

    void createIMMenu(long imHandle) {
        if (this.imHandle == imHandle) {
            return;
        }
        this.imHandle = imHandle;
        if (imHandle == 0L) {
            if (this.imItem != 0L) {
                OS.gtk_widget_destroy(this.imItem);
                this.imItem = 0L;
            }
            if (this.imSeparator != 0L) {
                OS.gtk_widget_destroy(this.imSeparator);
                this.imSeparator = 0L;
            }
            return;
        }
        if (this.imSeparator == 0L) {
            this.imSeparator = OS.gtk_separator_menu_item_new();
            OS.gtk_widget_show(this.imSeparator);
            OS.gtk_menu_shell_insert(this.handle, this.imSeparator, -1);
        }
        if (this.imItem == 0L) {
            byte[] buffer = Converter.wcsToMbcs(null, SWT.getMessage("SWT_InputMethods"), true);
            this.imItem = OS.gtk_image_menu_item_new_with_label(buffer);
            OS.gtk_widget_show(this.imItem);
            OS.gtk_menu_shell_insert(this.handle, this.imItem, -1);
        }
        long imSubmenu = OS.gtk_menu_new();
        OS.gtk_im_multicontext_append_menuitems(imHandle, imSubmenu);
        OS.gtk_menu_item_set_submenu(this.imItem, imSubmenu);
    }

    void createWidget(int index) {
        this.checkOrientation(this.parent);
        super.createWidget(index);
        this.parent.add(this);
    }

    void fixMenus(Decorations newParent) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].fixMenus(newParent);
            ++i;
        }
        this.parent.remove(this);
        newParent.add(this);
        this.parent = newParent;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (!OS.GTK_WIDGET_MAPPED(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        long window = OS.GTK_WIDGET_WINDOW(this.handle);
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        OS.gdk_window_get_origin(window, origin_x, origin_y);
        int x = origin_x[0] + OS.GTK_WIDGET_X(this.handle);
        int y = origin_y[0] + OS.GTK_WIDGET_Y(this.handle);
        int width = OS.GTK_WIDGET_WIDTH(this.handle);
        int height = OS.GTK_WIDGET_HEIGHT(this.handle);
        return new Rectangle(x, y, width, height);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.GTK_WIDGET_SENSITIVE(this.handle);
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        long list = OS.gtk_container_get_children(this.handle);
        if (list == 0L) {
            this.error(8);
        }
        int count = OS.g_list_length(list);
        if (this.imSeparator != 0L) {
            --count;
        }
        if (this.imItem != 0L) {
            --count;
        }
        if (index < 0 || index >= count) {
            this.error(6);
        }
        long data = OS.g_list_nth_data(list, index);
        OS.g_list_free(list);
        if (data == 0L) {
            this.error(8);
        }
        return (MenuItem)this.display.getWidget(data);
    }

    public int getItemCount() {
        this.checkWidget();
        long list = OS.gtk_container_get_children(this.handle);
        if (list == 0L) {
            return 0;
        }
        int count = OS.g_list_length(list);
        OS.g_list_free(list);
        if (this.imSeparator != 0L) {
            --count;
        }
        if (this.imItem != 0L) {
            --count;
        }
        return count;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        long list = OS.gtk_container_get_children(this.handle);
        if (list == 0L) {
            return new MenuItem[0];
        }
        int count = OS.g_list_length(list);
        if (this.imSeparator != 0L) {
            --count;
        }
        if (this.imItem != 0L) {
            --count;
        }
        MenuItem[] items = new MenuItem[count];
        int i = 0;
        while (i < count) {
            long data = OS.g_list_nth_data(list, i);
            items[i] = (MenuItem)this.display.getWidget(data);
            ++i;
        }
        OS.g_list_free(list);
        return items;
    }

    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = String.valueOf(result) + items[i].getNameText() + ", ";
                ++i;
            }
            result = String.valueOf(result) + items[length - 1].getNameText();
        }
        return result;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade == null) {
            return null;
        }
        return this.cascade.getParent();
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        Menu[] popups;
        this.checkWidget();
        if ((this.style & 8) != 0 && (popups = this.display.popups) != null) {
            int i = 0;
            while (i < popups.length) {
                if (popups[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        return OS.GTK_WIDGET_MAPPED(this.handle);
    }

    long gtk_hide(long widget) {
        if ((this.style & 8) != 0) {
            this.display.activeShell = this.getShell();
        }
        this.sendEvent(23);
        return 0L;
    }

    long gtk_show(long widget) {
        if ((this.style & 8) != 0) {
            this.display.activeShell = this.getShell();
            return 0L;
        }
        this.sendEvent(22);
        return 0L;
    }

    long gtk_show_help(long widget, long helpType) {
        if (this.sendHelpEvent(helpType)) {
            OS.gtk_menu_shell_deactivate(this.handle);
            return 1L;
        }
        return 0L;
    }

    void hookEvents() {
        super.hookEvents();
        long windowProc2 = this.display.windowProc2;
        long windowProc3 = this.display.windowProc3;
        OS.g_signal_connect(this.handle, OS.show, windowProc2, 38L);
        OS.g_signal_connect(this.handle, OS.hide, windowProc2, 19L);
        OS.g_signal_connect(this.handle, OS.show_help, windowProc3, 39L);
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    long menuPositionProc(long menu, long x, long y, long push_in, long user_data) {
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request(menu, requisition);
        int screenHeight = OS.gdk_screen_height();
        int reqy = this.y;
        if (reqy + requisition.height > screenHeight && reqy - requisition.height >= 0) {
            reqy -= requisition.height;
        }
        int screenWidth = OS.gdk_screen_width();
        int reqx = this.x;
        if ((this.style & 0x4000000) != 0) {
            if (reqx - requisition.width >= 0) {
                reqx -= requisition.width;
            }
        } else if (reqx + requisition.width > screenWidth) {
            reqx -= requisition.width;
        }
        if (x != 0L) {
            OS.memmove(x, new int[]{reqx}, 4L);
        }
        if (y != 0L) {
            OS.memmove(y, new int[]{reqy}, 4L);
        }
        if (push_in != 0L) {
            OS.memmove(push_in, new int[]{1}, 4L);
        }
        return 0L;
    }

    void releaseChild() {
        super.releaseChild();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        } else if ((this.style & 8) != 0) {
            this.display.removePopup(this);
        }
    }

    void releaseWidget() {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            if (!item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        if (this.parent != null) {
            this.parent.remove(this);
        }
        super.releaseWidget();
        this.parent = null;
        this.cascade = null;
        this.imHandle = 0L;
        this.imSeparator = 0L;
        this.imItem = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    void removeAccelerators(long accelGroup) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.removeAccelerators(accelGroup);
            ++i;
        }
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    boolean sendHelpEvent(long helpType) {
        if (this.selectedItem != null && !this.selectedItem.isDisposed() && this.selectedItem.hooks(28)) {
            this.selectedItem.postEvent(28);
            return true;
        }
        if (this.hooks(28)) {
            this.postEvent(28);
            return true;
        }
        return this.parent.sendHelpEvent(helpType);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            OS.GTK_WIDGET_SET_FLAGS(this.handle, 512);
        } else {
            OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 512);
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = x;
        this.y = y;
        this.hasLocation = true;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    void setOrientation() {
        if ((this.parent.style & 0x4000000) != 0 && this.handle != 0L) {
            OS.gtk_widget_set_direction(this.handle, 2);
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (visible) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }
}

