/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Module;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.reportmodel.IntegerColumn;
import net.sf.statcvs.reportmodel.SimpleTextColumn;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.reports.TableReport;
import net.sf.statcvs.util.IntegerMap;

public class ModuleTableReport
implements TableReport {
    private final Repository content;
    private Table table = null;
    private final IntegerMap filesMap = new IntegerMap();
    private final IntegerMap changesMap = new IntegerMap();
    private final IntegerMap linesMap = new IntegerMap();

    public ModuleTableReport(Repository content) {
        this.content = content;
    }

    public void calculate() {
        Iterator it = this.content.getModules().values().iterator();
        while (it.hasNext()) {
            Module mod = (Module)it.next();
            Iterator files = mod.getFiles().iterator();
            while (files.hasNext()) {
                VersionedFile vf = (VersionedFile)files.next();
                this.filesMap.addInt(mod.getName(), 1);
                this.changesMap.addInt(mod.getName(), vf.getRevisions().size());
            }
            this.linesMap.addInt(mod.getName(), mod.getCurrentLinesOfCode());
        }
        this.table = new Table(Messages.getString("MODULES_TABLE_SUMMARY"));
        IntegerColumn changes = new IntegerColumn(Messages.getString("COLUMN_CHANGES"));
        IntegerColumn linesOfCode = new IntegerColumn(Messages.getString("COLUMN_LOC"));
        IntegerColumn filesCol = new IntegerColumn(Messages.getString("FILES"));
        SimpleTextColumn keys = new SimpleTextColumn(Messages.getString("COLUMN_MODULES"));
        keys.setTotal(Messages.getString("TOTALS"));
        changes.setShowPercentages(true);
        linesOfCode.setShowPercentages(true);
        this.table.addColumn(keys);
        this.table.addColumn(filesCol);
        this.table.addColumn(changes);
        this.table.addColumn(linesOfCode);
        this.table.setKeysInFirstColumn(true);
        it = this.linesMap.iteratorSortedByValueReverse();
        while (it.hasNext()) {
            Object key = it.next();
            keys.addValue(key);
            changes.addValue(this.changesMap.get(key));
            linesOfCode.addValue(this.linesMap.get(key));
            filesCol.addValue(this.filesMap.get(key));
        }
        if (this.table.getRowCount() > 1) {
            this.table.setShowTotals(true);
        }
    }

    public Table getTable() {
        return this.table;
    }
}

