/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reportmodel;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.sf.statcvs.reportmodel.HelperTimePoint;
import net.sf.statcvs.reportmodel.TimePoint;

public class TimeLine {
    private final TreeMap dataPoints = new TreeMap();
    private Date minimumDate = null;
    private int initialValue;
    private boolean hasInitialValue = false;
    private final String title;
    private final String rangeLabel;

    public TimeLine(String title, String rangeLabel) {
        this.title = title;
        this.rangeLabel = rangeLabel;
    }

    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
        this.hasInitialValue = true;
    }

    public void addTimePoint(Date date, int value) {
        this.addTimePoint(HelperTimePoint.createAbsoluteValueTimePoint(date, value));
    }

    public void addChange(Date date, int delta) {
        this.addTimePoint(HelperTimePoint.createDeltaTimePoint(date, delta));
    }

    public boolean isEmpty() {
        return this.dataPoints.size() <= 1;
    }

    public List getDataPoints() {
        int currentValue;
        ArrayList<TimePoint> result;
        if (this.hasInitialValue && this.dataPoints.size() > 0) {
            result = new ArrayList(this.dataPoints.size() + 1);
            Date beforeMinimum = new Date(this.minimumDate.getTime() - 1L);
            result.add(new TimePoint(beforeMinimum, this.initialValue, 0));
            currentValue = this.initialValue;
        } else {
            result = new ArrayList<TimePoint>(this.dataPoints.size());
            if (this.dataPoints.size() == 0) {
                return result;
            }
            HelperTimePoint firstPoint = (HelperTimePoint)this.dataPoints.get(this.dataPoints.firstKey());
            if (!firstPoint.isAbsolute()) {
                throw new IllegalStateException("The first data point must be absolute, or setInitialValue must be used");
            }
            currentValue = firstPoint.getValue();
        }
        Iterator it = this.dataPoints.values().iterator();
        while (it.hasNext()) {
            HelperTimePoint point = (HelperTimePoint)it.next();
            if (point.isAbsolute()) {
                int delta = point.getValue() - currentValue;
                result.add(new TimePoint(point.getDate(), point.getValue(), delta));
                currentValue = point.getValue();
                continue;
            }
            result.add(new TimePoint(point.getDate(), currentValue += point.getValue(), point.getValue()));
        }
        return result;
    }

    private void addTimePoint(HelperTimePoint newPoint) {
        HelperTimePoint oldPoint = (HelperTimePoint)this.dataPoints.get(newPoint.getDate());
        if (oldPoint == null) {
            if (this.minimumDate == null || newPoint.getDate().before(this.minimumDate)) {
                this.minimumDate = newPoint.getDate();
            }
        } else {
            newPoint = oldPoint.join(newPoint);
        }
        this.dataPoints.put(newPoint.getDate(), newPoint);
    }

    public String getRangeLabel() {
        return this.rangeLabel;
    }

    public String getTitle() {
        return this.title;
    }
}

