/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.SymbolicName;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.xml.CommitListXml;
import org.jdom.Element;

public class LogXmlMaker {
    private static final String[] MONTH_TWO_CHARACTERS = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    private final ReportConfig config;
    private final List commits = new ArrayList();

    public static String getAnchor(SymbolicName tag) {
        return "tag-" + tag.getName();
    }

    public static String getURL(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return LogXmlMaker.getFileName(calendar.get(1), calendar.get(2)) + ".html";
    }

    private static String getFileName(int year, int month) {
        return year + "-" + MONTH_TWO_CHARACTERS[month];
    }

    public LogXmlMaker(ReportConfig config, Collection commits) {
        this.config = config;
        Iterator it = commits.iterator();
        while (it.hasNext()) {
            Commit commit = (Commit)it.next();
            this.commits.add(commit);
        }
    }

    public Element toFile() {
        Element lg = null;
        if (!this.commits.isEmpty()) {
            lg = new CommitListXml(this.commits, this.getTags(), true).renderCommitList(this.commits);
        }
        return lg;
    }

    private List getTags() {
        ArrayList tags = new ArrayList();
        GregorianCalendar calendar = new GregorianCalendar();
        Iterator it = this.config.getRepository().getSymbolicNames().iterator();
        while (it.hasNext()) {
            SymbolicName tag = (SymbolicName)it.next();
            calendar.setTime(tag.getDate());
        }
        Collections.reverse(tags);
        return tags;
    }
}

