/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages.xml;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.renderer.XMLRenderer;
import net.sf.statcvs.reportmodel.Column;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.reports.FileTypeReport;
import net.sf.statcvs.reports.FilesWithMostRevisionsTableReport;
import net.sf.statcvs.reports.LargestFilesTableReport;
import org.jdom.Element;

public class FilesXml {
    private static final NumberFormat[] DOUBLE_FORMATS = new NumberFormat[]{new DecimalFormat("0"), new DecimalFormat("0.0"), new DecimalFormat("0.00"), new DecimalFormat("0.000"), new DecimalFormat("0.0000")};
    private static final int NO_OF_COLS_IN_EXT_TABLE = 4;
    private static final int NO_OF_COLS_IN_LARG_TABLE = 4;
    private static final int MAX_LARGEST_FILES = 40;
    private Table table;
    private final XMLRenderer renderer = new XMLRenderer();
    private final ReportConfig config;
    private final Repository repository;

    public FilesXml(ReportConfig config) {
        this.config = config;
        this.repository = config.getRepository();
    }

    public Element toFile() {
        Element fileStats = new Element("FileStats");
        Element summ = new Element("Summary");
        summ.addContent(new Element("TotalFiles").setText(Integer.toString(this.getCurrentFileCount())));
        summ.addContent(new Element("AvgFileSize").setText(DOUBLE_FORMATS[1].format(this.getCurrentAverageFileSize()) + " lines"));
        summ.addContent(new Element("AvgRevisionsPerFile").setText(Double.toString(this.getCurrentAverageRevisionCount())));
        fileStats.addContent(summ);
        fileStats.addContent(this.fileExts());
        fileStats.addContent(this.largestFiles());
        fileStats.addContent(this.mostRevs());
        return fileStats;
    }

    private Element fileExts() {
        Element ele = new Element("Extensions");
        FileTypeReport tr = new FileTypeReport(this.config);
        tr.calculate();
        this.table = tr.getTable();
        String[] str = new String[4];
        for (int j = 0; j < this.table.getRowCount(); ++j) {
            Element col = null;
            int i = 0;
            Iterator it = this.table.getColumnIterator();
            Iterator itr = this.table.getColumnIterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                column.renderHead(this.renderer);
                str[i] = this.renderer.getColumnHead();
                if (i == 0) {
                    col = new Element(str[i]);
                } else {
                    col.addContent(new Element(str[i]));
                }
                ++i;
            }
            boolean isFirstColumn = true;
            int k = 0;
            while (itr.hasNext()) {
                Column column = (Column)itr.next();
                column.renderCell(j, this.renderer);
                if (isFirstColumn && this.table.hasKeysInFirstColumn()) {
                    col.setAttribute("ext", this.renderer.getRowHead().toLowerCase());
                    isFirstColumn = false;
                } else {
                    col.getChild(str[k]).setText(this.renderer.getTableCell());
                }
                ++k;
            }
            ele.addContent(col);
        }
        return ele;
    }

    public Element largestFiles() {
        Element larg = new Element("LargestFiles");
        LargestFilesTableReport largestFilesTable = new LargestFilesTableReport(this.config, this.repository.getFiles(), 40);
        largestFilesTable.calculate();
        this.table = largestFilesTable.getTable();
        String[] str = new String[4];
        for (int j = 0; j < this.table.getRowCount(); ++j) {
            Element col = null;
            int i = 0;
            Iterator it = this.table.getColumnIterator();
            Iterator itr = this.table.getColumnIterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                column.renderHead(this.renderer);
                str[i] = this.renderer.getColumnHead();
                if (i == 0) {
                    col = new Element(str[i]);
                } else {
                    str[i] = this.renderer.getColumnHead().replaceAll(" ", "_");
                }
                ++i;
            }
            boolean isFirstColumn = true;
            int k = 0;
            while (itr.hasNext()) {
                Column column = (Column)itr.next();
                column.renderCell(j, this.renderer);
                if (isFirstColumn && this.table.hasKeysInFirstColumn()) {
                    col.setText(this.renderer.getRowHead());
                    isFirstColumn = false;
                } else {
                    col.setAttribute(str[k].toLowerCase(), this.renderer.getTableCell());
                }
                ++k;
            }
            larg.addContent(col);
        }
        return larg;
    }

    public Element mostRevs() {
        Element revs = new Element("MostRevisions");
        FilesWithMostRevisionsTableReport mostRevs = new FilesWithMostRevisionsTableReport(this.config, this.repository.getFiles(), 40);
        mostRevs.calculate();
        this.table = mostRevs.getTable();
        String[] str = new String[4];
        for (int j = 0; j < this.table.getRowCount(); ++j) {
            Element col = null;
            int i = 0;
            Iterator it = this.table.getColumnIterator();
            Iterator itr = this.table.getColumnIterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                column.renderHead(this.renderer);
                if (i == 0) {
                    str[i] = this.renderer.getColumnHead();
                    col = new Element(str[i]);
                } else {
                    str[i] = this.renderer.getColumnHead().replaceAll(" ", "_");
                }
                ++i;
            }
            boolean isFirstColumn = true;
            int k = 0;
            while (itr.hasNext()) {
                Column column = (Column)itr.next();
                column.renderCell(j, this.renderer);
                if (isFirstColumn && this.table.hasKeysInFirstColumn()) {
                    col.setText(this.renderer.getRowHead());
                    isFirstColumn = false;
                } else {
                    col.setAttribute(str[k].toLowerCase(), this.renderer.getTableCell());
                }
                ++k;
            }
            revs.addContent(col);
        }
        return revs;
    }

    private int getCurrentFileCount() {
        int result = 0;
        Iterator it = this.repository.getFiles().iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            if (file.isDead()) continue;
            ++result;
        }
        return result;
    }

    private double getCurrentAverageFileSize() {
        return (double)this.repository.getCurrentLOC() / (double)this.getCurrentFileCount();
    }

    private double getCurrentAverageRevisionCount() {
        int revisions = 0;
        Iterator it = this.repository.getFiles().iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            if (file.isDead()) continue;
            revisions += file.getRevisions().size();
        }
        return (double)revisions / (double)this.getCurrentFileCount();
    }
}

