/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.pages.AbstractMarkup;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.pages.MarkupSyntax;

public class MarkupXDoc
extends AbstractMarkup
implements MarkupSyntax {
    private static final MarkupSyntax instance = new MarkupXDoc();

    public static MarkupSyntax getInstance() {
        return instance;
    }

    private MarkupXDoc() {
    }

    public String getEndOfPage() {
        return "</body>\n</document>";
    }

    public String getExtension() {
        return "xml";
    }

    public String getHeader(String pageName, String stylesheetURL, String charSet) {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        b.append("<document xmlns:lxslt=\"http://xml.apache.org/xslt\">\n");
        b.append("<properties><title>");
        b.append(pageName);
        b.append("</title></properties>\n");
        b.append("<head>");
        b.append("    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
        b.append(charSet);
        b.append("\"/>\n");
        b.append("    <meta name=\"Generator\" content=\"StatCVS 0.7.0\"/>\n");
        b.append("   <link rel=\"stylesheet\" href=\"");
        b.append(HTML.escape(stylesheetURL));
        b.append("\" type=\"text/css\"/>\n");
        if (ConfigurationOptions.isEnableTwitterButton()) {
            this.addTwitterScript(b);
        }
        b.append("</head>\n\n<body>");
        return b.toString();
    }

    public String startSection1(String title) {
        return "<section name=\"" + title + "\">\n";
    }

    public String endSection1() {
        return "</section>";
    }

    public String startSection2(String title) {
        return "\n<div class=\"section\">\n<subsection name =\"" + title + "\">\n";
    }

    public String startSection2(String title, String id) {
        return "\n<div id=\"" + HTML.escape(id) + "\" class=\"section\">\n<subsection name =\"" + title + "\">\n";
    }

    public String endSection2() {
        return "</subsection></div>";
    }

    public String getTableFormat() {
        return " class=\"statCvsTable\"";
    }

    public String toString() {
        return "XDoc";
    }
}

