/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.SymbolicName;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.CommitListFormatter;
import net.sf.statcvs.pages.NavigationNode;
import net.sf.statcvs.pages.Page;

public class CommitLogPageMaker {
    private static final String[] MONTH_TWO_CHARACTERS = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    private static final String[] MONTH_NAME = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private final ReportConfig config;
    private final int year;
    private final int month;
    private final boolean firstLogPage;
    private final List commits = new ArrayList();

    public static String getAnchor(SymbolicName tag) {
        return "tag-" + tag.getName().replace('.', '_');
    }

    public static String getURL(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return CommitLogPageMaker.getFileName(calendar.get(1), calendar.get(2)) + ".html";
    }

    private static String getFileName(int year, int month) {
        return year + "-" + MONTH_TWO_CHARACTERS[month];
    }

    public CommitLogPageMaker(ReportConfig config, int year, int month, Collection commits, boolean firstLogPage) {
        this.config = config;
        this.year = year;
        this.month = month;
        this.firstLogPage = firstLogPage;
        GregorianCalendar calendar = new GregorianCalendar();
        Iterator it = commits.iterator();
        while (it.hasNext()) {
            Commit commit = (Commit)it.next();
            calendar.setTime(commit.getDate());
            if (calendar.get(1) != year || calendar.get(2) != month) continue;
            this.commits.add(commit);
        }
    }

    public NavigationNode toFile() {
        Page result = this.config.createPage(this.getFileName(), this.getTitle(), this.getTitle() + " Commit Log");
        result.addAttribute("Number of Commits", this.commits.size());
        result.addAttribute("Number of Active Developers", this.countActiveDevelopers());
        if (!this.commits.isEmpty()) {
            result.addRawContent(new CommitListFormatter(this.config, this.commits, this.getTags(), true).render());
        }
        return result;
    }

    private String getFileName() {
        if (!this.firstLogPage) {
            return CommitLogPageMaker.getFileName(this.year, this.month);
        }
        return "commitlog";
    }

    private String getTitle() {
        return MONTH_NAME[this.month] + " " + this.year;
    }

    private int countActiveDevelopers() {
        HashSet<Author> developers = new HashSet<Author>();
        Iterator it = this.commits.iterator();
        while (it.hasNext()) {
            Commit commit = (Commit)it.next();
            developers.add(commit.getAuthor());
        }
        return developers.size();
    }

    private List getTags() {
        ArrayList<SymbolicName> tags = new ArrayList<SymbolicName>();
        GregorianCalendar calendar = new GregorianCalendar();
        Iterator it = this.config.getRepository().getSymbolicNames().iterator();
        while (it.hasNext()) {
            SymbolicName tag = (SymbolicName)it.next();
            calendar.setTime(tag.getDate());
            if (calendar.get(1) != this.year || calendar.get(2) != this.month) continue;
            tags.add(tag);
        }
        Collections.reverse(tags);
        return tags;
    }
}

