/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.CommitLogPageMaker;
import net.sf.statcvs.pages.NavigationNode;
import net.sf.statcvs.pages.PageGroup;

public class CommitLogPageGroupMaker {
    private final ReportConfig config;
    private final Repository repository;

    public CommitLogPageGroupMaker(ReportConfig config) {
        this.config = config;
        this.repository = config.getRepository();
    }

    public PageGroup getPages() {
        PageGroup pages = new PageGroup("Commit Logs");
        List commits = this.repository.getCommits();
        if (commits == null || commits.isEmpty()) {
            return null;
        }
        Date start = this.repository.getFirstDate();
        Date end = this.repository.getLastDate();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(end);
        GregorianCalendar startCal = new GregorianCalendar();
        startCal.setTime(start);
        ArrayList<NavigationNode> results = new ArrayList<NavigationNode>();
        boolean firstPage = true;
        while (true) {
            int year = calendar.get(1);
            int month = calendar.get(2);
            NavigationNode page = new CommitLogPageMaker(this.config, year, month, commits, firstPage).toFile();
            results.add(page);
            if (calendar.get(1) == startCal.get(1) && calendar.get(2) == startCal.get(2)) break;
            firstPage = false;
            ((Calendar)calendar).add(2, -1);
        }
        Iterator it = results.iterator();
        while (it.hasNext()) {
            pages.add((NavigationNode)it.next());
        }
        pages.setShowLinkToPreviousSibling(true);
        return pages;
    }
}

