/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.util.Set;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.WebRepositoryIntegration;

public class JCVSWebIntegration
implements WebRepositoryIntegration {
    private String baseURL;

    public JCVSWebIntegration(String baseURL) {
        this.baseURL = baseURL.endsWith("/") ? baseURL.substring(0, baseURL.length() - 1) : baseURL;
    }

    public String getName() {
        return "JCVSWeb";
    }

    public String getDirectoryUrl(Directory directory) {
        String path = this.baseURL + "/list/" + directory.getPath();
        return path;
    }

    public String getFileHistoryUrl(VersionedFile file) {
        return this.baseURL + "/vers/" + file.getFilenameWithPath();
    }

    public String getFileViewUrl(VersionedFile file) {
        return this.baseURL + "/view/" + file.getFilenameWithPath() + "/" + file.getLatestRevision().getRevisionNumber();
    }

    public String getFileViewUrl(Revision revision) {
        return this.baseURL + "/view/" + revision.getFile().getFilenameWithPath() + "/" + revision.getRevisionNumber();
    }

    public String getDiffUrl(Revision oldRevision, Revision newRevision) {
        return this.baseURL + "/pdiff/" + newRevision.getFile().getFilenameWithPath() + "/" + oldRevision.getRevisionNumber() + "/" + newRevision.getRevisionNumber();
    }

    public void setAtticFileNames(Set atticFileNames) {
    }

    public String getBaseUrl() {
        return this.baseURL;
    }
}

