/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Module;
import net.sf.statcvs.model.Revision;

public class VersionedFile
implements Comparable {
    private final String filename;
    private final SortedSet revisions = new TreeSet();
    private final Directory directory;
    private Module module;
    private final Set authors = new HashSet();

    public VersionedFile(String name, Directory directory) {
        this.filename = name;
        this.directory = directory;
        if (directory != null) {
            directory.addFile(this);
        }
    }

    public Set getAuthors() {
        return this.authors;
    }

    public String getFilenameWithPath() {
        return this.filename;
    }

    public String getFilename() {
        int lastDelim = this.filename.lastIndexOf("/");
        return this.filename.substring(lastDelim + 1, this.filename.length());
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Revision getLatestRevision() {
        return (Revision)this.revisions.last();
    }

    public Revision getInitialRevision() {
        return (Revision)this.revisions.first();
    }

    public SortedSet getRevisions() {
        return this.revisions;
    }

    public int getCurrentLinesOfCode() {
        return this.getLatestRevision().getLines();
    }

    public boolean isDead() {
        return this.getLatestRevision().isDead();
    }

    public boolean hasAuthor(Author author) {
        return this.authors.contains(author);
    }

    public Revision getPreviousRevision(Revision revision) {
        if (!this.revisions.contains(revision)) {
            throw new IllegalArgumentException("revision not containted in file");
        }
        SortedSet<Revision> headSet = this.revisions.headSet(revision);
        if (headSet.isEmpty()) {
            return null;
        }
        return headSet.last();
    }

    public String toString() {
        return this.getFilenameWithPath() + " (" + this.revisions.size() + " revisions)";
    }

    public int compareTo(Object other) {
        return this.filename.compareTo(((VersionedFile)other).filename);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof VersionedFile)) {
            return false;
        }
        VersionedFile that = (VersionedFile)rhs;
        boolean eq = this.filename.equals(that.filename);
        return eq;
    }

    public int hashCode() {
        return this.filename.hashCode();
    }

    public Revision addInitialRevision(String revisionNumber, Author author, Date date, String comment, int lines, SortedSet symbolicNames) {
        Revision result = new Revision(this, revisionNumber, 1, author, date, comment, lines, lines, 0, symbolicNames);
        this.addRevision(result);
        return result;
    }

    public Revision addChangeRevision(String revisionNumber, Author author, Date date, String comment, int lines, int linesDelta, int replacedLines, SortedSet symbolicNames) {
        Revision result = new Revision(this, revisionNumber, 2, author, date, comment, lines, linesDelta, replacedLines, symbolicNames);
        this.addRevision(result);
        return result;
    }

    public Revision addDeletionRevision(String revisionNumber, Author author, Date date, String comment, int lines, SortedSet symbolicNames) {
        Revision result = new Revision(this, revisionNumber, 3, author, date, comment, 0, -lines, 0, symbolicNames);
        this.addRevision(result);
        return result;
    }

    public Revision addBeginOfLogRevision(Date date, int lines, SortedSet symbolicNames) {
        Revision result = new Revision(this, "0.0", 5, null, date, null, lines, 0, 0, symbolicNames);
        this.addRevision(result);
        return result;
    }

    private void addRevision(Revision revision) {
        this.revisions.add(revision);
        if (revision.getAuthor() != null) {
            this.authors.add(revision.getAuthor());
        }
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }
}

