/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.model;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Module;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.SymbolicName;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.util.FilePatternMatcher;
import net.sf.statcvs.util.ModuleUtil;

public class Repository {
    private final SortedSet files = new TreeSet();
    private final SortedSet authors = new TreeSet();
    private final SortedSet revisions = new TreeSet();
    private final SortedMap modules = new TreeMap();
    private Directory root = null;
    private Date firstDate = null;
    private Date lastDate = null;
    private List commits;
    private SortedSet symbolicNames = new TreeSet();
    private final SymbolicName head = new SymbolicName("@");

    public void addFile(VersionedFile file) {
        this.files.add(file);
        Iterator it = file.getRevisions().iterator();
        while (it.hasNext()) {
            Revision revision = (Revision)it.next();
            this.revisions.add(revision);
            if (revision.getAuthor() != null) {
                this.authors.add(revision.getAuthor());
            }
            this.adjustStartAndEndDate(revision.getDate());
        }
        if (this.root == null) {
            this.initRoot();
        }
        if (!file.isDead()) {
            this.head.addRevision(file.getLatestRevision());
        }
        if (ModuleUtil.modulesPresent()) {
            this.addToModule(file);
        }
    }

    private void addToModule(VersionedFile file) {
        Module module;
        List moduleIds = ModuleUtil.getConfigModules();
        Iterator mod = moduleIds.iterator();
        String modName = null;
        while (mod.hasNext() && modName == null) {
            String moduleId = (String)mod.next();
            String pattern = ModuleUtil.getConfigModuleRegexp(moduleId);
            String name = ModuleUtil.getConfigModuleName(moduleId);
            FilePatternMatcher fpm = new FilePatternMatcher(pattern);
            if (!fpm.matches(file.getFilenameWithPath())) continue;
            modName = name;
        }
        if (modName == null) {
            modName = Messages.getString("PIE_MODSIZE_OTHER");
        }
        if ((module = (Module)this.modules.get(modName)) == null) {
            module = new Module(modName);
            this.modules.put(modName, module);
        }
        module.addFile(file);
        file.setModule(module);
    }

    public void setCommits(List commits) {
        this.commits = commits;
    }

    public List getCommits() {
        return this.commits;
    }

    public Date getLastDate() {
        return this.lastDate;
    }

    public Date getFirstDate() {
        return this.firstDate;
    }

    public int getCurrentLOC() {
        int result = 0;
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            result += file.getCurrentLinesOfCode();
        }
        return result;
    }

    public SortedSet getFiles() {
        return this.files;
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    public SortedSet getRevisions() {
        return this.revisions;
    }

    public SortedSet getDirectories() {
        return this.getRoot().getSubdirectoriesRecursive();
    }

    public Directory getRoot() {
        return this.root;
    }

    public void setSymbolicNames(SortedSet symbolicNames) {
        this.symbolicNames = symbolicNames;
    }

    public SortedSet getSymbolicNames() {
        return this.symbolicNames;
    }

    public SymbolicName getHead() {
        return this.head;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator it = this.files.iterator();
        VersionedFile cf = null;
        while (it.hasNext()) {
            cf = (VersionedFile)it.next();
            result.append(cf.toString()).append("\n");
        }
        return result.toString();
    }

    public SortedSet getAuthors() {
        return this.authors;
    }

    private void initRoot() {
        if (this.files.isEmpty()) {
            return;
        }
        VersionedFile file = (VersionedFile)this.files.first();
        Directory dir = file.getDirectory();
        while (!dir.isRoot()) {
            dir = dir.getParent();
        }
        this.root = dir;
    }

    private void adjustStartAndEndDate(Date revisionDate) {
        if (revisionDate == null) {
            return;
        }
        if (this.firstDate == null || this.firstDate.compareTo(revisionDate) > 0) {
            this.firstDate = revisionDate;
        }
        if (this.lastDate == null || this.lastDate.compareTo(revisionDate) < 0) {
            this.lastDate = revisionDate;
        }
    }

    public SortedMap getModules() {
        return this.modules;
    }
}

