/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.ant;

import java.io.IOException;
import net.sf.statcvs.Main;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.output.ConfigurationException;
import net.sf.statcvs.output.ConfigurationOptions;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class StatCvsTask
extends Task {
    private String title;
    private String logFile;
    private String pDir;
    private String outDir;
    private String cssFile;
    private String notesFile;
    private String viewcvs;
    private String viewvc;
    private String cvsweb;
    private String chora;
    private String jcvsweb;
    private String bugzilla;
    private String mantis;
    private String include = null;
    private String exclude = null;
    private String tags;
    private String format;
    private String nonDeveloperLogin;
    private String charset;
    private String configFile;
    private boolean disableTwitterButton = false;

    public void execute() throws BuildException {
        try {
            this.initProperties();
            Main.generateDefaultHTMLSuite();
        }
        catch (ConfigurationException e) {
            throw new BuildException(e.getMessage());
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage());
        }
        catch (LogSyntaxException e) {
            throw new BuildException(e.getMessage());
        }
    }

    protected void initProperties() throws ConfigurationException {
        ConfigurationOptions.setLogFileName(this.logFile);
        ConfigurationOptions.setCheckedOutDirectory(this.pDir);
        if (this.title != null) {
            ConfigurationOptions.setProjectName(this.title);
        }
        if (this.outDir != null) {
            ConfigurationOptions.setOutputDir(this.outDir);
        }
        if (this.cssFile != null) {
            ConfigurationOptions.setCssFile(this.cssFile);
        }
        if (this.notesFile != null) {
            ConfigurationOptions.setNotesFile(this.notesFile);
        }
        if (this.viewcvs != null) {
            ConfigurationOptions.setViewCvsURL(this.viewcvs);
        }
        if (this.viewvc != null) {
            ConfigurationOptions.setViewVcURL(this.viewvc);
        }
        if (this.cvsweb != null) {
            ConfigurationOptions.setCvswebURL(this.cvsweb);
        }
        if (this.chora != null) {
            ConfigurationOptions.setChoraURL(this.chora);
        }
        if (this.jcvsweb != null) {
            ConfigurationOptions.setJCVSWebURL(this.jcvsweb);
        }
        if (this.bugzilla != null) {
            ConfigurationOptions.setBugzillaUrl(this.bugzilla);
        }
        if (this.mantis != null) {
            ConfigurationOptions.setMantisUrl(this.mantis);
        }
        if (this.include != null) {
            ConfigurationOptions.setIncludePattern(this.include);
        }
        if (this.exclude != null) {
            ConfigurationOptions.setExcludePattern(this.exclude);
        }
        if (this.tags != null) {
            ConfigurationOptions.setSymbolicNamesPattern(this.tags);
        }
        if (this.format != null) {
            ConfigurationOptions.setOutputFormat(this.format);
        }
        if (this.charset != null) {
            ConfigurationOptions.setCharSet(this.charset);
        }
        if (this.nonDeveloperLogin != null) {
            ConfigurationOptions.addNonDeveloperLogin(this.nonDeveloperLogin);
        }
        if (this.configFile != null) {
            ConfigurationOptions.setConfigFile(this.configFile);
        }
        ConfigurationOptions.setEnableTwitterButton(!this.disableTwitterButton);
    }

    public void setLog(String logFile) {
        this.logFile = logFile;
    }

    public void setPath(String modDir) {
        this.pDir = modDir;
    }

    public void setOutputDir(String outDir) {
        this.outDir = outDir;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCss(String cssFile) {
        this.cssFile = cssFile;
    }

    public void setNotes(String notesFile) {
        this.notesFile = notesFile;
    }

    public void setViewCVS(String viewcvs) {
        this.viewcvs = viewcvs;
    }

    public void setViewVC(String viewvc) {
        this.viewvc = viewvc;
    }

    public void setCvsweb(String cvsweb) {
        this.cvsweb = cvsweb;
    }

    public void setChora(String chora) {
        this.chora = chora;
    }

    public void setJCVSWeb(String jcvsweb) {
        this.jcvsweb = jcvsweb;
    }

    public void setBugzilla(String bugzilla) {
        this.bugzilla = bugzilla;
    }

    public void setMantis(String mantis) {
        this.mantis = mantis;
    }

    public void setXDoc(boolean generateXDoc) {
        this.format = generateXDoc ? "xdoc" : "html";
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setNoDeveloper(String nonDeveloperLogin) {
        this.nonDeveloperLogin = nonDeveloperLogin;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setDisableTwitterButton(boolean disableTwitterButton) {
        this.disableTwitterButton = disableTwitterButton;
    }
}

