/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui.toolbar;

import chrriis.udoc.ui.ClassPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public abstract class ToolBarMenu
extends JLabel
implements ItemSelectable {
    protected static final Color TOOLTIP_FOREGROUND_COLOR = new Color(74, 42, 167);
    protected boolean isOn;
    protected boolean isOver;
    protected ClassPane classPane;
    protected Icon iconOn;
    protected Icon iconOff;
    static /* synthetic */ Class class$0;

    protected ToolBarMenu(Icon iconOn, Icon iconOff, ClassPane classPane) {
        super(iconOff);
        this.iconOn = iconOn;
        this.iconOff = iconOff;
        this.classPane = classPane;
        this.setBackground(this.getSelectionColor());
        this.setHorizontalAlignment(0);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) != 0 || (modifiers & 8) != 0 || (modifiers & 4) != 0) {
                    return;
                }
                ToolBarMenu.this.isOver = true;
                ToolBarMenu.this.setCursor(Cursor.getPredefinedCursor(12));
                ToolBarMenu.this.setOpaque(true);
                if (!ToolBarMenu.this.isOn) {
                    ToolBarMenu.this.setToolTipVisible(e, true);
                }
                ToolBarMenu.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                ToolBarMenu.this.isOver = false;
                ToolBarMenu.this.setCursor(null);
                ToolBarMenu.this.setOpaque(ToolBarMenu.this.isOn);
                if (!ToolBarMenu.this.isOn) {
                    ToolBarMenu.this.setToolTipVisible(e, false);
                }
                ToolBarMenu.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                ToolBarMenu.this.setOn(!ToolBarMenu.this.isOn);
                if (!ToolBarMenu.this.isOn) {
                    ToolBarMenu.this.setToolTipVisible(e, true);
                }
            }
        });
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ToolBarMenu.this.classPane.closeMenus();
                if (e.getStateChange() == 1) {
                    JPanel contentPane = new JPanel(new BorderLayout(0, 0));
                    String title = ToolBarMenu.this.getContentTitle();
                    if (title != null && title.length() > 0) {
                        JLabel titleLabel = new JLabel(title);
                        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
                        titleLabel.setHorizontalAlignment(0);
                        titleLabel.setBorder(UIManager.getBorder("TextField.border"));
                        titleLabel.setBackground(ToolBarMenu.this.getSelectionColor());
                        titleLabel.setOpaque(true);
                        contentPane.add((Component)titleLabel, "North");
                    }
                    Component popupMenuContent = ToolBarMenu.this.createPopupMenuContent();
                    contentPane.add(popupMenuContent, "South");
                    ToolBarMenu.this.addMenu(contentPane);
                    popupMenuContent.requestFocus();
                }
            }
        });
    }

    protected void setToolTipVisible(MouseEvent e, boolean isVisible) {
        if (isVisible) {
            String title = this.getContentTitle();
            if (title != null && title.length() > 0) {
                JLabel titleLabel = new JLabel(title);
                titleLabel.setForeground(TOOLTIP_FOREGROUND_COLOR);
                titleLabel.setOpaque(true);
                titleLabel.setBackground(this.classPane.getClassComponentPane().getBackground());
                this.classPane.showTooltip(titleLabel, this, (this.getWidth() - titleLabel.getPreferredSize().width) / 2, this.getHeight() + 20);
            }
            return;
        }
        this.classPane.hideTooltip();
    }

    protected void addMenu(JComponent content) {
        JPanel contentPane = new JPanel(new BorderLayout(0, 0)){
            boolean isExpanded;

            public void invalidate() {
                super.invalidate();
                if (this.isExpanded) {
                    this.validate();
                }
            }

            public void validate() {
                this.setSize(this.getPreferredSize());
                super.validate();
            }

            public void hide() {
                super.hide();
                ToolBarMenu.this.setOn(false);
            }

            public void reshape(int x, int y, int w, int h) {
                super.reshape(x, y, w, h);
                Dimension preferredSize = this.getPreferredSize();
                this.isExpanded = w == preferredSize.width && h == preferredSize.height;
            }
        };
        content.addMouseListener(new MouseAdapter(){});
        contentPane.setBorder(BorderFactory.createEtchedBorder());
        contentPane.add((Component)content, "Center");
        this.classPane.showMenu(contentPane, this, 0, this.getHeight());
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray;
        if (this.isOn) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    protected void fireItemStateChanged(ItemEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.awt.event.ItemListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((ItemListener)listeners[i + 1]).itemStateChanged(event);
            }
            i -= 2;
        }
    }

    public void addItemListener(ItemListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeItemListener(ItemListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void setOn(boolean isOn) {
        if (this.isOn == isOn) {
            return;
        }
        this.isOn = isOn;
        this.setOpaque(this.isOver);
        this.setIcon(isOn ? this.iconOn : this.iconOff);
        this.fireItemStateChanged(new ItemEvent(this, 701, this, isOn ? 1 : 2));
    }

    public Dimension getPreferredSize() {
        return new Dimension(50, super.getPreferredSize().height);
    }

    protected String getContentTitle() {
        return null;
    }

    protected abstract Component createPopupMenuContent();

    protected abstract Color getSelectionColor();
}

