/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui.toolbar;

import chrriis.udoc.model.ClassInfo;
import chrriis.udoc.model.Util;
import chrriis.udoc.model.processor.ClassProcessor;
import chrriis.udoc.model.processor.ClassProcessorRegistry;
import chrriis.udoc.ui.ClassComponent;
import chrriis.udoc.ui.ClassPane;
import chrriis.udoc.ui.IconManager;
import chrriis.udoc.ui.JStateCheckBox;
import chrriis.udoc.ui.toolbar.ToolBarMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ClassesToolBarMenu
extends ToolBarMenu {
    protected static final Color SELECTION_COLOR = new Color(218, 219, 255);
    protected ClassPane classPane;
    protected boolean isAdjustingCheckBox;

    public ClassesToolBarMenu(ClassPane classPane) {
        super(IconManager.getIcon("tool_bar_on.gif"), IconManager.getIcon("tool_bar_off.gif"), classPane);
        this.classPane = classPane;
    }

    protected String getContentTitle() {
        return "Classes";
    }

    protected Color getSelectionColor() {
        return SELECTION_COLOR;
    }

    protected Component createPopupMenuContent() {
        JPanel classVisibilityPane = new JPanel(new BorderLayout(2, 2));
        classVisibilityPane.setBorder(BorderFactory.createTitledBorder("Displayed Classes"));
        GridBagLayout gridBag = new GridBagLayout();
        JPanel classAdditionPane = new JPanel(gridBag);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        JLabel classNameLabel = new JLabel("Classes: ");
        gridBag.setConstraints(classNameLabel, cons);
        classAdditionPane.add(classNameLabel);
        ++cons.gridx;
        cons.weightx = 1.0;
        cons.fill = 2;
        final JTextField classNameField = new JTextField(this.classPane.getLastClassNames(), 20);
        gridBag.setConstraints(classNameField, cons);
        classAdditionPane.add(classNameField);
        ++cons.gridx;
        cons.weightx = 0.0;
        cons.fill = 0;
        final JButton browseClassesButton = new JButton("Browse...");
        gridBag.setConstraints(browseClassesButton, cons);
        classAdditionPane.add(browseClassesButton);
        ++cons.gridx;
        JButton addClassesButton = new JButton("Add");
        gridBag.setConstraints(addClassesButton, cons);
        classAdditionPane.add(addClassesButton);
        classVisibilityPane.add((Component)classAdditionPane, "North");
        final JList<Object> list = new JList<Object>();
        list.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (!(value instanceof ClassComponent)) {
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
                ClassComponent classComponent = (ClassComponent)value;
                ClassInfo classInfo = classComponent.getClassInfo();
                String name = classInfo.getName();
                String packageName = classInfo.getPackage().getName();
                if (packageName.length() > 0) {
                    name = String.valueOf(name) + " - " + packageName;
                }
                DefaultListCellRenderer renderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
                renderer.setIcon(IconManager.getIcon((classInfo.isLoaded() ? 0 : 262144) | classInfo.getModifiers()));
                renderer.setForeground(classComponent.isVisible() ? Color.BLACK : Color.GRAY);
                return renderer;
            }
        });
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setPreferredSize(new Dimension(200, 150));
        classVisibilityPane.add((Component)scrollPane, "Center");
        JPanel southPanel = new JPanel(new FlowLayout(1, 0, 0));
        final JButton removeButton = new JButton("Remove");
        removeButton.setEnabled(false);
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object[] values = list.getSelectedValues();
                ClassComponent[] classComponents = new ClassComponent[values.length];
                System.arraycopy(values, 0, classComponents, 0, values.length);
                if (ClassesToolBarMenu.this.classPane.areClassComponentsDeletable(classComponents)) {
                    ClassesToolBarMenu.this.classPane.deleteClassComponents(classComponents);
                    int i = 0;
                    while (i < classComponents.length) {
                        ((DefaultListModel)list.getModel()).removeElement(classComponents[i]);
                        ++i;
                    }
                }
            }
        });
        southPanel.add(removeButton);
        final JStateCheckBox checkBox = new JStateCheckBox("Filtered");
        southPanel.add(checkBox);
        classVisibilityPane.add((Component)southPanel, "South");
        checkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (ClassesToolBarMenu.this.isAdjustingCheckBox) {
                    return;
                }
                boolean isFiltered = e.getStateChange() == 1;
                checkBox.setGrayed(false);
                Object[] values = list.getSelectedValues();
                ClassComponent[] classComponents = new ClassComponent[values.length];
                System.arraycopy(values, 0, classComponents, 0, values.length);
                ClassesToolBarMenu.this.classPane.setClassComponentsFiltered(classComponents, isFiltered);
            }
        });
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                boolean isVisible = false;
                boolean isInvisible = false;
                Object[] values = list.getSelectedValues();
                ClassesToolBarMenu.this.classPane.clearSelectedClassComponents();
                int i = 0;
                while (i < values.length) {
                    ClassComponent classComponent = (ClassComponent)values[i];
                    if (classComponent.isVisible()) {
                        isVisible = true;
                    } else {
                        isInvisible = true;
                    }
                    if (isVisible && isInvisible) break;
                    ClassesToolBarMenu.this.classPane.addSelectedClassComponent(classComponent);
                    ++i;
                }
                ClassesToolBarMenu.this.isAdjustingCheckBox = true;
                checkBox.setGrayed(isVisible && isInvisible);
                checkBox.setSelected(!isVisible);
                checkBox.setEnabled(values.length > 0);
                ClassesToolBarMenu.this.isAdjustingCheckBox = false;
                ClassComponent[] classComponents = new ClassComponent[values.length];
                System.arraycopy(values, 0, classComponents, 0, values.length);
                removeButton.setEnabled(ClassesToolBarMenu.this.classPane.areClassComponentsDeletable(classComponents));
            }
        });
        checkBox.setEnabled(false);
        this.adjustList(list);
        GridBagLayout gridBag2 = new GridBagLayout();
        JPanel classProcessorPane = new JPanel(gridBag2);
        classProcessorPane.setBorder(BorderFactory.createTitledBorder("Processor"));
        GridBagConstraints cons2 = new GridBagConstraints();
        cons2.insets = new Insets(1, 0, 1, 0);
        cons2.gridx = 0;
        cons2.gridy = 0;
        cons2.anchor = 17;
        JLabel classProcessorLabel = new JLabel("Type: ");
        gridBag2.setConstraints(classProcessorLabel, cons2);
        classProcessorPane.add(classProcessorLabel);
        ++cons2.gridx;
        cons2.weightx = 1.0;
        cons2.fill = 2;
        ClassProcessor[] classProcessors = ClassProcessorRegistry.getClassProcessors();
        Arrays.sort(classProcessors, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ClassProcessor)o1).getProcessorName().toLowerCase(Locale.ENGLISH).compareTo(((ClassProcessor)o2).getProcessorName().toLowerCase(Locale.ENGLISH));
            }
        });
        final JComboBox<ClassProcessor> classProcessorComboBox = new JComboBox<ClassProcessor>(classProcessors);
        classProcessorComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ClassProcessor classProcessor = (ClassProcessor)value;
                String displayedValue = classProcessor.getProcessorName();
                String description = classProcessor.getProcessorDescription();
                if (description != null) {
                    displayedValue = String.valueOf(displayedValue) + " - " + description;
                }
                return super.getListCellRendererComponent((JList<?>)list, displayedValue, index, isSelected, cellHasFocus);
            }
        });
        gridBag2.setConstraints(classProcessorComboBox, cons2);
        classProcessorPane.add(classProcessorComboBox);
        cons2.gridx = 0;
        ++cons2.gridy;
        cons2.gridwidth = 2;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassesToolBarMenu.this.classPane.addClasses(classNameField.getText(), (ClassProcessor)classProcessorComboBox.getSelectedItem());
                ClassesToolBarMenu.this.adjustList(list);
            }
        };
        classNameField.addActionListener(actionListener);
        addClassesButton.addActionListener(actionListener);
        final JPanel processorParametersPanel = new JPanel(new BorderLayout(0, 0));
        processorParametersPanel.setVisible(false);
        gridBag2.setConstraints(processorParametersPanel, cons2);
        classProcessorPane.add(processorParametersPanel);
        classProcessorComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ClassProcessor processor = (ClassProcessor)e.getItem();
                    processorParametersPanel.removeAll();
                    JComponent parametersComponent = processor.getParametersComponent();
                    if (parametersComponent != null) {
                        processorParametersPanel.add((Component)parametersComponent, "Center");
                    }
                    processorParametersPanel.setVisible(parametersComponent != null);
                    processorParametersPanel.revalidate();
                    ClassesToolBarMenu.this.repaint();
                }
            }
        });
        classProcessorComboBox.setSelectedIndex(-1);
        classProcessorComboBox.setSelectedIndex(0);
        ClassProcessor lastClassProcessor = this.classPane.getLastClassProcessor();
        if (lastClassProcessor != null) {
            classProcessorComboBox.setSelectedItem(lastClassProcessor);
        }
        JPanel classPanel = new JPanel(new BorderLayout(0, 0)){

            public void requestFocus() {
                classNameField.requestFocus();
            }
        };
        classPanel.add((Component)classVisibilityPane, "Center");
        classPanel.add((Component)classProcessorPane, "North");
        browseClassesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDialog dialog;
                ClassProcessor classProcessor = (ClassProcessor)classProcessorComboBox.getSelectedItem();
                if (classProcessor == null) {
                    return;
                }
                Window window = SwingUtilities.getWindowAncestor(ClassesToolBarMenu.this);
                if (window instanceof Frame) {
                    dialog = new JDialog((Frame)window);
                } else if (window instanceof Dialog) {
                    dialog = new JDialog((Dialog)window);
                } else {
                    return;
                }
                dialog.setTitle("Class Browser");
                Container contentPane = dialog.getContentPane();
                JTree tree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode("Classes")));
                tree.addKeyListener(new KeyAdapter(this, tree){
                    final /* synthetic */ 10 this$1;
                    private final /* synthetic */ JTree val$tree;
                    {
                        this.this$1 = var1_1;
                        this.val$tree = jTree;
                    }

                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyChar() != '*') {
                            return;
                        }
                        TreePath[] selectionPaths = this.val$tree.getSelectionPaths();
                        if (selectionPaths == null || selectionPaths.length == 0) {
                            return;
                        }
                        int i = 0;
                        while (i < this.val$tree.getRowCount()) {
                            TreePath path = this.val$tree.getPathForRow(i);
                            int j = 0;
                            while (j < selectionPaths.length) {
                                if (selectionPaths[j].isDescendant(path)) {
                                    this.val$tree.expandRow(i);
                                    break;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                });
                tree.setRootVisible(false);
                tree.setShowsRootHandles(true);
                classProcessor.loadClassBrowser(tree);
                contentPane.add((Component)new JScrollPane(tree), "Center");
                JPanel southPanel = new JPanel(new FlowLayout(1, 0, 2));
                JButton addClassesButton = new JButton("Set");
                addClassesButton.setEnabled(false);
                tree.setCellRenderer(new DefaultTreeCellRenderer(this){
                    final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                        if (tree.getModel().getRoot() == value) {
                            return renderer;
                        }
                        if (leaf) {
                            renderer.setIcon(IconManager.getIcon("tree_type.gif"));
                        } else {
                            renderer.setIcon(IconManager.getIcon("tree_package.gif"));
                        }
                        return renderer;
                    }
                });
                tree.addTreeSelectionListener(new TreeSelectionListener(this, addClassesButton, tree){
                    final /* synthetic */ 10 this$1;
                    private final /* synthetic */ JButton val$addClassesButton;
                    private final /* synthetic */ JTree val$tree;
                    {
                        this.this$1 = var1_1;
                        this.val$addClassesButton = jButton;
                        this.val$tree = jTree;
                    }

                    public void valueChanged(TreeSelectionEvent e) {
                        this.val$addClassesButton.setEnabled(false);
                        TreePath[] paths = this.val$tree.getSelectionPaths();
                        if (paths == null) {
                            return;
                        }
                        int i = 0;
                        while (i < paths.length) {
                            if (((DefaultMutableTreeNode)paths[i].getLastPathComponent()).isLeaf()) {
                                this.val$addClassesButton.setEnabled(true);
                                return;
                            }
                            ++i;
                        }
                    }
                });
                addClassesButton.addActionListener(new ActionListener(this, tree, classNameField, dialog){
                    final /* synthetic */ 10 this$1;
                    private final /* synthetic */ JTree val$tree;
                    private final /* synthetic */ JTextField val$classNameField;
                    private final /* synthetic */ JDialog val$dialog;
                    {
                        this.this$1 = var1_1;
                        this.val$tree = jTree;
                        this.val$classNameField = jTextField;
                        this.val$dialog = jDialog;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreePath[] paths = this.val$tree.getSelectionPaths();
                        StringBuffer classesSB = new StringBuffer();
                        boolean isAdded = false;
                        int i = 0;
                        while (i < paths.length) {
                            TreePath path = paths[i];
                            if (((DefaultMutableTreeNode)path.getLastPathComponent()).isLeaf()) {
                                if (isAdded) {
                                    classesSB.append(' ');
                                } else {
                                    isAdded = true;
                                }
                                Object[] objects = path.getPath();
                                int j = 1;
                                while (j < objects.length) {
                                    if (j < objects.length - 1) {
                                        classesSB.append(((DefaultMutableTreeNode)objects[j]).getUserObject()).append('.');
                                    } else {
                                        classesSB.append(Util.escapeClassName((String)((DefaultMutableTreeNode)objects[j]).getUserObject()));
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        this.val$classNameField.setText(classesSB.toString());
                        this.val$dialog.dispose();
                    }
                });
                southPanel.add(addClassesButton);
                contentPane.add((Component)southPanel, "South");
                dialog.setSize(new Dimension(300, 500));
                dialog.setLocationRelativeTo(browseClassesButton);
                dialog.setModal(true);
                dialog.setVisible(true);
            }
        });
        return classPanel;
    }

    protected void adjustList(JList list) {
        ClassComponent[] components = this.classPane.getClassComponents();
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                ClassInfo c1 = ((ClassComponent)o1).getClassInfo();
                ClassInfo c2 = ((ClassComponent)o2).getClassInfo();
                int m1 = c1.getModifiers();
                int m2 = c2.getModifiers();
                int result = 0;
                if ((m1 & 0x40) != 0) {
                    if ((m2 & 0x100) != 0) {
                        result = 1;
                    } else {
                        result = c1.getName().toLowerCase(Locale.ENGLISH).compareTo(c2.getName().toLowerCase(Locale.ENGLISH));
                        if (result == 0) {
                            result = c1.getPackage().getName().toLowerCase(Locale.ENGLISH).compareTo(c2.getPackage().getName().toLowerCase(Locale.ENGLISH));
                        }
                    }
                } else if ((m2 & 0x40) != 0) {
                    result = -1;
                } else {
                    result = c1.getName().toLowerCase(Locale.ENGLISH).compareTo(c2.getName().toLowerCase(Locale.ENGLISH));
                    if (result == 0) {
                        result = c1.getPackage().getName().toLowerCase(Locale.ENGLISH).compareTo(c2.getPackage().getName().toLowerCase(Locale.ENGLISH));
                    }
                }
                return -result;
            }
        });
        DefaultListModel<ClassComponent> model = new DefaultListModel<ClassComponent>();
        int i = components.length - 1;
        while (i >= 0) {
            model.addElement(components[i]);
            --i;
        }
        list.setModel(model);
        ClassComponent[] selectedClassComponents = this.classPane.getSelectedClassComponents();
        int[] selectedIndices = new int[selectedClassComponents.length];
        int i2 = 0;
        while (i2 < selectedClassComponents.length) {
            selectedIndices[i2] = model.indexOf(selectedClassComponents[i2]);
            ++i2;
        }
        list.setSelectedIndices(selectedIndices);
    }
}

