/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.model.processor.javadoc;

import chrriis.udoc.model.ClassInfo;
import chrriis.udoc.model.ClassInfoLoader;
import chrriis.udoc.model.FieldInfo;
import chrriis.udoc.model.MethodInfo;
import chrriis.udoc.model.PackageInfo;
import chrriis.udoc.model.URLConnectionEx;
import chrriis.udoc.model.Util;
import chrriis.udoc.model.processor.ClassProcessor;
import chrriis.udoc.model.processor.javadoc.JavadocClassInfoLoader;
import chrriis.udoc.model.processor.javadoc.JavadocParametersComponent;
import chrriis.udoc.ui.webpage.WebpageViewer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JavadocClassProcessor
extends ClassProcessor {
    protected String documentationRoot;
    protected DefaultMutableTreeNode javadocNode;

    public String getProcessorID() {
        return "JavadocClassProcessor";
    }

    public String getProcessorName() {
        return "Javadoc";
    }

    public String getProcessorDescription() {
        return "Load class diagrams from a Java documentation";
    }

    public JComponent getParametersComponent() {
        return new JavadocParametersComponent(this);
    }

    public InputStream getClassInfoDataInputStream(String className) {
        try {
            String classData;
            int lastDotIndex = className.lastIndexOf(46);
            String packageName = lastDotIndex == -1 ? "" : className.substring(0, lastDotIndex);
            String documentationRoot = JavadocClassInfoLoader.getPackageDocumentationRoot(packageName);
            if (documentationRoot == null) {
                documentationRoot = this.getDocumentationRootURI();
            }
            if ((classData = JavadocClassInfoLoader.loadClassData(className, documentationRoot)) == null) {
                return null;
            }
            return new ByteArrayInputStream(classData.getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getDocumentationRoot() {
        return this.documentationRoot;
    }

    protected String getDocumentationRootURI() {
        if (this.documentationRoot.indexOf(":/") < 0) {
            return new File(this.documentationRoot).toURI().toString();
        }
        return this.documentationRoot;
    }

    public void setDocumentationRoot(String documentationRoot) {
        this.documentationRoot = documentationRoot;
        this.javadocNode = null;
    }

    protected String getLinkRoot(PackageInfo packageInfo) {
        String packageName = packageInfo.getName();
        String link = JavadocClassInfoLoader.getPackageDocumentationRoot(packageName);
        if (link == null) {
            link = String.valueOf(this.getDocumentationRootURI()) + '/' + packageName.replace('.', '/');
        }
        return link;
    }

    protected String getLink(PackageInfo packageInfo) {
        return String.valueOf(this.getLinkRoot(packageInfo)) + "/package-summary.html";
    }

    protected String getLink(ClassInfo classInfo) {
        String packagePath = classInfo.getPackage().getName();
        if (packagePath.length() > 0) {
            packagePath = String.valueOf(packagePath.replace('.', '/')) + "/";
        }
        String docPath = String.valueOf(packagePath) + Util.unescapeClassName(classInfo.getName()) + ".html";
        String linkRoot = this.getLinkRoot(classInfo.getPackage());
        if (linkRoot != null) {
            docPath = String.valueOf(linkRoot) + "/" + docPath;
        }
        return docPath;
    }

    protected String getLink(MethodInfo methodInfo) {
        StringBuffer sb = new StringBuffer();
        FieldInfo[] parameters = methodInfo.getParameters();
        int i = 0;
        while (i < parameters.length) {
            if (i > 0) {
                sb.append(", ");
            }
            String classDeclaration = parameters[i].getClassDeclaration();
            int count = 0;
            int j = 0;
            while (j < classDeclaration.length()) {
                char c = classDeclaration.charAt(j);
                switch (c) {
                    case '<': {
                        ++count;
                        break;
                    }
                    case '>': {
                        --count;
                        break;
                    }
                    default: {
                        if (count != 0) break;
                        sb.append(c);
                    }
                }
                ++j;
            }
            ++i;
        }
        return String.valueOf(this.getLink(methodInfo.getClassInfo())) + "#" + methodInfo.getName() + "(" + sb.toString() + ")";
    }

    protected String getLink(FieldInfo fieldInfo) {
        return String.valueOf(this.getLink(fieldInfo.getClassInfo())) + "#" + fieldInfo.getName();
    }

    public void openPackage(PackageInfo packageInfo) {
        WebpageViewer.open(packageInfo.getName(), this.getLink(packageInfo));
    }

    public void openClass(ClassInfo classInfo) {
        WebpageViewer.open(classInfo.getClassName(), this.getLink(classInfo));
    }

    public void openMethod(MethodInfo methodInfo) {
        WebpageViewer.open(methodInfo.getClassInfo().getClassName(), this.getLink(methodInfo));
    }

    public void openField(FieldInfo fieldInfo) {
        WebpageViewer.open(fieldInfo.getClassInfo().getClassName(), this.getLink(fieldInfo));
    }

    public String getXMLDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("<javadocClassProcessorParameter>");
        sb.append("<documentation value=\"").append(this.documentationRoot == null ? "" : Util.escapeXML(this.documentationRoot)).append("\"/>");
        sb.append("<packages>");
        String[] packageNames = JavadocClassInfoLoader.getPackageNames();
        int i = 0;
        while (i < packageNames.length) {
            String packageName = packageNames[i];
            sb.append("<package name=\"").append(Util.escapeXML(packageName)).append("\" documentation=\"").append(Util.escapeXML(JavadocClassInfoLoader.getPackageDocumentationRoot(packageName))).append("\"/>");
            ++i;
        }
        sb.append("</packages>");
        sb.append("</javadocClassProcessorParameter>");
        return sb.toString();
    }

    public void loadXMLDescription(String xmlDescription) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(xmlDescription.getBytes("UTF-8")));
            NodeList nodeList = document.getChildNodes().item(0).getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                String name = node.getNodeName();
                if ("documentation".equals(name)) {
                    this.setDocumentationRoot(node.getAttributes().getNamedItem("value").getNodeValue());
                } else if ("packages".equals(name)) {
                    this.loadPackages(node.getChildNodes());
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadPackages(NodeList nodeList) {
        JavadocClassInfoLoader.clearPackageDocumentationRootInformation();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("package".equals(name)) {
                JavadocClassInfoLoader.setPackageDocumentationRoot(node.getAttributes().getNamedItem("name").getNodeValue(), node.getAttributes().getNamedItem("documentation").getNodeValue());
            }
            ++i;
        }
    }

    public void destroyClassInfo(ClassInfo classInfo) {
        String packageName = classInfo.getPackage().getName();
        ClassInfo[] classInfos = ClassInfoLoader.getClassInfos();
        int i = 0;
        while (i < classInfos.length) {
            ClassInfo cInfo = classInfos[i];
            if (cInfo.getClassProcessor() == this && cInfo.getPackage().getName().equals(packageName)) {
                return;
            }
            ++i;
        }
        JavadocClassInfoLoader.removePackageDocumentationRoot(packageName);
    }

    public void loadClassBrowser(final JTree tree) {
        if (this.javadocNode != null) {
            tree.setModel(new DefaultTreeModel(this.javadocNode));
            return;
        }
        final String documentationRoot = this.documentationRoot;
        final DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getModel().getRoot();
        node.removeAllChildren();
        new Thread(){

            public void run() {
                String path = String.valueOf(JavadocClassProcessor.this.getDocumentationRootURI()) + "/allclasses-frame.html";
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(URLConnectionEx.openConnection(new URL(path)).getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        if (!(line = line.trim()).startsWith("<A HREF=\"")) continue;
                        line = line.substring("<A HREF=\"".length());
                        line = line.substring(0, line.indexOf(34) - ".html".length());
                        line = line.replace("$", "$$").replace('.', '$').replace('/', '.');
                        JavadocClassProcessor.addTreeClass(line, node);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(this, documentationRoot, node, tree){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ String val$documentationRoot;
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    private final /* synthetic */ JTree val$tree;
                    {
                        this.this$1 = var1_1;
                        this.val$documentationRoot = string;
                        this.val$node = defaultMutableTreeNode;
                        this.val$tree = jTree;
                    }

                    public void run() {
                        if (this.val$documentationRoot == null ? 1.access$0(this.this$1).documentationRoot != null : !this.val$documentationRoot.equals(1.access$0(this.this$1).documentationRoot)) {
                            return;
                        }
                        1.access$0(this.this$1).javadocNode = this.val$node;
                        this.val$tree.setModel(new DefaultTreeModel(1.access$0(this.this$1).javadocNode));
                    }
                });
            }

            static /* synthetic */ JavadocClassProcessor access$0(1 var0) {
                return var0.JavadocClassProcessor.this;
            }
        }.start();
    }

    protected static void addTreeClass(String className, DefaultMutableTreeNode node) {
        int index = className.indexOf(46);
        if (index != -1) {
            String packageName = className.substring(0, index);
            int i = node.getChildCount() - 1;
            while (i >= 0) {
                int comparison;
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                String childPackageOrClassName = (String)childNode.getUserObject();
                int n = comparison = childNode.isLeaf() ? 1 : childPackageOrClassName.compareTo(packageName);
                if (comparison == 0) {
                    JavadocClassProcessor.addTreeClass(className.substring(index + 1), childNode);
                    return;
                }
                if (comparison < 0) {
                    childNode = new DefaultMutableTreeNode(packageName);
                    node.insert(childNode, i + 1);
                    JavadocClassProcessor.addTreeClass(className.substring(index + 1), childNode);
                    return;
                }
                --i;
            }
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(packageName);
            node.insert(childNode, 0);
            JavadocClassProcessor.addTreeClass(className.substring(index + 1), childNode);
            return;
        }
        int i = node.getChildCount() - 1;
        while (i >= 0) {
            int comparison;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            String childClassName = (String)childNode.getUserObject();
            int n = comparison = !childNode.isLeaf() ? -1 : childClassName.compareTo(className);
            if (comparison == 0) {
                return;
            }
            if (comparison < 0) {
                childNode = new DefaultMutableTreeNode(Util.unescapeClassName(className));
                node.insert(childNode, i + 1);
                return;
            }
            --i;
        }
        node.insert(new DefaultMutableTreeNode(Util.unescapeClassName(className)), 0);
    }
}

