/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.model;

import chrriis.udoc.model.ClassInfo;
import chrriis.udoc.model.ClassInfoLoader;
import chrriis.udoc.model.FieldInfo;
import chrriis.udoc.model.MethodInfo;
import chrriis.udoc.model.Util;
import chrriis.udoc.model.processor.ClassProcessor;
import chrriis.udoc.model.processor.ClassProcessorRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelDescriptor {
    public static String getXMLDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("<model>");
        sb.append("<classProcessors>");
        ClassProcessor[] classProcessors = ClassProcessorRegistry.getClassProcessors();
        int i = 0;
        while (i < classProcessors.length) {
            ClassProcessor classProcessor = classProcessors[i];
            sb.append("<classProcessor id=\"").append(Util.escapeXML(classProcessor.getProcessorID())).append("\">");
            String xmlDescription = classProcessor.getXMLDescription();
            if (xmlDescription != null) {
                sb.append(xmlDescription);
            }
            sb.append("</classProcessor>");
            ++i;
        }
        sb.append("</classProcessors>");
        sb.append("<classes>");
        ClassInfo[] classInfos = ClassInfoLoader.getClassInfos();
        int i2 = 0;
        while (i2 < classInfos.length) {
            ClassInfo classInfo = classInfos[i2];
            sb.append(ModelDescriptor.getClassDescription(classInfo));
            ++i2;
        }
        sb.append("</classes>");
        sb.append("</model>");
        return sb.toString();
    }

    protected static String getClassDescription(ClassInfo classInfo) {
        StringBuffer sb = new StringBuffer();
        int loadingState = classInfo.getLoadingState();
        ClassProcessor classProcessor = classInfo.getClassProcessor();
        String classProcessorID = classProcessor == null ? "" : classProcessor.getProcessorID();
        sb.append("<class name=\"").append(Util.escapeXML(classInfo.getClassName())).append("\" state=\"").append(ModelDescriptor.getLoadingStateDescription(loadingState)).append("\" classProcessor=\"").append(classProcessorID).append("\">");
        if (loadingState == 2) {
            sb.append("<prototype value=\"").append(Util.escapeXML(classInfo.getPrototype())).append("\"/>");
            ClassInfo[] superTypes = classInfo.getSuperTypes();
            sb.append("<superTypes>");
            int i = 0;
            while (i < superTypes.length) {
                sb.append("<superType value=\"").append(Util.escapeXML(ModelDescriptor.createSimplePrototype(superTypes[i]))).append("\"/>");
                ++i;
            }
            sb.append("</superTypes>");
            ClassInfo[] subTypes = classInfo.getSubTypes();
            sb.append("<subTypes>");
            int i2 = 0;
            while (i2 < subTypes.length) {
                sb.append("<subType value=\"").append(Util.escapeXML(ModelDescriptor.createSimplePrototype(subTypes[i2]))).append("\"/>");
                ++i2;
            }
            sb.append("</subTypes>");
            FieldInfo[] enums = classInfo.getEnums();
            sb.append("<enums>");
            int i3 = 0;
            while (i3 < enums.length) {
                sb.append("<enum value=\"").append(Util.escapeXML(enums[i3].getPrototype())).append("\"/>");
                ++i3;
            }
            sb.append("</enums>");
            FieldInfo[] fields = classInfo.getFields();
            sb.append("<fields>");
            int i4 = 0;
            while (i4 < fields.length) {
                sb.append("<field value=\"").append(Util.escapeXML(fields[i4].getPrototype())).append("\"/>");
                ++i4;
            }
            sb.append("</fields>");
            MethodInfo[] constructors = classInfo.getConstructors();
            sb.append("<constructors>");
            int i5 = 0;
            while (i5 < constructors.length) {
                sb.append("<constructor value=\"").append(Util.escapeXML(constructors[i5].getPrototype())).append("\"/>");
                ++i5;
            }
            sb.append("</constructors>");
            MethodInfo[] methods = classInfo.getMethods();
            sb.append("<methods>");
            int i6 = 0;
            while (i6 < methods.length) {
                sb.append("<method value=\"").append(Util.escapeXML(methods[i6].getPrototype())).append("\"/>");
                ++i6;
            }
            sb.append("</methods>");
            MethodInfo[] annotationMembers = classInfo.getAnnotationMembers();
            sb.append("<annotationMembers>");
            int i7 = 0;
            while (i7 < annotationMembers.length) {
                sb.append("<annotationMember value=\"").append(Util.escapeXML(annotationMembers[i7].getPrototype())).append("\"/>");
                ++i7;
            }
            sb.append("</annotationMembers>");
        }
        sb.append("</class>");
        return sb.toString();
    }

    protected static String createSimplePrototype(ClassInfo classInfo) {
        return String.valueOf(Util.getModifiers(classInfo.getModifiers())) + classInfo.getDeclaration();
    }

    protected static String getLoadingStateDescription(int loadingState) {
        switch (loadingState) {
            case 2: {
                return "loaded";
            }
            case 3: {
                return "failed";
            }
        }
        return "notLoaded";
    }

    protected static int getLoadingState(String loadingStateDescription) {
        if ("loaded".equals(loadingStateDescription)) {
            return 2;
        }
        if ("failed".equals(loadingStateDescription)) {
            return 3;
        }
        return 0;
    }

    public static void clearModel() {
        ModelDescriptor.setXMLDescription("<model><classProcessors></classProcessors><classes></classes></model>");
    }

    public static void setXMLDescription(String description) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(description.getBytes("UTF-8")));
            NodeList nodeList = document.getChildNodes().item(0).getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                String name = node.getNodeName();
                if ("classProcessors".equals(name)) {
                    ModelDescriptor.loadClassProcessors(node.getChildNodes());
                } else if ("classes".equals(name)) {
                    ModelDescriptor.loadClasses(node.getChildNodes());
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void loadClassProcessors(NodeList nodeList) {
        int i = 0;
        while (i < nodeList.getLength()) {
            String id;
            ClassProcessor classProcessor;
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("classProcessor".equals(name) && (classProcessor = ClassProcessorRegistry.getClassProcessor(id = node.getAttributes().getNamedItem("id").getNodeValue())) != null) {
                NodeList childNodeList = node.getChildNodes();
                StringBuffer sb = new StringBuffer();
                int j = 0;
                while (j < childNodeList.getLength()) {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        DOMSource source = new DOMSource(childNodeList.item(j));
                        StreamResult result = new StreamResult(out);
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.transform(source, result);
                        String textContent = new String(out.toByteArray(), "UTF-8");
                        if (textContent != null) {
                            sb.append(textContent);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
                classProcessor.loadXMLDescription(sb.toString());
            }
            ++i;
        }
    }

    protected static void loadClasses(NodeList nodeList) {
        ArrayList<ClassInfo> classInfoList = new ArrayList<ClassInfo>();
        ArrayList<byte[]> classDescriptionList = new ArrayList<byte[]>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("class".equals(name)) {
                NamedNodeMap attributes = node.getAttributes();
                String className = attributes.getNamedItem("name").getNodeValue();
                String loadingStateDescription = attributes.getNamedItem("state").getNodeValue();
                String classProcessor = attributes.getNamedItem("classProcessor").getNodeValue();
                ClassInfo classInfo = new ClassInfo(className, ClassProcessorRegistry.getClassProcessor(classProcessor));
                int loadingState = ModelDescriptor.getLoadingState(loadingStateDescription);
                classInfo.setLoadingState(loadingState);
                classInfoList.add(classInfo);
                byte[] description = null;
                if (loadingState == 2) {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        DOMSource source = new DOMSource(node);
                        StreamResult result = new StreamResult(out);
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.transform(source, result);
                        description = out.toByteArray();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                classDescriptionList.add(description);
            }
            ++i;
        }
        ClassInfo[] classInfos = classInfoList.toArray(new ClassInfo[0]);
        ClassInfoLoader.setClassInfos(classInfos);
        int i2 = 0;
        while (i2 < classInfos.length) {
            ClassInfo classInfo = classInfos[i2];
            byte[] classData = (byte[])classDescriptionList.get(i2);
            if (classData != null) {
                ClassInfoLoader.loadClassInfo(classInfo, classInfo.getClassProcessor(), new ByteArrayInputStream(classData));
            }
            ++i2;
        }
    }
}

