/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.model;

import chrriis.udoc.model.ClassInfo;
import chrriis.udoc.model.ClassInfoLoader;
import chrriis.udoc.model.MethodInfo;
import chrriis.udoc.model.processor.ClassProcessor;

public class FieldInfo {
    protected ClassInfo classInfo;
    protected MethodInfo methodInfo;
    protected String classDeclaration;
    protected String name;
    protected int modifiers;
    protected int[] classNamesIndices;
    protected ClassInfo[] classInfos;
    protected ClassInfo[] annotations;
    protected String prototype;

    protected FieldInfo(ClassInfo classInfo, MethodInfo methodInfo, String classDeclaration, ClassProcessor classProcessor) {
        this(classInfo, methodInfo, classDeclaration, null, classProcessor);
    }

    protected FieldInfo(ClassInfo classInfo, MethodInfo methodInfo, String classDeclaration, String name, ClassProcessor classProcessor) {
        this(classInfo, methodInfo, classDeclaration, name, 0, classProcessor);
    }

    protected FieldInfo(ClassInfo classInfo, MethodInfo methodInfo, String classDeclaration, String name, int modifiers, ClassProcessor classProcessor) {
        this.classInfo = classInfo;
        this.methodInfo = methodInfo;
        this.name = name;
        this.classDeclaration = classDeclaration;
        this.modifiers = modifiers;
        this.classNamesIndices = this.getClassNameIndices(classDeclaration);
        this.classInfos = new ClassInfo[this.classNamesIndices.length / 2];
        int i = 0;
        while (i < this.classInfos.length) {
            this.classInfos[i] = ClassInfoLoader.createClassInfo(classDeclaration.substring(this.classNamesIndices[i * 2], this.classNamesIndices[i * 2 + 1]), classProcessor);
            ++i;
        }
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public String getClassDeclaration() {
        return this.classDeclaration;
    }

    public int[] getClassNamesIndices() {
        return this.classNamesIndices;
    }

    public ClassInfo[] getClassInfos() {
        return this.classInfos;
    }

    protected int[] getClassNameIndices(String classDeclaration) {
        if (this.methodInfo == null) {
            return this.classInfo.getClassNameIndices(classDeclaration);
        }
        String[] methodGenerics = this.methodInfo.getGenericDeclarations();
        String[] classGenerics = this.classInfo.getGenericDeclarations();
        String[] generics = new String[methodGenerics.length + classGenerics.length];
        System.arraycopy(classGenerics, 0, generics, 0, classGenerics.length);
        System.arraycopy(methodGenerics, 0, generics, classGenerics.length, methodGenerics.length);
        return ClassInfo.getClassNameIndices(classDeclaration, generics);
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    protected void setPrototype(String prototype) {
        this.prototype = prototype;
    }

    public String getPrototype() {
        return this.prototype;
    }

    protected void setAnnotations(ClassInfo[] annotations) {
        this.annotations = annotations;
        int i = 0;
        while (i < annotations.length) {
            if (annotations[i].getClassName().equals("java.lang.Deprecated")) {
                this.modifiers |= 0x200000;
                break;
            }
            ++i;
        }
    }

    public ClassInfo[] getAnnotations() {
        if (this.annotations == null) {
            return new ClassInfo[0];
        }
        return this.annotations;
    }
}

