/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui.widgets;

import chrriis.udoc.model.ClassInfo;
import chrriis.udoc.model.FieldInfo;
import chrriis.udoc.model.MethodInfo;
import chrriis.udoc.ui.ClassComponent;
import chrriis.udoc.ui.IconManager;
import chrriis.udoc.ui.widgets.ClassDeclarationComponent;
import chrriis.udoc.ui.widgets.MethodLink;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MethodDeclarationComponent
extends JPanel {
    protected static final Font METHOD_FONT = new Font("sans-serif", 0, 10);

    public MethodDeclarationComponent(ClassComponent classComponent, ClassInfo classInfo, MethodInfo method) {
        super(new FlowLayout(0, 0, 0));
        this.setOpaque(false);
        int modifiers = method.getReturnedParameter() == null ? 131072 : 65536;
        modifiers |= method.getModifiers();
        if ((method.getClassInfo().getModifiers() & 0x10) != 0) {
            modifiers &= 0xFFFFFF7F;
        }
        this.add(new JLabel(IconManager.getIcon(modifiers)));
        this.add(new MethodLink(classComponent, method.getName(), classInfo, method));
        this.add(new JLabel("("));
        FieldInfo[] fieldInfos = method.getParameters();
        int i = 0;
        while (i < fieldInfos.length) {
            FieldInfo field = fieldInfos[i];
            if (i > 0) {
                this.add(new JLabel(", "));
            }
            this.add(new ClassDeclarationComponent(classComponent, field.getClassDeclaration(), field.getClassNamesIndices(), field.getClassInfos()));
            ++i;
        }
        this.add(new JLabel(")"));
        i = this.getComponentCount() - 1;
        while (i >= 0) {
            this.getComponent(i).setFont(METHOD_FONT);
            --i;
        }
    }

    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
    }
}

