/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui.toolbar;

import chrriis.udoc.ui.ClassPane;
import chrriis.udoc.ui.IconManager;
import chrriis.udoc.ui.Workspace;
import chrriis.udoc.ui.print.PrintPreviewDialog;
import chrriis.udoc.ui.toolbar.ToolBarMenu;
import chrriis.udoc.ui.toolbar.ToolBarMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class WorkspaceToolBarMenu
extends ToolBarMenu {
    protected static final Color SELECTION_COLOR = new Color(218, 219, 255);
    protected ClassPane classPane;
    protected JFileChooser fileChooser;

    public WorkspaceToolBarMenu(ClassPane classPane) {
        super(IconManager.getIcon("tool_bar_on.gif"), IconManager.getIcon("tool_bar_off.gif"), classPane);
        this.classPane = classPane;
    }

    protected String getContentTitle() {
        return "Workspace";
    }

    protected Color getSelectionColor() {
        return SELECTION_COLOR;
    }

    protected void createFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
    }

    protected Component createPopupMenuContent() {
        JPanel workspacePane = new JPanel();
        BoxLayout boxLayout = new BoxLayout(workspacePane, 1);
        workspacePane.setLayout(boxLayout);
        ToolBarMenuItem loadWorkspaceMenuItem = new ToolBarMenuItem("Load Workspace...");
        loadWorkspaceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkspaceToolBarMenu.this.classPane.closeMenus();
                WorkspaceToolBarMenu.this.createFileChooser();
                WorkspaceToolBarMenu.this.fileChooser.setFileFilter(new FileFilter(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().endsWith(".udc");
                    }

                    public String getDescription() {
                        return "*.udc";
                    }
                });
                if (WorkspaceToolBarMenu.this.fileChooser.showOpenDialog(WorkspaceToolBarMenu.this) == 0) {
                    File f = WorkspaceToolBarMenu.this.fileChooser.getSelectedFile();
                    try {
                        int count;
                        BufferedInputStream in = new BufferedInputStream(new InflaterInputStream(new FileInputStream(f)));
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        byte[] bytes = new byte[1024];
                        while ((count = ((InputStream)in).read(bytes)) >= 0) {
                            out.write(bytes, 0, count);
                        }
                        Workspace.setXMLDescription(WorkspaceToolBarMenu.this.classPane, new String(out.toByteArray(), "UTF-8"));
                        ((InputStream)in).close();
                    }
                    catch (Exception ex) {
                        try {
                            int count;
                            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            byte[] bytes = new byte[1024];
                            while ((count = ((InputStream)in).read(bytes)) >= 0) {
                                out.write(bytes, 0, count);
                            }
                            Workspace.setXMLDescription(WorkspaceToolBarMenu.this.classPane, new String(out.toByteArray(), "UTF-8"));
                            ((InputStream)in).close();
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                        }
                    }
                }
            }
        });
        workspacePane.add(loadWorkspaceMenuItem);
        ToolBarMenuItem saveWorkspaceMenuItem = new ToolBarMenuItem("Save Workspace...");
        saveWorkspaceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkspaceToolBarMenu.this.classPane.closeMenus();
                WorkspaceToolBarMenu.this.createFileChooser();
                WorkspaceToolBarMenu.this.fileChooser.setFileFilter(new FileFilter(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().endsWith(".udc");
                    }

                    public String getDescription() {
                        return "*.udc";
                    }
                });
                if (WorkspaceToolBarMenu.this.fileChooser.showSaveDialog(WorkspaceToolBarMenu.this) == 0) {
                    File f = WorkspaceToolBarMenu.this.fileChooser.getSelectedFile();
                    if (!f.getName().endsWith(".udc")) {
                        f = new File(String.valueOf(f.getAbsolutePath()) + ".udc");
                    }
                    try {
                        Deflater deflater = new Deflater(9);
                        BufferedOutputStream out = new BufferedOutputStream(new DeflaterOutputStream((OutputStream)new FileOutputStream(f), deflater));
                        ((OutputStream)out).write(Workspace.getXMLDescription(WorkspaceToolBarMenu.this.classPane).getBytes("UTF-8"));
                        ((OutputStream)out).flush();
                        ((OutputStream)out).close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        workspacePane.add(saveWorkspaceMenuItem);
        ToolBarMenuItem autoLayoutMenuItem = new ToolBarMenuItem("Organize layout");
        autoLayoutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkspaceToolBarMenu.this.classPane.closeMenus();
                WorkspaceToolBarMenu.this.classPane.adjustLayout();
            }
        });
        workspacePane.add(autoLayoutMenuItem);
        ToolBarMenuItem printPreviewMenuItem = new ToolBarMenuItem("Print with Preview...");
        printPreviewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkspaceToolBarMenu.this.classPane.closeMenus();
                if (WorkspaceToolBarMenu.this.classPane.getClassComponentPanePrintBounds() == null) {
                    return;
                }
                Window ancestor = SwingUtilities.getWindowAncestor(WorkspaceToolBarMenu.this.classPane);
                PrintPreviewDialog dialog = ancestor instanceof Dialog ? new PrintPreviewDialog((Dialog)ancestor, WorkspaceToolBarMenu.this.classPane) : new PrintPreviewDialog((Frame)ancestor, WorkspaceToolBarMenu.this.classPane);
                dialog.pack();
                dialog.setLocationRelativeTo(ancestor);
                dialog.setResizable(false);
                dialog.setModal(true);
                dialog.setVisible(true);
            }
        });
        workspacePane.add(printPreviewMenuItem);
        return workspacePane;
    }
}

