/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.model.processor.source;

import chrriis.udoc.model.Util;
import chrriis.udoc.model.processor.ClassProcessor;
import chrriis.udoc.model.processor.source.SourceParametersComponent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SourceClassProcessor
extends ClassProcessor {
    protected String sourcePath;
    protected String classPath;
    protected static final int NONE = 0;
    protected static final int BLOCK_COMMENT = 1;
    protected static final int LINE_COMMENT = 2;
    protected static final int STRING_CONSTANT = 3;
    protected Map packageToClassesMap = new HashMap();
    protected final Object PACKAGE_LOCK = new Object();
    protected Map zipPackageToImportListMap = new HashMap();
    protected DefaultMutableTreeNode javadocNode;

    public String getProcessorID() {
        return "SourceClassProcessor";
    }

    public String getProcessorName() {
        return "Source [EXPERIMENTAL]";
    }

    public String getProcessorDescription() {
        return "Load class diagrams from \".java\" source files";
    }

    public JComponent getParametersComponent() {
        return new SourceParametersComponent(this);
    }

    protected InputStream getSourceInputStream(String className) {
        int lastDotIndex = className.lastIndexOf(46);
        String cName = className.substring(lastDotIndex + 1);
        int index = (cName = Util.unescapeClassName(cName)).indexOf(46);
        if (index != -1) {
            cName = cName.substring(0, index);
        }
        String subPath = String.valueOf(lastDotIndex == -1 ? cName : String.valueOf(className.substring(0, lastDotIndex + 1).replace('.', '/')) + cName) + ".java";
        String[] paths = this.getSourcePath().split(Util.getPathSeparator());
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            File file = new File(path);
            if (file.exists()) {
                if (file.isFile()) {
                    try {
                        ZipEntry entry;
                        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
                        while ((entry = zin.getNextEntry()) != null) {
                            if (!subPath.equals(entry.getName())) continue;
                            return zin;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        return new BufferedInputStream(new FileInputStream(String.valueOf(path) + "/" + subPath));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        return this.getClass().getResourceAsStream("/" + subPath);
    }

    public InputStream getClassInfoDataInputStream(String className) {
        int lastDotIndex = className.lastIndexOf(46);
        String cName = Util.unescapeClassName(className.substring(lastDotIndex + 1));
        String mainName = className.substring(lastDotIndex + 1);
        int dotIndex = (mainName = Util.unescapeClassName(mainName)).indexOf(46);
        if (dotIndex != -1) {
            mainName = mainName.substring(0, dotIndex);
        }
        String packageName = lastDotIndex == -1 ? "" : className.substring(0, lastDotIndex);
        InputStream in = this.getSourceInputStream(className);
        if (in == null) {
            return null;
        }
        try {
            int i;
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            int backslashCount = 0;
            int level = 0;
            int state = 0;
            char lastChar = '\u0000';
            boolean isClassFound = false;
            boolean isInClass = true;
            StringBuffer classNameSB = null;
            String prototype = null;
            String packageDeclaration = "";
            ArrayList<String> importList = new ArrayList<String>();
            importList.add(Util.unescapeClassName(className));
            ArrayList<String> fieldList = new ArrayList<String>();
            ArrayList<String> constructorList = new ArrayList<String>();
            ArrayList<String> methodList = new ArrayList<String>();
            StringBuffer tokenSB = new StringBuffer();
            while (level >= 0 && (i = ((Reader)reader).read()) != -1) {
                char c = (char)i;
                block1 : switch (state) {
                    case 0: {
                        switch (c) {
                            case '\t': 
                            case '\n': 
                            case '\r': {
                                c = ' ';
                            }
                            case ' ': {
                                if (level == 0 && lastChar != ' ' && tokenSB.length() > 0) {
                                    tokenSB.append(c);
                                }
                                lastChar = c;
                                break block1;
                            }
                            case ',': {
                                if (level == 0) {
                                    if (tokenSB.indexOf("<") == -1) {
                                        tokenSB.indexOf("(");
                                    }
                                    tokenSB.append(c);
                                }
                                lastChar = c;
                                break block1;
                            }
                            case '/': {
                                if (lastChar == '/') {
                                    state = 2;
                                    if (level == 0) {
                                        tokenSB.deleteCharAt(tokenSB.length() - 1);
                                        lastChar = tokenSB.length() > 0 ? (lastChar = tokenSB.charAt(tokenSB.length() - 1)) : (char)'\u0000';
                                        break block1;
                                    }
                                    lastChar = '\u0000';
                                    break block1;
                                }
                                if (level == 0) {
                                    tokenSB.append(c);
                                }
                                lastChar = c;
                                break block1;
                            }
                            case '*': {
                                if (lastChar == '/') {
                                    state = 1;
                                    if (level == 0) {
                                        tokenSB.deleteCharAt(tokenSB.length() - 1);
                                        lastChar = tokenSB.length() > 0 ? (lastChar = tokenSB.charAt(tokenSB.length() - 1)) : (char)'\u0000';
                                        break block1;
                                    }
                                    lastChar = '\u0000';
                                    break block1;
                                }
                                if (level == 0) {
                                    tokenSB.append(c);
                                }
                                lastChar = c;
                                break block1;
                            }
                            case '\"': {
                                state = 3;
                                backslashCount = 0;
                                lastChar = c;
                                break block1;
                            }
                            case ';': {
                                String s;
                                if (level == 0 && tokenSB.length() > 0) {
                                    s = tokenSB.toString();
                                    if (s.startsWith("package ")) {
                                        packageDeclaration = s.substring("package ".length()).trim();
                                        tokenSB = new StringBuffer();
                                    } else if (s.startsWith("import ")) {
                                        importList.add(s.substring("import ".length()).trim());
                                        tokenSB = new StringBuffer();
                                    } else if (isClassFound) {
                                        String token = tokenSB.toString();
                                        int index = token.indexOf(61);
                                        if (index != -1) {
                                            token = token.substring(0, index);
                                        }
                                        if ((token = token.trim()).indexOf(40) != -1) {
                                            if (SourceClassProcessor.isConstructor(token)) {
                                                constructorList.add(token);
                                            } else {
                                                methodList.add(token);
                                            }
                                        } else {
                                            fieldList.add(token);
                                        }
                                        tokenSB = new StringBuffer();
                                    }
                                }
                                lastChar = c;
                                break block1;
                            }
                            case '{': {
                                String s;
                                if (isInClass) {
                                    s = String.valueOf(' ') + tokenSB.toString();
                                    int index = s.indexOf(" class ");
                                    if (index != -1) {
                                        index += " class ".length();
                                    } else {
                                        index = s.indexOf(" interface ");
                                        if (index != -1) {
                                            index += " interface ".length();
                                        } else {
                                            index = s.indexOf(" enum ");
                                            if (index != -1) {
                                                index += " enum ".length();
                                            } else {
                                                index = s.indexOf(" @interface ");
                                                if (index != -1) {
                                                    index += " @interface ".length();
                                                }
                                            }
                                        }
                                    }
                                    if (index != -1) {
                                        if (!isClassFound) {
                                            s = s.substring(index).trim();
                                            int j = 0;
                                            while (j < s.length()) {
                                                switch (s.charAt(j)) {
                                                    case ' ': 
                                                    case '<': {
                                                        s = s.substring(0, j);
                                                    }
                                                }
                                                ++j;
                                            }
                                            boolean isValid = false;
                                            if (classNameSB == null) {
                                                if (s.equals(mainName)) {
                                                    classNameSB = new StringBuffer();
                                                    classNameSB.append(String.valueOf(packageName) + "." + s);
                                                    isValid = true;
                                                    isClassFound = true;
                                                }
                                            } else {
                                                String currentClass = String.valueOf(classNameSB.toString()) + '$' + Util.escapeClassName(s);
                                                if (className.equals(currentClass) || className.startsWith(String.valueOf(currentClass) + '$')) {
                                                    classNameSB.append('$').append(Util.escapeClassName(s));
                                                    isValid = true;
                                                    isClassFound = className.equals(currentClass);
                                                }
                                            }
                                            if (isValid) {
                                                level = -1;
                                            }
                                            if (isClassFound) {
                                                prototype = tokenSB.toString().trim();
                                            }
                                        }
                                        tokenSB = new StringBuffer();
                                    }
                                }
                                if (level == 0 && isClassFound) {
                                    s = tokenSB.toString();
                                    if (s.trim().length() > 0) {
                                        int eIndex = s.indexOf(61);
                                        if (eIndex != -1) {
                                            fieldList.add(s.substring(0, eIndex).trim());
                                        } else if (!"static".equals(s = s.trim())) {
                                            if (s.indexOf(40) != -1) {
                                                if (SourceClassProcessor.isConstructor(s)) {
                                                    constructorList.add(s);
                                                } else {
                                                    methodList.add(s);
                                                }
                                            } else {
                                                fieldList.add(s);
                                            }
                                        }
                                    }
                                    tokenSB = new StringBuffer();
                                    isInClass = false;
                                }
                                ++level;
                                lastChar = c;
                                break block1;
                            }
                            case '}': {
                                if (--level == 0) {
                                    isInClass = true;
                                }
                                lastChar = c;
                                break block1;
                            }
                        }
                        if (level == 0) {
                            tokenSB.append(c);
                        }
                        lastChar = c;
                        break;
                    }
                    case 2: {
                        switch (c) {
                            case '\n': 
                            case '\r': {
                                state = 0;
                                lastChar = tokenSB.length() > 0 ? (lastChar = tokenSB.charAt(tokenSB.length() - 1)) : (char)'\u0000';
                                break block1;
                            }
                        }
                        lastChar = c;
                        break;
                    }
                    case 1: {
                        switch (c) {
                            case '/': {
                                if (lastChar == '*') {
                                    state = 0;
                                    lastChar = tokenSB.length() > 0 ? (lastChar = tokenSB.charAt(tokenSB.length() - 1)) : (char)'\u0000';
                                    break block1;
                                }
                                lastChar = c;
                                break block1;
                            }
                        }
                        lastChar = c;
                        break;
                    }
                    case 3: {
                        switch (c) {
                            case '\\': {
                                backslashCount = (backslashCount + 1) % 2;
                                if (level != 0) break;
                                tokenSB.append(c);
                                break;
                            }
                            case '\"': {
                                if (backslashCount == 0) {
                                    state = 0;
                                }
                                if (level != 0) break;
                                tokenSB.append(c);
                            }
                        }
                        lastChar = c;
                    }
                }
            }
            if (prototype == null) {
                return null;
            }
            if (packageDeclaration == null) {
                packageDeclaration = "";
            }
            if (!packageName.equals(packageDeclaration)) {
                return null;
            }
            importList.add(String.valueOf(packageName) + ".*");
            importList.add("java.lang.*");
            String[] imports = this.resolveImports(importList);
            StringBuffer sourceSB = new StringBuffer();
            sourceSB.append("<type name=\"").append(Util.escapeXML(className)).append("\">");
            prototype = SourceClassProcessor.adjustPrototype(prototype, imports);
            sourceSB.append("<prototype value=\"").append(Util.escapeXML(prototype)).append("\"/>");
            int extendsIndex = -1;
            int implementsIndex = -1;
            int i2 = 0;
            while (i2 < prototype.length()) {
                char c = prototype.charAt(i2);
                int count = 0;
                switch (c) {
                    case '<': {
                        ++count;
                        break;
                    }
                    case '>': {
                        --count;
                        break;
                    }
                    default: {
                        if (count != 0) break;
                        String s = prototype.substring(i2);
                        if (s.startsWith(" extends ")) {
                            extendsIndex = i2 + " extends ".length();
                            break;
                        }
                        if (!s.startsWith(" implements ")) break;
                        implementsIndex = i2 + " implements ".length();
                    }
                }
                ++i2;
            }
            int classModifiers = Util.getClassModifiers(prototype);
            StringBuffer superClassesSB = new StringBuffer();
            StringBuffer superInterfacesSB = new StringBuffer();
            if (extendsIndex == -1 && (classModifiers & 0x100) != 0 && !"java.lang.Object".equals(className)) {
                superClassesSB.append("java.lang.Object");
            }
            if (extendsIndex != -1) {
                if (implementsIndex == -1) {
                    if ((classModifiers & 0x40) != 0) {
                        superInterfacesSB.append(prototype.substring(extendsIndex));
                    } else {
                        superClassesSB.append(prototype.substring(extendsIndex));
                    }
                } else {
                    superClassesSB.append(prototype.substring(extendsIndex, implementsIndex - " implements ".length()));
                }
            }
            if (implementsIndex != -1) {
                superInterfacesSB.append(prototype.substring(implementsIndex));
            }
            sourceSB.append("<superTypes>");
            int i3 = 0;
            while (i3 < 2) {
                String prefix;
                StringBuffer superTypeSB;
                if (i3 == 0) {
                    superTypeSB = superClassesSB;
                    prefix = "class ";
                } else {
                    superTypeSB = superInterfacesSB;
                    prefix = "interface ";
                }
                String superTypes = superTypeSB.toString();
                if (superTypes.length() > 0) {
                    int count = 0;
                    int j = 0;
                    while (j < superTypes.length()) {
                        char c = superTypes.charAt(j);
                        switch (c) {
                            case '<': {
                                ++count;
                                break;
                            }
                            case '>': {
                                --count;
                                break;
                            }
                            case ',': {
                                if (count != 0) break;
                                sourceSB.append("<superType value=\"").append(Util.escapeXML(String.valueOf(prefix) + superTypes.substring(0, j).trim())).append("\"/>");
                                superTypes = superTypes.substring(j + 1);
                                j = 0;
                            }
                        }
                        ++j;
                    }
                    sourceSB.append("<superType value=\"").append(Util.escapeXML(String.valueOf(prefix) + superTypes.trim())).append("\"/>");
                }
                ++i3;
            }
            sourceSB.append("</superTypes>");
            sourceSB.append("<constructors>");
            if (constructorList.isEmpty()) {
                sourceSB.append("<constructor value=\"public ").append(Util.escapeXML(cName)).append("()\"/>");
            } else {
                i3 = 0;
                while (i3 < constructorList.size()) {
                    sourceSB.append("<constructor value=\"").append(Util.escapeXML(SourceClassProcessor.adjustMethod((String)constructorList.get(i3), imports))).append("\"/>");
                    ++i3;
                }
            }
            sourceSB.append("</constructors>");
            String methodType = (classModifiers & 0x10) != 0 ? "annotationMember" : "method";
            sourceSB.append('<').append(methodType).append("s>");
            int i4 = 0;
            while (i4 < methodList.size()) {
                sourceSB.append('<').append(methodType).append(" value=\"").append(Util.escapeXML(SourceClassProcessor.adjustMethod((String)methodList.get(i4), imports))).append("\"/>");
                ++i4;
            }
            sourceSB.append("</").append(methodType).append("s>");
            sourceSB.append("<fields>");
            i4 = 0;
            while (i4 < fieldList.size()) {
                sourceSB.append("<field value=\"").append(Util.escapeXML(SourceClassProcessor.adjustField((String)fieldList.get(i4), imports))).append("\"/>");
                ++i4;
            }
            sourceSB.append("</fields>");
            sourceSB.append("</type>");
            System.err.println(sourceSB);
            return new ByteArrayInputStream(sourceSB.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static boolean isConstructor(String token) {
        while (token.startsWith("@") && !token.startsWith("@interface ")) {
            int count = 0;
            int i = 0;
            while (i < token.length()) {
                char c = token.charAt(i);
                switch (c) {
                    case '(': {
                        ++count;
                        break;
                    }
                    case ')': {
                        --count;
                        break;
                    }
                    case ' ': {
                        if (count != 0) break;
                        token = token.substring(i + 1);
                        i = token.length();
                    }
                }
                ++i;
            }
        }
        String[] tokens = token.split(" ");
        boolean isConstructor = false;
        int i = 0;
        while (i < tokens.length) {
            String t = tokens[i];
            if (!Util.isModifier(t)) {
                isConstructor = t.indexOf(40) != -1;
                break;
            }
            ++i;
        }
        return isConstructor;
    }

    protected static String adjustPrototype(String prototype, String[] imports) {
        prototype = prototype.replaceAll(" <", "<").replaceAll("< ", "<").replaceAll(" >", ">").replaceAll(" \\?", "\\?").replaceAll(", ", ",").replaceAll(",", ", ");
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(prototype, ", <>", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() <= 0) continue;
            boolean isAdded = false;
            if (token.length() == 1) {
                switch (token.charAt(0)) {
                    case ' ': 
                    case ',': 
                    case '<': 
                    case '>': {
                        isAdded = true;
                        sb.append(token);
                    }
                }
            }
            if (isAdded) continue;
            if (Util.isReservedKeyword(token)) {
                sb.append(token);
                continue;
            }
            sb.append(SourceClassProcessor.getFullyQualifiedName(token, imports));
        }
        return sb.toString();
    }

    protected static String adjustMethod(String prototype, String[] imports) {
        int spaceIndex;
        int index;
        prototype = prototype.replaceAll(" \\[", "\\[").replaceAll(" \\]", "\\]").replaceAll(" \\(", "\\(").replaceAll(" \\)", "\\)").replaceAll(" \\.\\.\\.", "\\.\\.\\.").replaceAll(" <", "<").replaceAll("< ", "<").replaceAll(" >", ">").replaceAll(" \\?", "\\?").replaceAll(", ", ",").replaceAll(",", ", ");
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(prototype, ", <>[])", true);
        ArrayList<String> tokenList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokenList.add(st.nextToken());
        }
        int i = 0;
        while (i < tokenList.size()) {
            String token = (String)tokenList.get(i);
            if (token.length() > 0) {
                boolean isAdded = false;
                if (token.length() == 1) {
                    switch (token.charAt(0)) {
                        case ' ': 
                        case ')': 
                        case ',': 
                        case '<': 
                        case '>': 
                        case '[': 
                        case ']': {
                            isAdded = true;
                            sb.append(token);
                        }
                    }
                }
                if (!isAdded) {
                    int index2 = token.indexOf(40);
                    if (index2 != -1) {
                        sb.append(token.substring(0, index2 + 1));
                        tokenList.add(i + 1, token.substring(index2 + 1));
                    } else if (Util.isReservedKeyword(token)) {
                        sb.append(token);
                    } else {
                        boolean isVarArgs = token.endsWith("...");
                        if (isVarArgs) {
                            sb.append(SourceClassProcessor.getFullyQualifiedName(token.substring(0, token.length() - 3), imports));
                            sb.append("...");
                        } else {
                            if (token.startsWith("@")) {
                                sb.append("@");
                                token = token.substring(1);
                            }
                            sb.append(SourceClassProcessor.getFullyQualifiedName(token, imports));
                        }
                    }
                }
            }
            ++i;
        }
        String method = sb.toString();
        while ((index = method.indexOf("[])")) != -1) {
            spaceIndex = method.substring(0, index).lastIndexOf(32);
            method = String.valueOf(method.substring(0, spaceIndex)) + "[]" + method.substring(spaceIndex, index) + method.substring(index + 2);
        }
        while ((index = method.indexOf("[],")) != -1) {
            spaceIndex = method.substring(0, index).lastIndexOf(32);
            method = String.valueOf(method.substring(0, spaceIndex)) + "[]" + method.substring(spaceIndex, index) + method.substring(index + 2);
        }
        return method;
    }

    protected static String adjustField(String prototype, String[] imports) {
        prototype = prototype.replaceAll(" \\[", "\\[").replaceAll(" \\]", "\\]").replaceAll(" <", "<").replaceAll("< ", "<").replaceAll(" >", ">").replaceAll(" \\?", "\\?").replaceAll(", ", ",").replaceAll(",", ", ");
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(prototype, ", <>[]", true);
        int count = st.countTokens();
        int i = 0;
        while (i < count - 1) {
            String token = st.nextToken();
            if (token.length() > 0) {
                boolean isAdded = false;
                if (token.length() == 1) {
                    switch (token.charAt(0)) {
                        case ' ': 
                        case ',': 
                        case '<': 
                        case '>': {
                            isAdded = true;
                            sb.append(token);
                        }
                    }
                }
                if (!isAdded) {
                    if (Util.isReservedKeyword(token)) {
                        sb.append(token);
                    } else {
                        if (token.startsWith("@")) {
                            sb.append("@");
                            token = token.substring(1);
                        }
                        sb.append(SourceClassProcessor.getFullyQualifiedName(token, imports));
                    }
                }
            }
            ++i;
        }
        sb.append(st.nextToken());
        String field = sb.toString();
        while (field.endsWith("[]")) {
            int index = field.lastIndexOf(32);
            field = String.valueOf(field.substring(0, index)) + "[]" + field.substring(index, field.length() - 2);
        }
        return field;
    }

    protected static String getFullyQualifiedName(String className, String[] imports) {
        if (Util.isReservedKeyword(className) || "?".equals(className)) {
            return className;
        }
        System.err.println(className);
        if (className.equals("init")) {
            System.err.println("in");
        }
        if (className.indexOf(46) != -1) {
            return className;
        }
        int i = 0;
        while (i < imports.length) {
            String imp = imports[i];
            if (imp.equals(className)) {
                return imp;
            }
            if (imp.endsWith("." + className)) {
                return imp;
            }
            ++i;
        }
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] resolveImports(List importList) {
        ArrayList newImportList = new ArrayList();
        int i = 0;
        while (i < importList.size()) {
            String className = (String)importList.get(i);
            if (className.endsWith(".*")) {
                String parentPackage = className.substring(0, className.length() - 2);
                Object object = this.PACKAGE_LOCK;
                synchronized (object) {
                    ArrayList classList = (ArrayList)this.packageToClassesMap.get(parentPackage);
                    if (classList == null) {
                        classList = new ArrayList();
                        this.packageToClassesMap.put(parentPackage, classList);
                        classList.addAll(this.resolveImport(parentPackage, this.getSourcePath(), ".java"));
                        classList.addAll(this.resolveImport(parentPackage, this.getClassPath(), ".class"));
                    }
                    newImportList.addAll(classList);
                }
            } else {
                newImportList.add(className);
            }
            ++i;
        }
        return newImportList.toArray(new String[0]);
    }

    protected List resolveImport(String parentPackage, String resourcePath, final String extension) {
        ArrayList<String> importList = new ArrayList<String>();
        String parentDirectory = (String.valueOf(parentPackage) + '.').replace('.', '/');
        String[] paths = resourcePath.split(Util.getPathSeparator());
        int i = 0;
        while (i < paths.length) {
            File file;
            String path = paths[i];
            if (path.length() > 0 && (file = new File(path)).exists()) {
                if (file.isFile()) {
                    String key = String.valueOf(file.getAbsolutePath()) + extension + "?";
                    Object value = this.zipPackageToImportListMap.get(key);
                    if (value == null) {
                        this.zipPackageToImportListMap.put(key + parentPackage, new ArrayList());
                        try {
                            ZipEntry entry;
                            ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
                            while ((entry = zin.getNextEntry()) != null) {
                                String entryName = entry.getName();
                                if (!entryName.endsWith(extension)) continue;
                                int slashIndex = entryName.lastIndexOf(47);
                                String packageName = slashIndex == -1 ? "" : entryName.substring(0, slashIndex).replace('/', '.');
                                ArrayList<String> zipImportList = (ArrayList<String>)this.zipPackageToImportListMap.get(key + packageName);
                                if (zipImportList == null) {
                                    zipImportList = new ArrayList<String>();
                                    this.zipPackageToImportListMap.put(key + packageName, zipImportList);
                                }
                                String className = entryName.substring(slashIndex + 1);
                                className = className.substring(0, className.length() - extension.length());
                                zipImportList.add(parentPackage.length() > 0 ? String.valueOf(parentPackage) + "." + className : className);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        List zipImportList = (List)this.zipPackageToImportListMap.get(key + parentPackage);
                        if (zipImportList != null) {
                            importList.addAll(zipImportList);
                        }
                    }
                } else {
                    try {
                        File f = new File(parentDirectory);
                        if (f.isDirectory()) {
                            String[] files = f.list(new FilenameFilter(){

                                public boolean accept(File dir, String name) {
                                    return new File(dir, name).isFile() && name.endsWith(extension);
                                }
                            });
                            int j = 0;
                            while (j < files.length) {
                                importList.add(files[j]);
                                ++j;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        return importList;
    }

    public String getSourcePath() {
        return this.sourcePath == null ? "" : this.sourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
        Object object = this.PACKAGE_LOCK;
        synchronized (object) {
            this.packageToClassesMap = new HashMap();
        }
    }

    public String getClassPath() {
        return this.classPath == null ? "" : this.classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassPath(String classPath) {
        this.classPath = classPath;
        Object object = this.PACKAGE_LOCK;
        synchronized (object) {
            this.packageToClassesMap = new HashMap();
        }
    }

    public String getXMLDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("<sourceClassProcessorParameter>");
        String pathSeparator = Util.getPathSeparator();
        sb.append("<sourcePaths>");
        String[] sourcePaths = this.getSourcePath().split(pathSeparator);
        int i = 0;
        while (i < sourcePaths.length) {
            sb.append("<sourcePath value=\"").append(Util.escapeXML(sourcePaths[i])).append("\"/>");
            ++i;
        }
        sb.append("</sourcePaths>");
        sb.append("<classPaths>");
        String[] classPaths = this.getClassPath().split(pathSeparator);
        int i2 = 0;
        while (i2 < classPaths.length) {
            sb.append("<classPath value=\"").append(Util.escapeXML(classPaths[i2])).append("\"/>");
            ++i2;
        }
        sb.append("</classPaths>");
        sb.append("</sourceClassProcessorParameter>");
        return sb.toString();
    }

    public void loadXMLDescription(String xmlDescription) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(xmlDescription.getBytes("UTF-8")));
            NodeList nodeList = document.getChildNodes().item(0).getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                String name = node.getNodeName();
                if ("sourcePaths".equals(name)) {
                    this.loadSourcePaths(node.getChildNodes());
                }
                if ("classPaths".equals(name)) {
                    this.loadClassPaths(node.getChildNodes());
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadSourcePaths(NodeList nodeList) {
        this.sourcePath = null;
        StringBuffer sb = new StringBuffer();
        String pathSeparator = Util.getPathSeparator();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("sourcePath".equals(name)) {
                if (i > 0) {
                    sb.append(pathSeparator);
                }
                sb.append(node.getAttributes().getNamedItem("value").getNodeValue());
            }
            ++i;
        }
        this.setSourcePath(sb.toString());
    }

    protected void loadClassPaths(NodeList nodeList) {
        this.classPath = null;
        StringBuffer sb = new StringBuffer();
        String pathSeparator = Util.getPathSeparator();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("classPath".equals(name)) {
                if (i > 0) {
                    sb.append(pathSeparator);
                }
                sb.append(node.getAttributes().getNamedItem("value").getNodeValue());
            }
            ++i;
        }
        this.setClassPath(sb.toString());
    }

    public void loadClassBrowser(final JTree tree) {
        if (this.javadocNode != null) {
            tree.setModel(new DefaultTreeModel(this.javadocNode));
            return;
        }
        final String classPath = this.classPath;
        final String sourcePath = this.sourcePath;
        final DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getModel().getRoot();
        node.removeAllChildren();
        new Thread(){

            public void run() {
                SourceClassProcessor.addTreeClassResources(SourceClassProcessor.this.getSourcePath(), ".java", node);
                SourceClassProcessor.addTreeClassResources(SourceClassProcessor.this.getClassPath(), ".class", node);
                SwingUtilities.invokeLater(new Runnable(this, classPath, sourcePath, node, tree){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ String val$classPath;
                    private final /* synthetic */ String val$sourcePath;
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    private final /* synthetic */ JTree val$tree;
                    {
                        this.this$1 = var1_1;
                        this.val$classPath = string;
                        this.val$sourcePath = string2;
                        this.val$node = defaultMutableTreeNode;
                        this.val$tree = jTree;
                    }

                    public void run() {
                        if (this.val$classPath == null ? 2.access$0(this.this$1).classPath != null : !this.val$classPath.equals(2.access$0(this.this$1).classPath)) {
                            return;
                        }
                        if (this.val$sourcePath == null ? 2.access$0(this.this$1).sourcePath != null : !this.val$sourcePath.equals(2.access$0(this.this$1).sourcePath)) {
                            return;
                        }
                        2.access$0(this.this$1).javadocNode = this.val$node;
                        this.val$tree.setModel(new DefaultTreeModel(2.access$0(this.this$1).javadocNode));
                    }
                });
            }

            static /* synthetic */ SourceClassProcessor access$0(2 var0) {
                return var0.SourceClassProcessor.this;
            }
        }.start();
    }

    protected static void addTreeClassResources(String resourcePath, String resourceExtension, DefaultMutableTreeNode node) {
        String[] paths = resourcePath.split(Util.getPathSeparator());
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            File file = new File(path);
            if (file.exists()) {
                if (file.isFile()) {
                    try {
                        ZipEntry entry;
                        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
                        while ((entry = zin.getNextEntry()) != null) {
                            String name = entry.getName();
                            if (!name.endsWith(resourceExtension)) continue;
                            SourceClassProcessor.addTreeClass(name.substring(0, name.length() - resourceExtension.length()).replace('/', '.'), node);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    SourceClassProcessor.addDirectoryContent(file, null, resourceExtension, node);
                }
            }
            ++i;
        }
    }

    protected static void addDirectoryContent(File directory, String currentPath, String resourceExtension, DefaultMutableTreeNode node) {
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String name = file.getName();
            if (file.isDirectory()) {
                SourceClassProcessor.addDirectoryContent(file, currentPath == null ? name : String.valueOf(currentPath) + "." + name, resourceExtension, node);
            } else if (name.endsWith(resourceExtension)) {
                name = name.substring(0, name.length() - resourceExtension.length());
                SourceClassProcessor.addTreeClass(currentPath == null ? name : String.valueOf(currentPath) + "." + name, node);
            }
            ++i;
        }
    }

    protected static void addTreeClass(String className, DefaultMutableTreeNode node) {
        int index = className.indexOf(46);
        if (index != -1) {
            String packageName = className.substring(0, index);
            int i = node.getChildCount() - 1;
            while (i >= 0) {
                int comparison;
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                String childPackageOrClassName = (String)childNode.getUserObject();
                int n = comparison = childNode.isLeaf() ? 1 : childPackageOrClassName.compareTo(packageName);
                if (comparison == 0) {
                    SourceClassProcessor.addTreeClass(className.substring(index + 1), childNode);
                    return;
                }
                if (comparison < 0) {
                    childNode = new DefaultMutableTreeNode(packageName);
                    node.insert(childNode, i + 1);
                    SourceClassProcessor.addTreeClass(className.substring(index + 1), childNode);
                    return;
                }
                --i;
            }
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(packageName);
            node.insert(childNode, 0);
            SourceClassProcessor.addTreeClass(className.substring(index + 1), childNode);
            return;
        }
        int i = node.getChildCount() - 1;
        while (i >= 0) {
            int comparison;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            String childClassName = (String)childNode.getUserObject();
            int n = comparison = !childNode.isLeaf() ? -1 : childClassName.compareTo(className);
            if (comparison == 0) {
                return;
            }
            if (comparison < 0) {
                childNode = new DefaultMutableTreeNode(Util.unescapeClassName(className));
                node.insert(childNode, i + 1);
                return;
            }
            --i;
        }
        node.insert(new DefaultMutableTreeNode(Util.unescapeClassName(className)), 0);
    }
}

