/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.model;

public class Util {
    protected static String pathSepartor;
    protected static boolean isRestricted;

    public static String escapeClassName(String className) {
        int length = className.length();
        StringBuffer sb = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = className.charAt(i);
            switch (c) {
                case '/': {
                    sb.append('.');
                    break;
                }
                case '.': {
                    sb.append('$');
                    break;
                }
                case '$': {
                    sb.append("$$");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String unescapeClassName(String className) {
        int length = className.length();
        StringBuffer sb = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = className.charAt(i);
            switch (c) {
                case '$': {
                    if (i < length - 1) {
                        char c2 = className.charAt(i + 1);
                        if (c2 != '$') {
                            sb.append('.');
                        }
                        sb.append(c2);
                        ++i;
                        break;
                    }
                    sb.append('.');
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static int getModifiers(String prototype) {
        int index;
        int modifiers = 0;
        while ((index = prototype.indexOf(32)) > 0) {
            String token = prototype.substring(0, index);
            int modifier = Util.getModifier(token);
            if (modifier < 0) break;
            modifiers |= modifier;
            prototype = prototype.substring(index + 1);
        }
        return modifiers;
    }

    protected static String getModifiers(int modifiers) {
        StringBuffer sb = new StringBuffer();
        if ((modifiers & 1) != 0) {
            sb.append("public ");
        } else if ((modifiers & 2) != 0) {
            sb.append("protected ");
        } else if ((modifiers & 8) != 0) {
            sb.append("private ");
        }
        if ((modifiers & 0x80) != 0 && (modifiers & 0x70) == 0) {
            sb.append("abstract ");
        }
        if ((modifiers & 0x200) != 0) {
            sb.append("static ");
        }
        if ((modifiers & 0x400) != 0) {
            sb.append("final ");
        }
        if ((modifiers & 0x1000) != 0) {
            sb.append("native");
        }
        if ((modifiers & 0x800) != 0) {
            sb.append("volatile");
        }
        if ((modifiers & 0x2000) != 0) {
            sb.append("transient");
        }
        if ((modifiers & 0x4000) != 0) {
            sb.append("synchronized");
        }
        if ((modifiers & 0x20) != 0) {
            sb.append("enum ");
        } else if ((modifiers & 0x10) != 0) {
            sb.append("@interface ");
        } else if ((modifiers & 0x40) != 0) {
            sb.append("interface ");
        } else if ((modifiers & 0x100) != 0) {
            sb.append("class ");
        }
        return sb.toString();
    }

    public static boolean isModifier(String modifier) {
        return Util.getModifier(modifier) != -1;
    }

    public static int getModifier(String modifier) {
        if ("public".equals(modifier)) {
            return 1;
        }
        if ("protected".equals(modifier)) {
            return 2;
        }
        if ("private".equals(modifier)) {
            return 8;
        }
        if ("@interface".equals(modifier)) {
            return 16;
        }
        if ("enum".equals(modifier)) {
            return 32;
        }
        if ("interface".equals(modifier)) {
            return 64;
        }
        if ("abstract".equals(modifier)) {
            return 128;
        }
        if ("class".equals(modifier)) {
            return 256;
        }
        if ("static".equals(modifier)) {
            return 512;
        }
        if ("final".equals(modifier)) {
            return 1024;
        }
        if ("native".equals(modifier)) {
            return 4096;
        }
        if ("volatile".equals(modifier)) {
            return 2048;
        }
        if ("transient".equals(modifier)) {
            return 8192;
        }
        if ("synchronized".equals(modifier)) {
            return 16384;
        }
        return -1;
    }

    public static String escapeXML(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer((int)((double)s.length() * 1.1));
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isReservedKeyword(String word) {
        if (Util.getModifier(word) != -1) {
            return true;
        }
        return "void".equals(word) || "boolean".equals(word) || "byte".equals(word) || "char".equals(word) || "short".equals(word) || "int".equals(word) || "long".equals(word) || "float".equals(word) || "double".equals(word) || "throws".equals(word) || "implements".equals(word) || "extends".equals(word);
    }

    public static int getClassModifiers(String prototype) {
        while (prototype.startsWith("@") && !prototype.startsWith("@interface ")) {
            int count = 0;
            int i = 0;
            while (i < prototype.length()) {
                char c = prototype.charAt(i);
                switch (c) {
                    case '(': {
                        ++count;
                        break;
                    }
                    case ')': {
                        --count;
                        break;
                    }
                    case ' ': {
                        if (count != 0) break;
                        prototype = prototype.substring(i + 1);
                        i = prototype.length();
                    }
                }
                ++i;
            }
        }
        String[] tokens = prototype.split(" ");
        int classModifiers = 0;
        int i = 0;
        while (i < tokens.length) {
            int modifier = Util.getModifier(tokens[i]);
            if (modifier == -1) break;
            classModifiers |= modifier;
            ++i;
        }
        return classModifiers;
    }

    public static String getPathSeparator() {
        if (pathSepartor != null) {
            return pathSepartor;
        }
        return System.getProperty("path.separator");
    }

    public static void setPathSeparator(String pathSepartor) {
        Util.pathSepartor = pathSepartor;
    }

    public static boolean isRestricted() {
        return isRestricted;
    }

    public static void setRestricted(boolean isRestricted) {
        Util.isRestricted = isRestricted;
    }
}

