/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class FilePatternMatcher {
    private final String originalPattern;
    private final List patterns = new ArrayList();

    public FilePatternMatcher(String wildcardPattern) {
        this.originalPattern = wildcardPattern;
        StringTokenizer tokenizer = new StringTokenizer(wildcardPattern, ":;");
        while (tokenizer.hasMoreTokens()) {
            this.patterns.add(Pattern.compile(this.buildRegex(tokenizer.nextToken())));
        }
    }

    public boolean matches(String filename) {
        Iterator it = this.patterns.iterator();
        while (it.hasNext()) {
            Pattern regex = (Pattern)it.next();
            if (!regex.matcher(filename).matches()) continue;
            return true;
        }
        return false;
    }

    private String buildRegex(String wildcardPattern) {
        String temp = wildcardPattern;
        if ((temp = temp.replace('\\', '/')).endsWith("/")) {
            temp = temp + "**";
        }
        if ("**".equals(temp = temp.replaceAll("\\*\\*/\\*\\*", "**"))) {
            return ".*";
        }
        if (temp.startsWith("**/") && temp.endsWith("/**")) {
            String inner = temp.substring(3, temp.length() - 3);
            return "(.*/)?" + this.buildInnerRegex(inner) + "(/.*)?";
        }
        if (temp.startsWith("**/")) {
            String inner = temp.substring(3);
            return "(.*/)?" + this.buildInnerRegex(inner);
        }
        if (temp.endsWith("/**")) {
            String inner = temp.substring(0, temp.length() - 3);
            return this.buildInnerRegex(inner) + "(/.*)?";
        }
        return this.buildInnerRegex(temp);
    }

    private String buildInnerRegex(String wildcardPattern) {
        int pos = wildcardPattern.indexOf("/**/");
        if (pos > -1) {
            String before = wildcardPattern.substring(0, pos);
            String after = wildcardPattern.substring(pos + 4);
            return this.buildInnerRegex(before) + "/(.*/)?" + this.buildInnerRegex(after);
        }
        return wildcardPattern.replaceAll("\\?", "[^/]").replaceAll("\\*", "[^/]*");
    }

    public String toString() {
        return this.originalPattern;
    }
}

