/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.WebRepositoryIntegration;
import net.sf.statcvs.pages.MarkupSyntax;
import net.sf.statcvs.pages.xml.XML;
import net.sf.statcvs.renderer.TableCellRenderer;

public class XMLRenderer
implements TableCellRenderer {
    private String xml = null;
    private MarkupSyntax output = null;

    public void renderCell(String content) {
        this.xml = content;
    }

    public void renderEmptyCell() {
        this.xml = null;
    }

    public void renderIntegerCell(int value) {
        this.xml = Integer.toString(value);
    }

    public void renderIntegerCell(int value, int total) {
        this.xml = Integer.toString(value) + " (" + this.getPercentage((double)value / (double)total) + ")";
    }

    public void renderPercentageCell(double ratio) {
        this.xml = this.getPercentage(ratio);
    }

    public void renderAuthorCell(Author author) {
        this.xml = XML.escape(author.getName());
    }

    public void renderDirectoryCell(Directory directory) {
        this.xml = XML.getDirectoryLink(directory);
    }

    public void renderFileCell(VersionedFile file, boolean withIcon, WebRepositoryIntegration webRepository) {
        this.xml = file.getFilenameWithPath();
    }

    public void renderLinkCell(String url, String label) {
        this.xml = XML.getLink(url, label);
    }

    public String getColumnHead() {
        return this.getHtml();
    }

    public String getRowHead() {
        return this.getHtml();
    }

    public String getTableCell() {
        return this.xml;
    }

    private String getPercentage(double ratio) {
        if (Double.isNaN(ratio)) {
            return "-";
        }
        int percentTimes10 = (int)Math.round(ratio * 1000.0);
        double percent = (double)percentTimes10 / 10.0;
        return Double.toString(percent) + "%";
    }

    private String getHtml() {
        return this.xml.replaceAll(" ", "");
    }

    public MarkupSyntax getOutput() {
        return this.output;
    }

    public void setOutput(MarkupSyntax output) {
        this.output = output;
    }

    public String getOddRowFormat() {
        return " class=\"even\"";
    }

    public String getEvenRowFormat() {
        return " class=\"odd\"";
    }

    public void renderAuthorIdCell(Author author) {
        this.xml = XML.getAuthorIdLink(author);
    }
}

