/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages.xml;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.xml.LogXmlMaker;
import org.jdom.Element;

public class LogXml {
    private final ReportConfig config;
    private final Repository repository;

    public LogXml(ReportConfig config) {
        this.config = config;
        this.repository = config.getRepository();
    }

    public Element toFile() {
        if (this.repository.getCommits().isEmpty()) {
            return null;
        }
        Date start = this.repository.getFirstDate();
        Date end = this.repository.getLastDate();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(end);
        GregorianCalendar startCal = new GregorianCalendar();
        startCal.setTime(start);
        Element commLog = new LogXmlMaker(this.config, this.repository.getCommits()).toFile();
        commLog.setAttribute("no_of_commits", Integer.toString(this.repository.getCommits().size()));
        commLog.setAttribute("active_developers", this.countActiveDevelopers());
        return commLog;
    }

    private String countActiveDevelopers() {
        HashSet<Author> developers = new HashSet<Author>();
        Iterator it = this.repository.getCommits().iterator();
        while (it.hasNext()) {
            Commit commit = (Commit)it.next();
            developers.add(commit.getAuthor());
        }
        return Integer.toString(developers.size());
    }
}

