/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.CommitScatterChartMaker;
import net.sf.statcvs.charts.LOCChartMaker;
import net.sf.statcvs.charts.ModifyAddChartMaker;
import net.sf.statcvs.charts.TimeBarChartMaker;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.DeveloperPageMaker;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.pages.NavigationNode;
import net.sf.statcvs.pages.Page;
import net.sf.statcvs.pages.PageGroup;
import net.sf.statcvs.reports.DevelopersOfTheMonthTable;
import net.sf.statcvs.reports.DevelopersRollingTableReport;
import net.sf.statcvs.reports.DevelopersTableReport;

public class AllDevelopersPageMaker {
    private final ReportConfig config;

    public AllDevelopersPageMaker(ReportConfig config) {
        this.config = config;
    }

    public NavigationNode toFile() {
        DevelopersTableReport developers = new DevelopersTableReport(this.config);
        DevelopersRollingTableReport rollingDevelopers = new DevelopersRollingTableReport(this.config);
        Page page = this.config.createPage("developers", Messages.getString("DEVELOPERS"), this.config.getProjectName() + " " + Messages.getString("DEVELOPERS"));
        if (developers.getDeveloperCount() > 1) {
            page.addAttribute(Messages.getString("NUMBER_DEVELOPERS"), developers.getDeveloperCount());
            page.add(developers);
            page.addSection(Messages.getString("ROLLING_DEV_TITLE"));
            page.add(rollingDevelopers);
            page.addRawContent(this.getOtherLoginsLinks());
            page.addSection(Messages.getString("LOC_TITLE"));
            ChartImage allAuthorsLOCChart = new LOCChartMaker.AllDevelopersLOCChartMaker(this.config, this.config.getLargeChartSize()).toFile();
            page.add(allAuthorsLOCChart);
        }
        ChartImage hoursChart = new TimeBarChartMaker.HourBarChartMaker("activity_time", this.config, this.config.getRepository().getRevisions(), Messages.getString("ACTIVITY_TIME_TITLE"), "activity_time.png").toFile();
        ChartImage weekdaysChart = new TimeBarChartMaker.WeekdayBarChartMaker("activity_day", this.config, this.config.getRepository().getRevisions(), Messages.getString("ACTIVITY_DAY_TITLE"), "activity_day.png").toFile();
        ChartImage scatterChart = new CommitScatterChartMaker(this.config, this.config.getLargeChartSize().width).toFile();
        ChartImage modifyAddChart = new ModifyAddChartMaker(this.config, this.config.getSmallChartSize().width).toFile();
        DevelopersOfTheMonthTable developerOfTheMonth = new DevelopersOfTheMonthTable(this.config);
        page.addSection(Messages.getString("DEVELOPER_OF_THE_MONTH"));
        page.add(developerOfTheMonth);
        page.addSection(Messages.getString("DEVELOPER_ACTIVITY"));
        page.add(scatterChart);
        page.add(modifyAddChart);
        page.addSection(Messages.getString("ACTIVITY_TITLE"));
        page.add(hoursChart);
        page.add(weekdaysChart);
        if (this.config.getRepository().getAuthors().size() >= 1) {
            PageGroup developerPages = new PageGroup(Messages.getString("DEVELOPERS"), false);
            Iterator it = this.config.getRepository().getAuthors().iterator();
            while (it.hasNext()) {
                Author developer = (Author)it.next();
                developerPages.add(new DeveloperPageMaker(this.config, developer).toFile());
            }
            page.addChild(developerPages);
        }
        return page;
    }

    private String getOtherLoginsLinks() {
        ArrayList<Author> nonDeveloperLogins = new ArrayList<Author>();
        Iterator it = this.config.getRepository().getAuthors().iterator();
        while (it.hasNext()) {
            Author author = (Author)it.next();
            if (this.config.isDeveloper(author)) continue;
            nonDeveloperLogins.add(author);
        }
        if (nonDeveloperLogins.isEmpty()) {
            return "";
        }
        Collections.sort(nonDeveloperLogins);
        StringBuffer s = new StringBuffer("<p>\n  Other Logins:\n  ");
        it = nonDeveloperLogins.iterator();
        while (it.hasNext()) {
            Author author = (Author)it.next();
            s.append(HTML.getLink(DeveloperPageMaker.getURL(author), author.getRealName()));
            if (!it.hasNext()) continue;
            s.append(", \n  ");
        }
        s.append("</p>\n");
        return s.toString();
    }
}

