/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import net.sf.statcvs.input.CvsFileBlockParser;
import net.sf.statcvs.input.CvsLogBuilder;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.util.LookaheadReader;

public class CvsLogfileParser {
    private static Logger logger = Logger.getLogger(CvsLogfileParser.class.getName());
    private final LookaheadReader logReader;
    private final CvsLogBuilder builder;

    public CvsLogfileParser(Reader logReader, CvsLogBuilder builder) {
        this.logReader = new LookaheadReader(logReader);
        this.builder = builder;
    }

    public void parse() throws LogSyntaxException, IOException {
        long startTime = System.currentTimeMillis();
        logger.fine("starting to parse...");
        this.eatNonCheckedInFileLines();
        if (!this.logReader.hasNextLine()) {
            return;
        }
        if (!"".equals(this.logReader.getCurrentLine())) {
            throw new LogSyntaxException("Expected '?' or empty line at line " + this.logReader.getLineNumber() + ", but found '" + this.logReader.getCurrentLine() + "'");
        }
        this.eatEmptyLines();
        boolean isFirstFile = true;
        do {
            CvsFileBlockParser parser = new CvsFileBlockParser(this.logReader, this.builder, isFirstFile);
            parser.parse();
            isFirstFile = false;
            this.eatEmptyLines();
        } while (this.logReader.hasNextLine());
        logger.fine("parsing finished in " + (System.currentTimeMillis() - startTime) + " ms.");
    }

    private void eatNonCheckedInFileLines() throws IOException {
        while (this.logReader.hasNextLine() && this.logReader.nextLine().startsWith("? ")) {
        }
    }

    private void eatEmptyLines() throws IOException {
        while (this.logReader.hasNextLine() && "".equals(this.logReader.nextLine())) {
        }
    }
}

