/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.charts;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartConfigUtil;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.SymbolicNameAnnotation;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.reports.LOCSeriesBuilder;
import net.sf.statcvs.util.IntegerMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class LOCChartMaker {
    private final ReportConfig config;
    private ChartImage chartFile = null;
    private final String chartName;

    public LOCChartMaker(String chartName, ReportConfig config, TimeSeries locSeries, String title, String fileName, Dimension size, List annotations) {
        this.chartName = chartName;
        this.config = config;
        if (locSeries == null) {
            return;
        }
        Paint[] colors = new Paint[]{Color.RED};
        TimeSeriesCollection collection = new TimeSeriesCollection();
        collection.addSeries(locSeries);
        JFreeChart chart = this.createLOCChart(collection, colors, title, annotations);
        Dimension dim = ChartConfigUtil.getDimension(chartName, size);
        this.chartFile = this.config.createChartImage(fileName, title, chart, dim);
    }

    public LOCChartMaker(String chartName, ReportConfig config, List locSeriesList, String title, String fileName, Dimension size, List annotations) {
        this.chartName = chartName;
        this.config = config;
        if (locSeriesList.isEmpty()) {
            return;
        }
        int i = 0;
        TimeSeriesCollection collection = new TimeSeriesCollection();
        Iterator it = locSeriesList.iterator();
        while (it.hasNext()) {
            TimeSeries series = (TimeSeries)it.next();
            collection.addSeries(series);
            ++i;
        }
        JFreeChart chart = this.createLOCChart(collection, null, title, annotations);
        Dimension dim = ChartConfigUtil.getDimension(chartName, size);
        this.chartFile = this.config.createChartImage(fileName, title, chart, dim);
    }

    private JFreeChart createLOCChart(TimeSeriesCollection data, Paint[] colors, String title, List annotations) {
        int i;
        String domain = Messages.getString("TIME_LOC_DOMAIN");
        String range = Messages.getString("TIME_LOC_RANGE");
        boolean legend = data.getSeriesCount() > 1;
        JFreeChart chart = ChartFactory.createTimeSeriesChart(this.config.getProjectName() + ": " + title, domain, range, data, legend, false, false);
        XYPlot plot = chart.getXYPlot();
        plot.setRenderer(new XYStepRenderer());
        if (colors == null) {
            for (i = 0; i < plot.getSeriesCount(); ++i) {
                Paint seriesPaint = plot.getRenderer().getSeriesPaint(i);
                if (seriesPaint == null || !seriesPaint.equals(new Color(255, 255, 85))) continue;
                plot.getRenderer().setSeriesPaint(i, new Color(240, 220, 85));
            }
        } else {
            for (i = 0; i < colors.length; ++i) {
                plot.getRenderer().setSeriesPaint(i, colors[i]);
            }
        }
        DateAxis domainAxis = (DateAxis)plot.getDomainAxis();
        domainAxis.setVerticalTickLabels(true);
        ValueAxis valueAxis = plot.getRangeAxis();
        valueAxis.setLowerBound(0.0);
        if (annotations != null) {
            Iterator it = annotations.iterator();
            while (it.hasNext()) {
                plot.addAnnotation((XYAnnotation)it.next());
            }
        }
        plot.setBackgroundPaint(ChartConfigUtil.getPlotColor(this.chartName));
        chart.setBackgroundPaint(ChartConfigUtil.getBackgroundColor(this.chartName));
        XYItemRenderer renderer = plot.getRenderer();
        ChartConfigUtil.configureStroke(this.chartName, renderer, data);
        ChartConfigUtil.configureShapes(this.chartName, renderer);
        ChartConfigUtil.configureCopyrightNotice(this.chartName, chart);
        ChartConfigUtil.configureChartBackgroungImage(this.chartName, chart);
        ChartConfigUtil.configurePlotImage(this.chartName, chart);
        return chart;
    }

    public ChartImage toFile() {
        return this.chartFile;
    }

    private static TimeSeries getLOCTimeSeries(SortedSet revisions, String title) {
        LOCSeriesBuilder locCounter = new LOCSeriesBuilder(title, true);
        Iterator it = revisions.iterator();
        while (it.hasNext()) {
            locCounter.addRevision((Revision)it.next());
        }
        if (locCounter.getMaximum() == 0) {
            return null;
        }
        return locCounter.getTimeSeries();
    }

    public static class AllDirectoriesLOCChartMaker
    extends LOCChartMaker {
        private static Collection getMajorDirectories(Repository repository, int max) {
            if (repository.getFirstDate() == null || repository.getLastDate() == null || repository.getFirstDate().equals(repository.getLastDate())) {
                return Collections.EMPTY_LIST;
            }
            IntegerMap importances = new IntegerMap();
            Iterator it = repository.getDirectories().iterator();
            while (it.hasNext()) {
                Directory directory = (Directory)it.next();
                importances.put(directory, AllDirectoriesLOCChartMaker.getImportance(directory, repository.getFirstDate(), repository.getLastDate()));
            }
            ArrayList result = new ArrayList(repository.getDirectories());
            Collections.sort(result, new Comparator(importances){
                private final /* synthetic */ IntegerMap val$importances;
                {
                    this.val$importances = val$importances;
                }

                public int compare(Object o1, Object o2) {
                    int importance2;
                    int importance1 = this.val$importances.get(o1);
                    if (importance1 > (importance2 = this.val$importances.get(o2))) {
                        return -1;
                    }
                    if (importance1 == importance2) {
                        return 0;
                    }
                    return 1;
                }
            });
            return AllDirectoriesLOCChartMaker.firstN(result, max);
        }

        private static int getImportance(Directory dir, Date start, Date end) {
            long timeRange = end.getTime() - start.getTime();
            double maxImportance = 0.0;
            int currentLines = 0;
            Iterator it = dir.getRevisions().iterator();
            while (it.hasNext()) {
                Revision revision = (Revision)it.next();
                long timeInRange = revision.getDate().getTime() - start.getTime();
                double timeFraction = (double)(timeInRange / timeRange) * 0.9 + 0.1;
                maxImportance = Math.max(maxImportance, (double)(currentLines += revision.getLinesDelta()) * timeFraction);
            }
            return (int)(maxImportance * 10.0);
        }

        private static List firstN(List list, int n) {
            return list.subList(0, Math.min(list.size(), n));
        }

        private static List createAllDirectoriesLOCSeries(Repository repository, int max) {
            Iterator it = AllDirectoriesLOCChartMaker.getMajorDirectories(repository, max).iterator();
            HashMap<Directory, LOCSeriesBuilder> directorySeriesMap = new HashMap<Directory, LOCSeriesBuilder>();
            while (it.hasNext()) {
                Directory directory = (Directory)it.next();
                directorySeriesMap.put(directory, new LOCSeriesBuilder(directory.getPath(), true));
            }
            it = repository.getRevisions().iterator();
            while (it.hasNext()) {
                LOCSeriesBuilder builder;
                Revision rev = (Revision)it.next();
                if (rev.isBeginOfLog() || (builder = (LOCSeriesBuilder)directorySeriesMap.get(rev.getFile().getDirectory())) == null) continue;
                builder.addRevision(rev);
            }
            ArrayList directories = new ArrayList(directorySeriesMap.keySet());
            Collections.sort(directories);
            ArrayList<TimeSeries> result = new ArrayList<TimeSeries>();
            it = directories.iterator();
            while (it.hasNext()) {
                Directory directory = (Directory)it.next();
                LOCSeriesBuilder builder = (LOCSeriesBuilder)directorySeriesMap.get(directory);
                TimeSeries series = builder.getTimeSeries();
                if (series == null) continue;
                result.add(series);
            }
            return result;
        }

        public AllDirectoriesLOCChartMaker(ReportConfig config, int showMaxDirectories) {
            super("directories_loc_timeline", config, AllDirectoriesLOCChartMaker.createAllDirectoriesLOCSeries(config.getRepository(), showMaxDirectories), Messages.getString("DIRECTORY_LOC_TITLE"), "directories_loc_timeline.png", config.getLargeChartSize(), SymbolicNameAnnotation.createAnnotations(config.getRepository().getSymbolicNames()));
        }
    }

    public static class AllDevelopersLOCChartMaker
    extends LOCChartMaker {
        private static List createAllDevelopersLOCSeries(ReportConfig config) {
            Iterator it = config.getRepository().getAuthors().iterator();
            HashMap<Author, LOCSeriesBuilder> authorSeriesMap = new HashMap<Author, LOCSeriesBuilder>();
            while (it.hasNext()) {
                Author author = (Author)it.next();
                if (!config.isDeveloper(author)) continue;
                authorSeriesMap.put(author, new LOCSeriesBuilder(author.getRealName(), false));
            }
            it = config.getRepository().getRevisions().iterator();
            while (it.hasNext()) {
                LOCSeriesBuilder builder;
                Revision rev = (Revision)it.next();
                if (rev.isBeginOfLog() || (builder = (LOCSeriesBuilder)authorSeriesMap.get(rev.getAuthor())) == null) continue;
                builder.addRevision(rev);
            }
            ArrayList authors = new ArrayList(authorSeriesMap.keySet());
            Collections.sort(authors);
            ArrayList<TimeSeries> result = new ArrayList<TimeSeries>();
            it = authors.iterator();
            while (it.hasNext()) {
                Author author = (Author)it.next();
                LOCSeriesBuilder builder = (LOCSeriesBuilder)authorSeriesMap.get(author);
                TimeSeries series = builder.getTimeSeries();
                if (series == null) continue;
                result.add(series);
            }
            return result;
        }

        public AllDevelopersLOCChartMaker(ReportConfig config, Dimension size) {
            super("loc_per_author", config, AllDevelopersLOCChartMaker.createAllDevelopersLOCSeries(config), Messages.getString("CONTRIBUTED_LOC_TITLE"), "loc_per_author.png", size, SymbolicNameAnnotation.createAnnotations(config.getRepository().getSymbolicNames()));
        }
    }

    public static class DirectoryLOCChartMaker
    extends LOCChartMaker {
        private static String getTitle(Directory directory) {
            return directory.getPath() + (directory.getPath() != null && directory.getPath().length() > 1 ? " " : "") + Messages.getString("TIME_LOC_SUBTITLE");
        }

        private static String getFilename(Directory directory) {
            return "loc_module" + HTML.escapeDirectoryName(directory.getPath()) + ".png";
        }

        public DirectoryLOCChartMaker(ReportConfig config, Directory directory) {
            super("loc_module", config, LOCChartMaker.getLOCTimeSeries(directory.getRevisions(), DirectoryLOCChartMaker.getTitle(directory)), DirectoryLOCChartMaker.getTitle(directory), DirectoryLOCChartMaker.getFilename(directory), config.getLargeChartSize(), SymbolicNameAnnotation.createAnnotations(config.getRepository().getSymbolicNames()));
        }
    }

    public static class MainLOCChartMaker
    extends LOCChartMaker {
        public MainLOCChartMaker(String chartName, ReportConfig config, String fileName, Dimension size) {
            super(chartName, config, LOCChartMaker.getLOCTimeSeries(config.getRepository().getRevisions(), Messages.getString("TIME_LOC_SUBTITLE")), Messages.getString("TIME_LOC_SUBTITLE"), fileName, size, SymbolicNameAnnotation.createAnnotations(config.getRepository().getSymbolicNames()));
        }
    }
}

