/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui.print;

import chrriis.udoc.ui.ClassPane;
import chrriis.udoc.ui.print.PrintProcessing;
import chrriis.udoc.ui.widgets.ArrowButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PrintPreviewDialog
extends JDialog {
    protected static final String TITLE = "Print Preview";
    protected static final int PREVIEW_SIZE = 300;
    protected static final String PORTRAIT = "Portrait";
    protected static final String LANDSCAPE = "Landscape";
    protected int x;
    protected int y;
    protected JLabel label;
    protected JPanel labelPanel;
    protected JComboBox orientationComboBox;
    protected JButton leftButton;
    protected JButton rightButton;
    protected JButton upButton;
    protected JButton downButton;
    protected JRadioButton scaleRadioButton;
    protected JTextField scaleField;
    protected JTextField pageFitField;
    protected JTextField hFitField;
    protected JTextField vFitField;
    protected JRadioButton pageFitRadioButton;
    protected JRadioButton hFitRadioButton;
    protected JRadioButton vFitRadioButton;
    protected JLabel statusLabel;
    protected Point pageCount;
    protected Image image;

    public PrintPreviewDialog(Dialog dialog, ClassPane classPane) {
        super(dialog, TITLE);
        this.init(classPane);
    }

    public PrintPreviewDialog(Frame frame, ClassPane classPane) {
        super(frame, TITLE);
        this.init(classPane);
    }

    protected void init(final ClassPane classPane) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (PrintPreviewDialog.this.image != null) {
                    PrintPreviewDialog.this.image.flush();
                }
            }
        });
        JPanel contentPane = new JPanel(new BorderLayout(0, 0));
        contentPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.label = new JLabel();
        this.label.setBorder(null);
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(0);
        this.label.setPreferredSize(new Dimension(300, 300));
        this.labelPanel = new JPanel(new BorderLayout(0, 0));
        this.labelPanel.setBorder(BorderFactory.createEtchedBorder());
        this.labelPanel.add((Component)this.label, "Center");
        GridBagLayout gridBag2 = new GridBagLayout();
        JPanel labelContainer = new JPanel(gridBag2){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                int max = Math.max(size.width, size.height);
                return new Dimension(max, max);
            }
        };
        labelContainer.add(this.labelPanel);
        JPanel centerPanel = new JPanel(new BorderLayout(0, 0));
        centerPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        GridBagLayout gridBag = new GridBagLayout();
        JPanel previewPanel = new JPanel(gridBag);
        TitledBorder previewTitleBorder = BorderFactory.createTitledBorder("Preview");
        previewPanel.setBorder(previewTitleBorder);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 1;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        gridBag.setConstraints(labelContainer, cons);
        previewPanel.add(labelContainer);
        cons.fill = 0;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        ++cons.gridx;
        JPanel verticalButtonsPanel = new JPanel(new GridLayout(0, 1, 2, 0));
        this.upButton = new ArrowButton(1);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PrintPreviewDialog.this.y == 0) {
                    return;
                }
                --PrintPreviewDialog.this.y;
                PrintPreviewDialog.this.adjust(classPane);
            }
        });
        verticalButtonsPanel.add(this.upButton);
        this.downButton = new ArrowButton(5);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PrintPreviewDialog.this.y == PrintPreviewDialog.this.pageCount.y - 1) {
                    return;
                }
                ++PrintPreviewDialog.this.y;
                PrintPreviewDialog.this.adjust(classPane);
            }
        });
        verticalButtonsPanel.add(this.downButton);
        gridBag.setConstraints(verticalButtonsPanel, cons);
        previewPanel.add(verticalButtonsPanel);
        cons.gridx = 0;
        ++cons.gridy;
        JPanel horizontalButtonsPanel = new JPanel(new GridLayout(1, 0, 0, 2));
        this.leftButton = new ArrowButton(7);
        this.leftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PrintPreviewDialog.this.x == 0) {
                    return;
                }
                --PrintPreviewDialog.this.x;
                PrintPreviewDialog.this.adjust(classPane);
            }
        });
        horizontalButtonsPanel.add(this.leftButton);
        this.rightButton = new ArrowButton(3);
        this.rightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PrintPreviewDialog.this.x == PrintPreviewDialog.this.pageCount.x - 1) {
                    return;
                }
                ++PrintPreviewDialog.this.x;
                PrintPreviewDialog.this.adjust(classPane);
            }
        });
        horizontalButtonsPanel.add(this.rightButton);
        gridBag.setConstraints(horizontalButtonsPanel, cons);
        previewPanel.add(horizontalButtonsPanel);
        cons.gridx = 0;
        ++cons.gridy;
        cons.gridwidth = 2;
        cons.anchor = 17;
        this.statusLabel = new JLabel(" ");
        gridBag.setConstraints(this.statusLabel, cons);
        previewPanel.add(this.statusLabel);
        centerPanel.add((Component)previewPanel, "Center");
        contentPane.add((Component)centerPanel, "Center");
        JPanel settingsPanel = new JPanel();
        BoxLayout layout = new BoxLayout(settingsPanel, 1);
        settingsPanel.setLayout(layout);
        settingsPanel.add(Box.createVerticalGlue());
        JPanel orientationPanel = new JPanel(new BorderLayout(0, 0)){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
            }
        };
        orientationPanel.setBorder(BorderFactory.createTitledBorder("Orientation"));
        this.orientationComboBox = new JComboBox<Object>(new Object[]{PORTRAIT, LANDSCAPE});
        this.orientationComboBox.setSelectedItem(PrintProcessing.isPortrait() ? PORTRAIT : LANDSCAPE);
        this.orientationComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PrintPreviewDialog.this.adjust(classPane);
                }
            }
        });
        orientationPanel.add((Component)this.orientationComboBox, "South");
        settingsPanel.add(orientationPanel);
        JPanel scalingPanel = new JPanel();
        scalingPanel.setBorder(BorderFactory.createTitledBorder("Scale"));
        BoxLayout boxLayout = new BoxLayout(scalingPanel, 1);
        scalingPanel.setLayout(boxLayout);
        ButtonGroup group = new ButtonGroup();
        JPanel scalePanel = new JPanel(new FlowLayout(0, 0, 0)){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
            }
        };
        this.scaleRadioButton = new JRadioButton("Ratio ");
        group.add(this.scaleRadioButton);
        scalePanel.add(this.scaleRadioButton);
        this.scaleField = new JTextField(PrintProcessing.getScalePercentageString(), 3);
        scalePanel.add(this.scaleField);
        scalePanel.add(new JLabel("%"));
        scalingPanel.add(scalePanel);
        JPanel pageFitPanel = new JPanel(new FlowLayout(0, 0, 0)){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
            }
        };
        this.pageFitRadioButton = new JRadioButton("Fit");
        group.add(this.pageFitRadioButton);
        pageFitPanel.add(this.pageFitRadioButton);
        this.pageFitField = new JTextField(PrintProcessing.getPageFitString(), 3);
        pageFitPanel.add(this.pageFitField);
        pageFitPanel.add(new JLabel(" pages"));
        scalingPanel.add(pageFitPanel);
        JPanel hFitPanel = new JPanel(new FlowLayout(0, 0, 0)){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
            }
        };
        this.hFitRadioButton = new JRadioButton("Fit");
        group.add(this.hFitRadioButton);
        hFitPanel.add(this.hFitRadioButton);
        this.hFitField = new JTextField(PrintProcessing.getHorizontalPageFitString(), 3);
        hFitPanel.add(this.hFitField);
        hFitPanel.add(new JLabel(" horizontal pages"));
        scalingPanel.add(hFitPanel);
        JPanel vFitPanel = new JPanel(new FlowLayout(0, 0, 0)){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
            }
        };
        this.vFitRadioButton = new JRadioButton("Fit");
        group.add(this.vFitRadioButton);
        vFitPanel.add(this.vFitRadioButton);
        this.vFitField = new JTextField(PrintProcessing.getVerticalPageFitString(), 3);
        vFitPanel.add(this.vFitField);
        vFitPanel.add(new JLabel(" vertical pages"));
        scalingPanel.add(vFitPanel);
        switch (PrintProcessing.getFitType()) {
            case 4: {
                this.pageFitRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.hFitRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.vFitRadioButton.setSelected(true);
                break;
            }
            default: {
                this.scaleRadioButton.setSelected(true);
            }
        }
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PrintPreviewDialog.this.adjust(classPane);
                }
            }
        };
        this.scaleRadioButton.addItemListener(itemListener);
        this.pageFitRadioButton.addItemListener(itemListener);
        this.hFitRadioButton.addItemListener(itemListener);
        this.vFitRadioButton.addItemListener(itemListener);
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                PrintPreviewDialog.this.adjust(classPane);
            }

            public void insertUpdate(DocumentEvent e) {
                PrintPreviewDialog.this.adjust(classPane);
            }

            public void removeUpdate(DocumentEvent e) {
                PrintPreviewDialog.this.adjust(classPane);
            }
        };
        this.scaleField.getDocument().addDocumentListener(documentListener);
        this.pageFitField.getDocument().addDocumentListener(documentListener);
        this.hFitField.getDocument().addDocumentListener(documentListener);
        this.vFitField.getDocument().addDocumentListener(documentListener);
        settingsPanel.add(scalingPanel);
        JPanel buttonPanel = new JPanel(new GridLayout(0, 1, 0, 2)){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        JButton printButton = new JButton("Print...");
        printButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreviewDialog.this.saveConfiguration();
                PrintPreviewDialog.this.dispose();
                PrintProcessing.print(classPane);
            }
        });
        buttonPanel.add(printButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreviewDialog.this.dispose();
            }
        });
        buttonPanel.add(cancelButton);
        settingsPanel.add(Box.createVerticalGlue());
        settingsPanel.add(buttonPanel);
        contentPane.add((Component)settingsPanel, "East");
        this.getContentPane().add((Component)contentPane, "Center");
        this.adjust(classPane);
    }

    protected void saveConfiguration() {
        boolean isPortrait;
        boolean bl = isPortrait = this.orientationComboBox.getSelectedItem() != LANDSCAPE;
        int fitType = this.pageFitRadioButton.isSelected() ? 4 : (this.hFitRadioButton.isSelected() ? 2 : (this.vFitRadioButton.isSelected() ? 3 : 1));
        PrintProcessing.setPortrait(isPortrait);
        PrintProcessing.setFitType(fitType);
        PrintProcessing.setPageFit(this.pageFitField.getText());
        PrintProcessing.setHorizontalPageFit(this.hFitField.getText());
        PrintProcessing.setVerticalPageFit(this.vFitField.getText());
        PrintProcessing.setScalePercentageString(this.scaleField.getText());
    }

    protected void adjust(ClassPane classPane) {
        boolean isPortrait;
        if (this.image != null) {
            this.image.flush();
        }
        boolean bl = isPortrait = this.orientationComboBox.getSelectedItem() != LANDSCAPE;
        int fitType = this.pageFitRadioButton.isSelected() ? 4 : (this.hFitRadioButton.isSelected() ? 2 : (this.vFitRadioButton.isSelected() ? 3 : 1));
        float pageFit = PrintProcessing.getValidVerticalPageFit(this.pageFitField.getText());
        float hPageFit = PrintProcessing.getValidHorizontalPageFit(this.hFitField.getText());
        float vPageFit = PrintProcessing.getValidVerticalPageFit(this.vFitField.getText());
        float scalePercentage = PrintProcessing.getValidScalePercentage(this.scaleField.getText());
        this.pageCount = PrintProcessing.getPageCount(classPane, new PrintProcessing.PrintingAttributes(isPortrait, fitType, scalePercentage, pageFit, hPageFit, vPageFit));
        if (this.x < 0) {
            this.x = 0;
        } else if (this.x >= this.pageCount.x) {
            this.x = this.pageCount.x - 1;
        }
        if (this.y < 0) {
            this.y = 0;
        } else if (this.y >= this.pageCount.y) {
            this.y = this.pageCount.y - 1;
        }
        this.leftButton.setEnabled(this.x > 0);
        this.rightButton.setEnabled(this.x < this.pageCount.x - 1);
        this.upButton.setEnabled(this.y > 0);
        this.downButton.setEnabled(this.y < this.pageCount.y - 1);
        Point edges = PrintProcessing.getEdges(classPane, isPortrait);
        int labelSize = this.label.getPreferredSize().width;
        int thumbNailWidth = labelSize * edges.x / 842;
        int thumbNailHeight = labelSize * edges.y / 842;
        this.image = new BufferedImage(thumbNailWidth, thumbNailHeight, 1);
        Graphics g = this.image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, thumbNailWidth, thumbNailHeight);
        PrintProcessing.printPage(classPane, g, new Rectangle(0, 0, thumbNailWidth, thumbNailHeight), this.x, this.y, new PrintProcessing.PrintingAttributes(isPortrait, fitType, scalePercentage, pageFit, hPageFit, vPageFit), 4);
        g.dispose();
        this.label.setIcon(new ImageIcon(this.image));
        this.labelPanel.setPreferredSize(new Dimension(this.image.getWidth(null), this.image.getHeight(null)));
        this.statusLabel.setText("Page " + (this.pageCount.x * this.y + this.x + 1) + "/" + this.pageCount.x * this.pageCount.y + " - Position " + (this.x + 1) + ", " + (this.y + 1));
    }
}

